/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.artificialintelligence.server;

import javax.inject.Inject;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.display.artificialintelligence.server.AiServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.AiServerAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.CredentialsDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.AiServerGrid;
import org.squashtest.tm.service.internal.repository.display.AiServerDisplayDao;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Service
@Transactional
public class AiServerDisplayServiceImpl
implements AiServerDisplayService {
    private final DSLContext dsl;
    private final AiServerDisplayDao aiServerDisplayDao;
    private final StoredCredentialsManager credentialsManager;

    @Inject
    AiServerDisplayServiceImpl(DSLContext dsl, AiServerDisplayDao aiServerDisplayDao, StoredCredentialsManager credentialsManager) {
        this.dsl = dsl;
        this.aiServerDisplayDao = aiServerDisplayDao;
        this.credentialsManager = credentialsManager;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public GridResponse findAll(GridRequest gridRequest) {
        GridResponse response = new AiServerGrid().getRows(gridRequest, this.dsl);
        response.sanitizeField("description");
        return response;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public AiServerAdminViewDto getAiServerView(Long aiServerId) {
        AiServerAdminViewDto aiServerAdminViewDto = this.aiServerDisplayDao.findAiServerById(aiServerId);
        ManageableCredentials credentials = this.credentialsManager.findAppLevelCredentials(aiServerId);
        aiServerAdminViewDto.setCredentials(CredentialsDto.from(credentials));
        return aiServerAdminViewDto;
    }
}

