/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.AbstractExecutionDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.deletion.jdbc.delegate.AbstractDelegateDeleteQuery;

public class JdbcIterationDeletionHandler
extends AbstractExecutionDeletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcIterationDeletionHandler.class);
    private final Set<Long> iterationIds;

    public JdbcIterationDeletionHandler(Collection<Long> iterationIds, DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, String operationId) {
        super(dslContext, entityManager, attachmentRepository, reorderHelper, operationId);
        this.iterationIds = new HashSet<Long>(iterationIds);
    }

    protected TableOnConditionStep<Record> joinToExecution() {
        return this.joinToIterationTestPlanItem().innerJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID));
    }

    private TableOnConditionStep<Record> joinToTestSuite() {
        return Tables.ITERATION.innerJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID));
    }

    private TableOnConditionStep<Record> joinToIterationTestPlanItem() {
        return Tables.ITERATION.innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID));
    }

    @Override
    protected Condition getPredicate() {
        return Tables.ITERATION.ITERATION_ID.in(this.iterationIds);
    }

    public void deleteIterations() {
        this.logStartProcess();
        this.clearPersistenceContext();
        this.storeEntitiesToDeleteIntoWorkingTable();
        this.performDeletions();
        this.reorderCampaigns();
        this.cleanWorkingTable();
        this.logEndProcess();
    }

    private void logEndProcess() {
        LOGGER.info(String.format("Deleted Iterations %s. Time elapsed %s", this.iterationIds, this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
    }

    private void performDeletions() {
        this.deleteItemTestPlanExecutions();
        this.performExecutionDeletions();
        this.deleteFailureDetails();
        this.deleteTestSuites();
        this.deleteIterationTestPlanItem();
        this.deleteIterationEntities();
        this.deleteCustomFieldValues();
        this.deleteAttachmentLists();
        this.deleteAttachmentContents();
    }

    private void reorderCampaigns() {
        List<Long> campaignIds = this.workingTables.selectIds(Tables.CAMPAIGN.CLN_ID);
        this.reorderHelper.reorder((Collection<Long>)campaignIds, Tables.CAMPAIGN_ITERATION, (Field<Long>)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (Field<Long>)Tables.CAMPAIGN_ITERATION.ITERATION_ID, (Field<Integer>)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER);
        LOGGER.debug("Reordered campaign content. Time on this stage {} ms", new Object[]{this.timeDiff()});
        this.updateTime();
    }

    private void deleteIterationEntities() {
        this.workingTables.delete(Tables.ITERATION.ITERATION_ID, Tables.AUTOMATED_SUITE.ITERATION_ID);
        this.workingTables.delete(Tables.ITERATION.ITERATION_ID, Tables.CAMPAIGN_ITERATION.ITERATION_ID);
        this.workingTables.delete(Tables.ITERATION.ITERATION_ID, Tables.ITERATION.ITERATION_ID);
        this.logDelete((Table<?>)Tables.ITERATION);
    }

    private void deleteFailureDetails() {
        this.workingTables.delete(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, Tables.FAILURE_DETAIL.ITEM_TEST_PLAN_ID);
        this.logDelete((Table<?>)Tables.FAILURE_DETAIL);
    }

    private void deleteIterationTestPlanItem() {
        this.workingTables.delete(Tables.ITERATION.ITERATION_ID, Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID);
        this.workingTables.delete(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID);
        this.workingTables.delete(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID);
        this.logDelete((Table<?>)Tables.ITERATION_TEST_PLAN_ITEM);
    }

    private void deleteTestSuites() {
        this.workingTables.delete(Tables.ITERATION.ITERATION_ID, Tables.ITERATION_TEST_SUITE.ITERATION_ID);
        this.workingTables.delete(Tables.TEST_SUITE.ID, Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID);
        this.workingTables.delete(Tables.TEST_SUITE.ID, Tables.AUTOMATED_SUITE.TEST_SUITE_ID);
        this.workingTables.delete(Tables.TEST_SUITE.ID, Tables.TEST_SUITE.ID);
        this.logDelete((Table<?>)Tables.TEST_SUITE);
    }

    private void deleteItemTestPlanExecutions() {
        this.workingTables.delete(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID);
    }

    private void logStartProcess() {
        LOGGER.debug(String.format("Init deletion process of iterations %s. Operation:  %s", this.iterationIds, this.operationId), new Object[0]);
    }

    private void storeEntitiesToDeleteIntoWorkingTable() {
        this.storeExecutionsToDeleteIntoWorkingTable();
        this.addCampaign();
        this.addIteration();
        this.addTestSuite();
        this.addFailureDetails();
        this.addIterationTestPlanItem();
        this.addCustomFieldValues();
        this.addAttachmentList();
        this.logReferenceEntitiesComplete();
    }

    private void addAttachmentList() {
        this.workingTables.addEntity(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, () -> this.selectExecutionAttachmentLists().union(this.makeSelectAttachmentList(Tables.TEST_SUITE.ID, Tables.TEST_SUITE.ATTACHMENT_LIST_ID)).union(this.makeSelectAttachmentList(Tables.ITERATION.ITERATION_ID, Tables.ITERATION.ATTACHMENT_LIST_ID)).union((Select)DSL.select((SelectField)Tables.AUTOMATED_SUITE.ATTACHMENT_LIST_ID, AbstractDelegateDeleteQuery.extractFieldTableNameAsParam(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID), (SelectField)this.operationIdParam).from((TableLike)Tables.AUTOMATED_SUITE).where(Tables.AUTOMATED_SUITE.ITERATION_ID.in(this.iterationIds))));
    }

    private void addCampaign() {
        this.workingTables.addEntity(Tables.CAMPAIGN.CLN_ID, () -> this.makeSelectClause(Tables.CAMPAIGN.CLN_ID).from((TableLike)Tables.CAMPAIGN).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).where(this.getPredicate()));
    }

    private void addIteration() {
        this.workingTables.addEntity(Tables.ITERATION.ITERATION_ID, () -> this.makeSelectClause(Tables.ITERATION.ITERATION_ID).from((TableLike)Tables.ITERATION).where(this.getPredicate()));
    }

    private void addCustomFieldValues() {
        this.workingTables.addEntity(Tables.CUSTOM_FIELD_VALUE.CFV_ID, () -> this.selectExecutionCustomFieldValues().union(this.makeSelectCustomFieldValues(Tables.TEST_SUITE.ID, BindableEntity.TEST_SUITE)).union(this.makeSelectCustomFieldValues(Tables.ITERATION.ITERATION_ID, BindableEntity.ITERATION)));
    }

    private void addIterationTestPlanItem() {
        this.workingTables.addEntity(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, () -> this.makeSelectClause(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID).from(this.joinToIterationTestPlanItem()).where(this.getPredicate()));
    }

    private void addFailureDetails() {
        this.workingTables.addEntity(Tables.FAILURE_DETAIL.ITEM_TEST_PLAN_ID, () -> this.makeSelectClause(Tables.FAILURE_DETAIL.ITEM_TEST_PLAN_ID).from(this.joinToFailureDetail()).where(this.getPredicate()));
    }

    private TableOnConditionStep<Record> joinToFailureDetail() {
        return Tables.ITERATION.innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.FAILURE_DETAIL).on(Tables.FAILURE_DETAIL.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID));
    }

    private void addTestSuite() {
        this.workingTables.addEntity(Tables.TEST_SUITE.ID, () -> this.makeSelectClause(Tables.TEST_SUITE.ID).from(this.joinToTestSuite()).where(this.getPredicate()));
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

