/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import java.util.Collection;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcExecutionDeletionHandler;

@Component
public class JdbcExecutionDeletionHandlerFactory {
    private final DSLContext dslContext;
    private final EntityManager entityManager;
    private final AttachmentRepository attachmentRepository;
    private final JdbcBatchReorderHelper reorderHelper;

    public JdbcExecutionDeletionHandlerFactory(DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper) {
        this.dslContext = dslContext;
        this.attachmentRepository = attachmentRepository;
        this.reorderHelper = reorderHelper;
        this.entityManager = entityManager;
    }

    public JdbcExecutionDeletionHandler build(Collection<Long> executionIds) {
        return this.build(executionIds, UUID.randomUUID().toString());
    }

    public JdbcExecutionDeletionHandler build(Collection<Long> executionIds, String operationId) {
        return new JdbcExecutionDeletionHandler(executionIds, this.dslContext, this.attachmentRepository, this.reorderHelper, operationId, this.entityManager);
    }
}

