/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;

@Component
@Scope(value="prototype")
public class TestCaseImportanceManagerForRequirementDeletion {
    private Map<TestCase, List<RequirementCriticality>> requirementDeletionConcernedTestCases;
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private TestCaseImportanceManagerService testCaseImportanceManagerService;

    public void prepareRequirementDeletion(List<Long> requirementLibrarieNodesIds) {
        this.requirementDeletionConcernedTestCases = new HashMap<TestCase, List<RequirementCriticality>>();
        List<RequirementVersion> requirementVersions = this.requirementDao.findVersionsForAll(requirementLibrarieNodesIds);
        this.storeReqVersionConcernedTestCases(requirementVersions);
    }

    private void storeReqVersionConcernedTestCases(List<RequirementVersion> requirementVersions) {
        for (RequirementVersion reqVersion : requirementVersions) {
            Set concernedTestCases = reqVersion.getVerifyingTestCases();
            RequirementCriticality nextCriticality = reqVersion.getCriticality();
            this.storeConcernedTestCases(concernedTestCases, nextCriticality);
        }
    }

    private void storeConcernedTestCases(Set<TestCase> concernedTestCases, RequirementCriticality nextCriticality) {
        for (TestCase testCase : concernedTestCases) {
            this.storeConcernedTestCase(nextCriticality, testCase);
        }
    }

    private void storeConcernedTestCase(RequirementCriticality nextCriticality, TestCase testCase) {
        if (this.requirementDeletionConcernedTestCases.containsKey(testCase)) {
            List<RequirementCriticality> storedCriticalities = this.requirementDeletionConcernedTestCases.get(testCase);
            storedCriticalities.add(nextCriticality);
        } else {
            ArrayList<RequirementCriticality> reqCriticalities = new ArrayList<RequirementCriticality>();
            reqCriticalities.add(nextCriticality);
            this.requirementDeletionConcernedTestCases.put(testCase, reqCriticalities);
        }
    }

    public void changeImportanceAfterRequirementDeletion() {
        if (this.requirementDeletionConcernedTestCases != null && !this.requirementDeletionConcernedTestCases.isEmpty()) {
            for (Map.Entry<TestCase, List<RequirementCriticality>> testCaseAndCriticalities : this.requirementDeletionConcernedTestCases.entrySet()) {
                TestCase testCase = testCaseAndCriticalities.getKey();
                List<RequirementCriticality> requirementCriticalities = testCaseAndCriticalities.getValue();
                TestCaseImportance maxReqCritImportance = TestCaseImportance.deduceTestCaseImportance(requirementCriticalities);
                this.testCaseImportanceManagerService.changeImportanceIfRelationRemoved(maxReqCritImportance, testCase);
            }
        }
        this.requirementDeletionConcernedTestCases = null;
    }
}

