/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customfield;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.ActionStepCollector;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customfield.CustomFieldHelper;
import org.squashtest.tm.service.customfield.CustomFieldHelperService;
import org.squashtest.tm.service.customfield.CustomFieldValueManagerService;
import org.squashtest.tm.service.customfield.DenormalizedFieldHelper;
import org.squashtest.tm.service.denormalizedfield.DenormalizedFieldValueManager;
import org.squashtest.tm.service.internal.customfield.AbstractCustomFieldHelper;
import org.squashtest.tm.service.internal.customfield.CustomFieldHelperImpl;
import org.squashtest.tm.service.internal.customfield.NoValuesCustomFieldHelper;

@Service(value="squashtest.tm.service.CustomFieldHelperService")
public class CustomFieldHelperServiceImpl
implements CustomFieldHelperService {
    @Inject
    private CustomFieldBindingFinderService cufBindingService;
    @Inject
    private CustomFieldValueManagerService cufValuesService;
    @Inject
    private DenormalizedFieldValueManager denormalizedFinder;

    @Override
    public boolean hasCustomFields(BoundEntity entity) {
        return this.cufValuesService.hasCustomFields(entity);
    }

    @Override
    public <X extends BoundEntity> CustomFieldHelper<X> newHelper(X entity) {
        CustomFieldHelperImpl<X> helper = new CustomFieldHelperImpl<X>(entity);
        helper.setCufBindingService(this.cufBindingService);
        helper.setCufValuesService(this.cufValuesService);
        return helper;
    }

    @Override
    public <X extends BoundEntity> CustomFieldHelper<X> newHelper(List<X> entities) {
        CustomFieldHelperImpl<X> helper = new CustomFieldHelperImpl<X>(entities);
        helper.setCufBindingService(this.cufBindingService);
        helper.setCufValuesService(this.cufValuesService);
        return helper;
    }

    @Override
    public <X extends DenormalizedFieldHolder> DenormalizedFieldHelper<X> newDenormalizedHelper(X entity) {
        DenormalizedFieldHelper<X> helper = new DenormalizedFieldHelper<X>(entity);
        helper.setDenormalizedFieldValueFinder(this.denormalizedFinder);
        return helper;
    }

    @Override
    public <X extends DenormalizedFieldHolder> DenormalizedFieldHelper<X> newDenormalizedHelper(List<X> entities) {
        DenormalizedFieldHelper<X> helper = new DenormalizedFieldHelper<X>(entities);
        helper.setDenormalizedFieldValueFinder(this.denormalizedFinder);
        return helper;
    }

    @Override
    public CustomFieldHelper<ActionTestStep> newStepsHelper(List<TestStep> steps, Project container) {
        List actionSteps = new ActionStepCollector().collect(steps);
        AbstractCustomFieldHelper helper = actionSteps.isEmpty() ? new NoValuesCustomFieldHelper(container, BindableEntity.TEST_STEP) : new CustomFieldHelperImpl(actionSteps);
        helper.setCufBindingService(this.cufBindingService);
        helper.setCufValuesService(this.cufValuesService);
        return helper;
    }
}

