/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customfield;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customfield.CustomFieldHelper;
import org.squashtest.tm.service.customfield.CustomFieldValueManagerService;

public abstract class AbstractCustomFieldHelper<X extends BoundEntity>
implements CustomFieldHelper<X> {
    private CustomFieldValueManagerService cufValuesService;
    protected CustomFieldBindingFinderService cufBindingService;
    private Collection<RenderingLocation> locations;
    private CustomFieldDefinitionStrategy addingStrategy = CustomFieldDefinitionStrategy.INTERSECTION;
    protected List<CustomField> customFields;

    protected AbstractCustomFieldHelper() {
    }

    protected abstract void initCustomFields();

    protected abstract List<CustomFieldValue> doGetCustomFieldValues();

    @Override
    public CustomFieldHelper<X> setRenderingLocations(RenderingLocation ... locations) {
        this.locations = Arrays.asList(locations);
        return this;
    }

    @Override
    public CustomFieldHelper<X> setRenderingLocations(Collection<RenderingLocation> locations) {
        this.locations = locations;
        return this;
    }

    @Override
    public CustomFieldHelper<X> restrictToCommonFields() {
        this.addingStrategy = CustomFieldDefinitionStrategy.INTERSECTION;
        return this;
    }

    @Override
    public CustomFieldHelper<X> includeAllCustomFields() {
        this.addingStrategy = CustomFieldDefinitionStrategy.UNION;
        return this;
    }

    @Override
    public final List<CustomField> getCustomFieldConfiguration() {
        if (!this.isInited()) {
            this.initCustomFields();
        }
        return this.customFields;
    }

    @Override
    public final List<CustomFieldValue> getCustomFieldValues() {
        if (!this.isInited()) {
            this.initCustomFields();
        }
        return this.doGetCustomFieldValues();
    }

    private boolean isInited() {
        return this.customFields != null;
    }

    protected final List<CustomField> findCustomFields(long projectId, BindableEntity entityType, Collection<RenderingLocation> optionalLocations) {
        List<CustomFieldBinding> bindings = this.cufBindingService.findCustomFieldsForProjectAndEntity(projectId, entityType);
        Collections.sort(bindings, new BindingSorter());
        if (optionalLocations != null && !optionalLocations.isEmpty()) {
            CollectionUtils.filter(bindings, (Predicate)new BindingLocationFilter(optionalLocations));
        }
        return (List)CollectionUtils.collect(bindings, (Transformer)new BindingFieldCollector());
    }

    protected void setCufBindingService(CustomFieldBindingFinderService cufBindingService) {
        this.cufBindingService = cufBindingService;
    }

    protected CustomFieldValueManagerService getCufValuesService() {
        return this.cufValuesService;
    }

    protected void setCufValuesService(CustomFieldValueManagerService cufValuesService) {
        this.cufValuesService = cufValuesService;
    }

    protected final CustomFieldDefinitionStrategy getAddingStrategy() {
        return this.addingStrategy;
    }

    protected Collection<RenderingLocation> getLocations() {
        return this.locations;
    }

    protected static final class BindingFieldCollector
    implements Transformer {
        protected BindingFieldCollector() {
        }

        public Object transform(Object arg0) {
            CustomFieldBinding binding = (CustomFieldBinding)arg0;
            return binding.getCustomField();
        }
    }

    protected static final class BindingLocationFilter
    implements Predicate {
        private Collection<RenderingLocation> locations;
        private boolean automaticallyPassed = false;

        BindingLocationFilter(Collection<RenderingLocation> locations) {
            this.locations = locations;
            this.automaticallyPassed = locations == null || locations.isEmpty();
        }

        public boolean evaluate(Object binding) {
            return this.automaticallyPassed || CollectionUtils.containsAny(this.locations, (Collection)((CustomFieldBinding)binding).getRenderingLocations());
        }
    }

    protected static final class BindingSorter
    implements Comparator<CustomFieldBinding>,
    Serializable {
        protected BindingSorter() {
        }

        @Override
        public int compare(CustomFieldBinding o1, CustomFieldBinding o2) {
            return o1.getPosition() - o2.getPosition();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum CustomFieldDefinitionStrategy {
        INTERSECTION{

            @Override
            List<CustomField> add(List<CustomField> orig, List<CustomField> addition) {
                if (orig.isEmpty()) {
                    return addition;
                }
                return new ArrayList<CustomField>(CollectionUtils.intersection(orig, addition));
            }
        }
        ,
        UNION{

            @Override
            List<CustomField> add(List<CustomField> orig, List<CustomField> addition) {
                orig.addAll(addition);
                return orig;
            }
        };


        abstract List<CustomField> add(List<CustomField> var1, List<CustomField> var2);
    }
}

