/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.campaign.IterationStatisticsService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.internal.repository.CustomItpiLastExecutionFilterDao;
import org.squashtest.tm.service.statistics.CountOnEnum;
import org.squashtest.tm.service.statistics.campaign.CampaignTestCaseSuccessRateStatistics;
import org.squashtest.tm.service.statistics.campaign.ProgressionStatistics;
import org.squashtest.tm.service.statistics.campaign.ScheduledIteration;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;
import org.squashtest.tm.service.statistics.iteration.TestSuiteTestInventoryStatistics;

@Transactional(readOnly=true)
@Service(value="IterationStatisticsService")
public class IterationStatisticsServiceImpl
implements IterationStatisticsService {
    private static final String PERM_CAN_READ_CAMPAIGN = "hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ') ";
    private static final String PERM_CAN_READ_ITERATION = "hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'READ') ";
    private static final String ID = "id";
    private static final String ITERATION_IDS = "iterationIds";
    private static final String ITPI_IDS = "itpiIds";
    private static final Logger LOGGER = LoggerFactory.getLogger(IterationStatisticsServiceImpl.class);
    @Inject
    private IterationTestPlanManagerService itpManagerService;
    @Inject
    private CustomItpiLastExecutionFilterDao itpiLastExecutionFilterDao;
    @PersistenceContext
    private EntityManager em;

    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'READ')  or hasRole('ROLE_ADMIN')")
    public Map<ExecutionStatus, Integer> gatherIterationTestCaseStatusStatistics(List<Long> iterationIds) {
        Query query = this.getCurrentSession().createNamedQuery("IterationStatistics.multipleglobaltestinventory", Object[].class);
        query.setParameter(ITERATION_IDS, iterationIds);
        List res = query.getResultList();
        return CountOnEnum.fromTuples(res, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
    }

    private Map<ExecutionStatus, Integer> gatherIterationTestCaseStatusStatisticsForTCLastExecScope(List<Long> itpiIds) {
        Query query = this.getCurrentSession().createNamedQuery("IterationStatistics.multipleglobaltestinventorybyitpi", Object[].class);
        query.setParameter(ITPI_IDS, itpiIds);
        List res = query.getResultList();
        return CountOnEnum.fromTuples(res, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
    }

    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'READ')  or hasRole('ROLE_ADMIN')")
    public Map<TestCaseImportance, Integer> gatherIterationNonExecutedTestCaseImportanceStatistics(List<Long> iterationIds) {
        Query query = this.getCurrentSession().createNamedQuery("IterationStatistics.multiplenonexecutedTestcaseImportance", Object[].class);
        query.setParameter(ITERATION_IDS, iterationIds);
        List res = query.getResultList();
        return CountOnEnum.fromTuples(res, TestCaseImportance.class).getStatistics();
    }

    private Map<TestCaseImportance, Integer> gatherIterationNonExecutedTestCaseImportanceStatisticsForTCLastExecScope(List<Long> itpiIds) {
        Query query = this.getCurrentSession().createNamedQuery("IterationStatistics.multiplenonexecutedTestcaseImportancebyitpi", Object[].class);
        query.setParameter(ITPI_IDS, itpiIds);
        List res = query.getResultList();
        return CountOnEnum.fromTuples(res, TestCaseImportance.class).getStatistics();
    }

    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ')  or hasRole('ROLE_ADMIN')")
    public CampaignTestCaseSuccessRateStatistics gatherIterationTestCaseSuccessRateStatistics(List<Long> iterationIds) {
        Query query = this.getCurrentSession().createNamedQuery("IterationStatistics.multipleSuccessRate", Object[].class);
        query.setParameter(ITERATION_IDS, iterationIds);
        List res = query.getResultList();
        return CampaignTestCaseSuccessRateStatistics.fromTuples(res);
    }

    private CampaignTestCaseSuccessRateStatistics gatherIterationTestCaseSuccessRateStatisticsForTCLastExecScope(List<Long> itpiIds) {
        Query query = this.getCurrentSession().createNamedQuery("IterationStatistics.multipleSuccessRateByItpi", Object[].class);
        query.setParameter(ITPI_IDS, itpiIds);
        List res = query.getResultList();
        return CampaignTestCaseSuccessRateStatistics.fromTuples(res);
    }

    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'READ')  or hasRole('ROLE_ADMIN')")
    public List<TestSuiteTestInventoryStatistics> gatherSingleTestSuiteTestInventoryStatistics(long iterationId) {
        LinkedList<TestSuiteTestInventoryStatistics> result = new LinkedList<TestSuiteTestInventoryStatistics>();
        Query query = this.getCurrentSession().createNamedQuery("IterationStatistics.testSuiteStatistics", Object[].class);
        query.setParameter(ID, (Object)iterationId);
        Query requery = this.getCurrentSession().createNamedQuery("IterationStatistics.testSuiteStatistics-testsLeftover", Object[].class);
        requery.setParameter(ID, (Object)iterationId);
        List<Object[]> res = this.mergeQueryResultLists(query.list(), requery.list());
        this.processTestSuiteTestInventoryStatistics(res, result);
        return result;
    }

    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'READ')  or hasRole('ROLE_ADMIN')")
    public List<TestSuiteTestInventoryStatistics> gatherManyTestSuiteTestInventoryStatistics(List<Long> iterationIds) {
        LinkedList<TestSuiteTestInventoryStatistics> result = new LinkedList<TestSuiteTestInventoryStatistics>();
        Query query = this.getCurrentSession().createNamedQuery("IterationStatistics.multipletestSuiteStatistics", Object[].class);
        query.setParameter(ITERATION_IDS, iterationIds);
        Query requery = this.getCurrentSession().createNamedQuery("IterationStatistics.multipletestSuiteStatistics-testsLeftover", Object[].class);
        requery.setParameter(ITERATION_IDS, iterationIds);
        List<Object[]> res = this.mergeQueryResultLists(query.list(), requery.list());
        this.processTestSuiteTestInventoryStatistics(res, result);
        return result;
    }

    private List<Object[]> mergeQueryResultLists(List<Object[]> queryResult, List<Object[]> leftoverQueryResult) {
        for (Object[] retuple : leftoverQueryResult) {
            retuple[0] = null;
            queryResult.add(retuple);
        }
        return queryResult;
    }

    private void processTestSuiteTestInventoryStatistics(List<Object[]> res, List<TestSuiteTestInventoryStatistics> result) {
        TestSuiteTestInventoryStatistics newStatistics = new TestSuiteTestInventoryStatistics();
        String previousSuiteName = "";
        for (Object[] tuple : res) {
            String suiteName = (String)tuple[0];
            Date scheduledStart = (Date)tuple[4];
            Date scheduledEnd = (Date)tuple[5];
            if (!this.sameSuite(previousSuiteName, suiteName)) {
                newStatistics = new TestSuiteTestInventoryStatistics();
                newStatistics.setTestsuiteName(suiteName);
                newStatistics.setScheduledStart(scheduledStart);
                newStatistics.setScheduledEnd(scheduledEnd);
                result.add(newStatistics);
            }
            previousSuiteName = suiteName;
            ExecutionStatus status = (ExecutionStatus)tuple[1];
            TestCaseImportance importance = (TestCaseImportance)tuple[2];
            Long howmany = (Long)tuple[3];
            if (status == null || importance == null) continue;
            newStatistics.addExecutionCount(howmany.intValue(), status.getCanonicalStatus(), importance);
        }
        this.sortTestSuiteTestInventoryStatisticsByTestSuiteName(result);
    }

    private boolean sameSuite(String name1, String name2) {
        return name1 == null && name2 == null || name1 != null && name1.equals(name2);
    }

    private void sortTestSuiteTestInventoryStatisticsByTestSuiteName(List<TestSuiteTestInventoryStatistics> result) {
        result.sort((t1, t2) -> {
            String t1SuiteName = t1.getTestsuiteName();
            String t2SuiteName = t2.getTestsuiteName();
            if (t1SuiteName != null && t2SuiteName != null) {
                return t1SuiteName.compareToIgnoreCase(t2SuiteName);
            }
            if (t1SuiteName == null) {
                return 1;
            }
            return -1;
        });
    }

    @Override
    public StatisticsBundle gatherIterationStatisticsBundle(List<Long> iterationIds, boolean lastExecScope) {
        StatisticsBundle bundle = this.initializeStatisticsBundle(iterationIds, lastExecScope);
        boolean isSolitaryIteration = iterationIds.size() == 1;
        List<TestSuiteTestInventoryStatistics> testSuiteTestInventoryStatistics = isSolitaryIteration ? this.gatherSingleTestSuiteTestInventoryStatistics(iterationIds.get(0)) : this.gatherManyTestSuiteTestInventoryStatistics(iterationIds);
        ProgressionStatistics iterationProgressionStatistics = isSolitaryIteration ? this.gatherIterationProgressionStatistics(iterationIds.get(0)) : new ProgressionStatistics();
        bundle.setTestsuiteTestInventoryStatisticsList(testSuiteTestInventoryStatistics);
        bundle.setProgressionStatistics(iterationProgressionStatistics);
        bundle.setSelectedIds(iterationIds);
        return bundle;
    }

    private StatisticsBundle initializeStatisticsBundle(List<Long> iterationIds, boolean lastExecScope) {
        CampaignTestCaseSuccessRateStatistics testCaseSuccessRate;
        Map<TestCaseImportance, Integer> testcaseImportance;
        Map<ExecutionStatus, Integer> testcaseStatuses;
        StatisticsBundle bundle = new StatisticsBundle();
        if (lastExecScope) {
            List<Long> itpiIdsInScope = this.itpiLastExecutionFilterDao.gatherLatestItpiIdsForTCInScopeForIteration(iterationIds);
            testcaseStatuses = this.gatherIterationTestCaseStatusStatisticsForTCLastExecScope(itpiIdsInScope);
            testcaseImportance = this.gatherIterationNonExecutedTestCaseImportanceStatisticsForTCLastExecScope(itpiIdsInScope);
            testCaseSuccessRate = this.gatherIterationTestCaseSuccessRateStatisticsForTCLastExecScope(itpiIdsInScope);
        } else {
            testcaseStatuses = this.gatherIterationTestCaseStatusStatistics(iterationIds);
            testcaseImportance = this.gatherIterationNonExecutedTestCaseImportanceStatistics(iterationIds);
            testCaseSuccessRate = this.gatherIterationTestCaseSuccessRateStatistics(iterationIds);
        }
        bundle.setTestCaseStatusStatistics(testcaseStatuses);
        bundle.setNonExecutedTestCaseImportanceStatistics(testcaseImportance);
        bundle.setTestCaseSuccessRateStatistics(testCaseSuccessRate);
        return bundle;
    }

    private ProgressionStatistics gatherIterationProgressionStatistics(long iterationId) {
        ProgressionStatistics progression = new ProgressionStatistics();
        Session session = this.getCurrentSession();
        Query query = session.createNamedQuery("IterationStatistics.findScheduledIterations", ScheduledIteration.class);
        query.setParameter(ID, (Object)iterationId, (Type)LongType.INSTANCE);
        ScheduledIteration scheduledIteration = (ScheduledIteration)query.uniqueResult();
        Query requery = session.createNamedQuery("IterationStatistics.findExecutionsHistory", Date.class);
        requery.setParameter(ID, (Object)iterationId, (Type)LongType.INSTANCE);
        requery.setParameterList("nonterminalStatuses", (Collection)ExecutionStatus.getNonTerminatedStatusSet());
        List executionHistory = requery.getResultList();
        try {
            progression.setScheduledIterations(Collections.singletonList(scheduledIteration));
            ScheduledIteration.checkIterationDatesAreSet(scheduledIteration);
            progression.computeSchedule();
            progression.computeCumulativeTestPerDate(executionHistory);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.info("CampaignStatistics : could not generate iteration progression statistics for iteration{} : some dates are wrong", new Object[]{iterationId});
            progression.addi18nErrorMessage(ex.getMessage());
        }
        return progression;
    }

    private Session getCurrentSession() {
        return (Session)this.em.unwrap(Session.class);
    }
}

