/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.DSLContext;
import org.springframework.security.access.AccessDeniedException;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestPlanOwner;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.script.GherkinParser;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.exception.execution.TestPlanTerminatedOrNoStepsException;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.campaign.TestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.campaign.AbstractTestPlanExecutionProcessingService$AjcClosure1;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManager;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.user.UserAccountService;

public abstract class AbstractTestPlanExecutionProcessingService<E extends TestPlanOwner>
implements TestPlanExecutionProcessingService<E> {
    private static final Logger LOGGER;
    private CampaignNodeDeletionHandler campaignDeletionHandler;
    private IterationTestPlanManager testPlanManager;
    private UserAccountService userService;
    private PermissionEvaluationService permissionEvaluationService;
    protected IterationTestPlanDao iterationTestPlanDao;
    protected DSLContext dslContext;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        AbstractTestPlanExecutionProcessingService.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(AbstractTestPlanExecutionProcessingService.class);
    }

    @Inject
    AbstractTestPlanExecutionProcessingService(CampaignNodeDeletionHandler campaignDeletionHandler, IterationTestPlanManager testPlanManager, UserAccountService userService, PermissionEvaluationService permissionEvaluationService, IterationTestPlanDao iterationTestPlanDao, DSLContext dslContext) {
        this.campaignDeletionHandler = campaignDeletionHandler;
        this.testPlanManager = testPlanManager;
        this.userService = userService;
        this.permissionEvaluationService = permissionEvaluationService;
        this.iterationTestPlanDao = iterationTestPlanDao;
        this.dslContext = dslContext;
    }

    protected void deleteAllExecutions(long testPlanOwnerId) {
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        List<IterationTestPlanItem> testPlan = this.getTestPlan(testPlanOwner);
        if (!testPlan.isEmpty()) {
            this.deleteAllExecutionsOfTestPlan(testPlan, testPlanOwner);
        }
    }

    private void deleteAllExecutionsOfTestPlan(List<IterationTestPlanItem> testPlan, E testPlanOwner) {
        String testerLogin = this.findUserLoginIfTester(testPlanOwner);
        for (IterationTestPlanItem iterationTestPlanItem : testPlan) {
            List executions;
            if (testerLogin != null && (iterationTestPlanItem.getUser() == null || !iterationTestPlanItem.getUser().getLogin().equals(testerLogin)) || (executions = iterationTestPlanItem.getExecutions()).isEmpty()) continue;
            this.campaignDeletionHandler.deleteExecutions(executions);
        }
    }

    @Override
    public Execution startResumeNextExecution(long testPlanOwnerId, long testPlanItemId) {
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        String testerLogin = this.findUserLoginIfTester(testPlanOwner);
        IterationTestPlanItem item = this.findNextExecutableTestPlanItem(testPlanOwner, testPlanItemId, testerLogin);
        Execution execution = this.findUnexecutedOrCreateExecution(item);
        while (execution == null || execution.getSteps().isEmpty()) {
            item = this.findNextExecutableTestPlanItem(testPlanOwner, item.getId());
            execution = this.findUnexecutedOrCreateExecution(item);
        }
        return execution;
    }

    private Execution startResumeNextExecutionOfFilteredTestPlan(long testPlanOwnerId, long testPlanItemId, List<IterationTestPlanItem> partialTestPlan) {
        E transientTestPlanOwner = this.createTransientTestPlanOwnerWithFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        String testerLogin = this.findUserLoginIfTester(testPlanOwnerId, transientTestPlanOwner.getClass().getName());
        IterationTestPlanItem item = this.findNextExecutableTestPlanItem(transientTestPlanOwner, testPlanItemId, testerLogin);
        Execution execution = this.findUnexecutedOrCreateExecution(item);
        while (execution == null || execution.getSteps().isEmpty()) {
            item = this.findNextExecutableTestPlanItem(transientTestPlanOwner, item.getId());
            execution = this.findUnexecutedOrCreateExecution(item);
        }
        return execution;
    }

    private boolean partialTestPlanIdsHasNextTestCase(long testPlanOwnerId, Execution execution, List<IterationTestPlanItem> partialTestPlan) {
        boolean hasNextTestCase = false;
        if (Objects.nonNull(execution)) {
            hasNextTestCase = this.partialTestPlanIdsHaveMoreExecutableItems(testPlanOwnerId, execution.getTestPlan().getId(), partialTestPlan);
        }
        return hasNextTestCase;
    }

    private boolean partialTestPlanHasNextTestCase(long testPlanOwnerId, Execution execution, List<IterationTestPlanItem> partialTestPlan) {
        boolean hasNextTestCase = false;
        if (Objects.nonNull(execution)) {
            hasNextTestCase = this.partialTestPlanHasMoreExecutableItems(testPlanOwnerId, execution.getTestPlan().getId(), partialTestPlan);
        }
        return hasNextTestCase;
    }

    @Override
    public Execution startResume(long testPlanOwnerId) {
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        String testerLogin = this.findUserLoginIfTester(testPlanOwner);
        IterationTestPlanItem item = this.findFirstExecutableTestPlanItem(testerLogin, testPlanOwner);
        Execution execution = this.findUnexecutedOrCreateExecution(item);
        if (execution == null || execution.getSteps().isEmpty()) {
            execution = this.startResumeNextExecution(testPlanOwnerId, item.getId());
        }
        return execution;
    }

    private Execution startResumePartialTestPlan(long testPlanOwnerId, List<IterationTestPlanItem> partialTestPlan) {
        E transientTestPlanOwner = this.createTransientTestPlanOwnerWithFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        String testerLogin = this.findUserLoginIfTester(testPlanOwnerId, transientTestPlanOwner.getClass().getName());
        IterationTestPlanItem item = this.findFirstExecutableTestPlanItem(testerLogin, transientTestPlanOwner);
        Execution execution = this.findUnexecutedOrCreateExecution(item);
        if (execution == null || execution.getSteps().isEmpty()) {
            this.startResumeNextExecution(testPlanOwnerId, item.getId());
        }
        return execution;
    }

    private Execution checkValidityThenResumeFilteredTestPlan(long iterationId, List<IterationTestPlanItem> partialTestPlan) {
        boolean hasDeletedTestCaseInFilteredSelection = this.hasDeletedTestCaseInFilteredSelection(partialTestPlan);
        if (!hasDeletedTestCaseInFilteredSelection) {
            try {
                return this.startResumePartialTestPlan(iterationId, partialTestPlan);
            }
            catch (TestPlanItemNotExecutableException ex) {
                throw new TestPlanTerminatedOrNoStepsException((Exception)((Object)ex));
            }
        }
        throw this.getTestPlanHasDeletedTestCaseException();
    }

    abstract ActionException getTestPlanHasDeletedTestCaseException();

    abstract List<IterationTestPlanItem> getFilteredTestPlan(long var1, List<GridFilterValue> var3);

    protected GridRequest prepareNonPaginatedGridRequest(List<GridFilterValue> filters) {
        GridRequest gridRequest = new GridRequest();
        gridRequest.setFilterValues(filters);
        return gridRequest.toNonPaginatedRequest();
    }

    protected List<Long> extractItemIdsFromGridResponse(GridResponse gridResponse) {
        return gridResponse.getDataRows().stream().map(row -> Long.valueOf(row.getId())).toList();
    }

    protected List<Long> extractItemIdsFromPartialTestPlan(List<IterationTestPlanItem> partialTestPlan) {
        return partialTestPlan.stream().map(IterationTestPlanItem::getId).toList();
    }

    @Override
    public Execution relaunch(long testPlanOwnerId) {
        this.deleteAllExecutions(testPlanOwnerId);
        return this.startResume(testPlanOwnerId);
    }

    @Override
    public TestPlanResume relaunchFilteredTestPlan(long testPlanOwnerId, List<GridFilterValue> filters) {
        List<IterationTestPlanItem> partialTestPlan = this.getFilteredTestPlan(testPlanOwnerId, filters);
        Execution execution = this.checkValidityThenRelaunchFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        boolean hasNextTestCase = this.partialTestPlanHasNextTestCase(testPlanOwnerId, execution, partialTestPlan);
        return this.createNewTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, this.extractItemIdsFromPartialTestPlan(partialTestPlan));
    }

    private Execution checkValidityThenRelaunchFilteredTestPlan(long testPlanOwnerId, List<IterationTestPlanItem> partialTestPlan) {
        boolean hasDeletedTestCaseInFilteredSelection = this.hasDeletedTestCaseInFilteredSelection(partialTestPlan);
        if (!hasDeletedTestCaseInFilteredSelection) {
            try {
                return this.startRelaunchPartialTestPlan(testPlanOwnerId, partialTestPlan);
            }
            catch (TestPlanItemNotExecutableException ex) {
                throw new TestPlanTerminatedOrNoStepsException((Exception)((Object)ex));
            }
        }
        throw this.getTestPlanHasDeletedTestCaseException();
    }

    private Execution startRelaunchPartialTestPlan(long testPlanOwnerId, List<IterationTestPlanItem> partialTestPlan) {
        this.deleteAllExecutionsOfPartialTestPlan(partialTestPlan, testPlanOwnerId);
        return this.startResumePartialTestPlan(testPlanOwnerId, partialTestPlan);
    }

    private void deleteAllExecutionsOfPartialTestPlan(List<IterationTestPlanItem> partialTestPlan, long testPlanOwnerId) {
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        this.deleteAllExecutionsOfTestPlan(partialTestPlan, testPlanOwner);
    }

    @Override
    public boolean hasMoreExecutableItems(long testPlanOwnerId, long testPlanItemId) {
        String testerLogin;
        E testPlanOwner = this.getTestPlanOwner(testPlanOwnerId);
        return !this.isLastExecutableTestPlanItem(testPlanOwner, testPlanItemId, testerLogin = this.findUserLoginIfTester(testPlanOwner));
    }

    private boolean partialTestPlanIdsHaveMoreExecutableItems(long testPlanOwnerId, Long testPlanItemId, List<IterationTestPlanItem> partialTestPlan) {
        E transientTestPlanOwner = this.createTransientTestPlanOwnerWithFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        String testerLogin = this.findUserLoginIfTester(testPlanOwnerId, transientTestPlanOwner.getClass().getName());
        return !this.isLastExecutableTestPlanItem(transientTestPlanOwner, testPlanItemId, testerLogin);
    }

    private boolean partialTestPlanHasMoreExecutableItems(long testPlanOwnerId, Long testPlanItemId, List<IterationTestPlanItem> partialTestPlan) {
        E transientTestPlanOwner = this.createTransientTestPlanOwnerWithFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        String testerLogin = this.findUserLoginIfTester(testPlanOwnerId, transientTestPlanOwner.getClass().getName());
        return !this.isLastExecutableTestPlanItem(transientTestPlanOwner, testPlanItemId, testerLogin);
    }

    abstract E getTestPlanOwner(long var1);

    abstract E createTransientTestPlanOwnerWithFilteredTestPlan(long var1, List<IterationTestPlanItem> var3);

    abstract List<IterationTestPlanItem> getTestPlan(E var1);

    abstract IterationTestPlanItem findFirstExecutableTestPlanItem(String var1, E var2);

    private boolean isLastExecutableTestPlanItem(E testPlanOwner, long testPlanItemId, String testerLogin) {
        List<IterationTestPlanItem> testPlans = this.getTestPlan(testPlanOwner);
        int i = testPlans.size() - 1;
        while (i >= 0) {
            IterationTestPlanItem item = testPlans.get(i);
            TestCase testCase = null;
            if (!item.isTestCaseDeleted()) {
                testCase = item.getReferencedTestCase();
                if (item.isExecutableThroughTestSuite() && this.testCaseHasSteps(testCase) && (testerLogin == null || item.isAssignedToUser(testerLogin))) {
                    return testPlanItemId == item.getId();
                }
            }
            --i;
        }
        return false;
    }

    private boolean testCaseHasSteps(final TestCase testCase) {
        final Wrapped hasSteps = new Wrapped();
        TestCaseVisitor visitor = new TestCaseVisitor(){

            public void visit(TestCase testCase2) {
                hasSteps.setValue((Object)(testCase2.getSteps() != null && !testCase2.getSteps().isEmpty() ? 1 : 0));
            }

            public void visit(KeywordTestCase keywordTestCase) {
                hasSteps.setValue((Object)(testCase.getSteps() != null && !testCase.getSteps().isEmpty() ? 1 : 0));
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                hasSteps.setValue((Object)(scriptedTestCase.getScript() != null && !scriptedTestCase.getScript().isEmpty() && AbstractTestPlanExecutionProcessingService.this.hasScenarios(scriptedTestCase) ? 1 : 0));
            }

            public void visit(ExploratoryTestCase exploratoryTestCase) {
                hasSteps.setValue((Object)false);
            }
        };
        testCase.accept(visitor);
        return (Boolean)hasSteps.getValue();
    }

    private boolean hasScenarios(ScriptedTestCase scriptedTestCase) {
        return GherkinParser.hasScenarios((String)scriptedTestCase.getScript());
    }

    abstract IterationTestPlanItem findNextExecutableTestPlanItem(E var1, long var2, String var4);

    abstract IterationTestPlanItem findNextExecutableTestPlanItem(E var1, long var2);

    private String findUserLoginIfTester(Object domainObject) {
        String testerLogin = null;
        try {
            PermissionsUtils.checkPermission(this.permissionEvaluationService, new SecurityCheckableObject(domainObject, "READ_UNASSIGNED"));
        }
        catch (AccessDeniedException ade) {
            LOGGER.error(ade.getMessage(), (Throwable)ade);
            testerLogin = this.userService.findCurrentUser().getLogin();
        }
        return testerLogin;
    }

    private String findUserLoginIfTester(long domainObjectId, String domainObjectClass) {
        String testerLogin = null;
        try {
            PermissionsUtils.checkPermission(this.permissionEvaluationService, Collections.singletonList(domainObjectId), "READ_UNASSIGNED", domainObjectClass);
        }
        catch (AccessDeniedException ade) {
            LOGGER.error(ade.getMessage(), (Throwable)ade);
            testerLogin = this.userService.findCurrentUser().getLogin();
        }
        return testerLogin;
    }

    private Execution findUnexecutedOrCreateExecution(IterationTestPlanItem testPlanItem) {
        Execution executionToReturn = null;
        if (testPlanItem.isExecutableThroughTestSuite() && (executionToReturn = testPlanItem.getLatestExecution()) == null) {
            executionToReturn = this.testPlanManager.addExecution(testPlanItem);
        }
        return executionToReturn;
    }

    protected boolean hasDeletedTestCaseInFilteredSelection(List<IterationTestPlanItem> partialTestPlan) {
        return partialTestPlan.stream().anyMatch(item -> Objects.isNull(item.getReferencedTestCase()));
    }

    @Override
    public TestPlanResume resumeWithFilteredTestPlan(long testPlanOwnerId, List<GridFilterValue> filters) {
        List<IterationTestPlanItem> partialTestPlan = this.getFilteredTestPlan(testPlanOwnerId, filters);
        Execution execution = this.checkValidityThenResumeFilteredTestPlan(testPlanOwnerId, partialTestPlan);
        boolean hasNextTestCase = this.partialTestPlanHasNextTestCase(testPlanOwnerId, execution, partialTestPlan);
        return this.createNewTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, this.extractItemIdsFromPartialTestPlan(partialTestPlan));
    }

    protected abstract TestPlanResume createNewTestPlanResume(long var1, Execution var3, boolean var4, List<Long> var5);

    @Override
    public TestPlanResume resumeNextExecutionOfFilteredTestPlan(long testPlanOwnerId, long testPlanItemId, List<Long> partialTestPlanItemIds) {
        List<Long> list = partialTestPlanItemIds;
        IterationTestPlanDao iterationTestPlanDao = this.iterationTestPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        AbstractTestPlanExecutionProcessingService$AjcClosure1 abstractTestPlanExecutionProcessingService$AjcClosure1 = new AbstractTestPlanExecutionProcessingService$AjcClosure1(objectArray);
        List partialTestPlan = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(abstractTestPlanExecutionProcessingService$AjcClosure1.linkClosureAndJoinPoint(4112));
        Execution execution = this.startResumeNextExecutionOfFilteredTestPlan(testPlanOwnerId, testPlanItemId, partialTestPlan);
        boolean hasNextTestCase = this.partialTestPlanIdsHasNextTestCase(testPlanOwnerId, execution, partialTestPlan);
        return this.createNewTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, partialTestPlanItemIds);
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody0(AbstractTestPlanExecutionProcessingService abstractTestPlanExecutionProcessingService, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdIn(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractTestPlanExecutionProcessingService.java", AbstractTestPlanExecutionProcessingService.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "ids", "", "java.util.List"), 542);
    }
}

