/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.knownissues.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.core.foundation.collection.Sorting;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.bugtracker.knownissues.local.LocalKnownIssue;
import org.squashtest.tm.service.bugtracker.knownissues.remote.RemoteKnownIssue;
import org.squashtest.tm.service.bugtracker.knownissues.remote.RemoteKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.CampaignFolderKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.CampaignKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExecutionKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExecutionStepKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExecutionUngroupedKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExploratorySessionOverviewKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExploratorySessionOverviewUngroupedKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.FailureDetailKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.IterationKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.RequirementVersionKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SessionNoteKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SprintKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SprintReqVersionKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.TestCaseKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.TestSuiteKnownIssueFinder;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.UserCredentialsCache;

@Service
@Transactional
public class RemoteKnownIssueFinderImpl
implements RemoteKnownIssueFinder {
    @Value(value="${squashtm.bugtracker.timeout:15}")
    private long timeout;
    private final BugTrackersService remoteBugTrackersService;
    private final CredentialsProvider credentialsProvider;
    private final BugTrackerDao bugTrackerDao;
    private final TestCaseKnownIssueFinder testCaseKnownIssueFinder;
    private final RequirementVersionKnownIssueFinder requirementVersionKnownIssueFinder;
    private final IterationKnownIssueFinder iterationKnownIssueFinder;
    private final TestSuiteKnownIssueFinder testSuiteKnownIssueFinder;
    private final CampaignKnownIssueFinder campaignKnownIssueFinder;
    private final CampaignFolderKnownIssueFinder campaignFolderKnownIssueFinder;
    private final ExecutionKnownIssueFinder executionKnownIssueFinder;
    private final FailureDetailKnownIssueFinder failureDetailKnownIssueFinder;
    private final ExecutionStepKnownIssueFinder executionStepKnownIssueFinder;
    private final ExecutionUngroupedKnownIssueFinder executionUngroupedKnownIssueFinder;
    private final SessionNoteKnownIssueFinder sessionNoteKnownIssueFinder;
    private final ExploratorySessionOverviewKnownIssueFinder exploratorySessionOverviewKnownIssueFinder;
    private final ExploratorySessionOverviewUngroupedKnownIssueFinder exploratorySessionOverviewUngroupedKnownIssueFinder;
    private final SprintReqVersionKnownIssueFinder sprintReqVersionKnownIssueFinder;
    private final SprintKnownIssueFinder sprintKnownIssueFinder;

    public RemoteKnownIssueFinderImpl(BugTrackersService remoteBugTrackersService, CredentialsProvider credentialsProvider, BugTrackerDao bugTrackerDao, TestCaseKnownIssueFinder testCaseKnownIssueFinder, RequirementVersionKnownIssueFinder requirementVersionKnownIssueFinder, IterationKnownIssueFinder iterationKnownIssueFinder, TestSuiteKnownIssueFinder testSuiteKnownIssueFinder, CampaignKnownIssueFinder campaignKnownIssueFinder, CampaignFolderKnownIssueFinder campaignFolderKnownIssueFinder, ExecutionKnownIssueFinder executionKnownIssueFinder, ExecutionStepKnownIssueFinder executionStepKnownIssueFinder, ExecutionUngroupedKnownIssueFinder executionUngroupedKnownIssueFinder, SessionNoteKnownIssueFinder sessionNoteKnownIssueFinder, ExploratorySessionOverviewKnownIssueFinder exploratorySessionOverviewKnownIssueFinder, ExploratorySessionOverviewUngroupedKnownIssueFinder exploratorySessionOverviewUngroupedKnownIssueFinder, SprintReqVersionKnownIssueFinder sprintReqVersionKnownIssueFinder, SprintKnownIssueFinder sprintKnownIssueFinder, FailureDetailKnownIssueFinder failureDetailKnownIssueFinder) {
        this.remoteBugTrackersService = remoteBugTrackersService;
        this.credentialsProvider = credentialsProvider;
        this.bugTrackerDao = bugTrackerDao;
        this.testCaseKnownIssueFinder = testCaseKnownIssueFinder;
        this.requirementVersionKnownIssueFinder = requirementVersionKnownIssueFinder;
        this.iterationKnownIssueFinder = iterationKnownIssueFinder;
        this.testSuiteKnownIssueFinder = testSuiteKnownIssueFinder;
        this.campaignKnownIssueFinder = campaignKnownIssueFinder;
        this.campaignFolderKnownIssueFinder = campaignFolderKnownIssueFinder;
        this.executionKnownIssueFinder = executionKnownIssueFinder;
        this.executionStepKnownIssueFinder = executionStepKnownIssueFinder;
        this.executionUngroupedKnownIssueFinder = executionUngroupedKnownIssueFinder;
        this.sessionNoteKnownIssueFinder = sessionNoteKnownIssueFinder;
        this.exploratorySessionOverviewKnownIssueFinder = exploratorySessionOverviewKnownIssueFinder;
        this.exploratorySessionOverviewUngroupedKnownIssueFinder = exploratorySessionOverviewUngroupedKnownIssueFinder;
        this.sprintReqVersionKnownIssueFinder = sprintReqVersionKnownIssueFinder;
        this.sprintKnownIssueFinder = sprintKnownIssueFinder;
        this.failureDetailKnownIssueFinder = failureDetailKnownIssueFinder;
    }

    @Override
    public List<RemoteKnownIssue> findForTestCase(long testCaseId, PagingAndSorting pagingAndSorting) {
        List<LocalKnownIssue> localKnownIssues = this.testCaseKnownIssueFinder.getPaginatedKnownIssues(testCaseId, pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public int getCountForTestCase(Long testCaseId) {
        return this.testCaseKnownIssueFinder.countKnownIssues(testCaseId);
    }

    @Override
    public List<RemoteKnownIssue> findForRequirementVersion(long requirementVersionId, PagingAndSorting pagingAndSorting) {
        List<LocalKnownIssue> issues = this.requirementVersionKnownIssueFinder.getPaginatedKnownIssues(requirementVersionId, pagingAndSorting);
        return this.findRemoteKnownIssues(issues, (Sorting)pagingAndSorting);
    }

    @Override
    public int getCountForRequirementVersion(Long requirementVersionId) {
        return this.requirementVersionKnownIssueFinder.countKnownIssues(requirementVersionId);
    }

    @Override
    public List<RemoteKnownIssue> findForIteration(long iterationId, PagingAndSorting pagingAndSorting) {
        List<LocalKnownIssue> localKnownIssues = this.iterationKnownIssueFinder.getPaginatedKnownIssues(iterationId, pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public int getCountForIteration(Long iterationId) {
        return this.iterationKnownIssueFinder.countKnownIssues(iterationId);
    }

    @Override
    public List<RemoteKnownIssue> findForTestSuite(long testSuiteId, PagingAndSorting pagingAndSorting) {
        List<LocalKnownIssue> localKnownIssues = this.testSuiteKnownIssueFinder.getPaginatedKnownIssues(testSuiteId, pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public int getCountForTestSuite(Long testSuiteId) {
        return this.testSuiteKnownIssueFinder.countKnownIssues(testSuiteId);
    }

    @Override
    public List<RemoteKnownIssue> findForCampaign(long campaignId, PagingAndSorting pagingAndSorting) {
        List<LocalKnownIssue> localKnownIssues = this.campaignKnownIssueFinder.getPaginatedKnownIssues(campaignId, pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public int getCountForCampaign(Long campaignId) {
        return this.campaignKnownIssueFinder.countKnownIssues(campaignId);
    }

    @Override
    public List<RemoteKnownIssue> findForCampaignFolder(long campaignFolderId, PagingAndSorting pagingAndSorting) {
        List<LocalKnownIssue> localKnownIssues = this.campaignFolderKnownIssueFinder.getPaginatedKnownIssues(campaignFolderId, pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public int getCountForCampaignFolder(Long campaignFolderId) {
        return this.campaignFolderKnownIssueFinder.countKnownIssues(campaignFolderId);
    }

    @Override
    public List<RemoteKnownIssue> findForExecution(long executionId, PagingAndSorting pagingAndSorting) {
        List<LocalKnownIssue> localKnownIssues = this.executionKnownIssueFinder.getPaginatedKnownIssues(executionId, pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public int getCountForExecution(Long executionId) {
        return this.executionKnownIssueFinder.countKnownIssues(executionId);
    }

    @Override
    public List<RemoteKnownIssue> findForFailureDetail(Long failureDetailId, PagingAndSorting pagingAndSorting) {
        List<LocalKnownIssue> localKnownIssues = this.failureDetailKnownIssueFinder.getPaginatedKnownIssues(failureDetailId, pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public int getCountForFailureDetail(Long failureDetailId) {
        return this.failureDetailKnownIssueFinder.countKnownIssues(failureDetailId);
    }

    @Override
    public List<RemoteKnownIssue> findForExecutionStep(long executionStepId, PagingAndSorting pagingAndSorting) {
        List<LocalKnownIssue> localKnownIssues = this.executionStepKnownIssueFinder.getPaginatedKnownIssues(executionStepId, pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public List<RemoteKnownIssue> findUngroupedForExecutionStep(long executionStepId) {
        DefaultPagingAndSorting pagingAndSorting = new DefaultPagingAndSorting("", true);
        List<LocalKnownIssue> localKnownIssues = this.executionStepKnownIssueFinder.getPaginatedKnownIssues(executionStepId, (PagingAndSorting)pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public int getCountForExecutionStep(Long executionStepId) {
        return this.executionStepKnownIssueFinder.countKnownIssues(executionStepId);
    }

    @Override
    public List<RemoteKnownIssue> findUngroupedForExecution(Long execId) {
        DefaultPagingAndSorting pagingAndSorting = new DefaultPagingAndSorting("", true);
        List<LocalKnownIssue> localKnownIssues = this.executionUngroupedKnownIssueFinder.getPaginatedKnownIssues(execId, (PagingAndSorting)pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public List<RemoteKnownIssue> findForSessionNote(Long sessionNoteId, PagingAndSorting sorter) {
        List<LocalKnownIssue> localKnownIssues = this.sessionNoteKnownIssueFinder.getPaginatedKnownIssues(sessionNoteId, sorter);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)sorter);
    }

    @Override
    public List<RemoteKnownIssue> findUngroupedForSessionNote(Long sessionNoteId) {
        DefaultPagingAndSorting pagingAndSorting = new DefaultPagingAndSorting("", true);
        List<LocalKnownIssue> localKnownIssues = this.sessionNoteKnownIssueFinder.getPaginatedKnownIssues(sessionNoteId, (PagingAndSorting)pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    @Override
    public int getCountForSessionNote(Long sessionNoteId) {
        return this.sessionNoteKnownIssueFinder.countKnownIssues(sessionNoteId);
    }

    @Override
    public List<RemoteKnownIssue> findForSessionOverview(Long overviewId, PagingAndSorting sorter) {
        List<LocalKnownIssue> localKnownIssues = this.exploratorySessionOverviewKnownIssueFinder.getPaginatedKnownIssues(overviewId, sorter);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)sorter);
    }

    @Override
    public int getCountForSessionOverview(Long overviewId) {
        return this.exploratorySessionOverviewKnownIssueFinder.countKnownIssues(overviewId);
    }

    @Override
    public List<RemoteKnownIssue> findUngroupedForOverview(Long overviewId) {
        DefaultPagingAndSorting pagingAndSorting = new DefaultPagingAndSorting("", true);
        List<LocalKnownIssue> localKnownIssues = this.exploratorySessionOverviewUngroupedKnownIssueFinder.getPaginatedKnownIssues(overviewId, (PagingAndSorting)pagingAndSorting);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)pagingAndSorting);
    }

    private List<RemoteKnownIssue> findRemoteKnownIssues(List<LocalKnownIssue> localKnownIssues, Sorting sorting) {
        Map<Long, Map<Long, List<LocalKnownIssue>>> map = this.getWorkMap(localKnownIssues);
        List<RemoteKnownIssue> remoteKnownIssues = this.collectRemoteIssues(map);
        this.applySorting(sorting, remoteKnownIssues);
        return remoteKnownIssues;
    }

    @Override
    public List<RemoteKnownIssue> findForSprintReqVersion(Long sprintReqVersionId, PagingAndSorting sorter) {
        List<LocalKnownIssue> localKnownIssues = this.sprintReqVersionKnownIssueFinder.getPaginatedKnownIssues(sprintReqVersionId, sorter);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)sorter);
    }

    @Override
    public int getCountForSprintReqVersion(Long sprintReqVersionId) {
        return this.sprintReqVersionKnownIssueFinder.countKnownIssues(sprintReqVersionId);
    }

    @Override
    public List<RemoteKnownIssue> findForSprint(Long sprintId, PagingAndSorting sorter) {
        List<LocalKnownIssue> localKnownIssues = this.sprintKnownIssueFinder.getPaginatedKnownIssues(sprintId, sorter);
        return this.findRemoteKnownIssues(localKnownIssues, (Sorting)sorter);
    }

    @Override
    public int getCountForSprint(Long sprintId) {
        return this.sprintKnownIssueFinder.countKnownIssues(sprintId);
    }

    private void applySorting(Sorting sorting, List<RemoteKnownIssue> remoteKnownIssues) {
        remoteKnownIssues.sort(Comparator.comparing(remoteKnownIssue -> {
            String issueId = remoteKnownIssue.remoteIssue.getId();
            if ("azuredevops.bugtracker".equals(remoteKnownIssue.bugTracker.getKind())) {
                return this.extractSubstringAfterLastTilde(issueId);
            }
            return issueId;
        }));
        if (sorting.getSortOrder().equals((Object)SortOrder.DESCENDING)) {
            Collections.reverse(remoteKnownIssues);
        }
    }

    private String extractSubstringAfterLastTilde(String remoteIssueId) {
        int lastIndex = remoteIssueId.lastIndexOf("~");
        return remoteIssueId.substring(lastIndex + 1);
    }

    private List<RemoteKnownIssue> collectRemoteIssues(Map<Long, Map<Long, List<LocalKnownIssue>>> map) {
        ArrayList<RemoteKnownIssue> remoteIssues = new ArrayList<RemoteKnownIssue>();
        map.forEach((projectId, issuesByBt) -> issuesByBt.forEach((btId, localIssues) -> {
            try {
                BugTracker bugTracker = (BugTracker)this.bugTrackerDao.getReferenceById(btId);
                Set<String> issueIds = localIssues.stream().map(local -> local.remoteIssueId).collect(Collectors.toSet());
                Future<List<RemoteIssue>> futureIssues = this.remoteBugTrackersService.getIssues((Long)projectId, (Collection<String>)issueIds, bugTracker, this.getCredentialsCache(), this.getLocaleContext(), this.getSecurityContext());
                List<RemoteIssue> btIssues = futureIssues.get(this.timeout, TimeUnit.SECONDS);
                List<RemoteKnownIssue> remoteKnownIssues = localIssues.stream().map(localIssue -> new RemoteKnownIssue(this.findRemoteIssue(btIssues, localIssue.remoteIssueId), bugTracker, (LocalKnownIssue)localIssue)).toList();
                remoteIssues.addAll(remoteKnownIssues);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                throw new BugTrackerRemoteException((Throwable)ex);
            }
        }));
        return remoteIssues;
    }

    private RemoteIssue findRemoteIssue(List<RemoteIssue> btIssues, String remoteIssueId) {
        return btIssues.stream().filter(btIssue -> btIssue.getId().equals(remoteIssueId)).findAny().orElseThrow(() -> new RuntimeException("Error while collecting remote issues : cannot find remote issue with id " + remoteIssueId));
    }

    private Map<Long, Map<Long, List<LocalKnownIssue>>> getWorkMap(List<LocalKnownIssue> localKnownIssues) {
        HashMap<Long, Map<Long, List<LocalKnownIssue>>> map = new HashMap<Long, Map<Long, List<LocalKnownIssue>>>();
        localKnownIssues.forEach(issue -> {
            Long projectId = issue.projectId;
            if (!map.containsKey(projectId)) {
                map.put(projectId, new HashMap());
            }
            Long bugtrackerId = issue.bugtrackerId;
            if (!((Map)map.get(projectId)).containsKey(bugtrackerId)) {
                ((Map)map.get(projectId)).put(bugtrackerId, new ArrayList());
            }
            ((List)((Map)map.get(projectId)).get(bugtrackerId)).add(issue);
        });
        return map;
    }

    private LocaleContext getLocaleContext() {
        return LocaleContextHolder.getLocaleContext();
    }

    private SecurityContext getSecurityContext() {
        return SecurityContextHolder.getContext();
    }

    private UserCredentialsCache getCredentialsCache() {
        return this.credentialsProvider.getCache();
    }
}

