/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.knownissues.local;

import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectHavingStep;
import org.jooq.SelectSeekStep1;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CampaignLibrary;
import org.squashtest.tm.jooq.domain.tables.CampaignLibraryContent;
import org.squashtest.tm.jooq.domain.tables.TestPlan;
import org.squashtest.tm.jooq.domain.tables.TestPlanItem;
import org.squashtest.tm.service.bugtracker.knownissues.local.LocalKnownIssue;
import org.squashtest.tm.service.bugtracker.knownissues.local.LocalKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.LocalKnownIssueFinderHelper;

public abstract class BaseLocalKnownIssueFinder<RECORD extends Record>
implements LocalKnownIssueFinder {
    protected final DSLContext dsl;

    protected BaseLocalKnownIssueFinder(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public int countKnownIssues(Long entityId) {
        return this.selectKnownIssues(entityId).fetch().size();
    }

    @Override
    public List<LocalKnownIssue> getPaginatedKnownIssues(Long entityId, PagingAndSorting paging) {
        SelectSeekStep1 nonPaginatedQuery = this.selectKnownIssues(entityId).orderBy(LocalKnownIssueFinderHelper.getOrderField(paging));
        Result records = paging.shouldDisplayAll() ? nonPaginatedQuery.fetch() : nonPaginatedQuery.limit((Number)paging.getFirstItemIndex(), (Number)paging.getPageSize()).fetch();
        return records.map(this::buildIssueFromRecord);
    }

    protected Table<?> getTable() {
        return BaseLocalKnownIssueFinder.getIssueToBugtrackerBindingJoin();
    }

    protected static Table<?> getIssueToBugtrackerBindingJoin() {
        return Tables.ISSUE.innerJoin((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.ISSUE.ISSUE_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID)).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)TestPlanItem.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)TestPlanItem.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)TestPlan.TEST_PLAN).on(TestPlanItem.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)TestPlan.TEST_PLAN.TEST_PLAN_ID)).leftJoin((TableLike)CampaignLibrary.CAMPAIGN_LIBRARY).on(TestPlan.TEST_PLAN.CL_ID.eq((Field)CampaignLibrary.CAMPAIGN_LIBRARY.CL_ID)).leftJoin((TableLike)CampaignLibraryContent.CAMPAIGN_LIBRARY_CONTENT).on(CampaignLibrary.CAMPAIGN_LIBRARY.CL_ID.eq((Field)CampaignLibraryContent.CAMPAIGN_LIBRARY_CONTENT.LIBRARY_ID)).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(DSL.coalesce((Field)CampaignLibraryContent.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID, (Field[])new Field[]{Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID}).eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID));
    }

    protected abstract SelectHavingStep<RECORD> selectKnownIssues(long var1);

    protected abstract LocalKnownIssue buildIssueFromRecord(RECORD var1);
}

