/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.excel;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.service.internal.batchimport.excel.NullPropertySetter;
import org.squashtest.tm.service.internal.batchimport.excel.PropertySetter;
import org.squashtest.tm.service.internal.batchimport.excel.ReflectionFieldSetter;
import org.squashtest.tm.service.internal.batchimport.excel.ReflectionMutatorSetter;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.LinkedLowLevelRequirementsSheetColumn;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementLinksSheetColumn;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.DatasetParamValuesSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.DatasetSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ParamAssignationModeSetter;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ParameterSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StepActionPropSetter;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StepResultPropSetter;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateWorksheet;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TestCaseSheetColumn;

final class PropertySetterRepository<COL extends Enum<COL>> {
    private static final String PROPERTY_PATH = "path";
    private static final String PROPERTY_MODE = "mode";
    private static final String PROPERTY_NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final Map<TemplateWorksheet, PropertySetterRepository<?>> FINDER_REPO_BY_WORKSHEET = new HashMap(TemplateWorksheet.values().length);
    private Map<COL, PropertySetter<?, ?>> propSetterByColumn = new HashMap();

    static {
        FINDER_REPO_BY_WORKSHEET.put(TemplateWorksheet.TEST_CASES_SHEET, PropertySetterRepository.createTestCasesWorksheetRepo());
        FINDER_REPO_BY_WORKSHEET.put(TemplateWorksheet.STEPS_SHEET, PropertySetterRepository.createStepsWorksheetRepo());
        FINDER_REPO_BY_WORKSHEET.put(TemplateWorksheet.PARAMETERS_SHEET, PropertySetterRepository.createParamsWorksheetRepo());
        FINDER_REPO_BY_WORKSHEET.put(TemplateWorksheet.DATASETS_SHEET, PropertySetterRepository.createDatasetsWorksheetRepo());
        FINDER_REPO_BY_WORKSHEET.put(TemplateWorksheet.DATASET_PARAM_VALUES_SHEET, PropertySetterRepository.createDatasetParamValuesWorksheetRepo());
        FINDER_REPO_BY_WORKSHEET.put(TemplateWorksheet.REQUIREMENT_SHEET, PropertySetterRepository.createRequirementWorksheetRepo());
        FINDER_REPO_BY_WORKSHEET.put(TemplateWorksheet.COVERAGE_SHEET, PropertySetterRepository.createCoverageWorksheetRepo());
        FINDER_REPO_BY_WORKSHEET.put(TemplateWorksheet.REQUIREMENT_LINKS_SHEET, PropertySetterRepository.createRequirementLinksWorksheetRepo());
        FINDER_REPO_BY_WORKSHEET.put(TemplateWorksheet.LINKED_LOW_LEVEL_REQS_SHEET, PropertySetterRepository.createLinkedLowLevelReqsWorksheetRepo());
    }

    private PropertySetterRepository() {
    }

    public static <C extends Enum<C>> PropertySetterRepository<C> forWorksheet(@NotNull TemplateWorksheet worksheet) {
        TemplateWorksheet templateWorksheet = worksheet;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)templateWorksheet);
        return FINDER_REPO_BY_WORKSHEET.get((Object)worksheet);
    }

    private static PropertySetterRepository<?> createCoverageWorksheetRepo() {
        PropertySetterRepository r = new PropertySetterRepository();
        r.propSetterByColumn.put(CoverageSheetColumn.REQ_PATH, ReflectionMutatorSetter.forProperty("reqPath", String.class));
        r.propSetterByColumn.put(CoverageSheetColumn.REQ_VERSION_NUM, ReflectionFieldSetter.forField("reqVersion"));
        r.propSetterByColumn.put(CoverageSheetColumn.TC_PATH, ReflectionMutatorSetter.forProperty("tcPath", String.class));
        return r;
    }

    private static PropertySetterRepository<?> createRequirementLinksWorksheetRepo() {
        PropertySetterRepository r = new PropertySetterRepository();
        r.propSetterByColumn.put(RequirementLinksSheetColumn.ACTION, ReflectionMutatorSetter.forOptionalProperty(PROPERTY_MODE));
        r.propSetterByColumn.put(RequirementLinksSheetColumn.REQ_PATH, ReflectionMutatorSetter.forProperty(PROPERTY_PATH, String.class));
        r.propSetterByColumn.put(RequirementLinksSheetColumn.REQ_VERSION_NUM, ReflectionMutatorSetter.forProperty(VERSION, Integer.class));
        r.propSetterByColumn.put(RequirementLinksSheetColumn.RELATED_REQ_PATH, ReflectionMutatorSetter.forProperty(PROPERTY_PATH, String.class));
        r.propSetterByColumn.put(RequirementLinksSheetColumn.RELATED_REQ_VERSION_NUM, ReflectionMutatorSetter.forProperty(VERSION, Integer.class));
        r.propSetterByColumn.put(RequirementLinksSheetColumn.RELATED_REQ_ROLE, ReflectionMutatorSetter.forOptionalProperty("relationRole"));
        return r;
    }

    private static PropertySetterRepository<?> createLinkedLowLevelReqsWorksheetRepo() {
        PropertySetterRepository r = new PropertySetterRepository();
        r.propSetterByColumn.put(LinkedLowLevelRequirementsSheetColumn.HIGH_LEVEL_REQ_PATH, ReflectionMutatorSetter.forProperty("highLevelReqPath", String.class));
        r.propSetterByColumn.put(LinkedLowLevelRequirementsSheetColumn.STANDARD_REQ_PATH, ReflectionMutatorSetter.forProperty("standardReqPath", String.class));
        return r;
    }

    private static PropertySetterRepository<?> createRequirementWorksheetRepo() {
        PropertySetterRepository r = new PropertySetterRepository();
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_PATH, ReflectionMutatorSetter.forProperty(PROPERTY_PATH, String.class));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_NUM, ReflectionFieldSetter.forOptionalField("order"));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_VERSION_REFERENCE, ReflectionFieldSetter.forOptionalField("reference"));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_VERSION_NAME, ReflectionFieldSetter.forOptionalField(PROPERTY_NAME));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_VERSION_MILESTONE, ReflectionFieldSetter.forOptionalField("milestones"));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_VERSION_NUM, ReflectionFieldSetter.forOptionalField(VERSION));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_VERSION_CATEGORY, ReflectionFieldSetter.forOptionalField("category"));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_VERSION_STATUS, ReflectionFieldSetter.forOptionalField("status"));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_VERSION_CRITICALITY, ReflectionFieldSetter.forOptionalField("criticality"));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_VERSION_DESCRIPTION, ReflectionFieldSetter.forOptionalField(DESCRIPTION));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_VERSION_CREATED_ON, ReflectionMutatorSetter.forOptionalProperty("createdOn"));
        r.propSetterByColumn.put(RequirementSheetColumn.REQ_VERSION_CREATED_BY, ReflectionMutatorSetter.forOptionalProperty("createdBy"));
        r.propSetterByColumn.put(RequirementSheetColumn.ACTION, ReflectionMutatorSetter.forOptionalProperty(PROPERTY_MODE));
        return r;
    }

    private static PropertySetterRepository<?> createDatasetsWorksheetRepo() {
        PropertySetterRepository r = new PropertySetterRepository();
        r.propSetterByColumn.put(DatasetSheetColumn.TC_OWNER_PATH, ReflectionMutatorSetter.forProperty(PROPERTY_PATH, String.class));
        r.propSetterByColumn.put(DatasetSheetColumn.TC_DATASET_NAME, ReflectionFieldSetter.forField(PROPERTY_NAME));
        r.propSetterByColumn.put(DatasetSheetColumn.ACTION, ReflectionFieldSetter.forOptionalField(PROPERTY_MODE));
        r.propSetterByColumn.put(DatasetSheetColumn.TC_PARAM_OWNER_PATH, NullPropertySetter.INSTANCE);
        r.propSetterByColumn.put(DatasetSheetColumn.TC_DATASET_PARAM_NAME, NullPropertySetter.INSTANCE);
        r.propSetterByColumn.put(DatasetSheetColumn.TC_DATASET_PARAM_VALUE, NullPropertySetter.INSTANCE);
        return r;
    }

    private static PropertySetterRepository<?> createDatasetParamValuesWorksheetRepo() {
        PropertySetterRepository r = new PropertySetterRepository();
        r.propSetterByColumn.put(DatasetParamValuesSheetColumn.TC_OWNER_PATH, ReflectionMutatorSetter.forProperty(PROPERTY_PATH, String.class));
        r.propSetterByColumn.put(DatasetParamValuesSheetColumn.TC_DATASET_NAME, ReflectionFieldSetter.forField(PROPERTY_NAME));
        r.propSetterByColumn.put(DatasetParamValuesSheetColumn.ACTION, ReflectionFieldSetter.forOptionalField(PROPERTY_MODE));
        r.propSetterByColumn.put(DatasetParamValuesSheetColumn.TC_PARAM_OWNER_PATH, ReflectionFieldSetter.forOptionalField("parameterOwnerPath"));
        r.propSetterByColumn.put(DatasetParamValuesSheetColumn.TC_DATASET_PARAM_NAME, ReflectionFieldSetter.forField("parameterName"));
        r.propSetterByColumn.put(DatasetParamValuesSheetColumn.TC_DATASET_PARAM_VALUE, ReflectionFieldSetter.forOptionalField("value"));
        return r;
    }

    private static PropertySetterRepository<?> createParamsWorksheetRepo() {
        PropertySetterRepository r = new PropertySetterRepository();
        r.propSetterByColumn.put(ParameterSheetColumn.TC_OWNER_PATH, ReflectionMutatorSetter.forProperty(PROPERTY_PATH, String.class));
        r.propSetterByColumn.put(ParameterSheetColumn.ACTION, ReflectionFieldSetter.forOptionalField(PROPERTY_MODE));
        r.propSetterByColumn.put(ParameterSheetColumn.TC_PARAM_NAME, ReflectionFieldSetter.forField(PROPERTY_NAME));
        r.propSetterByColumn.put(ParameterSheetColumn.TC_PARAM_DESCRIPTION, ReflectionFieldSetter.forOptionalField(DESCRIPTION));
        return r;
    }

    private static PropertySetterRepository<?> createStepsWorksheetRepo() {
        PropertySetterRepository stepWorksheetRepo = new PropertySetterRepository();
        stepWorksheetRepo.propSetterByColumn.put(StepSheetColumn.TC_OWNER_PATH, ReflectionMutatorSetter.forProperty(PROPERTY_PATH, String.class));
        stepWorksheetRepo.propSetterByColumn.put(StepSheetColumn.TC_STEP_NUM, ReflectionFieldSetter.forOptionalField("index"));
        stepWorksheetRepo.propSetterByColumn.put(StepSheetColumn.ACTION, ReflectionMutatorSetter.forOptionalProperty(PROPERTY_MODE));
        stepWorksheetRepo.propSetterByColumn.put(StepSheetColumn.TC_STEP_IS_CALL_STEP, NullPropertySetter.INSTANCE);
        stepWorksheetRepo.propSetterByColumn.put(StepSheetColumn.TC_STEP_ACTION, StepActionPropSetter.INSTANCE);
        stepWorksheetRepo.propSetterByColumn.put(StepSheetColumn.TC_STEP_EXPECTED_RESULT, StepResultPropSetter.INSTANCE);
        stepWorksheetRepo.propSetterByColumn.put(StepSheetColumn.TC_STEP_CALL_DATASET, ParamAssignationModeSetter.INSTANCE);
        return stepWorksheetRepo;
    }

    private static PropertySetterRepository<?> createTestCasesWorksheetRepo() {
        PropertySetterRepository r = new PropertySetterRepository();
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_PATH, ReflectionMutatorSetter.forProperty(PROPERTY_PATH, String.class));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_NUM, ReflectionFieldSetter.forOptionalField("order"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_UUID, ReflectionFieldSetter.forOptionalField("uuid"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_REFERENCE, ReflectionFieldSetter.forOptionalField("reference"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_NAME, ReflectionFieldSetter.forOptionalField(PROPERTY_NAME));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_MILESTONE, ReflectionFieldSetter.forOptionalField("milestones"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_WEIGHT_AUTO, ReflectionFieldSetter.forOptionalField("importanceAuto"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_WEIGHT, ReflectionFieldSetter.forOptionalField("importance"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_NATURE, ReflectionFieldSetter.forOptionalField("nature"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_TYPE, ReflectionFieldSetter.forOptionalField("type"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_STATUS, ReflectionFieldSetter.forOptionalField("status"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_AUTOMATABLE, ReflectionFieldSetter.forOptionalField("automatable"));
        r.propSetterByColumn.put(TestCaseSheetColumn.DRAFTED_BY_AI, ReflectionMutatorSetter.forOptionalProperty("draftedByAi", Boolean.class));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_DESCRIPTION, ReflectionFieldSetter.forOptionalField(DESCRIPTION));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_PRE_REQUISITE, ReflectionFieldSetter.forOptionalField("prerequisite"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_CREATED_ON, ReflectionMutatorSetter.forOptionalProperty("createdOn"));
        r.propSetterByColumn.put(TestCaseSheetColumn.TC_CREATED_BY, ReflectionMutatorSetter.forOptionalProperty("createdBy"));
        r.propSetterByColumn.put(TestCaseSheetColumn.ACTION, ReflectionMutatorSetter.forOptionalProperty(PROPERTY_MODE));
        return r;
    }

    public <V, T> PropertySetter<V, T> findPropSetter(COL col) {
        return this.propSetterByColumn.get(col);
    }
}

