/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.excel;

import org.squashtest.tm.service.internal.batchimport.testcase.excel.ColumnProcessingMode;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateWorksheet;

public enum DatasetSheetColumn implements TemplateColumn
{
    ACTION,
    TC_OWNER_PATH(ColumnProcessingMode.MANDATORY),
    TC_OWNER_ID(ColumnProcessingMode.IGNORED),
    TC_DATASET_ID(ColumnProcessingMode.IGNORED),
    TC_DATASET_NAME(ColumnProcessingMode.MANDATORY),
    TC_PARAM_OWNER_PATH,
    TC_PARAM_OWNER_ID(ColumnProcessingMode.IGNORED),
    TC_DATASET_PARAM_NAME(ColumnProcessingMode.MANDATORY),
    TC_DATASET_PARAM_VALUE;

    public final String header = this.name();
    public final ColumnProcessingMode processingMode;

    private DatasetSheetColumn() {
        this.processingMode = ColumnProcessingMode.OPTIONAL;
    }

    private DatasetSheetColumn(ColumnProcessingMode processingMode) {
        this.processingMode = processingMode;
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public ColumnProcessingMode getProcessingMode() {
        return this.processingMode;
    }

    @Override
    public TemplateWorksheet getWorksheet() {
        return TemplateWorksheet.DATASETS_SHEET;
    }

    @Override
    public String getFullName() {
        return String.valueOf(this.getWorksheet().sheetName) + "." + this.header;
    }
}

