/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.requirement.excel;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.internal.batchimport.excel.ExcelBatchImporter;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.CoverageInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.InstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.LinkedLowLevelRequirementInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.RequirementLinkInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.RequirementVersionInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ExcelWorkbookParser;

@Component
public class RequirementExcelBatchImporter
extends ExcelBatchImporter {
    private static final List<EntityType> REQ_ENTITIES_ORDERED_BY_INSTRUCTION_ORDER = Arrays.asList(EntityType.REQUIREMENT_VERSION, EntityType.COVERAGE, EntityType.REQUIREMENT_LINK, EntityType.LINKED_LOW_LEVEL_REQ);

    public RequirementExcelBatchImporter() {
        super(LoggerFactory.getLogger(RequirementExcelBatchImporter.class));
    }

    @Override
    public InstructionContainer<?> findInstructionsByEntity(ExcelWorkbookParser parser, EntityType entityType) {
        this.LOGGER.debug("creating instructions container for entity type : {}", new Object[]{entityType});
        return switch (entityType) {
            case EntityType.REQUIREMENT_VERSION -> new RequirementVersionInstructionContainer(parser.getRequirementVersionInstructions());
            case EntityType.COVERAGE -> new CoverageInstructionContainer(parser.getCoverageInstructions());
            case EntityType.REQUIREMENT_LINK -> new RequirementLinkInstructionContainer(parser.getRequirementLinkgsInstruction());
            case EntityType.LINKED_LOW_LEVEL_REQ -> new LinkedLowLevelRequirementInstructionContainer(parser.getLinkedLowLevelRequirementInstruction());
            default -> throw new IllegalArgumentException("Unknown EntityType for Requirement import : " + this);
        };
    }

    @Override
    public List<EntityType> getEntityType() {
        return REQ_ENTITIES_ORDERED_BY_INSTRUCTION_ORDER;
    }
}

