/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instructioncontainer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.Instruction;
import org.squashtest.tm.service.internal.batchimport.LogTrain;

public abstract class InstructionContainer<T extends Instruction<? extends Target>> {
    private final List<T> createInstructions;
    private final List<T> updateInstructions;
    private final List<T> deleteInstructions;
    private final Map<T, LogTrain> errorInstructions;

    protected InstructionContainer(List<T> instructions) {
        Map<Boolean, List<Instruction>> partitionedInstructions = instructions.stream().collect(Collectors.partitioningBy(instruction -> !instruction.getLogTrain().hasCriticalErrors()));
        this.errorInstructions = partitionedInstructions.get(false).stream().collect(Collectors.toMap(Function.identity(), Instruction::getLogTrain));
        Map instructionsByMode = partitionedInstructions.get(true).stream().collect(Collectors.groupingBy(Instruction::getMode, Collectors.toList()));
        this.createInstructions = instructionsByMode.getOrDefault((Object)ImportMode.CREATE, Collections.emptyList());
        this.updateInstructions = instructionsByMode.getOrDefault((Object)ImportMode.UPDATE, Collections.emptyList());
        this.deleteInstructions = instructionsByMode.getOrDefault((Object)ImportMode.DELETE, Collections.emptyList());
    }

    public List<T> getCreateInstructions() {
        return this.createInstructions;
    }

    public List<T> getUpdateInstructions() {
        return this.updateInstructions;
    }

    public List<T> getDeleteInstructions() {
        return this.deleteInstructions;
    }

    public Map<T, LogTrain> executeInstructions(Facility facility) {
        HashMap<T, LogTrain> logTrains = new HashMap<T, LogTrain>();
        if (!this.createInstructions.isEmpty()) {
            logTrains.putAll(this.executeCreate(facility));
        }
        if (!this.updateInstructions.isEmpty()) {
            logTrains.putAll(this.executeUpdate(facility));
        }
        if (!this.deleteInstructions.isEmpty()) {
            logTrains.putAll(this.executeDelete(facility));
        }
        logTrains.putAll(this.errorInstructions);
        return logTrains;
    }

    public List<Instruction<?>> getAllInstructions() {
        ArrayList instructions = new ArrayList();
        instructions.addAll(this.createInstructions);
        instructions.addAll(this.updateInstructions);
        instructions.addAll(this.deleteInstructions);
        instructions.addAll(this.errorInstructions.keySet());
        return instructions;
    }

    protected Map<T, LogTrain> executeUpdate(Facility facility) {
        return this.executeInstructions(this.getUpdateInstructions(), facility);
    }

    protected Map<T, LogTrain> executeDelete(Facility facility) {
        return this.executeInstructions(this.getDeleteInstructions(), facility);
    }

    protected Map<T, LogTrain> executeCreate(Facility facility) {
        return this.executeInstructions(this.getCreateInstructions(), facility);
    }

    protected Map<T, LogTrain> executeInstructions(List<T> instructions, Facility facility) {
        return instructions.stream().collect(Collectors.toMap(instruction -> instruction, instruction -> instruction.execute(facility)));
    }
}

