/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.importer.WithPath;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.batchimport.ActionStepInstruction;
import org.squashtest.tm.service.internal.batchimport.CallStepInstruction;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.CustomFieldValidator;
import org.squashtest.tm.service.internal.batchimport.DatasetInstruction;
import org.squashtest.tm.service.internal.batchimport.DatasetParamValueInstruction;
import org.squashtest.tm.service.internal.batchimport.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.EntityValidator;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.HighLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.Instruction;
import org.squashtest.tm.service.internal.batchimport.LinkedLowLevelRequirementInstruction;
import org.squashtest.tm.service.internal.batchimport.LinkedLowLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.MilestoneImportHelper;
import org.squashtest.tm.service.internal.batchimport.Milestoned;
import org.squashtest.tm.service.internal.batchimport.Model;
import org.squashtest.tm.service.internal.batchimport.ParameterInstruction;
import org.squashtest.tm.service.internal.batchimport.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.ProjectTargetStatus;
import org.squashtest.tm.service.internal.batchimport.RequirementLinkInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementLinkTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.StepType;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.TestCaseImportValidationBag;
import org.squashtest.tm.service.internal.batchimport.TestCaseInstruction;
import org.squashtest.tm.service.internal.batchimport.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.TestStepTarget;
import org.squashtest.tm.service.internal.batchimport.ValidationFacilitySubservicesProvider;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.LinkedLowLevelRequirementsSheetColumn;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageInstruction;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageTarget;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TestCaseSheetColumn;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionCoverageDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.UserContextService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

@Component
@Scope(value="prototype")
public class ValidationFacility
implements Facility,
ValidationFacilitySubservicesProvider {
    private static final String ROLE_ADMIN = "ROLE_ADMIN";
    private static final String PERM_READ = "READ";
    private static final String PERM_LINK = "LINK";
    private static final String PERM_IMPORT = "IMPORT";
    private static final String TEST_CASE_LIBRARY_CLASSNAME = "org.squashtest.tm.domain.testcase.TestCaseLibrary";
    private static final String REQUIREMENT_VERSION_LIBRARY_CLASSNAME = "org.squashtest.tm.domain.requirement.RequirementLibrary";
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationFacility.class);
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private InfoListItemFinderService infoListItemService;
    @Inject
    private Model model;
    @Inject
    private UserDao userDao;
    @Value(value="#{@featureManager.isEnabled('MILESTONE')}")
    private boolean milestonesEnabled;
    @Inject
    private MilestoneImportHelper milestoneHelper;
    @Inject
    private TestCaseLibraryNavigationService tcLibNavigationService;
    @Inject
    private RequirementLibraryFinderService reqFinderService;
    @Inject
    private RequirementVersionCoverageDao coverageDao;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private UserContextService userContextService;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private PluginFinderService pluginFinderService;
    @Inject
    private HighLevelRequirementService highLevelRequirementService;
    private EntityValidator entityValidator = new EntityValidator(this);
    private CustomFieldValidator cufValidator = new CustomFieldValidator();
    private CreationStrategy<TestCaseInstruction, TestCaseTarget> testCaseCreationStrategy = new CreationStrategy();
    private UpdateStrategy<TestCaseInstruction, TestCaseTarget> testCaseUpdateStrategy = new UpdateStrategy();
    private CreationStrategy<RequirementVersionInstruction, RequirementVersionTarget> requirementVersionCreationStrategy = new CreationStrategy();
    private UpdateStrategy<RequirementVersionInstruction, RequirementVersionTarget> requirementVersionUpdateStrategy = new UpdateStrategy();

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public InfoListItemFinderService getInfoListItemService() {
        return this.infoListItemService;
    }

    @Override
    public PluginFinderService getPluginFinderService() {
        return this.pluginFinderService;
    }

    @Override
    public RequirementLibraryFinderService getRequirementLibraryFinderService() {
        return this.reqFinderService;
    }

    @Override
    public HighLevelRequirementService getHighLevelRequirementService() {
        return this.highLevelRequirementService;
    }

    private void checkPathForUpdate(TestCaseTarget target, String name, LogTrain logs) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        String path = target.getPath();
        if (!PathUtils.arePathsAndNameConsistents((String)path, (String)name)) {
            String newPath = PathUtils.rename((String)path, (String)name);
            TestCaseTarget newTarget = new TestCaseTarget(newPath);
            TargetStatus newStatus = this.model.getStatus(newTarget);
            if (newStatus.status != Existence.NOT_EXISTS) {
                logs.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.tc.cantrename", new String[]{path, newPath}));
            }
        }
    }

    private List<LogEntry> fixMetadatas(Target target, AuditableMixin auditable, ImportMode importMode, EntityType type) {
        ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
        String login = auditable.getCreatedBy();
        boolean fixUser = false;
        if (StringUtils.isBlank((CharSequence)login)) {
            fixUser = true;
        } else {
            User user = this.userDao.findUserByLogin(login);
            if (user == null || !user.getActive().booleanValue()) {
                String warningMessage = null;
                String impactMessage = switch (importMode) {
                    case ImportMode.CREATE -> "message.import.log.impact.useCurrentLogin";
                    case ImportMode.UPDATE -> "message.import.log.impact.fieldNotChange";
                    default -> "message.import.log.impact.fieldNotChange";
                };
                switch (type) {
                    case REQUIREMENT_VERSION: {
                        warningMessage = "message.import.log.error.requirement.userNotFound";
                        break;
                    }
                    case TEST_CASE: {
                        warningMessage = "message.import.log.error.tc.userNotFound";
                        break;
                    }
                }
                LogEntry logEntry = LogEntry.warning().forTarget(target).withMessage(warningMessage, new Object[0]).withImpact(impactMessage, new Object[0]).build();
                logEntries.add(logEntry);
                fixUser = true;
            }
        }
        if (fixUser) {
            String username = this.userContextService.getUsername();
            auditable.setCreatedBy(username);
        }
        if (auditable.getCreatedOn() == null) {
            auditable.setCreatedOn(new Date());
        }
        return logEntries;
    }

    private List<LogEntry> fixMetadata(Target target, AuditableMixin auditable, ImportMode importMode, EntityType type, TestCaseImportValidationBag validationBag) {
        ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
        String login = auditable.getCreatedBy();
        boolean fixUser = false;
        if (StringUtils.isBlank((CharSequence)login)) {
            fixUser = true;
        } else if (!validationBag.activeLogins().contains(login)) {
            String warningMessage = null;
            String impactMessage = switch (importMode) {
                case ImportMode.CREATE -> "message.import.log.impact.useCurrentLogin";
                case ImportMode.UPDATE -> "message.import.log.impact.fieldNotChange";
                default -> "message.import.log.impact.fieldNotChange";
            };
            switch (type) {
                case REQUIREMENT_VERSION: {
                    warningMessage = "message.import.log.error.requirement.userNotFound";
                    break;
                }
                case TEST_CASE: {
                    warningMessage = "message.import.log.error.tc.userNotFound";
                    break;
                }
            }
            LogEntry logEntry = LogEntry.warning().forTarget(target).withMessage(warningMessage, new Object[0]).withImpact(impactMessage, new Object[0]).build();
            logEntries.add(logEntry);
            fixUser = true;
        }
        if (fixUser) {
            String username = validationBag.currentUsername();
            auditable.setCreatedBy(username);
        }
        if (auditable.getCreatedOn() == null) {
            auditable.setCreatedOn(new Date());
        }
        return logEntries;
    }

    @Override
    public LogTrain deleteTestCase(TestCaseTarget target) {
        LogEntry hasntPermission;
        LogTrain logs = new LogTrain();
        TargetStatus status = this.model.getStatus(target);
        if (status.getStatus() == Existence.NOT_EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.notFound", new Object[0]).build());
        }
        if ((hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target, (Target)target)) != null) {
            logs.addEntry(hasntPermission);
        }
        if (this.model.isCalled(target)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.cannotRemoveCalledTestCase", new Object[0]).build());
        }
        if (this.model.isTestCaseLockedByMilestones(target)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        return logs;
    }

    private LogTrain checkActionStepAddition(TestStepTarget target, ActionTestStep testStep, Map<String, String> cufValues) {
        LogEntry indexCheckLog;
        LogTrain logs = this.entityValidator.basicTestStepChecks(target);
        logs.append(this.cufValidator.checkCreateCustomFields(target, cufValues, this.model.getTestStepCufs(target)));
        LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasntPermission != null) {
            logs.addEntry(hasntPermission);
        }
        if (this.model.isTestCaseLockedByMilestones(target.getTestCase())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        TestCaseTarget testCase = target.getTestCase();
        TargetStatus tcStatus = this.getModel().getStatus(testCase);
        if ((tcStatus.status == Existence.TO_BE_CREATED || tcStatus.status == Existence.EXISTS) && (indexCheckLog = this.checkStepIndex(ImportMode.CREATE, target, ImportStatus.WARNING, "message.import.log.impact.testStepAddedAtMaxPosition")) != null) {
            logs.addEntry(indexCheckLog);
        }
        this.checkParamNameInString(target, logs, testStep.getAction(), StepSheetColumn.TC_STEP_ACTION);
        this.checkParamNameInString(target, logs, testStep.getExpectedResult(), StepSheetColumn.TC_STEP_EXPECTED_RESULT);
        return logs;
    }

    private void checkParamNameInString(Target target, LogTrain logs, String action, TemplateColumn column) {
        boolean hasInvalidParameterNamesInAction = Parameter.hasInvalidParameterNamesInString((String)action);
        if (hasInvalidParameterNamesInAction) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.step.param.wrongFormat", column.getHeader()).build());
        }
    }

    public LogTrain checkCallStepCreation(TestStepTarget target, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfo) {
        LogEntry indexCheckLog;
        LogEntry hasntCallPermission;
        LogTrain logs = this.entityValidator.basicTestStepChecks(target);
        logs.append(this.entityValidator.validateCallStep(target, calledTestCase, paramInfo, ImportMode.CREATE));
        LogEntry hasntOwnerPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasntOwnerPermission != null) {
            logs.addEntry(hasntOwnerPermission);
        }
        if ((hasntCallPermission = this.checkPermissionOnProject(PERM_READ, calledTestCase, (Target)target)) != null) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.tc.callStep.calledTcNotReadable", new Object[0]).withImpact("message.import.log.impact.callStepImportedAsActionStep", new Object[0]).build());
        }
        if (this.model.isTestCaseLockedByMilestones(target.getTestCase())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        if ((indexCheckLog = this.checkStepIndex(ImportMode.CREATE, target, ImportStatus.WARNING, "message.import.log.impact.testStepAddedAtMaxPosition")) != null) {
            logs.addEntry(indexCheckLog);
        }
        return logs;
    }

    @Override
    public LogTrain updateActionStep(TestStepTarget target, ActionTestStep testStep, Map<String, String> cufValues) {
        boolean exists;
        LogTrain logs = this.entityValidator.basicTestStepChecks(target);
        logs.append(this.cufValidator.checkUpdateCustomFields(target, cufValues, this.model.getTestStepCufs(target)));
        LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasntPermission != null) {
            logs.addEntry(hasntPermission);
        }
        if (this.model.isTestCaseLockedByMilestones(target.getTestCase())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        if (!(exists = this.model.stepExists(target))) {
            if (target.getIndex() == null) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.empty", new Object[0]).build());
            } else if (target.getIndex() < 0) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.negative", new Object[0]).build());
            } else {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.notexists", new Object[0]).build());
            }
        } else {
            StepType type = this.model.getType(target);
            if (type != StepType.ACTION) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.notanactionstep", new Object[0]).build());
            }
        }
        this.checkParamNameInString(target, logs, testStep.getAction(), StepSheetColumn.TC_STEP_ACTION);
        this.checkParamNameInString(target, logs, testStep.getExpectedResult(), StepSheetColumn.TC_STEP_EXPECTED_RESULT);
        return logs;
    }

    @Override
    public LogTrain updateCallStep(TestStepTarget target, CallTestStep testStep, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfos, ActionTestStep actionStepBackup) {
        boolean exists;
        LogEntry hasntCallPermission;
        LogTrain logs = this.entityValidator.basicTestStepChecks(target);
        logs.append(this.entityValidator.validateCallStep(target, calledTestCase, paramInfos, ImportMode.UPDATE));
        LogEntry hasntOwnerPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasntOwnerPermission != null) {
            logs.addEntry(hasntOwnerPermission);
        }
        if ((hasntCallPermission = this.checkPermissionOnProject(PERM_READ, calledTestCase, (Target)target)) != null) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.callStep.calledTcNotReadable", new Object[0]).build());
        }
        if (this.model.isTestCaseLockedByMilestones(target.getTestCase())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        if (!(exists = this.model.stepExists(target))) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.notexists", new Object[0]).build());
        } else {
            StepType type = this.model.getType(target);
            if (type != StepType.CALL) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.notacallstep", new Object[0]).build());
            }
            if (this.model.wouldCreateCycle(target, calledTestCase)) {
                logs.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.tc.callStep.cyclicCalls", new Object[]{target.getTestCase().getPath(), calledTestCase.getPath()}));
            }
        }
        return logs;
    }

    @Override
    public LogTrain deleteTestStep(TestStepTarget target) {
        LogEntry indexCheckLog;
        LogTrain logs = this.entityValidator.basicTestStepChecks(target);
        LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasntPermission != null) {
            logs.addEntry(hasntPermission);
        }
        if (this.model.isTestCaseLockedByMilestones(target.getTestCase())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        if ((indexCheckLog = this.checkStepIndex(ImportMode.DELETE, target, ImportStatus.FAILURE, null)) != null) {
            logs.addEntry(indexCheckLog);
        }
        return logs;
    }

    private LogTrain checkParameterCreation(ParameterTarget target) {
        LogEntry hasNoPermission;
        LogTrain logs = this.entityValidator.basicParameterChecks(target);
        if (this.model.doesParameterExists(target)) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.tc.param.alreadyexists", new Object[0]).withImpact("message.import.log.impact.paramupdate", new Object[0]).build());
        }
        if ((hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getOwner(), (Target)target)) != null) {
            logs.addEntry(hasNoPermission);
        }
        return logs;
    }

    @Override
    public LogTrain updateParameter(ParameterTarget target, Parameter param) {
        LogEntry hasNoPermission;
        LogTrain logs = this.entityValidator.basicParameterChecks(target);
        if (!this.model.doesParameterExists(target)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.param.notFound", new Object[0]).build());
        }
        if ((hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getOwner(), (Target)target)) != null) {
            logs.addEntry(hasNoPermission);
        }
        return logs;
    }

    @Override
    public LogTrain deleteParameter(ParameterTarget target) {
        LogEntry hasNoPermission;
        LogTrain logs = new LogTrain();
        if (!this.model.doesParameterExists(target)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.param.notFound", new Object[0]).build());
        }
        if ((hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getOwner(), (Target)target)) != null) {
            logs.addEntry(hasNoPermission);
        }
        return logs;
    }

    @Override
    public LogTrain failsafeUpdateParameterValue(DatasetTarget dataset, ParameterTarget param, String value, boolean isUpdate) {
        LogTrain junk = this.entityValidator.basicDatasetCheck(dataset);
        LogTrain logs = this.entityValidator.basicParameterValueChecks(param);
        logs.setForAll(dataset);
        if (!logs.hasCriticalErrors() && !junk.hasCriticalErrors()) {
            LogEntry hasNoPermission;
            if (!this.model.isParamInDataset(param, dataset)) {
                logs.addEntry(LogEntry.failure().forTarget(dataset).withMessage("message.import.log.error.tc.dataset.paramOwnerNotFound", new Object[0]).build());
            }
            if ((hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, dataset.getTestCase(), (Target)dataset)) != null) {
                logs.addEntry(hasNoPermission);
            }
        }
        return logs;
    }

    private LogTrain checkDatasetCreation(DatasetTarget dataset) {
        LogTrain logs = this.entityValidator.basicDatasetCheck(dataset);
        LogEntry hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, dataset.getTestCase(), (Target)dataset);
        if (hasNoPermission != null) {
            logs.addEntry(hasNoPermission);
        }
        return logs;
    }

    @Override
    public LogTrain deleteDataset(DatasetTarget dataset) {
        LogEntry hasNoPermission;
        LogTrain logs = this.entityValidator.basicDatasetCheck(dataset);
        if (!this.model.doesDatasetExists(dataset)) {
            logs.addEntry(LogEntry.failure().forTarget(dataset).withMessage("message.import.log.error.tc.dataset.notFound", new Object[0]).build());
        }
        if ((hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, dataset.getTestCase(), (Target)dataset)) != null) {
            logs.addEntry(hasNoPermission);
        }
        return logs;
    }

    private LogEntry checkPermissionOnProject(String permission, TestCaseTarget target, Target checkedTarget) {
        LogEntry entry = null;
        Long libid = this.model.getProjectStatus(target.getProject()).getTestCaseLibraryId();
        if (libid != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, permission, libid, TEST_CASE_LIBRARY_CLASSNAME)) {
            entry = new LogEntry(checkedTarget, ImportStatus.FAILURE, "message.import.log.error.unsuficientRight", new String[]{permission, target.getPath()});
        }
        return entry;
    }

    private LogEntry checkPermissionOnProject(String permission, RequirementVersionTarget target, Target checkedTarget) {
        LogEntry entry = null;
        Long libid = this.model.getProjectStatus(target.getProject()).getRequirementLibraryId();
        if (libid != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, permission, libid, REQUIREMENT_VERSION_LIBRARY_CLASSNAME)) {
            entry = new LogEntry(checkedTarget, ImportStatus.FAILURE, "message.import.log.error.unsuficientRight", new String[]{permission, target.getPath()});
        }
        return entry;
    }

    private LogEntry checkPermissionOnProject(String permission, CoverageTarget coverageTarget, Target checkedTarget) {
        String reqPath;
        Project reqProject;
        Long reqLibid;
        LogEntry entry = null;
        String tcPath = coverageTarget.getTcPath();
        Project tcProject = this.getProjectFromPath(tcPath);
        Long tcLibid = tcProject.getTestCaseLibrary().getId();
        if (tcLibid != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, permission, tcLibid, TEST_CASE_LIBRARY_CLASSNAME)) {
            entry = LogEntry.failure().forTarget(checkedTarget).withMessage("message.import.log.error.unsuficientRight", permission, tcPath).build();
        }
        if ((reqLibid = (reqProject = this.getProjectFromPath(reqPath = coverageTarget.getReqPath())).getRequirementLibrary().getId()) != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, permission, reqLibid, REQUIREMENT_VERSION_LIBRARY_CLASSNAME)) {
            entry = LogEntry.failure().forTarget(checkedTarget).withMessage("message.import.log.error.unsuficientRight", permission, reqPath).build();
        }
        return entry;
    }

    private LogEntry checkPermissionOnProject(String permission, LinkedLowLevelRequirementTarget linkedLowLevelRequirementTarget, Target checkedTarget) {
        String standardReqPath;
        Project reqProject;
        Long standardReqLibid;
        LogEntry entry = null;
        String highLevelReqPath = linkedLowLevelRequirementTarget.getHighLevelReqPath();
        Project highLevelReqProject = this.getProjectFromPath(highLevelReqPath);
        Long highLevelReqLibid = highLevelReqProject.getRequirementLibrary().getId();
        if (highLevelReqLibid != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, permission, highLevelReqLibid, REQUIREMENT_VERSION_LIBRARY_CLASSNAME)) {
            entry = LogEntry.failure().forTarget(checkedTarget).withMessage("message.import.log.error.unsuficientRight", permission, highLevelReqPath).build();
        }
        if ((standardReqLibid = (reqProject = this.getProjectFromPath(standardReqPath = linkedLowLevelRequirementTarget.getStandardReqPath())).getRequirementLibrary().getId()) != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, permission, standardReqLibid, REQUIREMENT_VERSION_LIBRARY_CLASSNAME)) {
            entry = LogEntry.failure().forTarget(checkedTarget).withMessage("message.import.log.error.unsuficientRight", permission, standardReqPath).build();
        }
        return entry;
    }

    private Project getProjectFromPath(String path) {
        String projectName = PathUtils.extractProjectName((String)path);
        projectName = PathUtils.unescapePathPartSlashes((String)projectName);
        return this.projectDao.findByName(projectName);
    }

    private LogEntry checkStepIndex(ImportMode mode, TestStepTarget target, ImportStatus importStatus, String optionalImpact) {
        Integer index = target.getIndex();
        LogEntry entry = null;
        if (index == null) {
            entry = LogEntry.status(importStatus).forTarget(target).withMessage("message.import.log.error.tc.tcStep.empty", new Object[0]).withImpact(optionalImpact, new Object[0]).build();
        } else if (index < 0) {
            entry = LogEntry.status(importStatus).forTarget(target).withMessage("message.import.log.error.tc.tcStep.negative", new Object[0]).withImpact(optionalImpact, new Object[0]).build();
        } else if (!(this.model.stepExists(target) || this.model.indexIsFirstAvailable(target) && mode == ImportMode.CREATE)) {
            entry = LogEntry.status(importStatus).forTarget(target).withMessage("message.import.log.error.tc.tcStep.numberOverNextPosition", new Object[0]).withImpact(optionalImpact, new Object[0]).build();
        }
        return entry;
    }

    @Override
    public Map<TestCaseInstruction, LogTrain> createTestCases(List<TestCaseInstruction> instructions) {
        Set<TestCaseTarget> targets = instructions.stream().map(Instruction::getTarget).collect(Collectors.toSet());
        this.model.initStatuses(targets);
        return this.checkTestCaseCreation(instructions);
    }

    private Map<TestCaseInstruction, LogTrain> checkTestCaseCreation(List<TestCaseInstruction> instructions) {
        String projectName = instructions.stream().findFirst().map(instruction -> ((TestCaseTarget)instruction.getTarget()).getProject()).orElseThrow();
        ProjectTargetStatus projectStatus = this.model.getProjectStatus(projectName);
        if (projectStatus.getStatus() != Existence.EXISTS) {
            return instructions.stream().collect(Collectors.toMap(instruction -> instruction, this::createLogForMissingProject));
        }
        TestCaseImportValidationBag bag = this.buildValidationBag(instructions, projectStatus.getId(), projectStatus.getTestCaseLibraryId());
        return instructions.stream().collect(Collectors.toMap(instruction -> instruction, instruction -> this.testCaseCreationValidation((TestCaseInstruction)instruction, bag)));
    }

    private LogTrain createLogForMissingProject(TestCaseInstruction instruction) {
        LogTrain logs = new LogTrain();
        logs.addEntry(LogEntry.failure().forTarget((Target)instruction.getTarget()).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
        return logs;
    }

    private TestCaseImportValidationBag buildValidationBag(List<TestCaseInstruction> instructions, Long projectId, Long testCaseLibraryId) {
        String currentUsername = this.userContextService.getUsername();
        List<String> activeLogins = this.collectActiveLogins(instructions);
        List<String> uuidList = this.collectExistingTestCaseUuids(instructions);
        Set<String> naturesConsistency = this.collectConsistentNatures(instructions, projectId);
        Set<String> typesConsistency = this.collectConsistentTypes(instructions, projectId);
        InfoListItem defaultNature = this.infoListItemService.findDefaultTestCaseNature(projectId);
        InfoListItem defaultType = this.infoListItemService.findDefaultTestCaseType(projectId);
        return new TestCaseImportValidationBag(testCaseLibraryId, activeLogins, uuidList, naturesConsistency, defaultNature, typesConsistency, defaultType, currentUsername);
    }

    private List<String> collectActiveLogins(List<TestCaseInstruction> instructions) {
        Set createdByList = instructions.stream().map(instruction -> instruction.getTestCase().getCreatedBy()).filter(user -> !Strings.isBlank((String)user)).collect(Collectors.toSet());
        return createdByList.isEmpty() ? Collections.emptyList() : this.userDao.filterActiveUserLogins(createdByList);
    }

    private List<String> collectExistingTestCaseUuids(List<TestCaseInstruction> instructions) {
        Set uuids = instructions.stream().map(instruction -> instruction.getTestCase().getUuid()).filter(user -> !Strings.isBlank((String)user)).collect(Collectors.toSet());
        return uuids.isEmpty() ? Collections.emptyList() : this.testCaseDao.filterExistingTestCaseUuids(uuids);
    }

    private Set<String> collectConsistentNatures(List<TestCaseInstruction> instructions, Long projectId) {
        Set<String> natures = instructions.stream().map(TestCaseInstruction::getTestCase).filter(testCase -> testCase.getNature() != null).map(testCase -> testCase.getNature().getCode()).filter(code -> !Strings.isBlank((String)code)).collect(Collectors.toSet());
        return natures.isEmpty() ? Collections.emptySet() : this.infoListItemService.filterConsistentNatures(projectId, natures);
    }

    private Set<String> collectConsistentTypes(List<TestCaseInstruction> instructions, Long projectId) {
        Set<String> types = instructions.stream().map(TestCaseInstruction::getTestCase).filter(testCase -> testCase.getType() != null).map(testCase -> testCase.getType().getCode()).filter(code -> !Strings.isBlank((String)code)).collect(Collectors.toSet());
        return types.isEmpty() ? Collections.emptySet() : this.infoListItemService.filterConsistentTypes(projectId, types);
    }

    private LogTrain testCaseCreationValidation(TestCaseInstruction instr, TestCaseImportValidationBag validationBag) {
        LogEntry hasntPermission;
        TestCaseTarget target = (TestCaseTarget)instr.getTarget();
        String path = target.getPath();
        TestCase testCase = instr.getTestCase();
        String name = testCase.getName();
        Map<String, String> cufValues = instr.getCustomFields();
        TargetStatus status = this.model.getStatus(target);
        LogTrain logs = this.entityValidator.createTestCaseChecks(target, testCase, validationBag);
        logs.append(this.cufValidator.checkCreateCustomFields(target, cufValues, this.model.getTestCaseCufs(target)));
        if (status.getStatus() != Existence.NOT_EXISTS) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.tc.alreadyexists", target.getPath()).withImpact("message.import.log.impact.tc.renamed", new Object[0]).build());
        }
        if ((hasntPermission = this.checkPermissionOnProject(validationBag.testCaseLibraryId(), target)) != null) {
            logs.addEntry(hasntPermission);
        }
        if (!StringUtils.isBlank((CharSequence)name) && !PathUtils.arePathsAndNameConsistents((String)path, (String)name)) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.tc.inconsistentNameAndPath", path, name).build());
        }
        this.testCaseCreationStrategy.validateMilestones(instr, logs);
        List<LogEntry> logEntries = this.fixMetadata(target, (AuditableMixin)testCase, ImportMode.CREATE, EntityType.TEST_CASE, validationBag);
        logs.addEntries(logEntries);
        this.checkParamNameInString(target, logs, testCase.getPrerequisite(), TestCaseSheetColumn.TC_PRE_REQUISITE);
        if (!StringUtils.isBlank((CharSequence)testCase.getUuid())) {
            if (validationBag.existingUuids().contains(testCase.getUuid())) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.uuid.alreadyExisting", testCase.getUuid()).build());
            } else {
                Pattern uuidPattern = Pattern.compile("[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}");
                if (!uuidPattern.matcher(testCase.getUuid()).matches()) {
                    logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.uuid.wrongFormat", new Object[0]).build());
                }
            }
        }
        return logs;
    }

    private LogEntry checkPermissionOnProject(Long testCaseLibraryId, TestCaseTarget target) {
        if (testCaseLibraryId != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, PERM_IMPORT, testCaseLibraryId, TEST_CASE_LIBRARY_CLASSNAME)) {
            return LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unsuficientRight", PERM_IMPORT, target.getPath()).build();
        }
        return null;
    }

    @Override
    public LogTrain updateTestCase(TestCaseInstruction instr) {
        TestCase testCase = instr.getTestCase();
        TestCaseTarget target = (TestCaseTarget)instr.getTarget();
        Map<String, String> cufValues = instr.getCustomFields();
        LogTrain logs = new LogTrain();
        String name = testCase.getName();
        TargetStatus status = this.model.getStatus(target);
        if (status.getStatus() == Existence.NOT_EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.notFound", new Object[0]).build());
        } else {
            ProjectTargetStatus projectStatus = this.model.getProjectStatus(target.getProject());
            TestCaseImportValidationBag bag = this.buildValidationBag(Collections.singletonList(instr), projectStatus.getId(), projectStatus.getTestCaseLibraryId());
            logs.append(this.entityValidator.updateTestCaseChecks(target, testCase, bag));
            logs.append(this.cufValidator.checkUpdateCustomFields(target, cufValues, this.model.getTestCaseCufs(target)));
            this.checkPathForUpdate(target, name, logs);
            LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target, (Target)target);
            if (hasntPermission != null) {
                logs.addEntry(hasntPermission);
            }
            if (this.model.isTestCaseLockedByMilestones(target)) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
            }
            List<LogEntry> logEntries = this.fixMetadatas(target, (AuditableMixin)testCase, ImportMode.UPDATE, EntityType.TEST_CASE);
            logs.addEntries(logEntries);
            this.testCaseUpdateStrategy.validateMilestones(instr, logs);
            this.checkParamNameInString(target, logs, testCase.getPrerequisite(), TestCaseSheetColumn.TC_PRE_REQUISITE);
        }
        return logs;
    }

    @Override
    public LogTrain createRequirementVersion(RequirementVersionInstruction instr) {
        RequirementVersionTarget target = (RequirementVersionTarget)instr.getTarget();
        RequirementTarget reqTarget = target.getRequirement();
        RequirementVersion reqVersion = instr.getRequirementVersion();
        Map<String, String> cufValues = instr.getCustomFields();
        LOGGER.debug("Req-Import - In Validation Facility for create {} version {}", new Object[]{target.getPath(), target.getVersion()});
        LogTrain logs = this.entityValidator.createRequirementVersionChecks(target, reqVersion);
        this.checkFolderConflict(instr, logs);
        this.checkImportedRequirementVersionStatusForCreate(target, reqVersion);
        logs.append(this.cufValidator.checkCreateCustomFields(target, cufValues, this.model.getRequirementVersionCufs(target)));
        LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target, (Target)target);
        if (hasntPermission != null) {
            logs.addEntry(hasntPermission);
        }
        this.checkAndFixRequirementVersionNumber(target, logs);
        this.entityValidator.createHighLevelRequirementChecks(target, logs);
        this.checkNatureUnicity(target, logs);
        this.checkAndFixNameConsistency(target, reqVersion);
        this.requirementVersionCreationStrategy.validateMilestones(instr, logs);
        this.checkMilestonesAlreadyUsedInRequirement(instr, logs);
        logs.addEntries(this.fixMetadatas(target, (AuditableMixin)reqVersion, ImportMode.CREATE, EntityType.REQUIREMENT_VERSION));
        if (!logs.hasCriticalErrors()) {
            this.model.addRequirementVersion(target, new TargetStatus(Existence.TO_BE_CREATED), (List<String>)instr.getMilestones());
            if (this.model.getStatus(reqTarget).getStatus() == Existence.NOT_EXISTS) {
                this.model.addRequirement(reqTarget, new TargetStatus(Existence.TO_BE_CREATED));
            }
        } else {
            instr.fatalError();
        }
        return logs;
    }

    private void checkImportedRequirementVersionStatusForCreate(RequirementVersionTarget target, RequirementVersion reqVersion) {
        RequirementStatus requirementVersionStatus = reqVersion.getStatus();
        if (requirementVersionStatus != null && requirementVersionStatus != RequirementStatus.WORK_IN_PROGRESS) {
            target.setImportedRequirementStatus(requirementVersionStatus);
            reqVersion.setStatus(RequirementStatus.WORK_IN_PROGRESS);
        }
    }

    private void checkExistingRequirementVersionStatus(RequirementVersionTarget target, LogTrain logs, RequirementVersion reqVersion) {
        if (!logs.hasCriticalErrors()) {
            Requirement requirement = this.reqFinderService.findRequirement(target.getRequirement().getId());
            RequirementVersion persistedReqVersion = requirement.findRequirementVersion(target.getVersion().intValue());
            RequirementStatus persistedStatus = persistedReqVersion.getStatus();
            if (!persistedStatus.isRequirementModifiable() && requirement.isHighLevel() == target.getRequirement().isHighLevel()) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.version.statusLocked", new Object[0]).build());
            } else if (!persistedStatus.isRequirementModifiable() && requirement.isHighLevel() != target.getRequirement().isHighLevel()) {
                logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.warn.reqVersionLockedStatusWithNatureTransformation", RequirementSheetColumn.REQ_NATURE.header).withImpact("message.import.log.impact.requirement.reqVersionLockedStatusWithNatureTransformation", new Object[0]).build());
                target.setImportedRequirementStatus(persistedStatus);
                reqVersion.updateStatusWithoutCheck(persistedStatus);
            } else if (persistedStatus.isRequirementModifiable()) {
                target.setImportedRequirementStatus(reqVersion.getStatus());
                if (!persistedStatus.equals((Object)reqVersion.getStatus())) {
                    reqVersion.setStatus(persistedStatus);
                }
            }
        }
    }

    @Override
    public LogTrain updateRequirementVersion(RequirementVersionInstruction instr) {
        RequirementVersionTarget target = (RequirementVersionTarget)instr.getTarget();
        RequirementVersion reqVersion = instr.getRequirementVersion();
        Map<String, String> cufValues = instr.getCustomFields();
        LogTrain logs = this.entityValidator.updateRequirementChecks(target, reqVersion);
        if (logs.hasCriticalErrors()) {
            instr.fatalError();
            return logs;
        }
        if (this.model.isRequirementVersionLockedByMilestones(target)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.version.milestoneLocked", new Object[0]).build());
        }
        if (logs.hasCriticalErrors()) {
            instr.fatalError();
            return logs;
        }
        this.checkRequirementVersionExists(target, logs);
        this.checkExistingRequirementVersionStatus(target, logs, reqVersion);
        if (logs.hasCriticalErrors()) {
            instr.fatalError();
            return logs;
        }
        logs.append(this.cufValidator.checkUpdateCustomFields(target, cufValues, this.model.getRequirementVersionCufs(target)));
        this.entityValidator.highLevelRequirementUpdateTests(target, logs);
        if (logs.hasCriticalErrors()) {
            instr.fatalError();
            return logs;
        }
        LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target, (Target)target);
        if (hasntPermission != null) {
            logs.addEntry(hasntPermission);
        }
        this.checkAndFixNameConsistency(target, reqVersion);
        this.requirementVersionUpdateStrategy.validateMilestones(instr, logs);
        this.checkMilestonesAlreadyUsedInRequirement(instr, logs);
        logs.addEntries(this.fixMetadatas(target, (AuditableMixin)reqVersion, ImportMode.UPDATE, EntityType.REQUIREMENT_VERSION));
        if (logs.hasCriticalErrors()) {
            instr.fatalError();
        }
        return logs;
    }

    private void checkRequirementVersionExists(RequirementVersionTarget target, LogTrain logs) {
        TargetStatus status = this.model.getStatus(target);
        TargetStatus reqStatus = this.model.getStatus(target.getRequirement());
        if (reqStatus.getStatus() != Existence.EXISTS || reqStatus.getId() == null) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.version.notExists", new Object[0]).build());
        } else if (status.getStatus() != Existence.EXISTS || status.getId() == null) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.version.notExists", new Object[0]).build());
        } else {
            target.getRequirement().setId(reqStatus.getId());
        }
    }

    private void checkFolderConflict(RequirementVersionInstruction instr, LogTrain logs) {
        RequirementVersionTarget target = (RequirementVersionTarget)instr.getTarget();
        if (this.model.isRequirementFolder(target)) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.warning.reqPathisFolder", new Object[0]).withImpact("message.import.log.impact.requirement.reqRenamed", new Object[0]).build());
            this.fixPathFolderConflict(instr);
        }
    }

    private void fixPathFolderConflict(RequirementVersionInstruction instr) {
        RequirementVersionTarget target = (RequirementVersionTarget)instr.getTarget();
        target.getRequirement().setPath(this.appendReqNameSuffix(target.getPath()));
        String name = PathUtils.extractName((String)target.getPath());
        instr.getRequirementVersion().setName(name);
    }

    private String appendReqNameSuffix(String name) {
        return String.valueOf(name) + "-Copie1";
    }

    private void checkAndFixNameConsistency(RequirementVersionTarget target, RequirementVersion reqVersion) {
        String reqName = PathUtils.extractName((String)target.getPath());
        String reqVersionName = reqVersion.getName();
        if (!(reqName = PathUtils.unescapePathPartSlashes((String)reqName)).equals(reqVersionName)) {
            target.setUnconsistentName(reqVersionName);
            reqVersion.setName(reqName);
        }
    }

    private void checkMilestonesAlreadyUsedInRequirement(RequirementVersionInstruction instr, LogTrain logs) {
        Collection milestones = instr.getMilestones();
        RequirementVersionTarget target = (RequirementVersionTarget)instr.getTarget();
        for (String milestone : milestones) {
            if (!this.model.checkMilestonesAlreadyUsedInRequirement(milestone, target)) continue;
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.milestone.used", RequirementSheetColumn.REQ_VERSION_MILESTONE.header).withImpact("message.import.log.impact.milestone.notBinded", new Object[0]).build());
        }
    }

    private void checkNatureUnicity(RequirementVersionTarget target, LogTrain logs) {
        if (target.getVersion() > 1) {
            RequirementTarget requirementTargetFromModel;
            Existence requirementStatus = this.model.getStatus(target.getRequirement()).getStatus();
            if (requirementStatus == Existence.EXISTS) {
                Long requirementLibraryNodeId = this.reqFinderService.findNodeIdByPath(target.getPath());
                Requirement requirement = this.reqFinderService.findRequirement(requirementLibraryNodeId);
                if (requirement.isHighLevel() != EntityType.HIGH_LEVEL_REQUIREMENT.equals((Object)target.getRequirement().getType())) {
                    this.addRequirementNatureCollisionErrorEntry(logs, target);
                }
            } else if (requirementStatus == Existence.TO_BE_CREATED && (requirementTargetFromModel = this.model.getRequirementTarget(target.getRequirement())) != null && !requirementTargetFromModel.getType().equals((Object)target.getRequirement().getType())) {
                this.addRequirementNatureCollisionErrorEntry(logs, target);
            }
        }
    }

    private void addRequirementNatureCollisionErrorEntry(LogTrain logs, RequirementVersionTarget target) {
        logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.nature.collision", RequirementSheetColumn.REQ_NATURE.header).build());
    }

    private void checkAndFixRequirementVersionNumber(RequirementVersionTarget target, LogTrain logs) {
        if (target.getVersion() == null || target.getVersion() <= 0) {
            this.setTargetVersionAndFixVersionNumber(target, logs, "message.import.log.error.requirement.version.null", "message.import.log.impact.versionModified");
        }
        Existence requirementVersionStatus = this.model.getStatus(target).getStatus();
        Existence requirementStatus = this.model.getStatus(target.getRequirement()).getStatus();
        LOGGER.debug("ReqImport Checking for version number: {}", new Object[]{target.getVersion()});
        LOGGER.debug("ReqImport Status of version: {} {}", new Object[]{target.getVersion(), requirementVersionStatus});
        if (requirementStatus != Existence.NOT_EXISTS && requirementVersionStatus != Existence.NOT_EXISTS) {
            this.fixVersionNumber(target);
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.requirement.version.collision", RequirementSheetColumn.REQ_VERSION_NUM.header).withImpact("message.import.log.impact.versionModified", new Object[0]).build());
        }
        this.checkPreviousVersionExistsAndReplaceVersionNumber(target, logs, requirementVersionStatus, requirementStatus);
    }

    private void setTargetVersionAndFixVersionNumber(RequirementVersionTarget target, LogTrain logs, String errorMessage, String impactMessage) {
        target.setVersion(1);
        this.fixVersionNumber(target);
        logs.addEntry(LogEntry.warning().forTarget(target).withMessage(errorMessage, RequirementSheetColumn.REQ_VERSION_NUM.header).withImpact(impactMessage, new Object[0]).build());
    }

    private void checkPreviousVersionExistsAndReplaceVersionNumber(RequirementVersionTarget target, LogTrain logs, Existence requirementVersionStatus, Existence requirementStatus) {
        if (requirementVersionStatus == Existence.NOT_EXISTS && target.getVersion() > 1) {
            Existence previousRequirementVersionStatus = null;
            if (requirementStatus != Existence.NOT_EXISTS) {
                RequirementVersionTarget previousRequirementVersion = new RequirementVersionTarget(target.getRequirement(), target.getVersion() - 1);
                previousRequirementVersionStatus = this.model.getStatus(previousRequirementVersion).getStatus();
            }
            if (requirementStatus == Existence.NOT_EXISTS || previousRequirementVersionStatus == Existence.NOT_EXISTS) {
                this.setTargetVersionAndFixVersionNumber(target, logs, "message.import.log.error.requirement.version.previousNotExists", "message.import.log.impact.versionModifiedToPreviousNumber");
            }
        }
    }

    private void fixVersionNumber(RequirementVersionTarget target) {
        Existence requirementVersionStatus = this.model.getStatus(target).getStatus();
        if (requirementVersionStatus == Existence.NOT_EXISTS) {
            return;
        }
        target.setVersion(target.getVersion() + 1);
        this.fixVersionNumber(target);
    }

    @Override
    public LogTrain deleteRequirementVersion(RequirementVersionInstruction instr) {
        throw new NotImplementedException("Implement me");
    }

    boolean areMilestoneValid(TestCaseInstruction instr) {
        LogTrain dummy = new LogTrain();
        this.testCaseUpdateStrategy.validateMilestones(instr, dummy);
        return dummy.hasNoErrorWhatsoever();
    }

    @Override
    public LogTrain createCoverage(CoverageInstruction instr) {
        LogTrain logs = new LogTrain();
        CoverageTarget target = (CoverageTarget)instr.getTarget();
        Long reqVersionId = this.checkRequirementVersionForCoverage(target, logs);
        Long tcId = this.checkTcForCoverage(target, logs);
        if (logs.hasCriticalErrors()) {
            return logs;
        }
        if (reqVersionId != null && tcId != null) {
            this.checkCoverageAlreadyExist(target, logs, tcId, reqVersionId);
        }
        if (logs.hasCriticalErrors()) {
            return logs;
        }
        logs.addEntry(this.checkPermissionOnProject(PERM_IMPORT, target, (Target)target));
        return logs;
    }

    private void checkCoverageAlreadyExist(CoverageTarget target, LogTrain logs, Long tcId, Long reqVersionId) {
        if (tcId != null && reqVersionId != null && this.coverageDao.byRequirementVersionAndTestCase(reqVersionId, tcId) != null) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.warning.linkAlreadyExist", new Object[0]).withImpact("message.import.log.impact.line.ignored", new Object[0]).build());
        }
    }

    private Long checkRequirementVersionForCoverage(CoverageTarget target, LogTrain logs) {
        if (!this.checkRequirementVersionPathIsValid(target, logs)) {
            logs.addEntry(this.createLogFailure(target, "message.import.log.error.requirement.notExists", new Object[0]));
            return null;
        }
        Long reqId = this.reqFinderService.findNodeIdByPath(target.getReqPath());
        if (reqId != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, PERM_READ, reqId, Requirement.class.getName())) {
            logs.addEntry(this.createLogFailure(target, "message.import.log.error.unsuficientRight", PERM_READ, target.getReqPath()));
            return null;
        }
        RequirementTarget reqTarget = new RequirementTarget(target.getReqPath());
        RequirementVersionTarget reqVersionTarget = new RequirementVersionTarget(reqTarget, target.getReqVersion());
        Existence reqStatus = this.getModel().getStatus(reqTarget).getStatus();
        if (reqStatus == Existence.NOT_EXISTS) {
            logs.addEntry(this.createLogFailure(target, "message.import.log.error.requirement.notExists", new Object[0]));
            return null;
        }
        Existence reqVersionStatus = this.getModel().getStatus(reqVersionTarget).getStatus();
        if (reqVersionStatus == Existence.NOT_EXISTS) {
            logs.addEntry(this.createLogFailure(target, "message.import.log.error.requirement.version.notExists", new Object[0]));
            return null;
        }
        if (reqVersionStatus == Existence.EXISTS) {
            Requirement req = this.reqFinderService.findRequirement(reqId);
            RequirementVersion reqVersion = req.findRequirementVersion(target.getReqVersion());
            if (!req.getStatus().isRequirementLinkable()) {
                logs.addEntry(this.createLogFailure(target, "message.import.log.error.requirement.version.statusLocked", new Object[0]));
            }
            return reqVersion.getId();
        }
        return null;
    }

    private void checkLinkedLowLevelAlreadyExist(LinkedLowLevelRequirementTarget target, LogTrain logs, Long highLevelReqId, Long standardReqId) {
        Requirement req = this.reqFinderService.findRequirement(standardReqId);
        if (req.getHighLevelRequirement() != null) {
            if (highLevelReqId.equals(req.getHighLevelRequirement().getId())) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.warning.linkAlreadyExist", new Object[0]).withImpact("message.import.log.impact.line.ignored", new Object[0]).build());
            } else {
                logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.warning.reqAlreadyLinkedToHighLvlReq", new Object[0]).withImpact("message.import.log.impact.requirement.highLvlReqReferenceLoss", new Object[0]).build());
            }
        }
    }

    private Long checkHighLevelReqForLinkedLowLevelRequirement(LinkedLowLevelRequirementTarget target, LogTrain logs) {
        Long highLevelReqId = this.reqFinderService.findNodeIdByPath(target.getHighLevelReqPath());
        if (highLevelReqId != null) {
            if (!this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, PERM_READ, highLevelReqId, Requirement.class.getName())) {
                logs.addEntry(this.createLogFailure(target, "message.import.log.error.unsuficientRight", PERM_READ, target.getHighLevelReqPath()));
                return null;
            }
            if (!this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, PERM_LINK, highLevelReqId, Requirement.class.getName())) {
                logs.addEntry(this.createLogFailure(target, "message.import.log.error.unsuficientRight", PERM_LINK, target.getHighLevelReqPath()));
                return null;
            }
        }
        HighLevelRequirementTarget highLevelReqTarget = new HighLevelRequirementTarget(target.getHighLevelReqPath());
        Existence reqStatus = this.getModel().getStatus(highLevelReqTarget).getStatus();
        return this.checkReqTargetExistenceForLinkedLowLevelRequirement(logs, reqStatus, target, highLevelReqId, true);
    }

    private Long checkReqTargetExistenceForLinkedLowLevelRequirement(LogTrain logs, Existence reqStatus, LinkedLowLevelRequirementTarget target, Long reqId, boolean isFromHighLevelReqPath) {
        if (reqStatus == Existence.NOT_EXISTS) {
            logs.addEntry(this.createLogFailure(target, "message.import.log.error.requirement.notExists", new Object[0]));
            return null;
        }
        if (reqStatus == Existence.EXISTS && reqId != null) {
            Requirement req = this.reqFinderService.findRequirement(reqId);
            if (!req.isHighLevel() && isFromHighLevelReqPath) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.requirementNotHighLevel", LinkedLowLevelRequirementsSheetColumn.HIGH_LEVEL_REQ_PATH.getHeader()).build());
                return null;
            }
            if (req.isHighLevel() && !isFromHighLevelReqPath) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.requirementNotStandard", LinkedLowLevelRequirementsSheetColumn.STANDARD_REQ_PATH.getHeader()).build());
                return null;
            }
            if (!req.getStatus().isRequirementLinkable()) {
                logs.addEntry(this.createLogFailure(target, "message.import.log.error.requirement.version.statusLocked", new Object[0]));
                return null;
            }
            return req.getId();
        }
        return null;
    }

    private Long checkReqForLinkedLowLevelRequirement(LinkedLowLevelRequirementTarget target, LogTrain logs) {
        Long reqId = this.reqFinderService.findNodeIdByPath(target.getStandardReqPath());
        if (reqId != null) {
            if (!this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, PERM_READ, reqId, Requirement.class.getName())) {
                logs.addEntry(this.createLogFailure(target, "message.import.log.error.unsuficientRight", PERM_READ, target.getStandardReqPath()));
                return null;
            }
            if (!this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, PERM_LINK, reqId, Requirement.class.getName())) {
                logs.addEntry(this.createLogFailure(target, "message.import.log.error.unsuficientRight", PERM_LINK, target.getStandardReqPath()));
                return null;
            }
        }
        if (this.entityValidator.isChildRequirementByPath(target.getStandardReqPath())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.cannotLinkToChildLowLevelRequirement", LinkedLowLevelRequirementsSheetColumn.STANDARD_REQ_PATH.getHeader()).build());
            return null;
        }
        RequirementTarget reqTarget = new RequirementTarget(target.getStandardReqPath());
        Existence reqStatus = this.getModel().getStatus(reqTarget).getStatus();
        return this.checkReqTargetExistenceForLinkedLowLevelRequirement(logs, reqStatus, target, reqId, false);
    }

    private boolean checkHighLevelStandardRequirementPathsAreValid(LinkedLowLevelRequirementTarget target, LogTrain logs) {
        boolean isTargetWellFormed = target.isWellFormed();
        if (!isTargetWellFormed) {
            if (!target.isHighLevelReqPathWellFormed()) {
                logs.addEntry(this.createLogFailure(target, "message.import.log.error.field.malformedPath", target.getHighLevelReqPath()));
            }
            if (!target.isStandardReqPathWellFormed()) {
                logs.addEntry(this.createLogFailure(target, "message.import.log.error.field.malformedPath", target.getStandardReqPath()));
            }
        }
        return isTargetWellFormed;
    }

    private boolean checkRequirementVersionPathIsValid(CoverageTarget target, LogTrain logs) {
        boolean reqVersionValid;
        boolean reqPathValid = target.isReqPathWellFormed();
        boolean bl = reqVersionValid = target.getReqVersion() > 0;
        if (!reqPathValid) {
            logs.addEntry(this.createLogFailure(target, "message.import.log.error.field.malformedPath", target.getReqPath()));
        }
        if (!reqVersionValid) {
            logs.addEntry(this.createLogFailure(target, "message.import.log.error.requirement.version.invalidVersionNumber", new Object[0]));
        }
        return reqPathValid && reqVersionValid;
    }

    private Long checkTcForCoverage(CoverageTarget target, LogTrain logs) {
        boolean tcPathValid = target.isTcPathWellFormed();
        String tcPath = target.getTcPath();
        if (!tcPathValid) {
            logs.addEntry(this.createLogFailure(target, "message.import.log.error.field.malformedPath", tcPath));
        } else {
            Long id = this.tcLibNavigationService.findNodeIdByPath(tcPath);
            if (id == null) {
                TargetStatus targetStatus = this.getModel().getStatus(new TestCaseTarget(target.getTcPath()));
                if (targetStatus.getStatus() != Existence.TO_BE_CREATED) {
                    logs.addEntry(this.createLogFailure(target, "message.import.log.error.tc.notFound", target.getTcPath()));
                }
            } else {
                return id;
            }
        }
        return null;
    }

    @Override
    public LogTrain createLinkedLowLevelRequirement(LinkedLowLevelRequirementInstruction instr) {
        LogTrain logs = new LogTrain();
        LinkedLowLevelRequirementTarget target = (LinkedLowLevelRequirementTarget)instr.getTarget();
        if (!this.checkHighLevelStandardRequirementPathsAreValid(target, logs)) {
            logs.addEntry(this.createLogFailure(target, "message.import.log.error.requirement.notExists", new Object[0]));
            return logs;
        }
        Long highLevelReqId = this.checkHighLevelReqForLinkedLowLevelRequirement(target, logs);
        Long standardReqId = this.checkReqForLinkedLowLevelRequirement(target, logs);
        if (logs.hasCriticalErrors()) {
            return logs;
        }
        if (highLevelReqId != null && standardReqId != null) {
            this.checkLinkedLowLevelAlreadyExist(target, logs, highLevelReqId, standardReqId);
        }
        if (logs.hasCriticalErrors()) {
            return logs;
        }
        logs.addEntry(this.checkPermissionOnProject(PERM_IMPORT, target, (Target)target));
        return logs;
    }

    @Override
    public LogTrain createRequirementLink(RequirementLinkInstruction instr) {
        RequirementLinkTarget target = (RequirementLinkTarget)instr.getTarget();
        LogTrain logs = this.requirementsExistAndLinkable(target);
        this.checkRequirementLinkRole(instr, logs);
        return logs;
    }

    @Override
    public LogTrain updateRequirementLink(RequirementLinkInstruction instr) {
        return this.createRequirementLink(instr);
    }

    @Override
    public LogTrain deleteRequirementLink(RequirementLinkInstruction instr) {
        return this.requirementsExistAndLinkable((RequirementLinkTarget)instr.getTarget());
    }

    private LogTrain checkRequirementLinkRole(RequirementLinkInstruction instr, LogTrain logs) {
        RequirementLinkTarget target = (RequirementLinkTarget)instr.getTarget();
        String role = instr.getRelationRole();
        if (StringUtils.isBlank((CharSequence)role)) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.warning.requirementlinks.role-not-set", new Object[0]).withImpact("message.import.log.impact.requirementlinks.role-not-set", new Object[0]).build());
        } else {
            Set<String> allRoles = this.getModel().getRequirementLinkRoles();
            if (!allRoles.contains(role)) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirementlinks.role-not-exists", new Object[0]).build());
            }
        }
        return logs;
    }

    private LogTrain requirementsExistAndLinkable(RequirementLinkTarget linkTarget) {
        LogTrain logs = new LogTrain();
        RequirementVersionTarget source = linkTarget.getSourceVersion();
        this.existAndLinkable(linkTarget, source, logs, "message.import.log.error.requirementlinks.malformed-sourcepath", "message.import.log.error.requirementlinks.source-notexist");
        RequirementVersionTarget dest = linkTarget.getDestVersion();
        this.existAndLinkable(linkTarget, dest, logs, "message.import.log.error.requirementlinks.malformed-destpath", "message.import.log.error.requirementlinks.dest-notexist");
        if (!logs.hasCriticalErrors() && linkTarget.getSourceVersion().equals(linkTarget.getDestVersion())) {
            logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage("message.import.log.error.requirementlinks.linking-same-requirement", new Object[0]).build());
        }
        return logs;
    }

    private void existAndLinkable(RequirementLinkTarget linkTarget, RequirementVersionTarget versionTarget, LogTrain logs, String malformedPathMessage, String nonexistentMessage) {
        LogEntry entry;
        if (!versionTarget.isWellFormed()) {
            logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage(malformedPathMessage, versionTarget.getPath()).build());
            return;
        }
        ProjectTargetStatus projectStatus = this.getModel().getProjectStatus(versionTarget.getProject());
        if (projectStatus.getStatus() != Existence.EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
            return;
        }
        TargetStatus versionStatus = this.getModel().getStatus(versionTarget);
        if (versionStatus.getStatus() != Existence.EXISTS && versionStatus.getStatus() != Existence.TO_BE_CREATED) {
            logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage(nonexistentMessage, new Object[0]).build());
            return;
        }
        Long reqId = this.reqFinderService.findNodeIdByPath(versionTarget.getPath());
        if (reqId != null) {
            Requirement req = this.reqFinderService.findRequirement(reqId);
            RequirementVersion reqVersion = req.findRequirementVersion(versionTarget.getVersion().intValue());
            if (!reqVersion.getStatus().isRequirementLinkable()) {
                logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage("message.import.log.error.requirementlinks.not-linkable", new Object[0]).build());
                return;
            }
        } else if (!versionTarget.getImportedRequirementStatus().isRequirementLinkable()) {
            logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage("message.import.log.error.requirementlinks.not-linkable", new Object[0]).build());
            return;
        }
        if ((entry = this.checkPermissionOnProject(PERM_LINK, versionTarget, (Target)linkTarget)) != null) {
            logs.addEntry(entry);
        }
    }

    private LogEntry createLogFailure(Target target, String msg, Object ... msgArgs) {
        return LogEntry.failure().forTarget(target).withMessage(msg, msgArgs).build();
    }

    @Override
    public Map<ParameterInstruction, LogTrain> createParameters(List<ParameterInstruction> parameterInstructions) {
        Set<TestCaseTarget> testCaseTargets = parameterInstructions.stream().map(instruction -> {
            ParameterTarget target = (ParameterTarget)instruction.getTarget();
            target.setName(instruction.getParameter().getName());
            return target.getOwner();
        }).collect(Collectors.toSet());
        this.model.initParameters(testCaseTargets);
        return parameterInstructions.stream().collect(Collectors.toMap(instruction -> instruction, instruction -> this.checkParameterCreation((ParameterTarget)instruction.getTarget())));
    }

    @Override
    public Map<DatasetInstruction, LogTrain> createDatasets(List<DatasetInstruction> instructions) {
        Set<TestCaseTarget> testCaseTargets = instructions.stream().map(instruction -> ((DatasetTarget)instruction.getTarget()).getTestCase()).collect(Collectors.toSet());
        this.model.initStatuses(testCaseTargets);
        return instructions.stream().collect(Collectors.toMap(instruction -> instruction, instruction -> this.checkDatasetCreation((DatasetTarget)instruction.getTarget())));
    }

    @Override
    public Map<ActionStepInstruction, LogTrain> addActionSteps(List<ActionStepInstruction> instructions) {
        Set<TestCaseTarget> testCaseTargets = instructions.stream().map(instruction -> ((TestStepTarget)instruction.getTarget()).getTestCase()).collect(Collectors.toSet());
        this.model.initStatuses(testCaseTargets);
        return instructions.stream().collect(Collectors.toMap(instruction -> instruction, instruction -> this.checkActionStepAddition((TestStepTarget)instruction.getTarget(), instruction.getTestStep(), instruction.getCustomFields())));
    }

    @Override
    public Map<CallStepInstruction, LogTrain> addCallSteps(List<CallStepInstruction> instructions) {
        this.initializationsForCallSteps(instructions);
        return instructions.stream().collect(Collectors.toMap(instruction -> instruction, instruction -> this.checkCallStepCreation((TestStepTarget)instruction.getTarget(), instruction.getCalledTC(), instruction.getDatasetInfo())));
    }

    private void initializationsForCallSteps(List<CallStepInstruction> instructions) {
        Map targetsByProject = instructions.stream().flatMap(i -> Stream.of(((TestStepTarget)i.getTarget()).getTestCase(), i.getCalledTC())).collect(Collectors.groupingBy(TestCaseTarget::getProject, Collectors.toSet()));
        HashSet<Long> ids = new HashSet<Long>();
        for (Map.Entry entry : targetsByProject.entrySet()) {
            Map<TestCaseTarget, Long> targetIds = this.model.getTargetIds(entry.getValue());
            instructions.stream().filter(i -> targetIds.containsKey(((TestStepTarget)i.getTarget()).getTestCase()) && targetIds.containsKey(i.getCalledTC())).flatMap(i -> Stream.of(((TestStepTarget)i.getTarget()).getTestCase(), i.getCalledTC())).map(targetIds::get).forEach(ids::add);
        }
        if (ids.isEmpty()) {
            return;
        }
        this.model.initRecursiveCallGraph(ids);
    }

    @Override
    public Map<DatasetParamValueInstruction, LogTrain> addDatasetParametersValues(List<DatasetParamValueInstruction> instructions) {
        Set<TestCaseTarget> testCaseTargets = instructions.stream().flatMap(i -> Stream.of(((DatasetTarget)i.getTarget()).getTestCase(), i.getParameterTarget().getOwner())).collect(Collectors.toSet());
        this.model.initStatuses(testCaseTargets);
        this.model.initCallGraph(testCaseTargets);
        return instructions.stream().collect(Collectors.toMap(instruction -> instruction, instruction -> this.checkDatasetParameterValueCreation((DatasetTarget)instruction.getTarget(), instruction.getParameterTarget(), instruction.getDatasetValue().getValue())));
    }

    private LogTrain checkDatasetParameterValueCreation(DatasetTarget target, ParameterTarget parameterTarget, String datasetValue) {
        return this.failsafeUpdateParameterValue(target, parameterTarget, datasetValue, false);
    }

    private abstract class AbstractMilestonesValidationStrategy<I extends Instruction<T>, T extends Target & WithPath> {
        private AbstractMilestonesValidationStrategy() {
        }

        public void validateMilestones(I instr, LogTrain logs) {
            Object target = ((Instruction)instr).getTarget();
            if (!ValidationFacility.this.milestonesEnabled && !((Milestoned)instr).getMilestones().isEmpty()) {
                logs.addEntry(this.logEntry().forTarget((Target)target).withMessage("message.import.log.error.milestoneFeatureDeactivated", new Object[0]).build());
            }
            if (ValidationFacility.this.milestonesEnabled) {
                MilestoneImportHelper.Partition existing = ValidationFacility.this.milestoneHelper.partitionExisting(((Milestoned)instr).getMilestones());
                MilestoneImportHelper.Partition bindables = ValidationFacility.this.milestoneHelper.partitionBindable(existing.passing, ((WithPath)target).getProject());
                logs.addEntries(this.logUnknownMilestones(target, existing.rejected));
                logs.addEntries(this.logUnbindableMilestones(target, bindables.rejected));
            }
        }

        protected abstract LogEntry.Builder logEntry();

        protected List<LogEntry> logUnbindableMilestones(T target, List<String> rejected) {
            ArrayList<LogEntry> logs = new ArrayList<LogEntry>(rejected.size());
            for (String name : rejected) {
                logs.add(this.logEntry().forTarget((Target)target).withMessage("message.import.log.error.milestone.wrongStatus", name).build());
            }
            return logs;
        }

        protected List<LogEntry> logUnknownMilestones(T target, List<String> rejected) {
            ArrayList<LogEntry> logs = new ArrayList<LogEntry>(rejected.size());
            for (String name : rejected) {
                logs.add(this.logEntry().forTarget((Target)target).withMessage("message.import.log.error.milestone.unknown", name).build());
            }
            return logs;
        }
    }

    private final class CreationStrategy<I extends Instruction<T>, T extends Target & WithPath>
    extends AbstractMilestonesValidationStrategy<I, T> {
        private CreationStrategy() {
        }

        @Override
        protected LogEntry.Builder logEntry() {
            return LogEntry.failure();
        }
    }

    private final class UpdateStrategy<I extends Instruction<T>, T extends Target & WithPath>
    extends AbstractMilestonesValidationStrategy<I, T> {
        private UpdateStrategy() {
        }

        @Override
        protected LogEntry.Builder logEntry() {
            return LogEntry.warning();
        }
    }
}

