/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.IsScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.batchimport.AbstractEntityFacilitySupport;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.batchimport.Batches;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.FacilityImplHelper;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ProjectTargetStatus;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.TestCaseFolderImportData;
import org.squashtest.tm.service.internal.batchimport.TestCaseImportData;
import org.squashtest.tm.service.internal.batchimport.TestCaseInstruction;
import org.squashtest.tm.service.internal.batchimport.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.tree.FolderNode;
import org.squashtest.tm.service.internal.batchimport.tree.FolderTree;
import org.squashtest.tm.service.internal.batchimport.tree.MissingNode;
import org.squashtest.tm.service.internal.importer.ExcelRowReaderUtils;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.user.UserAccountService;

@Component
@Scope(value="prototype")
public class TestCaseFacility
extends AbstractEntityFacilitySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(FacilityImpl.class);
    private static final String UNEXPECTED_ERROR_WHILE_IMPORTING_TEST_CASES = "unexpected error while importing test cases in project : ";
    private final FacilityImplHelper helper = new FacilityImplHelper(this);
    @Inject
    private InfoListItemFinderService listItemFinderService;
    @Inject
    private TestCaseLibraryNavigationService navigationService;
    @Inject
    private TestCaseModificationService testcaseModificationService;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private UserAccountService userAccountService;

    public Map<TestCaseInstruction, LogTrain> createTestCases(List<TestCaseInstruction> instructions) {
        Map<String, List<TestCaseInstruction>> instructionsByProjectName = instructions.stream().collect(Collectors.groupingBy(instruction -> ((TestCaseTarget)instruction.getTarget()).getProject()));
        return instructionsByProjectName.entrySet().stream().map(entry -> this.importProjectTestCases((String)entry.getKey(), (List)entry.getValue())).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<TestCaseInstruction, LogTrain> importProjectTestCases(String projectName, List<TestCaseInstruction> testCaseInstructions) {
        Map<TestCaseInstruction, LogTrain> instructionLogTrain = this.validator.createTestCases(testCaseInstructions);
        List<TestCaseInstruction> validTestCases = instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).map(Map.Entry::getKey).toList();
        try {
            this.doCreateTestCases(validTestCases, projectName);
        }
        catch (Exception ex) {
            instructionLogTrain.entrySet().stream().filter(e -> !((LogTrain)e.getValue()).hasCriticalErrors()).forEach(e -> {
                TestCaseTarget target = (TestCaseTarget)((TestCaseInstruction)e.getKey()).getTarget();
                LogTrain logTrain = (LogTrain)e.getValue();
                logTrain.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
                this.validator.getModel().setNotExists(target);
            });
            LOGGER.error("Excel import : unexpected error while importing test cases in project : {} : ", new Object[]{projectName, ex});
        }
        return instructionLogTrain;
    }

    private void doCreateTestCases(List<TestCaseInstruction> instructions, String projectName) {
        Project project = this.projectDao.findByName(projectName);
        User user = this.userAccountService.findCurrentUser();
        Long libraryId = project.getTestCaseLibrary().getId();
        ArrayList<TestCaseImportData> testCaseInFolders = new ArrayList<TestCaseImportData>();
        Batch<TestCaseImportData> libraryTestCases = new Batch<TestCaseImportData>(libraryId);
        for (TestCaseInstruction instr : instructions) {
            TestCaseImportData importTestCase = this.initTestCaseImportData(instr, user, project);
            TestCaseTarget target = (TestCaseTarget)instr.getTarget();
            if (target.isRootTestCase()) {
                libraryTestCases.addEntity(importTestCase);
                continue;
            }
            testCaseInFolders.add(importTestCase);
        }
        this.createTestCasesLinkToLibrary(project, libraryTestCases);
        this.createTestCasesLinkToFolders(project, testCaseInFolders);
    }

    private TestCaseImportData initTestCaseImportData(TestCaseInstruction instr, User user, Project project) {
        TestCase testCase = instr.getTestCase();
        TestCaseTarget target = (TestCaseTarget)instr.getTarget();
        testCase.setName(PathUtils.unescapePathPartSlashes((String)target.getName()));
        Map<String, String> cufValues = instr.getCustomFields();
        this.helper.fillNullWithDefaults(testCase);
        this.helper.truncate(testCase, cufValues);
        Map<Long, RawValue> acceptableCufs = this.toAcceptableCufs(cufValues);
        List<Long> milestoneIds = this.boundMilestonesIds(instr);
        TestCaseImportData importTestCase = new TestCaseImportData(testCase, target);
        if (!acceptableCufs.isEmpty()) {
            importTestCase.setCustomFields(acceptableCufs);
        }
        if (!milestoneIds.isEmpty()) {
            importTestCase.setMilestoneIds(milestoneIds);
        }
        if (TestCaseAutomatable.Y.equals((Object)testCase.getAutomatable())) {
            importTestCase.setAutomationRequest(this.createAutomationRequest(testCase, user, project));
        }
        return importTestCase;
    }

    private AutomationRequest createAutomationRequest(TestCase testCase, User user, Project project) {
        AutomationRequest automationRequest = new AutomationRequest();
        testCase.setAutomationRequest(automationRequest);
        automationRequest.setTestCase(testCase);
        automationRequest.setProject(project);
        automationRequest.setCreatedBy(user);
        if (testCase.getAutomatedTest() != null) {
            automationRequest.setManual(true);
        }
        return automationRequest;
    }

    private void createTestCasesLinkToLibrary(Project project, Batch<TestCaseImportData> batch) {
        List<TestCaseImportData> importedTestCases = batch.getEntities();
        if (importedTestCases.isEmpty()) {
            return;
        }
        Long libraryId = batch.getTargetId();
        List<String> contentNames = this.navigationService.findContentNamesByLibraryId(libraryId);
        TestCaseFacility.fixConflictNames(contentNames, importedTestCases);
        this.navigationService.addImportTestCasesToLibrary(libraryId, project, batch);
        importedTestCases.forEach(this::validatingTestCaseCreation);
    }

    private static void fixConflictNames(List<String> contentNames, List<TestCaseImportData> importData) {
        if (importData != null && !importData.isEmpty()) {
            importData.stream().map(TestCaseImportData::getTestCase).forEach(testCase -> {
                String newName = LibraryUtils.generateNonClashingName(testCase.getName(), contentNames, 255);
                if (!newName.equals(testCase.getName())) {
                    testCase.setName(newName);
                }
                contentNames.add(newName);
            });
        }
    }

    private void createTestCasesLinkToFolders(Project project, List<TestCaseImportData> folderTestCases) {
        Batches<TestCaseImportData> batches = this.collectExistingNodesAndCreateMissing(project.getName(), folderTestCases);
        if (batches == null) {
            return;
        }
        this.fixConflictNamesInFolders(batches);
        for (List<Batch<TestCaseImportData>> batchList : batches.partition(30)) {
            List<Long> currentFolderIds = batchList.stream().map(Batch::getTargetId).toList();
            this.navigationService.addImportTestCasesToFolders(currentFolderIds, project, batchList);
            batchList.stream().flatMap(b -> b.getEntities().stream()).forEach(this::validatingTestCaseCreation);
        }
    }

    private void validatingTestCaseCreation(TestCaseImportData testCaseData) {
        this.validator.getModel().setExists(testCaseData.getTarget(), testCaseData.getTestCase().getId());
    }

    private void fixConflictNamesInFolders(Batches<TestCaseImportData> batches) {
        Map<Long, List<String>> folderContentNames = this.navigationService.findContentNamesByFolderIds(batches.getTargetIds());
        for (Map.Entry<Long, List<String>> entry : folderContentNames.entrySet()) {
            List<TestCaseImportData> importData = batches.getEntitiesByTargetId(entry.getKey());
            TestCaseFacility.fixConflictNames(entry.getValue(), importData);
        }
    }

    private Batches<TestCaseImportData> collectExistingNodesAndCreateMissing(String projectName, List<TestCaseImportData> folderTestCases) {
        Map<String, List<TestCaseImportData>> importDataByFolderPath = folderTestCases.stream().collect(Collectors.groupingBy(instruction -> instruction.getTarget().getFolder()));
        if (importDataByFolderPath.isEmpty()) {
            return null;
        }
        FolderTree tree = new FolderTree(projectName, importDataByFolderPath);
        TreeMap<String, Long> projectPathIdTree = this.navigationService.buildTestCasePathsTree(projectName);
        Long testCaseLibraryId = this.projectDao.findTestCaseLibraryIdByName(projectName);
        List<MissingNode> missingNodes = tree.collectMissingNodes(projectPathIdTree, testCaseLibraryId);
        this.createMissingNodes(testCaseLibraryId, missingNodes);
        return tree.collectExistingNodes(projectPathIdTree);
    }

    private void createMissingNodes(Long testCaseLibraryId, List<MissingNode> missingNodes) {
        if (missingNodes.isEmpty()) {
            return;
        }
        Batch<TestCaseFolderImportData> libraryFolders = new Batch<TestCaseFolderImportData>(testCaseLibraryId);
        Batches<TestCaseFolderImportData> folderBatch = new Batches<TestCaseFolderImportData>();
        for (MissingNode missingNode : missingNodes) {
            FolderNode node = missingNode.node();
            TestCaseFolderImportData folderImportData = new TestCaseFolderImportData(node.convertToSquashFolder(), node.collectAllTestCaseImportData());
            if (missingNode.isLibraryContent()) {
                libraryFolders.addEntity(folderImportData);
                continue;
            }
            folderBatch.addBatch(missingNode.parentId(), folderImportData);
        }
        if (!libraryFolders.getEntities().isEmpty()) {
            this.navigationService.addImportFoldersToLibrary(testCaseLibraryId, libraryFolders);
            libraryFolders.getEntities().stream().flatMap(b -> b.testCaseDataInNodes().stream()).forEach(this::validatingTestCaseCreation);
        }
        for (List<Batch<TestCaseFolderImportData>> list : folderBatch.partition(20)) {
            List<Long> targetIds = list.stream().map(Batch::getTargetId).toList();
            this.navigationService.addImportFoldersToFolders(targetIds, list);
            list.stream().flatMap(b -> b.getEntities().stream()).flatMap(b -> b.testCaseDataInNodes().stream()).forEach(this::validatingTestCaseCreation);
        }
    }

    private LogTrain createTCRoutine(LogTrain train, TestCaseInstruction instruction) {
        TestCase testCase = instruction.getTestCase();
        TestCaseTarget target = (TestCaseTarget)instruction.getTarget();
        try {
            this.doCreateTestCases(Collections.singletonList(instruction), ((TestCaseTarget)instruction.getTarget()).getProject());
            this.validator.getModel().setExists(target, testCase.getId());
            LOGGER.debug("Excel import : Created Test Case \t'" + target + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
            this.validator.getModel().setNotExists(target);
            LOGGER.error("Excel import : unexpected error while importing " + target + " : ", (Throwable)ex);
        }
        return train;
    }

    private void fixNatureAndType(TestCaseTarget target, TestCase testCase) {
        InfoListItem type;
        ProjectTargetStatus projectStatus = this.validator.getModel().getProjectStatus(target.getProject());
        InfoListItem nature = testCase.getNature();
        if (nature != null && !this.listItemFinderService.isNatureConsistent(projectStatus.getId(), nature.getCode())) {
            testCase.setNature(this.listItemFinderService.findDefaultTestCaseNature(projectStatus.getId()));
        }
        if ((type = testCase.getType()) != null && !this.listItemFinderService.isTypeConsistent(projectStatus.getId(), type.getCode())) {
            testCase.setType(this.listItemFinderService.findDefaultTestCaseType(projectStatus.getId()));
        }
    }

    private void rebindMilestones(TestCaseInstruction instr, TestCase persistentSource) {
        if (!instr.getMilestones().isEmpty()) {
            List<Milestone> ms = this.milestoneHelper.findBindable(instr.getMilestones());
            persistentSource.getMilestones().clear();
            persistentSource.bindAllMilsetones(ms);
        } else {
            persistentSource.getMilestones().clear();
        }
    }

    public LogTrain updateTestCase(TestCaseInstruction instr) {
        TestCaseTarget target = (TestCaseTarget)instr.getTarget();
        TestCase testCase = instr.getTestCase();
        Map<String, String> cufValues = instr.getCustomFields();
        TargetStatus status = this.validator.getModel().getStatus(target);
        LogTrain train = this.validator.updateTestCase(instr);
        if (!train.hasCriticalErrors()) {
            if (status.status == Existence.NOT_EXISTS) {
                this.createTCRoutine(train, instr);
            } else {
                try {
                    this.helper.truncate(testCase, cufValues);
                    this.fixNatureAndType(target, testCase);
                    this.doUpdateTestcase(instr);
                    LOGGER.debug("Excel import : Updated Test Case \t'" + target + "'", new Object[0]);
                }
                catch (Exception ex) {
                    train.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
                    LOGGER.error("Excel import : unexpected error while updating " + target + " : ", (Throwable)ex);
                }
            }
        }
        return train;
    }

    private void doUpdateTestcase(TestCaseInstruction instr) {
        TestCaseTarget target = (TestCaseTarget)instr.getTarget();
        TestCase testCase = instr.getTestCase();
        Map<String, String> cufValues = instr.getCustomFields();
        TestCase orig = this.validator.getModel().get(target);
        Long origId = orig.getId();
        this.doUpdateCustomFields(cufValues, (BoundEntity)orig);
        if (this.validator.areMilestoneValid(instr)) {
            this.rebindMilestones(instr, orig);
        }
        this.doUpdateTestCaseCoreAttributes(testCase, orig);
        this.doUpdateTestCaseScriptIfScripted(testCase, orig);
        Integer order = target.getOrder();
        if (order != null && order > -1 && order < this.navigationService.countSiblingsOfNode(origId)) {
            Long[] origIds = new Long[]{origId};
            ClipboardPayload clipboardPayload = ClipboardPayload.withWhiteListIgnored(Collections.singletonList(origId));
            if (target.isRootTestCase()) {
                Long libraryId = this.validator.getModel().getProjectStatus(target.getProject()).getTestCaseLibraryId();
                this.navigationService.moveNodesToLibrary(libraryId, origIds, order, clipboardPayload);
            } else {
                Long folderId = this.navigationService.findNodeIdByPath(target.getFolder());
                this.navigationService.moveNodesToFolder(folderId, origIds, order, clipboardPayload);
            }
        }
    }

    private void doUpdateTestCaseScriptIfScripted(TestCase testCase, TestCase orig) {
        String newScript;
        boolean isTestCaseScripted = this.isTestCaseScripted(testCase);
        boolean isOrigScripted = this.isTestCaseScripted(orig);
        if (isTestCaseScripted && isOrigScripted && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{newScript = ((ScriptedTestCase)testCase).getScript()})) {
            ((ScriptedTestCase)orig).setScript(newScript);
        }
    }

    private boolean isTestCaseScripted(TestCase testCase) {
        IsScriptedTestCaseVisitor testCaseVisitor = new IsScriptedTestCaseVisitor();
        testCase.accept((TestCaseVisitor)testCaseVisitor);
        return testCaseVisitor.isScripted();
    }

    private void doUpdateTestCaseCoreAttributes(TestCase testCase, TestCase orig) {
        boolean importanceChanged;
        Long origId = orig.getId();
        boolean newImportanceAuto = testCase.isImportanceAuto() != null && testCase.isImportanceAuto() != false;
        this.updateName(orig, testCase.getName(), origId);
        this.updateReference(orig, testCase.getReference(), origId);
        this.updateDescription(orig, testCase.getDescription(), origId);
        this.updatePrerequisite(orig, testCase.getPrerequisite(), origId);
        this.updateImportance(testCase, orig, newImportanceAuto, origId);
        this.updateInfoListNature(orig, testCase.getNature(), origId);
        this.updateInfoListType(orig, testCase.getType(), origId);
        this.updateStatus(orig, testCase.getStatus(), origId);
        this.updateAutomatable(testCase, orig);
        boolean bl = importanceChanged = orig.isImportanceAuto() != null && orig.isImportanceAuto().equals(newImportanceAuto);
        if (importanceChanged || newImportanceAuto) {
            this.testcaseModificationService.changeImportanceAuto(origId, newImportanceAuto);
        }
    }

    private void updateAutomatable(TestCase testCase, TestCase orig) {
        if (testCase.getAutomatable() != null && !testCase.getAutomatable().equals((Object)orig.getAutomatable())) {
            orig.setAutomatable(testCase.getAutomatable());
            if (TestCaseAutomatable.Y.equals((Object)testCase.getAutomatable()) && orig.getAutomationRequest() == null) {
                Project project = orig.getProject();
                AutomationRequest automationRequest = this.createAutomationRequest(orig, this.userAccountService.findCurrentUser(), project);
                project.getAutomationRequestLibrary().addContent(automationRequest);
            }
        }
    }

    private void updateStatus(TestCase orig, TestCaseStatus newStatus, Long origId) {
        if (newStatus != null && orig.getStatus() != newStatus) {
            this.testcaseModificationService.changeStatus(origId, newStatus);
        }
    }

    private void updateName(TestCase orig, String newName, Long origId) {
        if (!StringUtils.isBlank((CharSequence)newName) && !newName.equals(orig.getName())) {
            this.testcaseModificationService.rename(origId, newName);
        }
    }

    private void updateReference(TestCase orig, String newRef, Long origId) {
        if (!StringUtils.isBlank((CharSequence)newRef) && !newRef.equals(orig.getReference())) {
            this.testcaseModificationService.changeReference(origId, newRef);
        }
    }

    private void updateDescription(TestCase orig, String newDesc, Long origId) {
        if (!StringUtils.isBlank((CharSequence)newDesc) && !newDesc.equals(orig.getDescription())) {
            this.testcaseModificationService.changeDescription(origId, ExcelRowReaderUtils.escapeHTMLInsideTags(newDesc));
        }
    }

    private void updatePrerequisite(TestCase orig, String newPrereq, Long origId) {
        if (!StringUtils.isBlank((CharSequence)newPrereq) && !newPrereq.equals(orig.getPrerequisite())) {
            this.testcaseModificationService.changePrerequisite(origId, ExcelRowReaderUtils.escapeHTMLInsideTags(newPrereq));
        }
    }

    private void updateImportance(TestCase testCase, TestCase orig, boolean newImportanceAuto, Long origId) {
        TestCaseImportance newImp = testCase.getImportance();
        if (!newImportanceAuto && newImp != null && orig.getImportance() != newImp) {
            this.testcaseModificationService.changeImportance(origId, newImp);
        }
    }

    private void updateInfoListNature(TestCase orig, InfoListItem newNat, Long origId) {
        if (newNat != null && !newNat.references((Object)orig.getNature())) {
            this.testcaseModificationService.changeNature((long)origId, newNat.getCode());
        }
    }

    private void updateInfoListType(TestCase orig, InfoListItem newType, Long origId) {
        if (newType != null && !newType.references((Object)orig.getType())) {
            this.testcaseModificationService.changeType((long)origId, newType.getCode());
        }
    }

    public LogTrain deleteTestCase(TestCaseTarget target) {
        LogTrain train = this.validator.deleteTestCase(target);
        if (!train.hasCriticalErrors()) {
            try {
                this.doDeleteTestCase(target);
                this.validator.getModel().setDeleted(target);
                LOGGER.debug("Excel import : Deleted Test Case \t'" + target + "'", new Object[0]);
            }
            catch (Exception ex) {
                train.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
                LOGGER.error("Excel import : unexpected error while deleting " + target + " : ", (Throwable)ex);
            }
        }
        return train;
    }

    private void doDeleteTestCase(TestCaseTarget target) {
        TestCase tc = this.validator.getModel().get(target);
        this.navigationService.deleteNodes(Collections.singletonList(tc.getId()));
    }
}

