/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.internal.batchimport.excel.ExcelBatchImporter;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.CoverageInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.DatasetInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.DatasetParamValueInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.InstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.ParameterInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.StepInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instructioncontainer.TestCaseInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ExcelWorkbookParser;

@Component
public class TestCaseExcelBatchImporter
extends ExcelBatchImporter {
    private static final List<EntityType> TC_ENTITIES_ORDERED_BY_INSTRUCTION_ORDER = Arrays.asList(EntityType.TEST_CASE, EntityType.PARAMETER, EntityType.DATASET, EntityType.TEST_STEP, EntityType.DATASET_PARAM_VALUES, EntityType.COVERAGE);

    public TestCaseExcelBatchImporter() {
        super(LoggerFactory.getLogger(TestCaseExcelBatchImporter.class));
    }

    @Override
    public InstructionContainer<?> findInstructionsByEntity(ExcelWorkbookParser parser, EntityType entityType) {
        this.LOGGER.debug("creating instruction container for entity type : {}", new Object[]{entityType});
        return switch (entityType) {
            case EntityType.TEST_CASE -> new TestCaseInstructionContainer(parser.getTestCaseInstructions());
            case EntityType.PARAMETER -> new ParameterInstructionContainer(parser.getParameterInstructions());
            case EntityType.DATASET -> new DatasetInstructionContainer(parser.getDatasetInstructions());
            case EntityType.TEST_STEP -> new StepInstructionContainer(parser.getTestStepInstructions());
            case EntityType.DATASET_PARAM_VALUES -> new DatasetParamValueInstructionContainer(parser.getDatasetParamValuesInstructions());
            case EntityType.COVERAGE -> new CoverageInstructionContainer(parser.getCoverageInstructions());
            default -> throw new IllegalArgumentException("Unknown EntityType for TestCase import : " + this);
        };
    }

    @Override
    public List<EntityType> getEntityType() {
        return TC_ENTITIES_ORDERED_BY_INSTRUCTION_ORDER;
    }
}

