/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.library.structures.GraphNode;
import org.squashtest.tm.domain.library.structures.LibraryGraph;
import org.squashtest.tm.exception.CyclicStepCallException;
import org.squashtest.tm.service.internal.batchimport.TestCaseTarget;

class TestCaseCallGraph
extends LibraryGraph<TestCaseTarget, Node> {
    private boolean mergeMode = false;

    TestCaseCallGraph() {
    }

    void addGraph(LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> othergraph) {
        this.mergeMode = true;
        this.mergeGraph(othergraph, (LibraryGraph.NodeTransformer)new LibraryGraph.NodeTransformer<LibraryGraph.SimpleNode<NamedReference>, Node>(){

            public Node createFrom(LibraryGraph.SimpleNode<NamedReference> node) {
                return new Node(new TestCaseTarget(((NamedReference)node.getKey()).getName()));
            }

            public Object createKey(LibraryGraph.SimpleNode<NamedReference> node) {
                return new TestCaseTarget(((NamedReference)node.getKey()).getName());
            }
        });
        for (Node n : this.getNodes()) {
            if (!n.isNew()) continue;
            n.state = NodeLifecycle.LIVE;
        }
        this.mergeMode = false;
    }

    public boolean knowsNode(TestCaseTarget target) {
        return this.getNodes().contains((Object)new Node(target));
    }

    public void addEdge(TestCaseTarget parent, TestCaseTarget child) {
        this.addEdge(new Node(parent), new Node(child));
    }

    public void addNode(TestCaseTarget target) {
        this.addNode(new Node(target));
    }

    public void removeNode(TestCaseTarget target) {
        Node n = (Node)this.getNode(target);
        if (n != null) {
            super.removeNode((Object)target);
            n.state = NodeLifecycle.REMOVED;
            this.getNodes().add(n);
        }
    }

    public void addEdge(Node src, Node dest) {
        if (this.checkShouldCreate(src, dest)) {
            super.addEdge((GraphNode)src, (GraphNode)dest);
        }
        if (!this.mergeMode) {
            ((Node)this.getNode((Object)((TestCaseTarget)src.getKey()))).state = NodeLifecycle.LIVE;
            ((Node)this.getNode((Object)((TestCaseTarget)dest.getKey()))).state = NodeLifecycle.LIVE;
        }
    }

    private boolean checkShouldCreate(Node src, Node dest) {
        boolean shouldCreate = true;
        Node iSrc = (Node)this.createIfNotExists(src);
        Node iDest = (Node)this.createIfNotExists(dest);
        if (this.mergeMode && !this.hasNewNodes(iSrc, iDest)) {
            shouldCreate = false;
        } else if (this.hasRemovedNodes(iSrc, iDest)) {
            shouldCreate = false;
        } else if (this.wouldCreateCycle((TestCaseTarget)iSrc.getKey(), (TestCaseTarget)iDest.getKey())) {
            throw new CyclicStepCallException("cannot add to test case call graph an edge from '" + ((TestCaseTarget)src.getKey()).getPath() + "' to '" + ((TestCaseTarget)dest.getKey()).getPath() + "' : would create a cycle");
        }
        return shouldCreate;
    }

    boolean isCalled(TestCaseTarget target) {
        Node n = (Node)this.getNode(target);
        if (n != null) {
            return !n.getInbounds().isEmpty();
        }
        return false;
    }

    boolean wouldCreateCycle(TestCaseTarget src, TestCaseTarget dest) {
        if (this.getNode(dest) == null || this.getNode(src) == null) {
            return false;
        }
        if (src.equals(dest)) {
            return true;
        }
        HashSet<Node> processed = new HashSet<Node>();
        LinkedList<Node> nodes = new LinkedList<Node>();
        Node orig = (Node)this.getNode(dest);
        processed.add(orig);
        nodes.add(orig);
        while (!nodes.isEmpty()) {
            Node current = (Node)((Object)nodes.poll());
            if (current.calls(src)) {
                return true;
            }
            this.processingChilds(current, processed, nodes);
        }
        return false;
    }

    private void processingChilds(Node current, Set<Node> processed, LinkedList<Node> nodes) {
        for (Node child : current.getOutbounds()) {
            if (processed.contains((Object)child)) continue;
            nodes.add(child);
            processed.add(child);
        }
    }

    private boolean hasNewNodes(Node n1, Node n2) {
        return n1.isNew() || n2.isNew();
    }

    private boolean hasRemovedNodes(Node n1, Node n2) {
        return n1.isRemoved() || n2.isRemoved();
    }

    static final class Node
    extends GraphNode<TestCaseTarget, Node> {
        private NodeLifecycle state = NodeLifecycle.NEW;

        Node(TestCaseTarget target) {
            super((Object)target);
        }

        Node(LibraryGraph.SimpleNode<NamedReference> othernode) {
            super((Object)new TestCaseTarget(((NamedReference)othernode.getKey()).getName()));
        }

        boolean isMe(TestCaseTarget target) {
            return target.equals(this.key);
        }

        boolean calls(TestCaseTarget callee) {
            for (Node n : this.outbounds) {
                if (!n.isMe(callee)) continue;
                return true;
            }
            return false;
        }

        boolean isNew() {
            return this.state == NodeLifecycle.NEW;
        }

        boolean isLive() {
            return this.state == NodeLifecycle.LIVE;
        }

        boolean isRemoved() {
            return this.state == NodeLifecycle.REMOVED;
        }
    }

    private static enum NodeLifecycle {
        NEW,
        LIVE,
        REMOVED;

    }
}

