/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.HighLevelNewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.NewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementLibraryNodeVisitor;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.requirement.link.SameRequirementLinkedRequirementVersionException;
import org.squashtest.tm.exception.requirement.link.UnlinkableLinkedRequirementVersionException;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.batchimport.AbstractEntityFacilitySupport;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.FacilityImplHelper;
import org.squashtest.tm.service.internal.batchimport.Instruction;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ProjectTargetStatus;
import org.squashtest.tm.service.internal.batchimport.RequirementLinkInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementLinkTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkTypeDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateRequirementLibraryNodeDao;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;

@Component
@Scope(value="prototype")
class RequirementFacility
extends AbstractEntityFacilitySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(FacilityImpl.class);
    @Inject
    private RequirementLibraryFinderService reqFinderService;
    @Inject
    private MilestoneMembershipManager milestoneService;
    @Inject
    private HibernateRequirementLibraryNodeDao rlnDao;
    @Inject
    private InfoListItemFinderService listItemFinderService;
    @Inject
    private RequirementVersionManagerService requirementVersionManagerService;
    @Inject
    private RequirementLibraryNavigationService reqLibNavigationService;
    @Inject
    private LinkedRequirementVersionManagerService reqlinkService;
    @Inject
    private RequirementVersionLinkTypeDao reqlinkTypeDao;
    @Inject
    private HighLevelRequirementService highLevelRequirementService;
    private final FacilityImplHelper helper = new FacilityImplHelper(this);
    private ImportPostProcessHandler postProcessHandler;

    RequirementFacility() {
    }

    public LogTrain createRequirementVersion(RequirementVersionInstruction instr) {
        LogTrain train = this.validator.createRequirementVersion(instr);
        if (!train.hasCriticalErrors()) {
            this.createReqVersionRoutine(train, instr);
            this.postProcessHandler = new CreateRequirementVersionPostProcessStrategy();
        }
        return train;
    }

    private void changeRequirementVersionStatus(RequirementVersionInstruction rvi) {
        RequirementStatus newstatus = ((RequirementVersionTarget)rvi.getTarget()).getImportedRequirementStatus();
        RequirementStatus oldStatus = rvi.getRequirementVersion().getStatus();
        if (newstatus == null || newstatus == oldStatus) {
            return;
        }
        if (newstatus == RequirementStatus.APPROVED && oldStatus == RequirementStatus.WORK_IN_PROGRESS) {
            this.requirementVersionManagerService.changeStatus(rvi.getRequirementVersion().getId(), RequirementStatus.UNDER_REVIEW);
        }
        this.requirementVersionManagerService.changeStatus(rvi.getRequirementVersion().getId(), newstatus);
    }

    private LogTrain createReqVersionRoutine(LogTrain train, RequirementVersionInstruction instruction) {
        RequirementVersion reqVersion = instruction.getRequirementVersion();
        Map<String, String> cufValues = instruction.getCustomFields();
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        try {
            this.helper.fillNullWithDefaults(reqVersion);
            this.helper.truncate(reqVersion, cufValues);
            this.fixCategory(target, reqVersion);
            RequirementVersion newVersion = this.doCreateRequirementVersion(instruction);
            this.validator.getModel().addRequirement(target.getRequirement(), new TargetStatus(Existence.EXISTS, newVersion.getRequirement().getId()));
            this.validator.getModel().addRequirementVersion(target, new TargetStatus(Existence.EXISTS, newVersion.getId()));
            instruction.setRequirementVersion(newVersion);
            LOGGER.debug("Excel import : Created Requirement version \t'" + target + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
            this.validator.getModel().setNotExists(target);
            LOGGER.error("Excel import : unexpected error while importing " + target + " : ", (Throwable)ex);
        }
        return train;
    }

    private RequirementVersion doCreateRequirementVersion(RequirementVersionInstruction instruction) {
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        Long reqId = this.validator.getModel().getRequirementId(target);
        if (reqId == null) {
            return this.doCreateRequirementAndVersion(instruction);
        }
        return this.doAddingNewVersionToRequirement(instruction, reqId);
    }

    private RequirementVersion doCreateRequirementAndVersion(RequirementVersionInstruction instruction) {
        Requirement finalRequirement;
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        String projectName = PathUtils.extractProjectName((String)target.getPath());
        projectName = PathUtils.unescapePathPartSlashes((String)projectName);
        RequirementVersion requirementVersion = instruction.getRequirementVersion();
        Map<Long, RawValue> acceptableCufs = this.toAcceptableCufs(instruction.getCustomFields());
        HighLevelNewRequirementVersionDto dto = EntityType.HIGH_LEVEL_REQUIREMENT.equals((Object)target.getRequirement().getType()) ? new HighLevelNewRequirementVersionDto(requirementVersion, acceptableCufs) : new NewRequirementVersionDto(requirementVersion, acceptableCufs);
        dto.setName(PathUtils.unescapePathPartSlashes((String)dto.getName()));
        if (target.getRequirement().isRootRequirement()) {
            Long requirementLibrairyId = this.validator.getModel().getProjectStatus(projectName).getRequirementLibraryId();
            List<String> siblingNames = this.reqLibNavigationService.findNamesInLibraryStartingWith(requirementLibrairyId, dto.getName());
            this.renameIfNeeded((NewRequirementVersionDto)dto, siblingNames);
            finalRequirement = this.reqLibNavigationService.addRequirementToRequirementLibrary((long)requirementLibrairyId, (NewRequirementVersionDto)dto, Collections.emptyList());
            this.milestoneService.bindRequirementVersionToMilestones(finalRequirement.getCurrentVersion().getId(), this.boundMilestonesIds(instruction));
        } else {
            List paths = PathUtils.scanPath((String)target.getPath());
            String parentPath = (String)paths.get(paths.size() - 2);
            Long finalParentId = this.reqFinderService.findNodeIdByPath(parentPath);
            if (finalParentId == null) {
                finalParentId = this.reqLibNavigationService.mkdirs(parentPath);
            }
            List<String> siblingNames = this.reqLibNavigationService.findNamesInNodeStartingWith(finalParentId, dto.getName());
            this.renameIfNeeded((NewRequirementVersionDto)dto, siblingNames);
            RequirementLibraryNode parent = this.reqLibNavigationService.findRequirementLibraryNodeById(finalParentId);
            AddRequirementVisitor visitor = new AddRequirementVisitor(instruction, finalParentId, (NewRequirementVersionDto)dto);
            parent.accept((RequirementLibraryNodeVisitor)visitor);
            finalRequirement = visitor.getFinalRequirement();
        }
        return this.doAfterCreationProcess(finalRequirement, instruction, requirementVersion);
    }

    private void renameIfNeeded(NewRequirementVersionDto version, Collection<String> siblingNames) {
        String newName = LibraryUtils.generateNonClashingName(version.getName(), siblingNames, 255);
        if (!newName.equals(version.getName())) {
            version.setName(newName);
        }
    }

    private RequirementVersion doAfterCreationProcess(Requirement persistedRequirement, RequirementVersionInstruction instruction, RequirementVersion requirementVersion) {
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        this.bindRequirementVersionToMilestones(persistedRequirement.getCurrentVersion(), this.boundMilestonesIds(instruction));
        this.doUpdateRequirementCategory(requirementVersion, persistedRequirement.getCurrentVersion());
        this.fixVersionNumber(persistedRequirement, target.getVersion());
        return persistedRequirement.getCurrentVersion();
    }

    private RequirementVersion doAddingNewVersionToRequirement(RequirementVersionInstruction instruction, Long reqId) {
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        Requirement requirement = this.reqLibNavigationService.findRequirement(reqId);
        Map<Long, RawValue> acceptableCufs = this.toAcceptableCufs(instruction.getCustomFields());
        RequirementVersion requirementVersion = instruction.getRequirementVersion();
        requirementVersion.setVersionNumber(((RequirementVersionTarget)instruction.getTarget()).getVersion().intValue());
        this.requirementVersionManagerService.createNewVersion((long)reqId, false, false, (AuditableMixin)requirementVersion);
        RequirementVersion requirementVersionPersisted = requirement.getCurrentVersion();
        this.reqLibNavigationService.initCUFvalues(requirementVersionPersisted, acceptableCufs);
        this.bindRequirementVersionToMilestones(requirementVersionPersisted, this.boundMilestonesIds(instruction));
        this.doUpdateRequirementCoreAttributes(requirementVersion, requirementVersionPersisted);
        this.fixVersionNumber(requirement, target.getVersion());
        return requirement.findRequirementVersion(target.getVersion().intValue());
    }

    private void bindRequirementVersionToMilestones(RequirementVersion requirementVersionPersisted, List<Long> boundMilestonesIds) {
        List allVersion = requirementVersionPersisted.getRequirement().getRequirementVersions();
        HashSet milestoneBinded = new HashSet();
        HashSet<Long> milestoneBindedId = new HashSet<Long>();
        HashSet<Long> checkedMilestones = new HashSet<Long>();
        for (RequirementVersion requirementVersion : allVersion) {
            milestoneBinded.addAll(requirementVersion.getMilestones());
        }
        for (Milestone milestone : milestoneBinded) {
            milestoneBindedId.add(milestone.getId());
        }
        for (Long id : boundMilestonesIds) {
            if (milestoneBindedId.contains(id)) continue;
            checkedMilestones.add(id);
        }
        if (!checkedMilestones.isEmpty()) {
            requirementVersionPersisted.getMilestones().clear();
            this.requirementVersionManagerService.bindMilestones(requirementVersionPersisted.getId(), checkedMilestones);
        }
    }

    private void doUpdateRequirementCoreAttributes(RequirementVersion reqVersion, RequirementVersion orig) {
        this.doUpdateRequirementReference(reqVersion, orig);
        this.doUpdateRequirementDescription(reqVersion, orig);
        this.doUpdateRequirementCriticality(reqVersion, orig);
        this.doUpdateRequirementCategory(reqVersion, orig);
    }

    private void doUpdateRequirementReference(RequirementVersion reqVersion, RequirementVersion orig) {
        String newReference = reqVersion.getReference();
        if (!StringUtils.isBlank((CharSequence)newReference) && !newReference.equals(orig.getReference())) {
            this.requirementVersionManagerService.changeReference(orig.getId(), newReference);
        }
    }

    private void doUpdateRequirementDescription(RequirementVersion reqVersion, RequirementVersion orig) {
        String newDescription = reqVersion.getDescription();
        if (!StringUtils.isBlank((CharSequence)newDescription) && !newDescription.equals(orig.getDescription())) {
            this.requirementVersionManagerService.changeDescription(orig.getId(), newDescription);
        }
    }

    private void doUpdateRequirementCriticality(RequirementVersion reqVersion, RequirementVersion orig) {
        RequirementCriticality newCriticality = reqVersion.getCriticality();
        if (newCriticality != null && newCriticality != orig.getCriticality()) {
            this.requirementVersionManagerService.changeCriticality(orig.getId(), newCriticality);
        }
    }

    private void doUpdateRequirementCategory(RequirementVersion reqVersion, RequirementVersion orig) {
        Long idOrig = orig.getId();
        InfoListItem oldCategory = orig.getCategory();
        InfoListItem newCategory = reqVersion.getCategory();
        if (newCategory != null && !oldCategory.references((Object)newCategory)) {
            this.requirementVersionManagerService.changeCategory((long)idOrig, newCategory.getCode());
        }
    }

    private void doUpdateRequirementModificationMetadata(AuditableMixin requirementVersion, AuditableMixin persistedVersion) {
        persistedVersion.setLastModifiedBy(requirementVersion.getCreatedBy());
        persistedVersion.setLastModifiedOn(requirementVersion.getCreatedOn());
    }

    private void fixVersionNumber(Requirement requirement, Integer version) {
        this.reqLibNavigationService.changeCurrentVersionNumber(requirement, version);
    }

    public LogTrain updateRequirementVersion(RequirementVersionInstruction instr) {
        LogTrain train = this.validator.updateRequirementVersion(instr);
        if (!train.hasCriticalErrors()) {
            this.updateRequirementVersionRoutine(train, instr);
            this.postProcessHandler = new UpdateRequirementVersionPostProcessStrategy();
        }
        return train;
    }

    private void updateRequirementVersionRoutine(LogTrain train, RequirementVersionInstruction instruction) {
        RequirementVersion reqVersion = instruction.getRequirementVersion();
        Map<String, String> cufValues = instruction.getCustomFields();
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        try {
            if (target.getImportedRequirementStatus().isRequirementModifiable() || !target.getImportedRequirementStatus().isRequirementModifiable() && reqVersion.getStatus().isRequirementModifiable()) {
                this.helper.fillNullWithDefaults(reqVersion);
                this.helper.truncate(reqVersion, cufValues);
                this.fixCategory(target, reqVersion);
                RequirementVersion newVersion = this.doUpdateRequirementVersion(instruction, cufValues);
                instruction.setRequirementVersion(newVersion);
                this.validator.getModel().bindMilestonesToRequirementVersion(target, (List<String>)instruction.getMilestones());
                LOGGER.debug("Excel import : Updated Requirement Version \t'" + target + "'", new Object[0]);
            } else {
                Requirement req = this.reqLibNavigationService.findRequirement(target.getRequirement().getId());
                this.doUpdateRequirementNature(req, target.getRequirement());
                instruction.setRequirementVersion(req.findRequirementVersion(target.getVersion().intValue()));
            }
        }
        catch (Exception ex) {
            train.addEntry(new LogEntry(target, ImportStatus.FAILURE, "message.import.log.error.unexpectederror", new Object[]{ex.getClass().getName()}));
            this.validator.getModel().setNotExists(target);
            LOGGER.error("Excel import : unexpected error while importing " + target + " : ", (Throwable)ex);
        }
    }

    public LogTrain createRequirementLink(RequirementLinkInstruction instr) {
        LogTrain train = this.validator.createRequirementLink(instr);
        if (!train.hasCriticalErrors()) {
            this.createOrUpdateLink(instr, train);
        }
        return train;
    }

    public LogTrain updateRequirementLink(RequirementLinkInstruction instr) {
        LogTrain train = this.validator.updateRequirementLink(instr);
        if (!train.hasCriticalErrors()) {
            this.createOrUpdateLink(instr, train);
        }
        return train;
    }

    public LogTrain deleteRequirementLink(RequirementLinkInstruction instr) {
        LogTrain train = this.validator.deleteRequirementLink(instr);
        if (!train.hasCriticalErrors()) {
            long sourceId = this.findVersionIdByTarget(((RequirementLinkTarget)instr.getTarget()).getSourceVersion());
            long destId = this.findVersionIdByTarget(((RequirementLinkTarget)instr.getTarget()).getDestVersion());
            this.reqlinkService.removeLinkedRequirementVersionsFromRequirementVersion(sourceId, Arrays.asList(destId));
        }
        return train;
    }

    private void createOrUpdateLink(RequirementLinkInstruction instr, LogTrain train) {
        long sourceId = this.findVersionIdByTarget(((RequirementLinkTarget)instr.getTarget()).getSourceVersion());
        long destId = this.findVersionIdByTarget(((RequirementLinkTarget)instr.getTarget()).getDestVersion());
        String destRole = instr.getRelationRole();
        if (StringUtils.isBlank((CharSequence)destRole)) {
            destRole = this.reqlinkTypeDao.getDefaultRequirementVersionLinkType().getRole2Code();
        }
        try {
            this.reqlinkService.addOrUpdateRequirementLink(sourceId, destId, destRole);
        }
        catch (SameRequirementLinkedRequirementVersionException ex) {
            train.addEntry(LogEntry.failure().forTarget((Target)instr.getTarget()).withMessage("message.import.log.error.requirementlinks.linking-same-requirement", new Object[0]).build());
            LOGGER.debug(ex.getMessage(), (Throwable)ex);
        }
        catch (UnlinkableLinkedRequirementVersionException ex) {
            train.addEntry(LogEntry.failure().forTarget((Target)instr.getTarget()).withMessage("message.import.log.error.requirementlinks.not-linkable", new Object[0]).build());
            LOGGER.debug(ex.getMessage(), (Throwable)ex);
        }
    }

    private long findVersionIdByTarget(RequirementVersionTarget versTarget) {
        Long reqId = this.validator.getModel().getRequirementId(versTarget);
        return this.requirementVersionManagerService.findReqVersionIdByRequirementAndVersionNumber(reqId, versTarget.getVersion());
    }

    private void fixCategory(RequirementVersionTarget target, RequirementVersion requirementVersion) {
        ProjectTargetStatus projectStatus = this.validator.getModel().getProjectStatus(target.getProject());
        InfoListItem category = requirementVersion.getCategory();
        if (category == null || !this.listItemFinderService.isCategoryConsistent(projectStatus.getId(), category.getCode())) {
            requirementVersion.setCategory(this.listItemFinderService.findDefaultRequirementCategory(projectStatus.getId()));
        }
    }

    private RequirementVersion doUpdateRequirementVersion(RequirementVersionInstruction instruction, Map<String, String> cufValues) {
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        RequirementVersion reqVersion = instruction.getRequirementVersion();
        Requirement req = this.reqLibNavigationService.findRequirement(target.getRequirement().getId());
        RequirementVersion orig = req.findRequirementVersion(target.getVersion().intValue());
        this.doUpdateRequirementCoreAttributes(reqVersion, orig);
        if (CollectionUtils.isEmpty((Collection)instruction.getMilestones())) {
            orig.getMilestones().clear();
        } else {
            this.updateRequirementVersionToMilestones(target.isRejectedMilestone(), orig, this.boundMilestonesIds(instruction));
        }
        this.doUpdateCustomFields(cufValues, (BoundEntity)orig);
        this.doUpdateRequirementModificationMetadata((AuditableMixin)reqVersion, (AuditableMixin)orig);
        this.moveRequirement(target.getRequirement(), req);
        this.doUpdateRequirementNature(req, target.getRequirement());
        return orig;
    }

    private void updateRequirementVersionToMilestones(boolean corruptedMilestones, RequirementVersion requirementVersionPersisted, List<Long> boundMilestonesIds) {
        if (!corruptedMilestones) {
            this.bindRequirementVersionToMilestones(requirementVersionPersisted, boundMilestonesIds);
        }
    }

    private void moveRequirement(RequirementTarget target, Requirement req) {
        final Integer newPosition = target.getOrder();
        if (newPosition == null || newPosition <= 0) {
            return;
        }
        final Long[] sourceIds = new Long[]{req.getId()};
        final ClipboardPayload clipboardPayload = ClipboardPayload.withWhiteListIgnored(Collections.singletonList(req.getId()));
        if (target.isRootRequirement()) {
            this.reqLibNavigationService.moveNodesToLibrary(req.getLibrary().getId(), sourceIds, newPosition, clipboardPayload);
        } else {
            List<Long> ids = this.rlnDao.getParentsIds(req.getId());
            Long firstParentId = ids.get(ids.size() - 2);
            RequirementLibraryNode parent = this.reqLibNavigationService.findRequirementLibraryNodeById(firstParentId);
            final Long parentId = parent.getId();
            parent.accept(new RequirementLibraryNodeVisitor(){

                public void visit(Requirement requirement) {
                    RequirementFacility.this.reqLibNavigationService.moveNodesToRequirement(parentId, sourceIds, newPosition, clipboardPayload);
                }

                public void visit(RequirementFolder folder) {
                    RequirementFacility.this.reqLibNavigationService.moveNodesToFolder(parentId, sourceIds, newPosition, clipboardPayload);
                }
            });
        }
    }

    private void doUpdateRequirementNature(Requirement req, RequirementTarget target) {
        if (!req.isHighLevel() && target.isHighLevel()) {
            this.highLevelRequirementService.convertIntoHighLevelRequirement(req.getId());
        } else if (req.isHighLevel() && !target.isHighLevel()) {
            this.highLevelRequirementService.convertIntoStandardRequirement(req.getId());
        }
    }

    public LogTrain deleteRequirementVersion(RequirementVersionInstruction instr) {
        throw new NotImplementedException("implement me - must return a Failure : Not implemented in the log train instead of throwing this exception");
    }

    public void postprocess(List<Instruction<?>> instructions) {
        if (this.postProcessHandler != null) {
            this.postProcessHandler.doPostProcess(instructions);
        }
    }

    private class AddRequirementVisitor
    implements RequirementLibraryNodeVisitor {
        private final RequirementVersionInstruction instruction;
        private Requirement finalRequirement;
        private final Long finalParentId;
        private final NewRequirementVersionDto dto;

        public AddRequirementVisitor(RequirementVersionInstruction instruction, Long finalParentId, NewRequirementVersionDto dto) {
            this.instruction = instruction;
            this.finalParentId = finalParentId;
            this.dto = dto;
        }

        public Requirement getFinalRequirement() {
            return this.finalRequirement;
        }

        public void visit(Requirement requirement) {
            this.finalRequirement = requirement.isHighLevel() ? RequirementFacility.this.reqLibNavigationService.addRequirementToHighLevelRequirement((long)this.finalParentId, this.dto, RequirementFacility.this.boundMilestonesIds(this.instruction)) : RequirementFacility.this.reqLibNavigationService.addRequirementToRequirement((long)this.finalParentId, this.dto, RequirementFacility.this.boundMilestonesIds(this.instruction));
        }

        public void visit(RequirementFolder folder) {
            this.finalRequirement = RequirementFacility.this.reqLibNavigationService.addRequirementToRequirementFolder((long)this.finalParentId, this.dto, RequirementFacility.this.boundMilestonesIds(this.instruction));
        }
    }

    private class CreateRequirementVersionPostProcessStrategy
    implements ImportPostProcessHandler {
        private CreateRequirementVersionPostProcessStrategy() {
        }

        @Override
        public void doPostProcess(List<Instruction<?>> instructions) {
            for (Instruction<?> instruction : instructions) {
                RequirementVersionInstruction rvi;
                if (!(instruction instanceof RequirementVersionInstruction) || (rvi = (RequirementVersionInstruction)instruction).isFatalError()) continue;
                RequirementFacility.this.changeRequirementVersionStatus(rvi);
            }
        }
    }

    private static interface ImportPostProcessHandler {
        public void doPostProcess(List<Instruction<?>> var1);
    }

    private class UpdateRequirementVersionPostProcessStrategy
    implements ImportPostProcessHandler {
        private UpdateRequirementVersionPostProcessStrategy() {
        }

        @Override
        public void doPostProcess(List<Instruction<?>> instructions) {
            for (Instruction<?> instruction : instructions) {
                RequirementVersionInstruction rvi;
                if (!(instruction instanceof RequirementVersionInstruction) || (rvi = (RequirementVersionInstruction)instruction).isFatalError() || !rvi.getRequirementVersion().getStatus().isRequirementModifiable()) continue;
                this.renameRequirementVersion(rvi);
                RequirementFacility.this.changeRequirementVersionStatus(rvi);
            }
        }

        private void renameRequirementVersion(RequirementVersionInstruction rvi) {
            String unconsistentName = ((RequirementVersionTarget)rvi.getTarget()).getUnconsistentName();
            if (unconsistentName != null && !StringUtils.isEmpty((CharSequence)unconsistentName)) {
                String newName = PathUtils.unescapePathPartSlashes((String)unconsistentName);
                RequirementVersionTarget target = (RequirementVersionTarget)rvi.getTarget();
                Requirement req = RequirementFacility.this.reqLibNavigationService.findRequirement(target.getRequirement().getId());
                RequirementVersion orig = req.findRequirementVersion(target.getVersion().intValue());
                orig.setName(newName);
            }
        }
    }
}

