/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.service.internal.batchimport.CustomFieldInfos;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;

@Component
@Scope(value="prototype")
class CustomFieldTransator {
    private final Map<String, CustomFieldInfos> cufInfosCache = new HashMap<String, CustomFieldInfos>();
    @Inject
    private CustomFieldDao customFieldDao;

    CustomFieldTransator() {
    }

    protected final Map<Long, RawValue> toAcceptableCufs(Map<String, String> valueByCode) {
        HashMap<Long, RawValue> result = new HashMap<Long, RawValue>(valueByCode.size());
        for (Map.Entry<String, String> entry : valueByCode.entrySet()) {
            CustomFieldInfos infos;
            String requestedCode = entry.getKey();
            if (!this.cufInfosCache.containsKey(requestedCode)) {
                this.loadCustomFieldByCode(requestedCode);
            }
            if ((infos = this.cufInfosCache.get(requestedCode)) == null) continue;
            String requestedValue = entry.getValue();
            if (infos.getType().equals((Object)InputType.TAG)) {
                List values = requestedValue == null ? Collections.emptyList() : Arrays.asList(requestedValue.split("\\|"));
                result.put(infos.getId(), new RawValue(values));
                continue;
            }
            result.put(infos.getId(), new RawValue(requestedValue));
        }
        return result;
    }

    protected final InputType getInputTypeFor(String cufCode) {
        CustomFieldInfos infos;
        InputType response = null;
        if (!this.cufInfosCache.containsKey(cufCode)) {
            this.loadCustomFieldByCode(cufCode);
        }
        if ((infos = this.cufInfosCache.get(cufCode)) != null) {
            response = infos.getType();
        }
        return response;
    }

    private void loadCustomFieldByCode(String code) {
        CustomField customField = this.customFieldDao.findByCode(code);
        CustomFieldInfos infos = null;
        if (customField != null) {
            Long id = customField.getId();
            InputType type = customField.getInputType();
            infos = new CustomFieldInfos(id, type);
        }
        this.cufInfosCache.put(code, infos);
    }
}

