/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.server;

import java.util.Date;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.artificialintelligence.server.MalformedJsonPathException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.artificialintelligence.server.AiServerManagerService;
import org.squashtest.tm.service.internal.repository.AiServerDao;
import org.squashtest.tm.service.jsonpathextractor.JsonPathExtractor;
import org.squashtest.tm.service.project.CustomGenericProjectManager;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional
public class AiServerManagerServiceImpl
implements AiServerManagerService {
    private final AiServerDao aiServerDao;
    private final DSLContext dsl;
    private final CustomGenericProjectManager customGenericProjectManager;
    private final UserAccountService userAccountService;
    private final JsonPathExtractor jsonPathExtractor;

    public AiServerManagerServiceImpl(AiServerDao aiServerDao, DSLContext dsl, CustomGenericProjectManager customGenericProjectManager, UserAccountService userAccountService, JsonPathExtractor jsonPathExtractor) {
        this.aiServerDao = aiServerDao;
        this.dsl = dsl;
        this.customGenericProjectManager = customGenericProjectManager;
        this.userAccountService = userAccountService;
        this.jsonPathExtractor = jsonPathExtractor;
    }

    @Override
    public void persist(AiServer server) {
        String serverName = server.getName();
        if (this.nameInUse(serverName)) {
            throw new NameAlreadyInUseException(AiServer.class.getSimpleName(), serverName);
        }
        server.setAuthenticationPolicy(AuthenticationPolicy.APP_LEVEL);
        server.setAuthenticationProtocol(AuthenticationProtocol.TOKEN_AUTH);
        this.aiServerDao.save(server);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void deleteAiServers(List<Long> aiServerIds) {
        this.customGenericProjectManager.unbindAiServers(aiServerIds);
        this.aiServerDao.deleteAllById(aiServerIds);
    }

    @Override
    public void updateName(long aiServerId, String name) {
        if (this.nameInUse(name)) {
            throw new NameAlreadyInUseException(AiServer.class.getSimpleName(), name);
        }
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        server.setName(name);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public boolean nameInUse(String serverName) {
        Long id = (Long)this.dsl.select((SelectField)Tables.THIRD_PARTY_SERVER.SERVER_ID).from((TableLike)Tables.THIRD_PARTY_SERVER).join((TableLike)Tables.AI_SERVER).on(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq((Field)Tables.AI_SERVER.SERVER_ID)).where(Tables.THIRD_PARTY_SERVER.NAME.eq((Object)serverName)).fetchOneInto(Long.class);
        return id != null;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateDescription(long aiServerId, String description) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        server.setDescription(description);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateUrl(long aiServerId, String url) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        server.setUrl(url);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updatePayloadTemplate(long aiServerId, String payload) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        if (payload.isEmpty()) {
            server.setPayloadTemplate(null);
        } else {
            server.setPayloadTemplate(payload);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void forceAuditAfterCredentialsUpdate(long aiServerId) {
        AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
        server.setLastModifiedOn(new Date());
        server.setLastModifiedBy(this.userAccountService.findCurrentUserDto().getUsername());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void updateJsonPath(long aiServerId, String jsonPath) {
        if (this.jsonPathExtractor.isPathValid(jsonPath) || jsonPath.isEmpty()) {
            AiServer server = (AiServer)this.aiServerDao.getReferenceById(aiServerId);
            if (jsonPath.isEmpty()) {
                server.setJsonPath(null);
            } else {
                server.setJsonPath(jsonPath);
            }
        } else {
            throw new MalformedJsonPathException();
        }
    }
}

