/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.actionword;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeDefinition;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.actionword.AWLNDeletionHandler;
import org.squashtest.tm.service.internal.actionword.ActionWordLibraryNodeBuilder;
import org.squashtest.tm.service.internal.actionword.ActionWordLibraryNodeCopier;
import org.squashtest.tm.service.internal.actionword.ActionWordLibraryNodeMover;
import org.squashtest.tm.service.internal.display.dto.actionword.ActionWordPreview;
import org.squashtest.tm.service.internal.display.dto.actionword.LinkedToKeywordStepPreviewReport;
import org.squashtest.tm.service.internal.repository.ActionWordDao;
import org.squashtest.tm.service.internal.repository.ActionWordLibraryNodeDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;

@Service
@Transactional
public class ActionWordLibraryNodeServiceImpl
implements ActionWordLibraryNodeService {
    @Inject
    protected PermissionEvaluationService permissionService;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private ActionWordLibraryNodeDao actionWordLibraryNodeDao;
    @Inject
    private ActionWordDao actionWordDao;
    @Inject
    private AWLNDeletionHandler deletionHandler;
    @Inject
    private ActionWordLibraryNodeCopier nodeCopier;
    @Inject
    private ActionWordLibraryNodeMover nodeMover;

    @Override
    public ActionWordLibraryNode findActionWordLibraryNodeById(Long nodeId) {
        return (ActionWordLibraryNode)this.actionWordLibraryNodeDao.getReferenceById(nodeId);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#nodeId, 'org.squashtest.tm.domain.actionword.ActionWordLibraryNode', 'READ')  or hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public ActionWordLibrary findLibraryByNodeId(Long nodeId) {
        return (ActionWordLibrary)this.findEntityAndCheckType(nodeId, ActionWordTreeDefinition.LIBRARY);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#nodeId, 'org.squashtest.tm.domain.actionword.ActionWordLibraryNode', 'READ')  or hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public ActionWord findActionWordByNodeId(Long nodeId) {
        return (ActionWord)this.findEntityAndCheckType(nodeId, ActionWordTreeDefinition.ACTION_WORD);
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentId, 'org.squashtest.tm.domain.actionword.ActionWordLibraryNode', 'CREATE')  or hasRole('ROLE_ADMIN')")
    public ActionWordLibraryNode createNewNode(Long parentId, ActionWordTreeEntity entity) throws NameAlreadyInUseException {
        ActionWordLibraryNode parentNode = (ActionWordLibraryNode)this.actionWordLibraryNodeDao.getReferenceById(parentId);
        boolean tokenCaseInsensitivity = this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS);
        ActionWordLibraryNode newNode = new ActionWordLibraryNodeBuilder(parentNode, entity, tokenCaseInsensitivity).build();
        return (ActionWordLibraryNode)this.actionWordLibraryNodeDao.save(newNode);
    }

    @Override
    @IsUltimateLicenseAvailable
    public boolean simulateCopyNodes(List<Long> nodeIds, long targetId) {
        List nodes = this.actionWordLibraryNodeDao.findAllById(nodeIds);
        ActionWordLibraryNode target = (ActionWordLibraryNode)this.actionWordLibraryNodeDao.getReferenceById(targetId);
        boolean caseInsensitivity = this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS);
        return this.nodeCopier.simulateCopyNodes(nodes, target, caseInsensitivity);
    }

    @Override
    @PreAuthorize(value="hasPermission(#targetId, 'org.squashtest.tm.domain.actionword.ActionWordLibraryNode', 'CREATE')  or hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public List<ActionWordLibraryNode> copyNodes(List<Long> nodeIds, long targetId) {
        List nodes = this.actionWordLibraryNodeDao.findAllById(nodeIds);
        ActionWordLibraryNode target = (ActionWordLibraryNode)this.actionWordLibraryNodeDao.getReferenceById(targetId);
        boolean caseInsensitivity = this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS);
        return this.nodeCopier.copyNodes(nodes, target, caseInsensitivity);
    }

    @Override
    public void moveNodes(List<Long> nodeIds, long targetId) {
        PermissionsUtils.checkPermission(this.permissionService, nodeIds, Permissions.DELETE.name(), ActionWordLibraryNode.class.getName());
        List nodes = this.actionWordLibraryNodeDao.findAllById(nodeIds);
        ActionWordLibraryNode target = (ActionWordLibraryNode)this.actionWordLibraryNodeDao.getReferenceById(targetId);
        boolean caseInsensitivity = this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS);
        this.nodeMover.moveNodes(nodes, target, caseInsensitivity);
    }

    @Override
    public ActionWordLibraryNode findNodeFromEntity(ActionWordTreeEntity actionWordTreeEntity) {
        return this.actionWordLibraryNodeDao.findNodeFromEntity(actionWordTreeEntity);
    }

    private ActionWordTreeEntity findEntityAndCheckType(Long nodeId, ActionWordTreeDefinition entityType) {
        ActionWordLibraryNode node = this.findActionWordLibraryNodeById(nodeId);
        if (node == null || node.getEntityType() != entityType) {
            String message = "The node of id %d doesn't exist or doesn't represent a %s entity.";
            throw new IllegalArgumentException(String.format(message, nodeId, entityType.getTypeName()));
        }
        ActionWordTreeEntity entity = node.getEntity();
        if (entity == null) {
            String message = "The node of id %d represents a null entity.";
            throw new IllegalArgumentException(String.format(message, nodeId));
        }
        return entity;
    }

    @Override
    public void renameNodeFromActionWord(ActionWord actionWord) {
        ActionWordLibraryNode actionWordLibraryNode = this.findNodeFromEntity((ActionWordTreeEntity)actionWord);
        actionWordLibraryNode.renameNode(actionWord.createWord());
    }

    @Override
    @IsUltimateLicenseAvailable
    public OperationReport delete(List<Long> nodeIds) {
        List nodeIdsToDelete = this.actionWordLibraryNodeDao.getActionWordLibraryNodeIdsWithoutSteps(nodeIds);
        PermissionsUtils.checkPermission(this.permissionService, nodeIdsToDelete, Permissions.DELETE.name(), ActionWordLibraryNode.class.getName());
        return this.deletionHandler.deleteNodes(nodeIdsToDelete);
    }

    @Override
    @IsUltimateLicenseAvailable
    public String findActionWordPathByPreviewNode(ActionWordPreview node) {
        StringBuilder result = new StringBuilder(node.actionWordName());
        this.addParentNameIntoNodePath(result, node.projectName());
        return result.toString();
    }

    private void addParentNameIntoNodePath(StringBuilder builder, String projectName) {
        builder.insert(0, String.valueOf(projectName) + "/");
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<String> findAllCaseInsensitiveDuplicateActions() {
        return this.actionWordDao.findAllCaseInsensitiveDuplicateActions();
    }

    @Override
    @IsUltimateLicenseAvailable
    public List<LinkedToKeywordStepPreviewReport> previewAffectedNodes(List<Long> nodeIds) {
        ArrayList<LinkedToKeywordStepPreviewReport> reports = new ArrayList<LinkedToKeywordStepPreviewReport>();
        List previewNodes = this.actionWordLibraryNodeDao.fetchActionWordPreviewDtos(nodeIds);
        for (ActionWordPreview previewNode : previewNodes) {
            String nodePath = this.findActionWordPathByPreviewNode(previewNode);
            int keywordTestStepCount = previewNode.associatedKeywordTestStepCount();
            if (keywordTestStepCount <= 0) continue;
            reports.add(new LinkedToKeywordStepPreviewReport(nodePath, keywordTestStepCount));
        }
        return reports;
    }
}

