/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.annotation;

import javax.inject.Inject;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;

@Aspect
@Component
public class IsUltimateLicenseAvailableAspect {
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService;

    boolean isUltimateLicenseAvailable() {
        return this.ultimateLicenseAvailabilityService.isAvailable();
    }

    @Around(value="@annotation(IsUltimateLicenseAvailable)")
    public Object checkUltimateLicense(ProceedingJoinPoint joinPoint) throws Throwable {
        String errorMessage = "Forbidden " + HttpStatus.FORBIDDEN.value() + " Ultimate License Not Available";
        if (!this.isUltimateLicenseAvailable()) {
            throw new AccessDeniedException(errorMessage);
        }
        return joinPoint.proceed();
    }
}

