/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.testplanretriever;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.tuple.Triple;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.squashtest.tm.api.plugin.EntityType;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.TagsValue;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.campaign.AutomatedExecutionCreationService;
import org.squashtest.tm.service.internal.dto.AutomatedTestCaseDTO;
import org.squashtest.tm.service.internal.dto.AutomatedTestPlanDTO;
import org.squashtest.tm.service.internal.dto.ExecutionOrderDTO;
import org.squashtest.tm.service.internal.dto.TestPlanContextDTO;
import org.squashtest.tm.service.internal.dto.TriggerRequestDTO;
import org.squashtest.tm.service.internal.dto.TriggerRequestExtendedDTO;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.TagDao;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.internal.testautomation.testplanretriever.RestAutomatedSuiteManagerService;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.testautomation.testplanretriever.CustomFieldValuesForExec;
import org.squashtest.tm.service.testautomation.testplanretriever.RestTestPlanFinder;
import org.squashtest.tm.service.testautomation.testplanretriever.TestPlanRetrievalService$AjcClosure1;
import org.squashtest.tm.service.testautomation.testplanretriever.exception.NotFoundCustomFieldException;
import org.squashtest.tm.service.testautomation.testplanretriever.exception.TestPlanException;

@Service
@Transactional
public class TestPlanRetrievalService<T extends TriggerRequestDTO, C extends CustomFieldValuesForExec> {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseService;
    @Inject
    private CustomFieldDao cufDao;
    @Inject
    private TagDao tagDao;
    @Inject
    protected IterationTestPlanDao itpiDao;
    @Inject
    protected RestAutomatedSuiteManagerService<C> restService;
    @Inject
    protected RestTestPlanFinder restTestPlanFinder;
    @Inject
    private EntityPathHeaderDao pathHeaderDao;
    @Inject
    protected ProjectDao projectDao;
    @Inject
    private AutomatedExecutionCreationService automatedExecutionCreationService;
    @Value(value="${info.app.version}")
    protected String squashTMVersion;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @BatchPreventConcurrent(entityType=IterationTestPlanItem.class)
    public AutomatedTestPlanDTO getIterationTestPlan(T triggerRequest, Iteration iteration, @Ids List<Long> itemTestPlanIds) throws TestPlanException {
        String path = this.pathHeaderDao.buildIterationPathHeader(iteration.getId());
        TestPlanContextDTO testPlanContext = new TestPlanContextDTO(EntityType.ITERATION, iteration.getName(), path, iteration.getUuid(), this.squashTMVersion);
        AutomatedSuite suite = this.restService.createAutomatedSuiteLinkedToIteration(iteration);
        Project project = this.projectDao.fetchByIterationIdForAutomatedExecutionCreation(iteration.getId());
        return this.getAutomatedTestPlanDTO(triggerRequest, itemTestPlanIds, suite, testPlanContext, project);
    }

    @BatchPreventConcurrent(entityType=IterationTestPlanItem.class)
    public AutomatedTestPlanDTO getTestSuiteTestPlan(T triggerRequest, TestSuite testSuite, @Ids List<Long> itemTestPlanIds) throws TestPlanException {
        String path = this.pathHeaderDao.buildTestSuitePathHeader(testSuite.getId());
        TestPlanContextDTO testPlanContext = new TestPlanContextDTO(EntityType.TEST_SUITE, testSuite.getName(), path, testSuite.getUuid(), this.squashTMVersion);
        AutomatedSuite suite = this.restService.createAutomatedSuiteLinkedToTestSuite(testSuite);
        Project project = this.projectDao.fetchByTestSuiteForAutomatedExecutionCreation(testSuite.getId());
        return this.getAutomatedTestPlanDTO(triggerRequest, itemTestPlanIds, suite, testPlanContext, project);
    }

    private AutomatedTestPlanDTO getAutomatedTestPlanDTO(T triggerRequest, List<Long> itemIds, AutomatedSuite suite, TestPlanContextDTO testPlanContext, Project project) throws NotFoundCustomFieldException {
        Map<Long, Long> itemExecutionMap = this.getItemExecutionMap(triggerRequest, itemIds, suite, project);
        List items = this.itpiDao.fetchWithServerByIds(itemExecutionMap.keySet());
        ExecutionOrderDTO executionOrder = this.getExecutionOrder(items, itemExecutionMap);
        return new AutomatedTestPlanDTO(suite.getId(), executionOrder, testPlanContext);
    }

    private Map<Long, Long> getItemExecutionMap(T triggerRequest, List<Long> itemIds, AutomatedSuite suite, Project project) throws NotFoundCustomFieldException {
        HibernateConfig.enableBatch(this.entityManager, 10);
        HashMap<Long, Long> itemExecutionMap = new HashMap<Long, Long>();
        List partitionedIds = Lists.partition(itemIds, (int)10);
        for (List ids : partitionedIds) {
            List<IterationTestPlanItem> items = this.fetchIterationTestPlanItems(triggerRequest, ids);
            itemExecutionMap.putAll(this.automatedExecutionCreationService.createAutomatedExecutions(suite, items, project));
        }
        return itemExecutionMap;
    }

    protected List<IterationTestPlanItem> fetchIterationTestPlanItems(T triggerRequest, List<Long> itemIds) throws NotFoundCustomFieldException {
        List<Long> list = itemIds;
        IterationTestPlanDao iterationTestPlanDao = this.itpiDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        TestPlanRetrievalService$AjcClosure1 testPlanRetrievalService$AjcClosure1 = new TestPlanRetrievalService$AjcClosure1(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testPlanRetrievalService$AjcClosure1.linkClosureAndJoinPoint(4112));
        return this.activateFilter(triggerRequest, items);
    }

    private List<IterationTestPlanItem> activateFilter(T triggerRequest, List<IterationTestPlanItem> items) throws NotFoundCustomFieldException {
        if (!this.ultimateLicenseService.isAvailable()) {
            return items;
        }
        TriggerRequestExtendedDTO extendedUltimateTriggerRequest = (TriggerRequestExtendedDTO)triggerRequest;
        if (StringUtils.hasLength((String)extendedUltimateTriggerRequest.getTagLabel())) {
            if (this.cufDao.findByLabelAndInputType(extendedUltimateTriggerRequest.getTagLabel(), InputType.TAG) != null) {
                items = this.filterByTag(extendedUltimateTriggerRequest, items);
            } else {
                throw new NotFoundCustomFieldException();
            }
        }
        return items;
    }

    private List<IterationTestPlanItem> filterByTag(TriggerRequestExtendedDTO triggerRequest, List<IterationTestPlanItem> items) {
        List<Long> testCasesIds = items.stream().map(item -> item.getReferencedTestCase().getId()).toList();
        List<TagsValue> tagsValues = this.getTagsValuesByTagLabelAndTestCaseIds(testCasesIds, triggerRequest.getTagLabel());
        List<String> givenValues = this.cleanAndSplitValueList(triggerRequest.getTagValue());
        List<Long> testCasesWithTags = tagsValues.stream().filter(tagsValue -> tagsValue.getValues().stream().anyMatch(givenValues::contains)).map(CustomFieldValue::getBoundEntityId).distinct().toList();
        return items.stream().filter(item -> testCasesWithTags.contains(item.getReferencedTestCase().getId())).toList();
    }

    private List<TagsValue> getTagsValuesByTagLabelAndTestCaseIds(List<Long> testCasesIds, String tagLabel) {
        return this.tagDao.getTagsValuesByTagLabelAndTestCaseIds(testCasesIds, tagLabel);
    }

    private List<String> cleanAndSplitValueList(String valuesAsString) {
        return Stream.of(valuesAsString.trim().split("\\|")).map(String::trim).filter(value -> !value.isEmpty()).toList();
    }

    private ExecutionOrderDTO createExecutionOrder(Collection<Triple<IterationTestPlanItem, Map<String, Object>, Map<String, Object>>> testListWithParams) {
        ExecutionOrderDTO executionOrder = new ExecutionOrderDTO();
        testListWithParams.forEach(testWithParams -> {
            AutomatedTestCaseDTO testCaseDTO = new AutomatedTestCaseDTO(((IterationTestPlanItem)testWithParams.getLeft()).getId(), (Map)testWithParams.getMiddle(), (Map)testWithParams.getRight());
            executionOrder.getTestList().add(testCaseDTO);
            LoggerFactory.getLogger(TestPlanRetrievalService.class).debug("Including test {} to execution order.", new Object[]{testCaseDTO.getParamMap().get("TC_AUTOMATED_TEST_REFERENCE")});
        });
        return executionOrder;
    }

    private ExecutionOrderDTO getExecutionOrder(List<IterationTestPlanItem> items, Map<Long, Long> itemExecutionMap) {
        Collection<Triple<IterationTestPlanItem, Map<String, Object>, Map<String, Object>>> testListWithParams = this.restService.prepareExecutionOrder(items, itemExecutionMap);
        return this.createExecutionOrder(testListWithParams);
    }

    static {
        TestPlanRetrievalService.ajc$preClinit();
    }

    static final /* synthetic */ List fetchForAutomatedExecutionCreation_aroundBody0(TestPlanRetrievalService testPlanRetrievalService, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.fetchForAutomatedExecutionCreation(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestPlanRetrievalService.java", TestPlanRetrievalService.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "fetchForAutomatedExecutionCreation", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "itemTestPlanIds", "", "java.util.List"), 171);
    }
}

