/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.profile.CannotAddUserToTeamWithCustomProfileException;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.internal.repository.ProfileDao;
import org.squashtest.tm.service.internal.repository.TeamDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.user.CustomTeamModificationServiceImpl$AjcClosure1;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;
import org.squashtest.tm.service.user.CustomTeamModificationService;

@Service(value="CustomTeamModificationService")
@PreAuthorize(value="hasRole('ROLE_ADMIN')")
@Transactional
public class CustomTeamModificationServiceImpl
implements CustomTeamModificationService {
    @Inject
    private TeamDao teamDao;
    @Inject
    private UserDao userDao;
    @Inject
    private ObjectAclService aclService;
    @Inject
    private ProfileDao profileDao;
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public void persist(Team team) {
        if (!this.teamDao.findAllByName(team.getName()).isEmpty()) {
            throw new NameAlreadyInUseException("Team", team.getName());
        }
        this.teamDao.save(team);
    }

    @Override
    public void deleteTeam(long teamId) {
        Team team = (Team)this.teamDao.getReferenceById(teamId);
        List memberIds = IdentifiedUtil.extractIds((Collection)team.getMembers());
        this.removeMembers(team, (List<Long>)memberIds);
        this.aclService.removeAllResponsibilities(teamId);
        this.teamDao.delete(team);
    }

    @Override
    public void deleteTeam(List<Long> teamId) {
        for (Long id : teamId) {
            this.deleteTeam(id);
        }
    }

    @Override
    public void changeName(long teamId, String name) {
        String trimName = name.trim();
        if (!this.teamDao.findAllByName(trimName).isEmpty()) {
            throw new NameAlreadyInUseException("Team", trimName);
        }
        Team team = (Team)this.teamDao.getReferenceById(teamId);
        team.setName(trimName);
    }

    @Override
    public void addMember(long teamId, String login) {
        this.addMembers(teamId, Arrays.asList(login));
    }

    @Override
    public void addMembers(long teamId, List<String> logins) {
        this.verifyTeamDoesNothaveCustomProfiles(teamId);
        List<String> list = logins;
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        CustomTeamModificationServiceImpl$AjcClosure1 customTeamModificationServiceImpl$AjcClosure1 = new CustomTeamModificationServiceImpl$AjcClosure1(objectArray);
        List users = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(customTeamModificationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        Team team = (Team)this.teamDao.getReferenceById(teamId);
        team.addMembers((Collection)users);
        this.aclService.refreshAcls();
    }

    private void verifyTeamDoesNothaveCustomProfiles(long teamId) {
        if (this.ultimateLicenseAvailabilityService.isAvailable()) {
            return;
        }
        Set profileNames = this.profileDao.findProfileNamesByPartyId(teamId);
        if (profileNames.stream().anyMatch(profileName -> !AclGroup.isSystem((String)profileName))) {
            throw new CannotAddUserToTeamWithCustomProfileException();
        }
    }

    @Override
    public List<User> findAllNonMemberUsers(long teamId) {
        return this.userDao.findAllNonTeamMembers(teamId);
    }

    @Override
    public void removeMember(long teamId, long memberId) {
        User user = (User)this.userDao.getReferenceById(memberId);
        Team team = (Team)this.teamDao.getReferenceById(teamId);
        team.removeMember(user);
        this.aclService.refreshAcls();
    }

    @Override
    public void removeMembers(long teamId, List<Long> memberIds) {
        Team team = (Team)this.teamDao.getReferenceById(teamId);
        this.removeMembers(team, memberIds);
    }

    private void removeMembers(Team team, List<Long> memberIds) {
        List users = this.userDao.findAllById(memberIds);
        team.removeMember((Collection)users);
        this.aclService.refreshAcls();
    }

    @Override
    public void removeMemberFromAllTeams(long memberId) {
        User user = (User)this.userDao.getReferenceById(memberId);
        ArrayList<Long> teamIds = new ArrayList<Long>();
        Set teams = user.getTeams();
        for (Team team : teams) {
            teamIds.add(team.getId());
            team.removeMember(user);
        }
        user.removeTeams(teamIds);
        this.aclService.refreshAcls();
    }

    static {
        CustomTeamModificationServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findUsersByLoginList_aroundBody0(CustomTeamModificationServiceImpl customTeamModificationServiceImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginList(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CustomTeamModificationServiceImpl.java", CustomTeamModificationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findUsersByLoginList", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "loginList", "", "java.util.List"), 111);
    }
}

