/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd.robot.keywords;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.service.internal.testcase.bdd.TextGridFormatter;
import org.squashtest.tm.service.internal.testcase.bdd.robot.RobotSyntaxHelpers;
import org.squashtest.tm.service.internal.testcase.bdd.robot.SectionBuilderHelpers;

public final class RetrieveDocstringsKeywordBuilder {
    private static final List<String> RETRIEVE_DOCSTRINGS_DOCUMENTATION_LINES = Arrays.asList("Retrieves Squash TM's docstrings and stores them in a dictionary.", "", "For instance, two docstrings have been defined in Squash TM,", "the first one containing the string", "\"I am the", "FIRST    docstring\",", "the second one containing the string \"I am the second docstring\"", "", "First, this keyword retrieves values and converts them to an inline string :", "${docstring_1} =    Set Variable    I am the\\nFIRST\\tdocstring\"", "", "Then, this keyword stores the docstrings into the &{docstrings} dictionary", "with each docstring name as key, and each docstring value as value :", "${docstrings} =    Create Dictionary    docstring_1=${docstring_1}    docstring_2=${docstring_2}");

    private RetrieveDocstringsKeywordBuilder() {
    }

    public static String buildRetrieveDocstrings(KeywordTestCase keywordTestCase) {
        boolean isDocstringEnabled = SectionBuilderHelpers.isTestCaseUsingDocstrings(keywordTestCase);
        if (isDocstringEnabled) {
            SectionBuilderHelpers.MultiLineStringBuilder stringBuilder = new SectionBuilderHelpers.MultiLineStringBuilder();
            List<String> docstrings = SectionBuilderHelpers.extractUsedDocstrings(keywordTestCase);
            return stringBuilder.appendNewLine().appendLine("Retrieve Docstrings").append(SectionBuilderHelpers.formatDocumentationSettingLines(RETRIEVE_DOCSTRINGS_DOCUMENTATION_LINES)).appendNewLine().append(RetrieveDocstringsKeywordBuilder.formatDocstringScalars(docstrings)).appendNewLine().append(RetrieveDocstringsKeywordBuilder.formatDocstringsDictionaryCreation(docstrings)).appendNewLine().appendLine("    RETURN    " + RobotSyntaxHelpers.dictionaryVariable("docstrings")).toString();
        }
        return "";
    }

    private static String formatDocstringScalars(List<String> docstrings) {
        TextGridFormatter textGridFormatter = new TextGridFormatter();
        int i = 0;
        while (i < docstrings.size()) {
            String docstringContent = RetrieveDocstringsKeywordBuilder.preprocessDocstring(docstrings.get(i));
            String docstringName = String.format("docstring_%s", i + 1);
            textGridFormatter.addRow(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.scalarVariable(docstringName)), "Set Variable", docstringContent);
            ++i;
        }
        return textGridFormatter.format(TextGridFormatter.withRowPrefix("    "));
    }

    private static String formatDocstringsDictionaryCreation(List<String> docstrings) {
        ArrayList<String> cells = new ArrayList<String>();
        cells.add(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.dictionaryVariable("docstrings")));
        cells.add("Create Dictionary");
        int i = 0;
        while (i < docstrings.size()) {
            String docstringName = String.format("docstring_%s", i + 1);
            String entry = String.valueOf(docstringName) + "=" + RobotSyntaxHelpers.scalarVariable(docstringName);
            cells.add(entry);
            ++i;
        }
        return new TextGridFormatter().addRow(cells).format(TextGridFormatter.withRowPrefix("    "));
    }

    private static String preprocessDocstring(String docstringContent) {
        return docstringContent.replace("\n", "\\n").replace("\t", "\\t");
    }
}

