/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.exception.actionword.InvalidActionWordParameterNameException;
import org.squashtest.tm.service.internal.testcase.bdd.AbstractActionWordParser;
import org.squashtest.tm.service.internal.testcase.bdd.ActionWordTokenizer;

public class LibraryActionWordParser
extends AbstractActionWordParser {
    public ActionWord createActionWordInLibrary(String input) {
        List<ActionWordTokenizer.AWToken> tokens = this.checkInputAndParseTokens(input, false);
        for (ActionWordTokenizer.AWToken token : tokens) {
            switch (token.getType()) {
                case PLAIN_TEXT: {
                    this.addTextFragment(token);
                    break;
                }
                case QUOTED_VALUE: {
                    this.addNamedParameter(token);
                    break;
                }
                case NUMBER: {
                    this.addNumberFragment(token);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Found unexpected AWToken of type '%s' with text '%s'.", new Object[]{token.getType(), token.getLexeme()}));
                }
            }
        }
        return new ActionWord(this.fragments);
    }

    private void addNamedParameter(ActionWordTokenizer.AWToken token) {
        String parameterName = this.canonicalizeKeywordParameterName(token.getLexeme());
        this.addParameter(parameterName, "", "");
    }

    private String canonicalizeKeywordParameterName(String candidateName) {
        if (candidateName.startsWith("\"") && candidateName.endsWith("\"")) {
            if (candidateName.length() < 3) {
                throw new InvalidActionWordParameterNameException("Action word parameter name cannot be blank.");
            }
            candidateName = candidateName.substring(1, candidateName.length() - 1);
        }
        if (StringUtils.isBlank((CharSequence)candidateName)) {
            throw new InvalidActionWordParameterNameException("Action word parameter name cannot be blank.");
        }
        candidateName = candidateName.trim().replaceAll("(\\s)+", "_");
        if (!Pattern.compile("^[A-Za-z0-9_-]{1,255}$").matcher(candidateName).matches()) {
            throw new InvalidActionWordParameterNameException("Action word parameter name must contain only alphanumeric, dash or underscore characters.");
        }
        return candidateName;
    }
}

