/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.event.EventListener;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.api.automation.workflow.AutomationWorkflow;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.core.scm.api.exception.ScmNoCredentialsException;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.QProject;
import org.squashtest.tm.domain.scm.QScmRepository;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.QTestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testcase.QKeywordTestCase;
import org.squashtest.tm.domain.testcase.QScriptedTestCase;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.tf.automationrequest.QAutomationRequest;
import org.squashtest.tm.service.internal.repository.ActionWordDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.ScmRepositoryDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.scmserver.ScmConnectorRegistry;
import org.squashtest.tm.service.internal.tf.event.AutomationRequestStatusChangeEvent;
import org.squashtest.tm.service.scmserver.ScmRepositoryFilesystemService;
import org.squashtest.tm.service.scmserver.ScmRepositoryManifest;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.spi.ScmConnector;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@Component
public class BDDTestCaseEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDDTestCaseEventListener.class);
    private static final String SPEL_ARSTATUS = "T(org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus)";
    private static final String CHANGED_REQUEST_IDS_MESSAGE = "changed request ids : '{}'";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private ScmConnectorRegistry scmConnectorRegistry;
    @Inject
    private ScmRepositoryFilesystemService scmService;
    @Inject
    private TestCaseModificationService tcService;
    @Inject
    private ScmRepositoryDao scmRepositoryDao;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private MessageSource i18nHelper;
    @Inject
    private ActionWordDao actionWordDao;
    @Autowired(required=false)
    Collection<AutomationWorkflow> plugins = Collections.emptyList();

    private String getMessage(String i18nKey) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.i18nHelper.getMessage(i18nKey, null, locale);
    }

    @Order(value=10)
    @EventListener(classes={AutomationRequestStatusChangeEvent.class}, condition="#event.newStatus == T(org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus).TRANSMITTED")
    public void commitWhenTransmitted(AutomationRequestStatusChangeEvent event) {
        this.em.clear();
        LOGGER.debug("request status changed : committing test scripts to repositories if needed", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(CHANGED_REQUEST_IDS_MESSAGE, new Object[]{event.getAutomationRequestIds()});
        }
        List<Long> requestIds = event.getAutomationRequestIds();
        Collection<Long> testCaseIds = this.findTestCaseIdsByAutomationRequestIds(requestIds);
        LOGGER.debug("committing test cases to their repositories", new Object[0]);
        LOGGER.trace("test case ids : '{}'", new Object[]{testCaseIds});
        Map scriptsGroupedByScm = this.scmRepositoryDao.findScriptedAndKeywordTestCasesGroupedByRepoById(testCaseIds);
        for (Map.Entry entry : scriptsGroupedByScm.entrySet()) {
            ScmRepository scm = (ScmRepository)entry.getKey();
            Set testCases = (Set)entry.getValue();
            Credentials credentials = this.testScmCredentials(scm);
            this.scmService.createOrUpdateScriptFile(scm, testCases);
            this.synchronizeRepository(scm, credentials);
        }
        this.processRemoteTickets(new ArrayList<Long>(requestIds));
    }

    private void processRemoteTickets(List<Long> requestIds) {
        LOGGER.debug("request status changed and type workflow isremote : create a new jira ticket and remoteRAE", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(CHANGED_REQUEST_IDS_MESSAGE, new Object[]{requestIds});
        }
        List testCases = this.testCaseDao.findTestCaseByAutomationRequestIds(requestIds);
        for (TestCase tc : testCases) {
            boolean isRemoteWorkflowActive;
            boolean bl = isRemoteWorkflowActive = tc.getProject().isAllowAutomationWorkflow() && AutomationWorkflowType.REMOTE_WORKFLOW.equals((Object)tc.getProject().getAutomationWorkflowType());
            if (!isRemoteWorkflowActive) continue;
            LibraryPluginBinding lpb = this.projectDao.findPluginForProject(tc.getProject().getId(), PluginType.AUTOMATION);
            for (AutomationWorkflow plugin : this.plugins) {
                this.handleTicketCreation(tc, lpb, plugin);
            }
        }
    }

    private void handleTicketCreation(TestCase tc, LibraryPluginBinding lpb, AutomationWorkflow plugin) {
        String remoteIssueKey;
        if (plugin.getPluginType().equals((Object)lpb.getPluginType()) && (remoteIssueKey = plugin.createNewTicketRemoteServer(tc.getId())) != null) {
            plugin.createRemoteAutomationRequestExtenderForTestCaseIfNotExist(remoteIssueKey, tc.getId());
        }
    }

    private Credentials testScmCredentials(ScmRepository scm) {
        Supplier<ScmNoCredentialsException> throwIfNull;
        Optional<Credentials> maybeCredentials;
        Credentials credentials;
        AuthenticationProtocol protocol;
        ScmServer server = scm.getScmServer();
        ScmConnector connector = this.scmConnectorRegistry.createConnector(scm);
        if (!connector.supports(protocol = (credentials = (maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)server)).orElseThrow(throwIfNull = () -> {
            throw new ScmNoCredentialsException(String.format(this.getMessage("message.scmRepository.noCredentials"), scm.getName()));
        })).getImplementedProtocol())) {
            throw new UnsupportedAuthenticationModeException(protocol.toString());
        }
        connector.testCredentials(credentials);
        return credentials;
    }

    private void synchronizeRepository(ScmRepository scm, Credentials credentials) {
        ScmConnector connector = this.scmConnectorRegistry.createConnector(scm);
        try {
            connector.synchronize(credentials);
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Order(value=100)
    @EventListener(classes={AutomationRequestStatusChangeEvent.class}, condition="#event.newStatus == T(org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus).TRANSMITTED or #event.newStatus == T(org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus).AUTOMATED")
    public void autoBindWhenAvailable(AutomationRequestStatusChangeEvent event) {
        LOGGER.debug("request status changed : autobinding test scripts if needed and possible", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(CHANGED_REQUEST_IDS_MESSAGE, new Object[]{event.getAutomationRequestIds()});
        }
        List<Long> requestIds = event.getAutomationRequestIds();
        List<TestCase> candidates = this.findTCCandidatesForAutoBind(requestIds);
        Map<Project, List<TestCase>> testCasesByProjects = candidates.stream().collect(Collectors.groupingBy(tc -> tc.getProject()));
        for (Map.Entry<Project, List<TestCase>> entry : testCasesByProjects.entrySet()) {
            Project project = entry.getKey();
            ScmRepository scm = project.getScmRepository();
            List<TestCase> testCases = entry.getValue();
            try {
                scm.doWithLock(() -> {
                    this.autoBindWithScm(scm, testCases);
                    return null;
                });
            }
            catch (IOException ex) {
                LOGGER.error("Error while autobinding test cases from project '{}'", new Object[]{project.getName(), ex});
            }
        }
    }

    @Order(value=200)
    @EventListener(classes={AutomationRequestStatusChangeEvent.class}, condition="#event.newStatus == T(org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus).AUTOMATED")
    public void registerActionWordLastImplementationInformation(AutomationRequestStatusChangeEvent event) {
        List<Long> automationRequestIds = event.getAutomationRequestIds();
        this.actionWordDao.updateActionWordImplInfoFromAutomRequestIds(automationRequestIds);
    }

    private void autoBindWithScm(ScmRepository scm, List<TestCase> testCases) {
        LOGGER.debug("autobinding test cases for scm '{}'", new Object[]{scm.getName()});
        if (LOGGER.isTraceEnabled()) {
            List tcIds = IdCollector.collect(testCases);
            LOGGER.trace("test case ids : {}", new Object[]{tcIds});
        }
        ScmRepositoryManifest manifest = new ScmRepositoryManifest(scm);
        Optional<TestAutomationProject> maybeGherkin = this.findFirstGherkinProject(testCases);
        if (maybeGherkin.isPresent()) {
            TestAutomationProject gherkinProject = maybeGherkin.get();
            testCases.forEach(tc -> {
                String pattern = this.scmService.createTestCasePatternForResearch((TestCase)tc);
                Optional<File> maybeFile = manifest.locateTest(pattern, tc.getId());
                if (maybeFile.isPresent()) {
                    File testFile = maybeFile.get();
                    String normalizedName = manifest.getRelativePath(testFile);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("autobinding test case [{}:{}] to script file '{}'", new Object[]{tc.getId(), tc.getName(), normalizedName});
                    }
                    this.tcService.bindAutomatedTestAutomatically(tc.getId(), gherkinProject.getId(), normalizedName);
                } else {
                    LOGGER.trace("no script found or test case [{}:{}]", new Object[]{tc.getId(), tc.getName()});
                }
            });
        } else {
            LOGGER.debug("no automation project found, skipping", new Object[0]);
        }
    }

    private Optional<TestAutomationProject> findFirstGherkinProject(List<TestCase> tcs) {
        if (tcs.isEmpty()) {
            return Optional.empty();
        }
        TestCase tc = tcs.get(0);
        return tc.getProject().getTestAutomationProjects().stream().filter(TestAutomationProject::isCanRunGherkin).sorted(Comparator.comparing(TestAutomationProject::getLabel)).findFirst();
    }

    private Collection<Long> findTestCaseIdsByAutomationRequestIds(Collection<Long> automationRequestIds) {
        if (automationRequestIds.isEmpty()) {
            return Collections.emptyList();
        }
        QAutomationRequest automationRequest = QAutomationRequest.automationRequest;
        QTestCase testCase = QTestCase.testCase;
        return ((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select((Expression)testCase.id).from((EntityPath)automationRequest)).join((EntityPath)automationRequest.testCase, (Path)testCase)).where((Predicate)automationRequest.id.in(automationRequestIds))).fetch();
    }

    private List<TestCase> findTCCandidatesForAutoBind(Collection<Long> automationRequestIds) {
        if (automationRequestIds.isEmpty()) {
            return Collections.emptyList();
        }
        QScriptedTestCase scriptedTestCase = QScriptedTestCase.scriptedTestCase;
        QKeywordTestCase keywordTestCase = QKeywordTestCase.keywordTestCase;
        List<TestCase> result = this.findScriptedAndKeywordTCForAutoBind(scriptedTestCase, (NumberPath<Long>)scriptedTestCase.id, automationRequestIds);
        result.addAll(this.findScriptedAndKeywordTCForAutoBind(keywordTestCase, (NumberPath<Long>)keywordTestCase.id, automationRequestIds));
        return result;
    }

    private <Y extends TestCase, T extends EntityPathBase<Y>> List<TestCase> findScriptedAndKeywordTCForAutoBind(T testCaseTable, NumberPath<Long> entityPathBaseId, Collection<Long> automationRequestIds) {
        QAutomationRequest automationRequest = QAutomationRequest.automationRequest;
        QTestCase testCase = QTestCase.testCase;
        QProject project = QProject.project1;
        QTestAutomationProject automationProject = QTestAutomationProject.testAutomationProject;
        QScmRepository scm = QScmRepository.scmRepository;
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select((Expression)testCase).from((EntityPath)automationRequest)).join((EntityPath)automationRequest.testCase, (Path)testCase)).join((EntityPath)testCase.project, (Path)project)).join(testCaseTable)).on((Predicate)entityPathBaseId.eq((Expression)testCase.id))).join((CollectionExpression)project.testAutomationProjects, (Path)automationProject)).join((EntityPath)project.scmRepository, (Path)scm)).where((Predicate)automationRequest.id.in(automationRequestIds).and((Predicate)automationProject.canRunGherkin.isTrue()))).fetch();
    }
}

