/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bdd.Keyword;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.exception.CompositeDomainException;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.customfield.CustomFieldValueManagerService;
import org.squashtest.tm.service.internal.repository.KeywordTestStepDao;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.testcase.CustomTestStepModificationService;
import org.squashtest.tm.service.testcase.ParameterModificationService;

@Service(value="CustomTestStepModificationService")
@Transactional
public class CustomTestStepModificationServiceImpl
implements CustomTestStepModificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomTestStepModificationServiceImpl.class);
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private TestStepDao testStepDao;
    @Inject
    private KeywordTestStepDao keywordTestStepDao;
    @Inject
    private CustomFieldValueManagerService cufValueService;
    @Inject
    private ParameterModificationService parameterModificationService;

    @Override
    @PreAuthorize(value="hasPermission(#testStepId, 'org.squashtest.tm.domain.testcase.TestStep', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void updateKeywordTestStep(long testStepId, Keyword updatedKeyword) {
        KeywordTestStep testStep = (KeywordTestStep)this.keywordTestStepDao.getReferenceById(testStepId);
        if (updatedKeyword != null && !updatedKeyword.equals((Object)testStep.getKeyword())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("changing step #{} keyword to '{}'", new Object[]{testStepId, updatedKeyword});
            }
            testStep.setKeyword(updatedKeyword);
        }
    }

    @Override
    @CheckBlockingMilestone(entityType=TestStep.class)
    public void updateTestStep(@Id Long testStepId, String action, String expectedResult, Map<Long, RawValue> cufValues) {
        ArrayList<DomainException> exceptions = new ArrayList<DomainException>();
        TestStep step = (TestStep)this.testStepDao.findById(testStepId);
        PermissionsUtils.checkPermission(this.permissionEvaluationService, new SecurityCheckableObject(step, "WRITE"));
        this.updateCufValues(step, cufValues, exceptions);
        this.updateNonCustomFields(action, expectedResult, exceptions, step);
        this.parameterModificationService.createParamsForStep(testStepId);
        if (!exceptions.isEmpty()) {
            throw new CompositeDomainException(exceptions);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateNonCustomFields(String action, String expectedResult, List<DomainException> exceptions, TestStep step) {
        block3: {
            step.accept((TestStepVisitor)new TestStepUpdater(action, expectedResult));
            try {
                this.testStepDao.flush();
                break block3;
            }
            catch (ConstraintViolationException e) {
                CustomTestStepModificationServiceImpl.LOGGER.error(e.getMessage(), (Throwable)e);
                ** for (cv : e.getConstraintViolations())
            }
lbl-1000:
            // 1 sources

            {
                property = cv.getPropertyPath().toString();
                message = cv.getMessage();
                exceptions.add(new DomainException(message, property){

                    public String getI18nKey() {
                        return "";
                    }
                });
                continue;
            }
        }
    }

    private TestStep updateCufValues(TestStep step, Map<Long, RawValue> cufValues, List<DomainException> exceptions) {
        if (cufValues != null) {
            for (Map.Entry<Long, RawValue> cufValue : cufValues.entrySet()) {
                this.changeCufRawValue(cufValue, exceptions);
            }
        }
        return step;
    }

    private void changeCufRawValue(Map.Entry<Long, RawValue> cufValue, List<DomainException> exceptions) {
        try {
            if (cufValue.getValue() != null) {
                RawValue rValue = cufValue.getValue();
                this.cufValueService.changeValue(cufValue.getKey(), rValue);
            }
        }
        catch (DomainException e) {
            LOGGER.error(e.getMessage(), new Object[0]);
            exceptions.add(e);
        }
    }

    private static final class TestStepUpdater
    implements TestStepVisitor {
        private String expectedResult;
        private String action;

        private TestStepUpdater(String action, String expectedResult) {
            this.action = action;
            this.expectedResult = expectedResult;
        }

        public void visit(ActionTestStep visited) {
            if (this.action != null) {
                visited.setAction(this.action);
            }
            if (this.expectedResult != null) {
                visited.setExpectedResult(this.expectedResult);
            }
        }

        public void visit(CallTestStep visited) {
        }

        public void visit(KeywordTestStep visited) {
        }
    }
}

