/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.testplanretriever;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.internal.testautomation.testplanretriever.AutomatedTestBuilderService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.testautomation.testplanretriever.CustomFieldValuesForExec;

@Service
@Transactional
public class RestAutomatedSuiteManagerService<C extends CustomFieldValuesForExec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestAutomatedSuiteManagerService.class);
    @Inject
    private AutomatedSuiteDao automatedSuiteDao;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private AutomatedTestBuilderService<C> testBuilder;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private EntityPathHeaderDao pathHeaderDao;

    public Collection<Triple<IterationTestPlanItem, Map<String, Object>, Map<String, Object>>> prepareExecutionOrder(List<IterationTestPlanItem> items, Map<Long, Long> itemExecutionMap) {
        if (!this.permissionService.hasRole("ROLE_TA_API_CLIENT")) {
            throw new AccessDeniedException("Access is denied");
        }
        return this.collectAutomatedTests(items, itemExecutionMap);
    }

    public AutomatedSuite createAutomatedSuiteLinkedToIteration(Iteration iteration) {
        return this.createAutomatedSuiteLinkedToIterationAndClearSession(iteration);
    }

    public AutomatedSuite createAutomatedSuiteLinkedToTestSuite(TestSuite testSuite) {
        return this.createAutomatedSuiteLinkedToTestSuiteAndClearSession(testSuite);
    }

    private AutomatedSuite createAutomatedSuiteLinkedToIterationAndClearSession(Iteration iteration) {
        return this.automatedSuiteDao.createNewSuiteWithLinkToIteration(iteration);
    }

    private AutomatedSuite createAutomatedSuiteLinkedToTestSuiteAndClearSession(TestSuite testSuite) {
        return this.automatedSuiteDao.createNewSuiteWithLinkToTestSuite(testSuite);
    }

    private Collection<Triple<IterationTestPlanItem, Map<String, Object>, Map<String, Object>>> collectAutomatedTests(Collection<IterationTestPlanItem> items, Map<Long, Long> itemExecutionMap) {
        ArrayList<Triple<IterationTestPlanItem, Map<String, Object>, Map<String, Object>>> tests = new ArrayList<Triple<IterationTestPlanItem, Map<String, Object>, Map<String, Object>>>();
        CustomFieldValuesForExec customFieldValuesForExec = this.testBuilder.fetchCustomFieldValues(items);
        Map<Long, String> pathById = this.getTestCasePathByIds(items);
        Map<Long, Credentials> scmServerCredentialsMap = this.getScmServerCredentialsMap(items);
        for (IterationTestPlanItem item : items) {
            Credentials credentials = null;
            ScmRepository scmRepository = item.getReferencedTestCase().getScmRepository();
            if (scmRepository != null) {
                if (scmRepository.getScmServer().isCredentialsNotShared()) {
                    LOGGER.info("Do not share Git credentials for the execution environment for the SCM server : {}. Please make sure you have correctly configured Git credentials in the execution environment.", new Object[]{scmRepository.getScmServer().getFriendlyName()});
                } else {
                    credentials = scmServerCredentialsMap.get(scmRepository.getScmServer().getId());
                }
            }
            String testCasePath = pathById.get(item.getReferencedTestCase().getId());
            Long executionId = itemExecutionMap.get(item.getId());
            tests.add(this.testBuilder.createTestWithParams(item, customFieldValuesForExec, credentials, executionId, testCasePath));
        }
        return tests;
    }

    private Map<Long, String> getTestCasePathByIds(Collection<IterationTestPlanItem> items) {
        Set<Long> testCaseIds = items.stream().map(item -> item.getReferencedTestCase().getId()).collect(Collectors.toSet());
        return this.pathHeaderDao.buildTestCasePathByIds(testCaseIds);
    }

    private Map<Long, Credentials> getScmServerCredentialsMap(Collection<IterationTestPlanItem> itpis) {
        Map scmServerMap = itpis.stream().filter(item -> item.getReferencedTestCase().getScmRepository() != null).map(item -> item.getReferencedTestCase().getScmRepository().getScmServer()).collect(Collectors.toMap(ThirdPartyServer::getId, server -> server, (existing, replacement) -> existing, LinkedHashMap::new));
        HashMap<Long, Credentials> scmServerCredentialsMap = new HashMap<Long, Credentials>();
        scmServerMap.values().forEach(server -> {
            Optional<Credentials> maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)server);
            scmServerCredentialsMap.put(server.getId(), maybeCredentials.orElse(null));
        });
        return scmServerCredentialsMap;
    }
}

