/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.model.messages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.testautomation.model.messages.AdditionalConfigurationAcceptedKeys;
import org.squashtest.tm.service.internal.testautomation.model.messages.exceptions.ArrayExpectedInAdditionalConfigurationException;
import org.squashtest.tm.service.internal.testautomation.model.messages.exceptions.EmptySectionInAdditionalConfigurationException;
import org.squashtest.tm.service.internal.testautomation.model.messages.exceptions.InvalidYamlSyntaxInAdditionalConfigurationException;
import org.squashtest.tm.service.internal.testautomation.model.messages.exceptions.ObjectExpectedInAdditionalConfigurationException;
import org.squashtest.tm.service.internal.testautomation.model.messages.exceptions.UnknownKeyInAdditionalConfigurationException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public class AdditionalConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdditionalConfiguration.class);
    private Map<String, Object> defaults = new HashMap<String, Object>();
    private List<Object> hooks = new ArrayList<Object>();
    private Map<String, Object> metadata = new HashMap<String, Object>();
    private Map<String, Object> resources = new HashMap<String, Object>();
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Map<String, Object> strategy = new HashMap<String, Object>();

    public AdditionalConfiguration(String additionalConfiguration) {
        Yaml yaml = new Yaml();
        try {
            Map additionalConfigurationMap = (Map)yaml.load(additionalConfiguration);
            this.ifContainsAnUnknownKeyThrowException(additionalConfigurationMap);
            this.setAttributes(additionalConfigurationMap);
        }
        catch (ClassCastException | MarkedYAMLException ex) {
            LOGGER.error(ex.getMessage(), ex);
            InvalidYamlSyntaxInAdditionalConfigurationException invalidYamlException = new InvalidYamlSyntaxInAdditionalConfigurationException();
            invalidYamlException.addArg(additionalConfiguration);
            throw invalidYamlException;
        }
    }

    private void ifContainsAnUnknownKeyThrowException(Map<String, Object> additionalConfigurationMap) {
        ArrayList<String> acceptedKeys = new ArrayList<String>();
        AdditionalConfigurationAcceptedKeys[] additionalConfigurationAcceptedKeysArray = AdditionalConfigurationAcceptedKeys.values();
        int n = additionalConfigurationAcceptedKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            AdditionalConfigurationAcceptedKeys key2 = additionalConfigurationAcceptedKeysArray[n2];
            acceptedKeys.add(key2.getKeyName());
            ++n2;
        }
        String unknownKey = additionalConfigurationMap.keySet().stream().filter(key -> !acceptedKeys.contains(key)).findFirst().orElse(null);
        if (unknownKey != null) {
            UnknownKeyInAdditionalConfigurationException unknownKeyException = new UnknownKeyInAdditionalConfigurationException();
            unknownKeyException.addArg(unknownKey);
            throw unknownKeyException;
        }
    }

    private void setAttributes(Map<String, Object> additionalConfigurationMap) {
        String defaultsKey = AdditionalConfigurationAcceptedKeys.DEFAULTS.getKeyName();
        String hooksKey = AdditionalConfigurationAcceptedKeys.HOOKS.getKeyName();
        String metadataKey = AdditionalConfigurationAcceptedKeys.METADATA.getKeyName();
        String resourcesKey = AdditionalConfigurationAcceptedKeys.RESOURCES.getKeyName();
        String variablesKey = AdditionalConfigurationAcceptedKeys.VARIABLES.getKeyName();
        String strategyKey = AdditionalConfigurationAcceptedKeys.STRATEGY.getKeyName();
        if (additionalConfigurationMap.containsKey(defaultsKey)) {
            this.setDefaults(this.buildMap(defaultsKey, additionalConfigurationMap.get(defaultsKey)));
        }
        if (additionalConfigurationMap.containsKey(hooksKey)) {
            this.setHooks(this.buildList(hooksKey, additionalConfigurationMap.get(hooksKey)));
        }
        if (additionalConfigurationMap.containsKey(metadataKey)) {
            this.setMetadata(this.buildMap(metadataKey, additionalConfigurationMap.get(metadataKey)));
        }
        if (additionalConfigurationMap.containsKey(resourcesKey)) {
            this.setResources(this.buildMap(resourcesKey, additionalConfigurationMap.get(resourcesKey)));
        }
        if (additionalConfigurationMap.containsKey(variablesKey)) {
            this.setVariables(this.buildMap(variablesKey, additionalConfigurationMap.get(variablesKey)));
        }
        if (additionalConfigurationMap.containsKey(strategyKey)) {
            this.setStrategy(this.buildMap(strategyKey, additionalConfigurationMap.get(strategyKey)));
        }
    }

    private Map<String, Object> buildMap(String key, Object conf) {
        if (conf == null) {
            EmptySectionInAdditionalConfigurationException emptySectionException = new EmptySectionInAdditionalConfigurationException();
            emptySectionException.addArg(key);
            throw emptySectionException;
        }
        if (conf instanceof Map) {
            return (Map)conf;
        }
        ObjectExpectedInAdditionalConfigurationException invalidObjectException = new ObjectExpectedInAdditionalConfigurationException();
        invalidObjectException.addArg(key);
        invalidObjectException.addArg(conf.toString());
        throw invalidObjectException;
    }

    private List<Object> buildList(String key, Object conf) {
        if (conf == null) {
            EmptySectionInAdditionalConfigurationException emptySectionException = new EmptySectionInAdditionalConfigurationException();
            emptySectionException.addArg(key);
            throw emptySectionException;
        }
        if (conf instanceof List) {
            return (List)conf;
        }
        ArrayExpectedInAdditionalConfigurationException invalidArrayException = new ArrayExpectedInAdditionalConfigurationException();
        invalidArrayException.addArg(key);
        invalidArrayException.addArg(conf.toString());
        throw invalidArrayException;
    }

    public Map<String, Object> getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Map<String, Object> defaults) {
        this.defaults = defaults;
    }

    public List<Object> getHooks() {
        return this.hooks;
    }

    public void setHooks(List<Object> hooks) {
        this.hooks = hooks;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public Map<String, Object> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, Object> resources) {
        this.resources = resources;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Object> getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Map<String, Object> strategy) {
        this.strategy = strategy;
    }
}

