/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTag;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTagHolder;
import org.squashtest.tm.domain.environmentvariable.EVBindableEntity;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingService;
import org.squashtest.tm.service.internal.repository.TestAutomationProjectDao;
import org.squashtest.tm.service.internal.repository.TestAutomationServerDao;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;

@Transactional
@Service(value="squashtest.tm.service.TestAutomationServerManagementService")
public class TestAutomationServerManagerServiceImpl
implements TestAutomationServerManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationServerManagerServiceImpl.class);
    private final TestAutomationServerDao serverDao;
    private final TestAutomationProjectDao projectDao;
    private final StoredCredentialsManager storedCredentialsManager;
    private final EnvironmentVariableBindingService environmentVariableBindingService;

    public TestAutomationServerManagerServiceImpl(TestAutomationServerDao serverDao, TestAutomationProjectDao projectDao, StoredCredentialsManager storedCredentialsManager, EnvironmentVariableBindingService environmentVariableBindingService) {
        this.serverDao = serverDao;
        this.projectDao = projectDao;
        this.storedCredentialsManager = storedCredentialsManager;
        this.environmentVariableBindingService = environmentVariableBindingService;
    }

    @Override
    public TestAutomationServer findById(long serverId) {
        return (TestAutomationServer)this.serverDao.getReferenceById(serverId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void persist(TestAutomationServer server) {
        TestAutomationServer nameInUse = this.serverDao.findByName(server.getName());
        if (nameInUse != null) {
            throw new NameAlreadyInUseException(TestAutomationServer.class.getSimpleName(), server.getName());
        }
        server.setAuthenticationPolicy(AuthenticationPolicy.APP_LEVEL);
        switch (server.getKind()) {
            case squashOrchestrator: {
                server.setAuthenticationProtocol(AuthenticationProtocol.TOKEN_AUTH);
                break;
            }
            default: {
                server.setAuthenticationProtocol(AuthenticationProtocol.BASIC_AUTH);
            }
        }
        this.serverDao.save(server);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteServers(List<Long> serverIds) {
        this.storedCredentialsManager.deleteAllServerCredentials(serverIds);
        for (Long id : serverIds) {
            this.environmentVariableBindingService.unbindAllByEntityIdAndType(id, EVBindableEntity.TEST_AUTOMATION_SERVER);
            this.projectDao.deleteAllHostedProjects(id);
            this.serverDao.deleteServer(id);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<TestAutomationServer> findSortedTestAutomationServers(Pageable pageable) {
        return this.serverDao.findAll(pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeURL(long serverId, URL url) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.getReferenceById(serverId);
        server.setUrl(url.toExternalForm());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeName(long serverId, String newName) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.getReferenceById(serverId);
        if (newName.equals(server.getName())) {
            return;
        }
        TestAutomationServer alreadyExists = this.serverDao.findByName(newName);
        if (alreadyExists != null) {
            throw new NameAlreadyInUseException(TestAutomationServer.class.getSimpleName(), newName);
        }
        server.setName(newName);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeDescription(long serverId, String description) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.getReferenceById(serverId);
        server.setDescription(description);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeManualSlaveSelection(long serverId, boolean manualSlaveSelection) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.getReferenceById(serverId);
        server.setManualSlaveSelection(manualSlaveSelection);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void updateEnvironmentTags(long serverId, List<String> tags) {
        Optional maybeServer = this.serverDao.findById(serverId);
        if (maybeServer.isPresent()) {
            TestAutomationServer server = (TestAutomationServer)maybeServer.get();
            server.getEnvironmentTags().clear();
            if (Objects.nonNull(tags) && !tags.isEmpty()) {
                server.setEnvironmentTags(tags.stream().map(tag -> new AutomationEnvironmentTag(tag, AutomationEnvironmentTagHolder.TEST_AUTOMATION_SERVER)).toList());
            }
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void clearEnvironmentTags(long serverId) {
        this.updateEnvironmentTags(serverId, Collections.emptyList());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeObserverURL(long serverId, URL url) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.findById(serverId).orElseThrow();
        server.setObserverUrl(url.toExternalForm());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void clearObserverURL(long serverId) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.findById(serverId).orElseThrow();
        server.setObserverUrl(null);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeEventBusURL(long serverId, URL url) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.findById(serverId).orElseThrow();
        server.setEventBusUrl(url.toExternalForm());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void clearEventBusURL(long serverId) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.findById(serverId).orElseThrow();
        server.setEventBusUrl(null);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeAdditionalConfiguration(long serverId, String additionalConfiguration) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.findById(serverId).orElseThrow();
        server.setAdditionalConfiguration(additionalConfiguration);
    }

    @Override
    public boolean isAdditionalConfigurationValid(String additionalConfiguration) {
        YAMLMapper yamlMapper = new YAMLMapper();
        try {
            yamlMapper.readTree(additionalConfiguration);
            return true;
        }
        catch (Exception e) {
            LOGGER.info("Invalid yaml syntax.", (Throwable)e);
            return false;
        }
    }

    @Override
    public void forceAuditAfterCredentialsUpdated(long serverId) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.findById(serverId).orElseThrow();
        server.setLastModifiedOn(new Date());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeKillSwitchURL(long serverId, URL url) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.findById(serverId).orElseThrow();
        server.setKillswitchUrl(url.toExternalForm());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void clearKillSwitchURL(long serverId) {
        TestAutomationServer server = (TestAutomationServer)this.serverDao.findById(serverId).orElseThrow();
        server.setKillswitchUrl(null);
    }
}

