/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Table;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.jooq.domain.tables.ItemTestPlanExecution;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentTagManagerService;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentVariableManagerService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.repository.AutomatedTestDao;
import org.squashtest.tm.service.internal.repository.CustomTestAutomationServerDao;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.internal.testautomation.AutomatedSuiteManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.testautomation.AutomatedSuiteManagerServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.testautomation.AutomatedSuiteManagerServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.testautomation.AutomatedSuiteManagerServiceImpl$AjcClosure7;
import org.squashtest.tm.service.internal.testautomation.AutomatedSuiteStartService;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorRegistry;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.orchestrator.model.OrchestratorResponse;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;
import org.squashtest.tm.service.testautomation.AutomationDeletionCount;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteCreationSpecification;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteWithSquashAutomAutomatedITPIs;
import org.squashtest.tm.service.testautomation.model.EnvironmentVariableValue;
import org.squashtest.tm.service.testautomation.model.SquashAutomExecutionConfiguration;
import org.squashtest.tm.service.testautomation.model.SuiteExecutionConfiguration;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.supervision.AutomatedExecutionViewUtils;
import org.squashtest.tm.service.testautomation.supervision.model.AutomatedSuiteOverview;

@Transactional
@Service(value="squashtest.tm.service.AutomatedSuiteManagementService")
public class AutomatedSuiteManagerServiceImpl
implements AutomatedSuiteManagerService {
    private static final String EXECUTE = "EXECUTE";
    private static final Logger LOGGER;
    public static final int BIND_VARIABLES_LIMIT = 500;
    @Inject
    private AutomatedSuiteDao autoSuiteDao;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private TestSuiteDao testSuiteDao;
    @Inject
    private IterationTestPlanDao testPlanDao;
    @Inject
    private ExecutionDao executionDao;
    @Inject
    private PrivateDenormalizedFieldValueService denormalizedFieldValueService;
    @Inject
    private TestAutomationConnectorRegistry connectorRegistry;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private CampaignNodeDeletionHandler deletionHandler;
    @Inject
    private PrivateCustomFieldValueService customFieldValuesService;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private CustomTestAutomationServerDao testAutomationServerDao;
    @Inject
    private GenericProjectDao genericProjectDao;
    @Inject
    private AutomatedTestDao autoTestDao;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dslContext;
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseService;
    @Inject
    private DenormalizedEnvironmentVariableManagerService denormalizedEnvironmentVariableManagerService;
    @Inject
    private DenormalizedEnvironmentTagManagerService denormalizedEnvironmentTagManagerService;
    @Inject
    private CustomTestSuiteModificationService customTestSuiteModificationService;
    @Inject
    private AutomatedSuiteStartService automatedSuiteStartService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        AutomatedSuiteManagerServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(AutomatedSuiteManagerServiceImpl.class);
    }

    @Override
    public AutomatedSuite findById(String id) {
        return this.autoSuiteDao.findById(id);
    }

    @Override
    public boolean stopWorkflows(String suiteId, List<String> workflows) {
        ArrayList errors = new ArrayList();
        workflows.forEach(workflow -> {
            LOGGER.info("Stopping workflow {} for suite {}", new Object[]{workflow, suiteId});
            AutomatedSuiteWorkflow automatedSuiteWorkflow = this.autoSuiteDao.getAutomatedSuiteWorkflowByWorkflowId((String)workflow);
            if (automatedSuiteWorkflow == null) {
                LOGGER.info("No running workflow {} for suite {}", new Object[]{workflow, suiteId});
                return;
            }
            this.stopWorkflow(suiteId, (String)workflow, automatedSuiteWorkflow, errors);
        });
        return errors.contains(true);
    }

    private void stopWorkflow(String suiteId, String workflow, AutomatedSuiteWorkflow automatedSuiteWorkflow, List<Boolean> errors) {
        Long projectId = automatedSuiteWorkflow.getProjectId();
        TestAutomationServer server = this.genericProjectDao.findTestAutomationServer(projectId);
        if (server == null) {
            LOGGER.error("No test automation server found for project with id: {}", new Object[]{projectId});
            errors.add(true);
            return;
        }
        TestAutomationConnector connector = this.connectorRegistry.getConnectorForKind(server.getKind());
        TokenAuthCredentials credentials = this.credentialsProvider.getProjectLevelCredentials(server.getId(), projectId).orElse(null);
        try {
            OrchestratorResponse<Void> response = connector.killWorkflow(server, projectId, credentials, workflow);
            if (response.isReachable()) {
                AutomatedSuite suite = (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)suiteId);
                suite.getWorkflows().removeIf(work -> work.getWorkflowId().equals(workflow));
                this.computeNewTestSuiteStatus(suite);
            } else {
                LOGGER.error("Orchestrator unreachable. Cannot stop workflow {} for suite {}", new Object[]{workflow, suiteId});
                errors.add(true);
            }
        }
        catch (TestAutomationException ex) {
            LOGGER.error("An error occurred while stopping workflow {} for suite {}", new Object[]{workflow, suiteId});
            LOGGER.trace("Error stacktrace: ", (Throwable)((Object)ex));
            errors.add(true);
        }
    }

    private void computeNewTestSuiteStatus(AutomatedSuite suite) {
        TestSuite testSuite = suite.getTestSuite();
        if (testSuite != null) {
            this.customTestSuiteModificationService.updateExecutionStatus(List.of(testSuite));
        }
    }

    private void processAutomatedSuitesDeletion(List<String> automatedSuiteIds) {
        List<String> list = automatedSuiteIds;
        ExecutionDao executionDao = this.executionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)executionDao, list);
        Object[] objectArray = new Object[]{this, executionDao, list, joinPoint};
        AutomatedSuiteManagerServiceImpl$AjcClosure1 automatedSuiteManagerServiceImpl$AjcClosure1 = new AutomatedSuiteManagerServiceImpl$AjcClosure1(objectArray);
        List executionIds = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(automatedSuiteManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        if (!executionIds.isEmpty()) {
            this.deletionHandler.bulkDeleteExecutions(executionIds);
        }
        List<Long> attachmentListIds = this.autoSuiteDao.findAttachmentListIdsByIds(automatedSuiteIds);
        List<ExternalContentCoordinates> externalContentCoordinates = this.attachmentManagerService.getListPairContentIDListIDForAutomatedSuiteIds(automatedSuiteIds);
        this.autoSuiteDao.deleteAutomatedSuiteWorkflowsBySuiteIds(automatedSuiteIds);
        this.autoSuiteDao.deleteAllByIds(automatedSuiteIds);
        this.autoTestDao.pruneOrphans();
        this.attachmentManagerService.removeAttachmentsAndLists(attachmentListIds);
        this.attachmentManagerService.deleteContents(externalContentCoordinates);
    }

    @Override
    public void deleteAutomatedSuites(List<String> automatedSuiteIds) {
        this.processAutomatedSuitesDeletion(automatedSuiteIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public AutomationDeletionCount countOldAutomatedSuitesAndExecutions() {
        return this.autoSuiteDao.countOldAutomatedSuitesAndExecutions();
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public AutomationDeletionCount countOldAutomatedSuitesAndExecutionsForProject(Long projectId) {
        return this.autoSuiteDao.countOldAutomatedSuitesAndExecutionsByProjectId(projectId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void cleanOldSuites() {
        this.cleanAutomatedSuites(this.autoSuiteDao.getOldAutomatedSuiteIds());
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void cleanOldSuitesForProject(Long projectId) {
        this.cleanAutomatedSuites(this.autoSuiteDao.getOldAutomatedSuiteIdsByProjectId(projectId));
    }

    private void cleanAutomatedSuites(List<String> oldAutomatedSuiteIds) {
        if (oldAutomatedSuiteIds.isEmpty()) {
            return;
        }
        List automatedSuiteIdPartitions = Lists.partition(oldAutomatedSuiteIds, (int)500);
        automatedSuiteIdPartitions.forEach(automatedSuiteIdPartition -> {
            this.processAutomatedSuitesDeletion((List<String>)automatedSuiteIdPartition);
            this.entityManager.flush();
            this.entityManager.clear();
        });
    }

    @Override
    @BatchPreventConcurrent(entityType=IterationTestPlanItem.class)
    public AutomatedSuiteOverview createAndExecute(AutomatedSuiteCreationSpecification specification, @Ids List<Long> itemTestPlanIds) {
        if (this.ultimateLicenseService.isAvailable()) {
            this.setSquashAutomOrchestratorAdditionalConfiguration(specification);
        }
        LOGGER.debug("Start creating executions: {}", new Object[]{new Date()});
        AutomatedSuiteWithSquashAutomAutomatedITPIs suiteWithAutomItpis = this.createFromSpecification(specification, itemTestPlanIds);
        LOGGER.debug("End creating executions: {}", new Object[]{new Date()});
        LOGGER.debug("Start sending executions: {}", new Object[]{new Date()});
        this.automatedSuiteStartService.start(suiteWithAutomItpis, specification.getExecutionConfigurations(), specification.getSquashAutomExecutionConfigurations());
        LOGGER.debug("End sending executions: {}", new Object[]{new Date()});
        LOGGER.debug("Start creating automated suite overview: {}", new Object[]{new Date()});
        AutomatedSuiteOverview automatedSuiteOverview = AutomatedExecutionViewUtils.buildFirstAutomatedSuiteOverview(suiteWithAutomItpis);
        LOGGER.debug("End creating automated suite overview: {}", new Object[]{new Date()});
        AutomatedSuiteManagerServiceImpl.setMessages(suiteWithAutomItpis, automatedSuiteOverview);
        return automatedSuiteOverview;
    }

    private static void setMessages(AutomatedSuiteWithSquashAutomAutomatedITPIs suiteWithAutomItpis, AutomatedSuiteOverview automatedSuiteOverview) {
        if (suiteWithAutomItpis.getErrorMessage() != null) {
            automatedSuiteOverview.setErrorMessage(suiteWithAutomItpis.getErrorMessage());
        } else if (suiteWithAutomItpis.getWorkflowsUUIDs() != null && !suiteWithAutomItpis.getWorkflowsUUIDs().isEmpty()) {
            automatedSuiteOverview.setWorkflowsUUIDs(suiteWithAutomItpis.getWorkflowsUUIDs());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    @BatchPreventConcurrent(entityType=IterationTestPlanItem.class)
    public AutomatedSuite createFromIterationTestPlan(long iterationId, @Ids List<Long> testPlanIds) {
        Long projectId = this.iterationDao.getProjectId(iterationId);
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        List<Long> squashTFAutomatedItems = this.extractSquashTFAutomatedItems(testPlanIds);
        String newSuiteId = this.createSuiteAndClearSession(iteration);
        this.createSquashTFExecutions(squashTFAutomatedItems, newSuiteId, projectId);
        return (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)newSuiteId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    @BatchPreventConcurrent(entityType=IterationTestPlanItem.class)
    public AutomatedSuite createFromTestSuiteTestPlan(long testSuiteId, @Ids List<Long> testPlanIds) {
        Long projectId = this.testSuiteDao.getProjectId(testSuiteId);
        List<Long> squashTFAutomatedItems = this.extractSquashTFAutomatedItems(testPlanIds);
        TestSuite testSuite = (TestSuite)this.testSuiteDao.findById(testSuiteId).orElseThrow();
        String suiteId = this.createSuiteAndClearSession(testSuite);
        this.createSquashTFExecutions(squashTFAutomatedItems, suiteId, projectId);
        return (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)suiteId);
    }

    @Override
    @BatchPreventConcurrent(entityType=IterationTestPlanItem.class)
    public AutomatedSuite createFromItemsAndIteration(@Ids List<Long> testPlanIds, long iterationId) {
        PermissionsUtils.checkPermission(this.permissionService, testPlanIds, EXECUTE, IterationTestPlanItem.class.getName());
        List<Long> list = testPlanIds;
        IterationTestPlanDao iterationTestPlanDao = this.testPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        AutomatedSuiteManagerServiceImpl$AjcClosure3 automatedSuiteManagerServiceImpl$AjcClosure3 = new AutomatedSuiteManagerServiceImpl$AjcClosure3(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(automatedSuiteManagerServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
        Long projectId = this.iterationDao.getProjectId(iterationId);
        return this.createSuite(items, projectId);
    }

    private AutomatedSuite createSuite(List<Long> items, Long projectId) {
        List<Long> squashTFAutomatedItems = this.extractSquashTFAutomatedItems(items);
        String newSuiteId = this.createSuiteAndClearSession();
        this.createSquashTFExecutions(squashTFAutomatedItems, newSuiteId, projectId);
        return (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)newSuiteId);
    }

    private AutomatedSuiteWithSquashAutomAutomatedITPIs createFromSpecification(AutomatedSuiteCreationSpecification specification, List<Long> itemTestPlanIds) {
        specification.validate();
        this.checkPermission(specification);
        Long contextId = specification.getContext().getId();
        Collection<SquashAutomExecutionConfiguration> orchestratorConfigurations = specification.getSquashAutomExecutionConfigurations();
        EntityType entityType = specification.getContext().getType();
        return this.createAutomatedSuite(contextId, orchestratorConfigurations, entityType, itemTestPlanIds);
    }

    private AutomatedSuiteWithSquashAutomAutomatedITPIs createAutomatedSuite(Long entityId, Collection<SquashAutomExecutionConfiguration> orchestratorConfigurations, EntityType entityType, List<Long> itemIds) {
        Long projectId = this.findProjectId(entityType, entityId);
        List<Long> squashTFAutomatedItems = this.extractSquashTFAutomatedItems(itemIds);
        List<Long> squashOrchestratorAutomatedItems = this.extractSquashOrchestratorAutomatedItems(itemIds);
        String suiteId = this.createSuiteAndClearSession(entityId, entityType);
        Map<Long, Long> orchestratorItemExecutionMap = this.createAutomatedExecutions(suiteId, squashTFAutomatedItems, squashOrchestratorAutomatedItems, orchestratorConfigurations, projectId);
        return this.createAutomatedSuiteWithSquashAutomAutomatedITPIs(suiteId, orchestratorItemExecutionMap);
    }

    private Map<Long, Long> createAutomatedExecutions(String suiteId, List<Long> squashTFAutomatedItems, List<Long> squashOrchestratorAutomatedItems, Collection<SquashAutomExecutionConfiguration> orchestratorConfigurations, Long projectId) {
        this.createSquashTFExecutions(squashTFAutomatedItems, suiteId, projectId);
        return this.createSquashOrchestratorExecutions(squashOrchestratorAutomatedItems, suiteId, orchestratorConfigurations, projectId);
    }

    private Long findProjectId(EntityType entityType, Long entityId) {
        if (EntityType.ITERATION.equals((Object)entityType)) {
            return this.iterationDao.getProjectId(entityId);
        }
        return this.testSuiteDao.getProjectId(entityId);
    }

    private String createSuiteAndClearSession(Long entityId, EntityType entityType) {
        if (EntityType.ITERATION.equals((Object)entityType)) {
            return this.createSuiteAndClearSession((Iteration)this.iterationDao.findById(entityId));
        }
        return this.createSuiteAndClearSession((TestSuite)this.testSuiteDao.findById(entityId).orElseThrow());
    }

    private AutomatedSuiteWithSquashAutomAutomatedITPIs createAutomatedSuiteWithSquashAutomAutomatedITPIs(String automatedSuiteId, Map<Long, Long> orchestratorItemExecutionMap) {
        AutomatedSuite suite = (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)automatedSuiteId);
        List items = this.testPlanDao.fetchWithServerByIds(orchestratorItemExecutionMap.keySet());
        AutomatedSuiteWithSquashAutomAutomatedITPIs automatedSuiteWithSquashAutomAutomatedITPIs = new AutomatedSuiteWithSquashAutomAutomatedITPIs(suite, items);
        automatedSuiteWithSquashAutomAutomatedITPIs.setItemExecutionMap(orchestratorItemExecutionMap);
        return automatedSuiteWithSquashAutomAutomatedITPIs;
    }

    private void checkPermission(AutomatedSuiteCreationSpecification specification) {
        ArrayList<Long> singleId = new ArrayList<Long>();
        singleId.add(specification.getContext().getId());
        Class clazz = specification.getContext().getType() == EntityType.ITERATION ? Iteration.class : TestSuite.class;
        PermissionsUtils.checkPermission(this.permissionService, singleId, EXECUTE, clazz.getName());
    }

    @Override
    public void start(AutomatedSuite suite) {
        this.automatedSuiteStartService.start(suite, new ArrayList<SuiteExecutionConfiguration>());
    }

    private void createSquashTFExecutions(List<Long> itemIds, String newSuiteId, Long projectId) {
        if (itemIds.isEmpty()) {
            return;
        }
        HibernateConfig.enableBatch(this.entityManager, 20);
        List partitionedIds = Lists.partition(itemIds, (int)20);
        Project project = this.projectDao.fetchForAutomatedExecutionCreation(projectId);
        for (List ids : partitionedIds) {
            ArrayList<Execution> executions = new ArrayList<Execution>();
            Map<Long, Long> itemExecutionMap = this.createOneBatchOfSquashTFExecution(ids, newSuiteId, executions);
            this.entityManager.flush();
            this.entityManager.clear();
            this.insertBatchItemTestPlanExecutionLink(itemExecutionMap);
            this.addExternalFields(executions, project);
        }
    }

    private void addExternalFields(List<Execution> executions, Project project) {
        this.customFieldValuesService.createAllCustomFieldValues(executions, project);
        List steps = executions.stream().flatMap(exec -> exec.getSteps().stream()).toList();
        this.customFieldValuesService.createAllCustomFieldValues(steps, project);
        Map<Long, List<DenormalizedFieldHolder>> map = executions.stream().map(DenormalizedFieldHolder.class::cast).collect(Collectors.groupingBy(holder -> ((Execution)holder).getReferencedTestCase().getId()));
        this.denormalizedFieldValueService.createBatchDenormalizedFieldValues(map, BindableEntity.TEST_CASE);
        this.denormalizedFieldValueService.createAllDenormalizedFieldValuesForSteps(executions);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private Map<Long, Long> createSquashOrchestratorExecutions(List<Long> itemIds, String newSuiteId, Collection<SquashAutomExecutionConfiguration> configurations, Long projectId) {
        if (itemIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HibernateConfig.enableBatch(this.entityManager, 20);
        List partitionedIds = Lists.partition(itemIds, (int)20);
        HashMap<Long, Long> itemExecutionMap = new HashMap<Long, Long>();
        Project project = this.projectDao.fetchForAutomatedExecutionCreation(projectId);
        for (List ids : partitionedIds) {
            itemExecutionMap.putAll(this.createOneBatchOfSquashOrchestratorExecutions(ids, newSuiteId, configurations, project));
        }
        return itemExecutionMap;
    }

    private Map<Long, Long> createOneBatchOfSquashOrchestratorExecutions(List<Long> ids, String newSuiteId, Collection<SquashAutomExecutionConfiguration> configurations, Project project) {
        AutomatedSuite automatedSuite = (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)newSuiteId);
        List<Long> list = ids;
        IterationTestPlanDao iterationTestPlanDao = this.testPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        AutomatedSuiteManagerServiceImpl$AjcClosure5 automatedSuiteManagerServiceImpl$AjcClosure5 = new AutomatedSuiteManagerServiceImpl$AjcClosure5(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(automatedSuiteManagerServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
        HashMap<Long, Long> itemExecutionMap = new HashMap<Long, Long>();
        ArrayList<Execution> createdExecution = new ArrayList<Execution>();
        items.forEach(item -> this.createAutomatedExecution(configurations, (IterationTestPlanItem)item, (Map<Long, Long>)itemExecutionMap, automatedSuite, (List<Execution>)createdExecution));
        this.entityManager.flush();
        this.entityManager.clear();
        this.insertBatchItemTestPlanExecutionLink(itemExecutionMap);
        this.addExternalFields(createdExecution, project);
        return itemExecutionMap;
    }

    private void insertBatchItemTestPlanExecutionLink(Map<Long, Long> itemExecutionMap) {
        Map nextItemExecutionOrderMap = this.testPlanDao.getNextTestPlanExecutionOrders(itemExecutionMap.keySet());
        ArrayList inserts = new ArrayList();
        itemExecutionMap.forEach((itemId, executionId) -> {
            Integer executionOrder = (Integer)nextItemExecutionOrderMap.get(itemId);
            if (executionOrder != null) {
                inserts.add(this.dslContext.insertInto((Table)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION).set((Field)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID, itemId).set((Field)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID, executionId).set((Field)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER, (Object)executionOrder));
            }
        });
        this.dslContext.batch(inserts).execute();
    }

    private void createAutomatedExecution(Collection<SquashAutomExecutionConfiguration> configurations, IterationTestPlanItem item, Map<Long, Long> itemExecutionMap, AutomatedSuite automatedSuite, List<Execution> createdExecutions) {
        if (!item.isAutomated()) {
            return;
        }
        Execution execution = item.createExecution(null, null);
        AutomatedExecutionExtender extender = new AutomatedExecutionExtender();
        extender.setExecution(execution);
        execution.setAutomatedExecutionExtender(extender);
        this.saveAutomatedExecution(item, execution);
        itemExecutionMap.put(item.getId(), execution.getId());
        automatedSuite.addExtender(extender);
        createdExecutions.add(execution);
        TestCase testCase = item.getReferencedTestCase();
        SquashAutomExecutionConfiguration configuration = configurations.stream().filter(conf -> conf.getProjectId().equals(item.getReferencedTestCase().getProject().getId())).findAny().orElseThrow();
        AutomatedTestTechnology technology = testCase.getAutomatedTestTechnology();
        if (Objects.nonNull(technology)) {
            extender.setTestTechnology(technology.getName());
        }
        this.createDenormalizedEnvironmentTagsForAutomatedExecution(configuration.getEnvironmentTags(), technology, extender);
        this.createDenormalizedEnvironmentVariablesForAutomatedExecution(configuration.getEnvironmentVariables(), extender);
    }

    private void saveAutomatedExecution(IterationTestPlanItem item, Execution execution) {
        this.executionDao.save(execution);
        item.notifyAutomatedExecutionAddition(execution);
    }

    private String createSuiteAndClearSession() {
        AutomatedSuite newSuite = this.autoSuiteDao.createNewSuite();
        this.entityManager.flush();
        String newSuiteId = newSuite.getId();
        this.entityManager.clear();
        return newSuiteId;
    }

    private String createSuiteAndClearSession(Iteration iteration) {
        AutomatedSuite newSuite = this.autoSuiteDao.createNewSuite(iteration);
        this.entityManager.flush();
        String newSuiteId = newSuite.getId();
        this.entityManager.clear();
        return newSuiteId;
    }

    private String createSuiteAndClearSession(TestSuite testSuite) {
        AutomatedSuite newSuite = this.autoSuiteDao.createNewSuite(testSuite);
        this.entityManager.flush();
        String newSuiteId = newSuite.getId();
        this.entityManager.clear();
        return newSuiteId;
    }

    private Map<Long, Long> createOneBatchOfSquashTFExecution(List<Long> ids, String newSuiteId, List<Execution> executions) {
        AutomatedSuite automatedSuite = (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)newSuiteId);
        List<Long> list = ids;
        IterationTestPlanDao iterationTestPlanDao = this.testPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        AutomatedSuiteManagerServiceImpl$AjcClosure7 automatedSuiteManagerServiceImpl$AjcClosure7 = new AutomatedSuiteManagerServiceImpl$AjcClosure7(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(automatedSuiteManagerServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112));
        HashMap<Long, Long> itemExecutionMap = new HashMap<Long, Long>();
        for (IterationTestPlanItem item : items) {
            if (!item.isAutomated()) continue;
            Execution execution = item.createAutomatedExecution();
            this.saveAutomatedExecution(item, execution);
            automatedSuite.addExtender(execution.getAutomatedExecutionExtender());
            executions.add(execution);
            itemExecutionMap.put(item.getId(), execution.getId());
        }
        return itemExecutionMap;
    }

    private void createDenormalizedEnvironmentVariablesForAutomatedExecution(Map<String, EnvironmentVariableValue> environmentVariables, AutomatedExecutionExtender extender) {
        if (Objects.nonNull(environmentVariables) && !environmentVariables.isEmpty()) {
            HashMap<String, String> variables = new HashMap<String, String>();
            environmentVariables.forEach((key, value) -> {
                String string = variables.put((String)key, value.getValue());
            });
            this.denormalizedEnvironmentVariableManagerService.createAllDenormalizedEnvironmentVariablesForAutomatedExecution(variables, extender);
        }
    }

    private void createDenormalizedEnvironmentTagsForAutomatedExecution(List<String> environmentTags, AutomatedTestTechnology testTechnology, AutomatedExecutionExtender extender) {
        String testTechnologyPrefix;
        if (Objects.isNull(environmentTags)) {
            return;
        }
        ArrayList<String> tags = new ArrayList<String>(environmentTags);
        String technologyKey = testTechnology.getActionProviderKey();
        if (Objects.nonNull(technologyKey) && !technologyKey.isEmpty() && environmentTags.contains(testTechnologyPrefix = this.extractTechnologyPrefix(technologyKey))) {
            tags.remove(testTechnologyPrefix);
        }
        this.denormalizedEnvironmentTagManagerService.createAllDenormalizedEnvironmentTagsForAutomatedExecution(tags, extender);
    }

    private String extractTechnologyPrefix(String technologyKey) {
        return technologyKey.split("/")[0];
    }

    @Override
    public void pruneAutomatedSuites(List<String> automatedSuiteIds, boolean complete) {
        Map<Long, Long> map = this.autoSuiteDao.getAutomatedExecutionIdsWithAttachmentListIds(automatedSuiteIds, complete);
        List<Long> executionIds = map.keySet().stream().toList();
        List<ExternalContentCoordinates> externalContentCoordinates = this.attachmentManagerService.getListPairContentIDListIDForExecutionIds(executionIds);
        List<Long> attachmentLists = map.values().stream().toList();
        this.attachmentManagerService.removeAttachmentsAndContents(attachmentLists, externalContentCoordinates);
    }

    @Override
    public void pruneAttachments(Long projectId, boolean complete) {
        this.pruneAutomatedSuites(this.autoSuiteDao.getOldAutomatedSuiteIdsByProjectId(projectId), complete);
    }

    private List<Long> extractSquashOrchestratorAutomatedItems(List<Long> items) {
        return this.testPlanDao.filterSquashOrchestratorItemIds(items);
    }

    private List<Long> extractSquashTFAutomatedItems(List<Long> itemIds) {
        return this.testPlanDao.filterSquashTfItemIds(itemIds);
    }

    private void setSquashAutomOrchestratorAdditionalConfiguration(AutomatedSuiteCreationSpecification specification) {
        for (SquashAutomExecutionConfiguration additionalConfiguration : specification.getSquashAutomExecutionConfigurations()) {
            additionalConfiguration.setAdditionalConfiguration(this.testAutomationServerDao.getAdditionalConfigurationByProjectId(additionalConfiguration.getProjectId()));
        }
    }

    static final /* synthetic */ List findAllIdsByAutomatedSuiteIds_aroundBody0(AutomatedSuiteManagerServiceImpl automatedSuiteManagerServiceImpl, ExecutionDao executionDao, List list, JoinPoint joinPoint) {
        return executionDao.findAllIdsByAutomatedSuiteIds(list);
    }

    static final /* synthetic */ List findAllByIdsOrderedByIterationTestPlan_aroundBody2(AutomatedSuiteManagerServiceImpl automatedSuiteManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, List list, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdsOrderedByIterationTestPlan(list);
    }

    static final /* synthetic */ List fetchForAutomatedExecutionCreation_aroundBody4(AutomatedSuiteManagerServiceImpl automatedSuiteManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.fetchForAutomatedExecutionCreation(collection);
    }

    static final /* synthetic */ List fetchForAutomatedExecutionCreation_aroundBody6(AutomatedSuiteManagerServiceImpl automatedSuiteManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.fetchForAutomatedExecutionCreation(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AutomatedSuiteManagerServiceImpl.java", AutomatedSuiteManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllIdsByAutomatedSuiteIds", "org.squashtest.tm.service.internal.repository.ExecutionDao", "java.util.List", "arg0", "", "java.util.List"), 228);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdsOrderedByIterationTestPlan", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.List", "testPlanIds", "", "java.util.List"), 374);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "fetchForAutomatedExecutionCreation", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "itemTestPlanIds", "", "java.util.List"), 578);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "fetchForAutomatedExecutionCreation", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "itemTestPlanIds", "", "java.util.List"), 696);
    }
}

