/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.servers;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import javax.inject.Provider;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.spi.DefaultOAuth2FormValues;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import org.squashtest.tm.exception.bugtracker.CannotObtainOauth2TokensException;
import org.squashtest.tm.exception.bugtracker.InvalidOauth2RequestException;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.service.internal.servers.OAuth2ConsumerService;
import org.squashtest.tm.service.internal.servers.ServerOAuth2Conf;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.Oauth2Tokens;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.spi.OAuth2ConfigurationHandler;

@Service(value="squashtest.tm.service.OAuth2ConsumerService")
public class OAuth2ConsumerServiceImpl
implements OAuth2ConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2ConsumerServiceImpl.class);
    private final StoredCredentialsManager credManager;
    private final CredentialsProvider credProvider;
    private final BugTrackerConnectorFactory bugTrackerConnectorFactory;
    private final Provider<BugTrackerFinderService> bugTrackerFinderServiceProvider;
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();

    public OAuth2ConsumerServiceImpl(StoredCredentialsManager credManager, CredentialsProvider credProvider, BugTrackerConnectorFactory bugTrackerConnectorFactory, Provider<BugTrackerFinderService> bugTrackerFinderServiceProvider) {
        this.credManager = credManager;
        this.credProvider = credProvider;
        this.bugTrackerConnectorFactory = bugTrackerConnectorFactory;
        this.bugTrackerFinderServiceProvider = bugTrackerFinderServiceProvider;
    }

    @Override
    public String getOauth2AuthenticationUrl(BugTracker bugTracker) {
        ServerOAuth2Conf serverOAuth2Conf = this.loadOauth2Conf(bugTracker.getId());
        OAuth2ConfigurationHandler handler = this.bugTrackerConnectorFactory.findOauth2Handler(bugTracker);
        return handler.getOauth2AuthenticationUrl(bugTracker, serverOAuth2Conf);
    }

    @Override
    public void getOauth2token(Long serverId, String code, String username) {
        ServerOAuth2Conf serverOAuth2Conf = this.loadOauth2Conf(serverId);
        BugTracker bugTracker = ((BugTrackerFinderService)this.bugTrackerFinderServiceProvider.get()).findById(serverId);
        OAuth2ConfigurationHandler handler = this.bugTrackerConnectorFactory.findOauth2Handler(bugTracker);
        String uri = handler.getOauth2RequestTokenUrl(serverId, code, serverOAuth2Conf);
        this.requestAndSaveTokens(serverId, username, uri);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public OAuth2Credentials refreshOauth2Token(Long serverId, OAuth2Credentials creds, String username) {
        ServerOAuth2Conf serverOAuth2Conf = this.loadOauth2Conf(serverId);
        BugTracker bugTracker = ((BugTrackerFinderService)this.bugTrackerFinderServiceProvider.get()).findById(serverId);
        OAuth2ConfigurationHandler handler = this.bugTrackerConnectorFactory.findOauth2Handler(bugTracker);
        String uri = handler.getRefreshTokenUrl(serverOAuth2Conf, creds);
        Oauth2Tokens tokens = this.requestAndSaveTokens(serverId, username, uri);
        creds.setAccessToken(tokens.getAccessToken());
        creds.setRefreshToken(tokens.getRefreshToken());
        creds.setExpirationDate(tokens.getExpirationDate());
        return creds;
    }

    @Override
    public DefaultOAuth2FormValues getDefaultOAuth2FormValue(Long serverId) {
        BugTracker bugTracker = ((BugTrackerFinderService)this.bugTrackerFinderServiceProvider.get()).findById(serverId);
        OAuth2ConfigurationHandler handler = this.bugTrackerConnectorFactory.findOauth2Handler(bugTracker);
        String btURL = bugTracker.getUrl().replaceAll("\\/*$", "");
        return handler.getDefaultValueForOauth2Form(btURL);
    }

    @Override
    public void getCurrentUserOauth2token(long bugTrackerId, String code) {
        String user = this.credProvider.currentUser();
        this.getOauth2token(bugTrackerId, code, user);
    }

    private Oauth2Tokens requestAndSaveTokens(Long serverId, String username, String uri) {
        Oauth2Tokens tokens;
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            HttpRequest request = HttpRequest.newBuilder().header("Content-Type", "application/x-www-form-urlencoded").uri(new URI(uri)).POST(HttpRequest.BodyPublishers.noBody()).build();
            HttpResponse<String> httpResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            String responseBody = httpResponse.body();
            int statusCode = httpResponse.statusCode();
            if (statusCode != 200) {
                throw new CannotObtainOauth2TokensException(responseBody);
            }
            tokens = (Oauth2Tokens)mapper.readValue(responseBody, Oauth2Tokens.class);
            tokens.setExpirationDate();
            this.saveOauth2TokenToDataBase(serverId, tokens, username);
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new InvalidOauth2RequestException(e);
        }
        return tokens;
    }

    private void saveOauth2TokenToDataBase(Long serverId, Oauth2Tokens token, String username) {
        if (username == null) {
            LOGGER.trace("Squash-TM is now authorized on server '{}'. Storing app level credentials in the database", new Object[]{serverId});
            this.credManager.storeAppLevelCredentials(serverId, token);
        } else {
            LOGGER.trace("Squash-TM is now authorized by user '{}' on server '{}', now storing them in the database", new Object[]{username, serverId});
            this.credManager.storeUserCredentials(serverId, username, token);
        }
    }

    private ServerOAuth2Conf loadOauth2Conf(long serverId) {
        LOGGER.debug("loading oauth2 conf for server '{}'", new Object[]{serverId});
        ServerAuthConfiguration storedConf = this.credManager.unsecuredFindServerAuthConfiguration(serverId);
        if (storedConf == null || storedConf.getImplementedProtocol() != AuthenticationProtocol.OAUTH_2) {
            throw new BugTrackerNoCredentialsException("No OAuth 2 configuration available !", null);
        }
        return (ServerOAuth2Conf)storedConf;
    }
}

