/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.servers;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.exception.bugtracker.CannotObtainOauth2TokensException;
import org.squashtest.tm.exception.bugtracker.InvalidOauth2RequestException;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.servers.OAuth2ConsumerService;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.servers.UserCredentialsCache;

@Service(value="squashtest.tm.service.CredentialsProvider")
public class CredentialsProviderImpl
implements CredentialsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialsProviderImpl.class);
    private static final String CREDENTIALS_FOUND = "CredentialsProviderImpl : credentials found";
    private static final String CREDENTIALS_NOT_FOUND = "CredentialsProviderImpl : credentials not found";
    private static final String CREDENTIALS_FOUND_IN_DB = "CredentialsProviderImpl : found in database";
    @Inject
    private StoredCredentialsManager storedCredentialsManager;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private Provider<OAuth2ConsumerService> oAuth2ConsumerServiceProvider;
    private final ThreadLocal<UserCredentialsCache> threadedCache = new ThreadLocal();

    @Override
    public String currentUser() {
        UserCredentialsCache userCache = this.getCache();
        return userCache.getUser();
    }

    @Override
    public boolean hasCredentials(ThirdPartyServer server) {
        return this.getCurrentUserCredentials(server).isPresent();
    }

    @Override
    public boolean hasAppLevelCredentials(ThirdPartyServer server) {
        return this.getAppLevelCredentials(server).isPresent();
    }

    @Override
    public Optional<Credentials> getCurrentUserCredentials(ThirdPartyServer server) {
        Optional<Credentials> option;
        LOGGER.debug("CredentialsProviderImpl : looking for credentials for server '{}' for current user", new Object[]{server.getName()});
        Credentials credentials = this.getCredentialsFromCache(server);
        if (credentials == null) {
            credentials = this.getCurrentUserCredentialsFromStore(server);
        }
        if (credentials != null) {
            credentials = this.refreshOauth2TokensIfNeeded(server.getId(), credentials, this.currentUser());
            LOGGER.debug(CREDENTIALS_FOUND, new Object[0]);
            option = Optional.of(credentials);
        } else {
            LOGGER.debug(CREDENTIALS_NOT_FOUND, new Object[0]);
            option = Optional.empty();
        }
        return option;
    }

    @Override
    public Optional<Credentials> getUserCredentials(ThirdPartyServer server, String username) {
        Optional<Credentials> option;
        LOGGER.debug("CredentialsProviderImpl : looking for credentials for server '{}' for user '{}'", new Object[]{server.getName(), username});
        Credentials credentials = this.getUserCredentialsFromStore(server, username);
        if (credentials != null) {
            credentials = this.refreshOauth2TokensIfNeeded(server.getId(), credentials, username);
            LOGGER.debug(CREDENTIALS_FOUND, new Object[0]);
            option = Optional.of(credentials);
        } else {
            LOGGER.debug(CREDENTIALS_NOT_FOUND, new Object[0]);
            option = Optional.empty();
        }
        return option;
    }

    @Override
    public Optional<Credentials> getAppLevelCredentials(ThirdPartyServer server) {
        Optional<Credentials> option;
        LOGGER.debug("CredentialsProviderImpl : looking for app-level credentials for server '{}'", new Object[]{server.getName()});
        Credentials credentials = this.getAppLevelCredentialsFromStore(server);
        if (credentials != null) {
            credentials = this.refreshOauth2TokensIfNeeded(server.getId(), credentials, null);
            LOGGER.debug(CREDENTIALS_FOUND, new Object[0]);
            option = Optional.of(credentials);
        } else {
            LOGGER.debug(CREDENTIALS_NOT_FOUND, new Object[0]);
            option = Optional.empty();
        }
        return option;
    }

    private Credentials refreshOauth2TokensIfNeeded(Long serverId, Credentials creds, String username) {
        if (creds.getImplementedProtocol() == AuthenticationProtocol.OAUTH_2) {
            OAuth2Credentials oauth2Creds = (OAuth2Credentials)creds;
            Long dateNow = System.currentTimeMillis();
            Long tokenExpirationDate = oauth2Creds.getExpirationDate();
            if (dateNow > tokenExpirationDate) {
                try {
                    return ((OAuth2ConsumerService)this.oAuth2ConsumerServiceProvider.get()).refreshOauth2Token(serverId, oauth2Creds, username);
                }
                catch (CannotObtainOauth2TokensException | InvalidOauth2RequestException e) {
                    LOGGER.error("Could not refresh Oauth2 token", e);
                }
            }
        }
        return creds;
    }

    private Credentials getCredentialsFromCache(ThirdPartyServer server) {
        UserCredentialsCache userCache = this.getCache();
        Credentials credentials = null;
        if (userCache.hasCredentials(server)) {
            credentials = userCache.getCredentials(server);
            LOGGER.trace("CredentialsProviderImpl : found in cache", new Object[0]);
        }
        return credentials;
    }

    private Credentials getCurrentUserCredentialsFromStore(ThirdPartyServer server) {
        Credentials result = null;
        ManageableCredentials managed = this.storedCredentialsManager.findUserCredentials(server.getId(), this.currentUser());
        if (managed != null) {
            LOGGER.trace(CREDENTIALS_FOUND_IN_DB, new Object[0]);
            result = managed.build(this.storedCredentialsManager, server, this.getCache().getUser());
        }
        return result;
    }

    private Credentials getUserCredentialsFromStore(ThirdPartyServer server, String username) {
        Credentials result = null;
        ManageableCredentials managed = this.storedCredentialsManager.findUserCredentials(server.getId(), username);
        if (managed != null) {
            LOGGER.trace(CREDENTIALS_FOUND_IN_DB, new Object[0]);
            result = managed.build(this.storedCredentialsManager, server, this.getCache().getUser());
        }
        return result;
    }

    private Credentials getAppLevelCredentialsFromStore(ThirdPartyServer server) {
        Credentials result = null;
        ManageableCredentials managed = this.storedCredentialsManager.unsecuredFindAppLevelCredentials(server.getId());
        if (managed != null) {
            LOGGER.trace(CREDENTIALS_FOUND_IN_DB, new Object[0]);
            result = managed.build(this.storedCredentialsManager, server, null);
        }
        return result;
    }

    @Override
    public void cacheCredentials(ThirdPartyServer server, Credentials credentials) {
        if (server.getAuthenticationPolicy() != AuthenticationPolicy.APP_LEVEL) {
            LOGGER.debug("CredentialsProviderImpl : caching credentials for server '{}'", new Object[]{server.getName()});
            UserCredentialsCache userCache = this.getCache();
            userCache.cacheIfAllowed(server, credentials);
        } else {
            LOGGER.debug("CredentialsProviderImpl : refused to cache application-level credentials", new Object[0]);
        }
    }

    @Override
    public void uncacheCredentials(ThirdPartyServer server) {
        UserCredentialsCache userCache = this.getCache();
        userCache.uncache(server);
    }

    @Override
    public void restoreCache(UserCredentialsCache credentials) {
        if (credentials == null) {
            throw new NullArgumentException("Cannot store null credentials");
        }
        LOGGER.debug("CredentialsProviderImpl : restoring credentials cache for user '{}'", new Object[]{credentials.getUser()});
        this.threadedCache.set(credentials);
    }

    @Override
    public void unloadCache() {
        UserCredentialsCache cache = this.threadedCache.get();
        if (cache != null) {
            LOGGER.debug("CredentialsProviderImpl : unloading credentials cache for user '{}'", new Object[]{cache.getUser()});
        }
        this.threadedCache.remove();
    }

    @Override
    public Optional<TokenAuthCredentials> getProjectLevelCredentials(Long serverId, Long projectId) {
        return Optional.ofNullable(this.storedCredentialsManager.findProjectCredentials(serverId, projectId)).filter(TokenAuthCredentials.class::isInstance).map(TokenAuthCredentials.class::cast);
    }

    @Override
    public UserCredentialsCache getCache() {
        UserCredentialsCache userCache = this.threadedCache.get();
        if (userCache == null) {
            LOGGER.trace("CredentialsProviderImpl : current user has no credentials cache (yet).", new Object[0]);
            userCache = this.createDefaultOrDie();
            this.threadedCache.set(userCache);
        }
        return userCache;
    }

    private UserCredentialsCache createDefaultOrDie() {
        LOGGER.debug("CredentialsProviderImpl : attempting to create a default cache", new Object[0]);
        String username = UserContextHolder.getUsername();
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalStateException("CredentialsProviderImpl : attempted to get the credentials cache for current user but none were found. This is a programming error, which means that either there is no user context, or that the thread was initiated in an illegal way (the credentials cache were not loaded from the session)");
        }
        return new UserCredentialsCache(username, this.featureManager);
    }
}

