/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.scmserver;

import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.service.internal.repository.ScmServerDao;
import org.squashtest.tm.service.internal.scmserver.ScmConnectorRegistry;
import org.squashtest.tm.service.scmserver.ScmServerCredentialsService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Service(value="ScmServerCredentialsService")
@Transactional
public class ScmServerCredentialsServiceImpl
implements ScmServerCredentialsService {
    @Inject
    private ScmServerDao serverDao;
    @Inject
    private StoredCredentialsManager credentialsManager;
    @Inject
    private ScmConnectorRegistry scmConnectorRegistry;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public AuthenticationProtocol[] getSupportedProtocols(ScmServer server) {
        return this.scmConnectorRegistry.createConnector(server).getSupportedProtocols();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void testCredentials(long serverId, ManageableCredentials credentials) {
        ThirdPartyServer server = (ThirdPartyServer)this.serverDao.getReferenceById(serverId);
        Credentials usableCredentials = credentials.build(this.credentialsManager, server, null);
        if (usableCredentials == null) {
            throw new BugTrackerNoCredentialsException("credentials could not be built, either because the credentials themselves are not suitable, or because the protocol configuration is incomplete/invalid", null);
        }
    }
}

