/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jooq.TableField;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NewFolderDto;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.ExportRequirementData;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.NewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementLibraryNodeVisitor;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.InconsistentInfoListItemException;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.exception.library.NameAlreadyExistsAtDestinationException;
import org.squashtest.tm.exception.sync.PathAlreadyInUseException;
import org.squashtest.tm.exception.sync.PathValidationDomainException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.CheckBlockingMilestones;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.PreventConcurrents;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.importer.XlsImportLimitationHandler;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.batchexport.RequirementExcelExporter;
import org.squashtest.tm.service.internal.batchexport.RequirementExportDao;
import org.squashtest.tm.service.internal.batchexport.RequirementSearchExcelExporter;
import org.squashtest.tm.service.internal.batchexport.SearchRequirementExcelExporter;
import org.squashtest.tm.service.internal.batchexport.SearchSimpleRequirementExcelExporter;
import org.squashtest.tm.service.internal.batchexport.models.RequirementExportModel;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementExcelBatchImporter;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.library.AbstractLibraryNavigationService;
import org.squashtest.tm.service.internal.library.NodeDeletionHandler;
import org.squashtest.tm.service.internal.library.PasteStrategy;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;
import org.squashtest.tm.service.internal.repository.display.HighLevelRequirementDisplayDao;
import org.squashtest.tm.service.internal.requirement.RequirementFactory;
import org.squashtest.tm.service.internal.requirement.RequirementNodeDeletionHandler;
import org.squashtest.tm.service.internal.requirement.coercers.RLNAndParentIdsCoercerForArray;
import org.squashtest.tm.service.internal.requirement.coercers.RLNAndParentIdsCoercerForList;
import org.squashtest.tm.service.internal.requirement.coercers.RequirementLibraryIdsCoercerForArray;
import org.squashtest.tm.service.internal.requirement.coercers.RequirementLibraryIdsCoercerForList;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;
import org.squashtest.tm.service.project.ProjectFilterModificationService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.remotesynchronisation.RemoteSynchronisationService;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementStatisticsService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.statistics.requirement.RequirementStatisticsBundle;
import org.squashtest.tm.service.user.UserAccountService;

@Service(value="squashtest.tm.service.RequirementLibraryNavigationService")
@Transactional
public class RequirementLibraryNavigationServiceImpl
extends AbstractLibraryNavigationService<RequirementLibrary, RequirementFolder, RequirementLibraryNode>
implements RequirementLibraryNavigationService,
RequirementLibraryFinderService {
    public static final String SYNCHRONISATION_PATH = "synchronisationPath";
    private static final String REQUIREMENT_ID = "requirementId";
    private static final String SOURCE_NODES_IDS = "sourceNodesIds";
    private static final String DESTINATION_ID = "destinationId";
    private static final String TARGET_ID = "targetId";
    private static final String EXPORT = "EXPORT";
    private static final String NODE_IDS = "nodeIds";
    private static final String SIMPLE = "simple";
    @Inject
    private RequirementLibraryDao requirementLibraryDao;
    @Inject
    private RequirementFolderDao requirementFolderDao;
    @Inject
    @Qualifier(value="squashtest.tm.repository.RequirementLibraryNodeDao")
    private LibraryNodeDao<RequirementLibraryNode> requirementLibraryNodeDao;
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private RequirementNodeDeletionHandler deletionHandler;
    @Inject
    private ProjectFilterModificationService projectFilterModificationService;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToRequirementFolderStrategy")
    private Provider<PasteStrategy<RequirementFolder, RequirementLibraryNode>> pasteToRequirementFolderStrategyProvider;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToRequirementLibraryStrategy")
    private Provider<PasteStrategy<RequirementLibrary, RequirementLibraryNode>> pasteToRequirementLibraryStrategyProvider;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToRequirementStrategy")
    private Provider<PasteStrategy<Requirement, Requirement>> pasteToRequirementStrategyProvider;
    @Inject
    private RequirementStatisticsService statisticsService;
    @Inject
    private MilestoneMembershipManager milestoneService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private InfoListItemFinderService infoListItemService;
    @Inject
    private RequirementExportDao requirementExportDao;
    @Inject
    @Named(value="requirementExcelExporter")
    private Provider<RequirementExcelExporter> exporterProvider;
    @Inject
    private Provider<SearchRequirementExcelExporter> searchExporterProvider;
    @Inject
    private Provider<SearchSimpleRequirementExcelExporter> searchSimpleExporterProvider;
    @Inject
    private RequirementExcelBatchImporter batchImporter;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private CustomFieldBindingFinderService customFieldBindingFinderService;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;
    @Inject
    private RemoteSynchronisationService remoteSynchronisationService;
    @Inject
    private RequirementFactory requirementFactory;
    @Inject
    private HighLevelRequirementDisplayDao highLevelRequirementDisplayDao;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private XlsImportLimitationHandler xlsImportLimitationHandler;

    @Override
    protected NodeDeletionHandler<RequirementLibraryNode, RequirementFolder> getDeletionHandler() {
        return this.deletionHandler;
    }

    @Override
    @PostAuthorize(value="hasPermission(returnObject,'READ')  or hasRole('ROLE_ADMIN')")
    public Requirement findRequirement(long reqId) {
        return (Requirement)this.requirementDao.findById(reqId);
    }

    protected RequirementLibraryDao getLibraryDao() {
        return this.requirementLibraryDao;
    }

    protected RequirementFolderDao getFolderDao() {
        return this.requirementFolderDao;
    }

    @Override
    protected LibraryNodeDao<RequirementLibraryNode> getLibraryNodeDao() {
        return this.requirementLibraryNodeDao;
    }

    @Override
    protected PasteStrategy<RequirementFolder, RequirementLibraryNode> getPasteToFolderStrategy() {
        return (PasteStrategy)this.pasteToRequirementFolderStrategyProvider.get();
    }

    @Override
    protected PasteStrategy<RequirementLibrary, RequirementLibraryNode> getPasteToLibraryStrategy() {
        return (PasteStrategy)this.pasteToRequirementLibraryStrategyProvider.get();
    }

    private PasteStrategy<Requirement, Requirement> getPasteToRequirementStrategy() {
        return (PasteStrategy)this.pasteToRequirementStrategyProvider.get();
    }

    @Override
    @UsedInPlugin(value="Xsquash4GitLab & Xsquash4Jira")
    public @UsedInPlugin(value="Xsquash4GitLab & Xsquash4Jira") String getPathAsString(long entityId) {
        RequirementLibraryNode node = (RequirementLibraryNode)this.getLibraryNodeDao().findById(entityId);
        this.checkPermission(new SecurityCheckableObject(node, "READ"));
        List<String> names = this.getLibraryNodeDao().getParentsName(entityId);
        String projectName = node.getProject().getName();
        if (projectName.contains("/")) {
            projectName = projectName.replace("/", "\\/");
        }
        return "/" + projectName + "/" + this.formatPath(names);
    }

    private String formatPath(List<String> names) {
        StringBuilder builder = new StringBuilder();
        for (String name : names) {
            builder.append("/").append(name);
        }
        return builder.toString();
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.requirement.RequirementLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibrary.class)
    public RequirementFolder addFolderToLibrary(@Id long destinationId, RequirementFolder newFolder) {
        RequirementLibrary container = (RequirementLibrary)this.getLibraryDao().findById(destinationId);
        container.addContent((LibraryNode)newFolder);
        this.replaceAllInfoListReferences(newFolder);
        this.getFolderDao().persist(newFolder);
        this.createAllCustomFieldValues(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        this.generateCuf(newFolder);
        return newFolder;
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.requirement.RequirementLibrary' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibrary.class)
    public RequirementFolder addFolderToLibrary(@Id long destinationId, NewFolderDto folderDto) {
        RequirementFolder newFolder = (RequirementFolder)folderDto.toFolder(EntityType.REQUIREMENT_FOLDER);
        return this.addFolderToLibrary(destinationId, newFolder, folderDto.getCustomFields());
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.requirement.RequirementFolder' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public RequirementFolder addFolderToFolder(@Id long destinationId, RequirementFolder newFolder) {
        RequirementFolder container = (RequirementFolder)this.getFolderDao().findById(destinationId);
        container.addContent((RequirementLibraryNode)newFolder);
        this.replaceAllInfoListReferences(newFolder);
        this.getFolderDao().persist(newFolder);
        this.createAllCustomFieldValues(newFolder);
        this.generateCuf(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.requirement.RequirementFolder' , 'CREATE' ) or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public RequirementFolder addFolderToFolder(@Id long destinationId, NewFolderDto folderDto) {
        RequirementFolder newFolder = (RequirementFolder)folderDto.toFolder(EntityType.REQUIREMENT_FOLDER);
        return this.addFolderToFolder(destinationId, newFolder, folderDto.getCustomFields());
    }

    private void generateCuf(RequirementFolder newFolder) {
        List<CustomFieldBinding> projectsBindings = this.customFieldBindingFinderService.findCustomFieldsForProjectAndEntity(newFolder.getProject().getId(), BindableEntity.REQUIREMENT_FOLDER);
        for (CustomFieldBinding binding : projectsBindings) {
            this.customFieldValueService.cascadeCustomFieldValuesCreationNotCreatedFolderYet(binding, (BoundEntity)newFolder);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.requirement.RequirementLibrary' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibrary.class)
    public Requirement addRequirementToRequirementLibrary(@Id long libraryId, @NotNull NewRequirementVersionDto newVersion, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = newVersion;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        return this.addRequirementToRequirementLibraryUnsecured(libraryId, newVersion, milestoneIds);
    }

    @Override
    public Requirement addRequirementToRequirementLibraryUnsecured(@Id long libraryId, @NotNull NewRequirementVersionDto newVersion, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = newVersion;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        RequirementLibrary library = (RequirementLibrary)this.requirementLibraryDao.findById(libraryId);
        Requirement newReq = this.createRequirement(newVersion);
        library.addContent((LibraryNode)newReq);
        this.replaceAllInfoListReferences(newReq);
        this.requirementDao.persist(newReq);
        this.createCustomFieldValues((BoundEntity)newReq.getCurrentVersion());
        this.customFieldValueService.initCustomFieldValues((BoundEntity)newReq.getCurrentVersion(), newVersion.getCustomFields());
        this.createAttachmentsFromLibraryNode((LibraryNode)newReq, (BoundEntity)newReq.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(newReq.getCurrentVersion().getId(), milestoneIds);
        return newReq;
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.requirement.RequirementLibrary' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibrary.class)
    public Requirement addRequirementToRequirementLibrary(@Id long libraryId, @NotNull Requirement requirement, List<Long> milestoneIds) {
        Requirement requirement2 = requirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirement2);
        RequirementLibrary library = (RequirementLibrary)this.requirementLibraryDao.findById(libraryId);
        if (!library.isContentNameAvailable(requirement.getName())) {
            throw new DuplicateNameException(requirement.getName(), requirement.getName());
        }
        library.addContent((LibraryNode)requirement);
        this.replaceAllInfoListReferences(requirement);
        this.requirementDao.persist(requirement);
        this.createCustomFieldValues((BoundEntity)requirement.getCurrentVersion());
        this.createAttachmentsFromLibraryNode((LibraryNode)requirement, (BoundEntity)requirement.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(requirement.getCurrentVersion().getId(), milestoneIds);
        return requirement;
    }

    private Requirement createRequirement(NewRequirementVersionDto newVersionData) {
        return this.requirementFactory.createRequirement(newVersionData);
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.requirement.RequirementFolder' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public Requirement addRequirementToRequirementFolder(@Id long folderId, @NotNull NewRequirementVersionDto firstVersion, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = firstVersion;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        return this.addRequirementToRequirementFolderUnsecured(folderId, firstVersion, milestoneIds);
    }

    @Override
    public Requirement addRequirementToRequirementFolderUnsecured(@Id long folderId, @NotNull NewRequirementVersionDto firstVersion, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = firstVersion;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        RequirementFolder folder = this.requirementFolderDao.findByIdWithContent(folderId);
        Requirement newReq = this.createRequirement(firstVersion);
        folder.addContent((RequirementLibraryNode)newReq);
        this.replaceAllInfoListReferences(newReq);
        this.requirementDao.persist(newReq);
        RequirementVersion currentVersion = newReq.getCurrentVersion();
        this.createCustomFieldValues((BoundEntity)currentVersion);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)currentVersion, firstVersion.getCustomFields());
        this.createAttachmentsFromLibraryNode((LibraryNode)newReq, (BoundEntity)newReq.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(currentVersion.getId(), milestoneIds);
        return newReq;
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.requirement.RequirementFolder' , 'CREATE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public Requirement addRequirementToRequirementFolder(@Id long folderId, @NotNull Requirement requirement, List<Long> milestoneIds) {
        Requirement requirement2 = requirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirement2);
        RequirementFolder folder = this.requirementFolderDao.findByIdWithContent(folderId);
        if (!folder.isContentNameAvailable(requirement.getName())) {
            throw new DuplicateNameException(requirement.getName(), requirement.getName());
        }
        folder.addContent((RequirementLibraryNode)requirement);
        this.replaceAllInfoListReferences(requirement);
        this.requirementDao.persist(requirement);
        this.createCustomFieldValues((BoundEntity)requirement.getCurrentVersion());
        this.createAttachmentsFromLibraryNode((LibraryNode)requirement, (BoundEntity)requirement.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(requirement.getCurrentVersion().getId(), milestoneIds);
        return requirement;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    @CheckBlockingMilestone(entityType=Requirement.class)
    public Requirement addRequirementToRequirement(@Id long requirementId, @NotNull NewRequirementVersionDto newRequirement, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = newRequirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        return this.addRequirementToRequirementUnsecured(requirementId, newRequirement, milestoneIds);
    }

    @Override
    public Requirement addRequirementToRequirementUnsecured(@Id long requirementId, @NotNull NewRequirementVersionDto newRequirement, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = newRequirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        Requirement parent = this.requirementDao.findByIdWithChildren(requirementId);
        Requirement child = this.createRequirement(newRequirement);
        child.setHighLevelRequirement(parent.getHighLevelRequirement());
        parent.addContent(child);
        this.replaceAllInfoListReferences(child);
        this.requirementDao.persist(child);
        this.createCustomFieldValues((BoundEntity)child.getCurrentVersion());
        this.customFieldValueService.initCustomFieldValues((BoundEntity)child.getCurrentVersion(), newRequirement.getCustomFields());
        this.createAttachmentsFromLibraryNode((LibraryNode)child, (BoundEntity)child.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(child.getCurrentVersion().getId(), milestoneIds);
        return child;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    @CheckBlockingMilestone(entityType=Requirement.class)
    public Requirement addRequirementToHighLevelRequirement(@Id long requirementId, @NotNull NewRequirementVersionDto newRequirement, List<Long> milestoneIds) {
        NewRequirementVersionDto newRequirementVersionDto = newRequirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)newRequirementVersionDto);
        HighLevelRequirement parent = (HighLevelRequirement)this.requirementDao.findById(requirementId);
        Requirement child = this.createRequirement(newRequirement);
        child.setHighLevelRequirement(parent);
        parent.addContent(child);
        this.replaceAllInfoListReferences(child);
        this.requirementDao.persist(child);
        this.createCustomFieldValues((BoundEntity)child.getCurrentVersion());
        this.customFieldValueService.initCustomFieldValues((BoundEntity)child.getCurrentVersion(), newRequirement.getCustomFields());
        this.createAttachmentsFromLibraryNode((LibraryNode)child, (BoundEntity)child.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(child.getCurrentVersion().getId(), milestoneIds);
        return child;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public Requirement addRequirementToRequirement(@Id long requirementId, @NotNull Requirement newRequirement, List<Long> milestoneIds) {
        Requirement requirement = newRequirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirement);
        Requirement parent = this.requirementDao.findByIdWithChildren(requirementId);
        newRequirement.setHighLevelRequirement(parent.getHighLevelRequirement());
        parent.addContent(newRequirement);
        this.replaceAllInfoListReferences(newRequirement);
        this.requirementDao.persist(newRequirement);
        this.createCustomFieldValues((BoundEntity)newRequirement.getCurrentVersion());
        this.createAttachmentsFromLibraryNode((LibraryNode)newRequirement, (BoundEntity)newRequirement.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(newRequirement.getCurrentVersion().getId(), milestoneIds);
        return newRequirement;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=RequirementLibraryNode.class)
    public Requirement addRequirementToHighLevelRequirement(@Id long requirementId, @NotNull Requirement newRequirement, List<Long> milestoneIds) {
        Requirement requirement = newRequirement;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirement);
        HighLevelRequirement parent = (HighLevelRequirement)this.requirementDao.findById(requirementId);
        newRequirement.setHighLevelRequirement(parent);
        parent.addContent(newRequirement);
        this.replaceAllInfoListReferences(newRequirement);
        this.requirementDao.persist(newRequirement);
        this.createCustomFieldValues((BoundEntity)newRequirement.getCurrentVersion());
        this.createAttachmentsFromLibraryNode((LibraryNode)newRequirement, (BoundEntity)newRequirement.getCurrentVersion());
        this.milestoneService.bindRequirementVersionToMilestones(newRequirement.getCurrentVersion().getId(), milestoneIds);
        return newRequirement;
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="requirementId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="sourceNodesIds", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="sourceNodesIds", coercer=RequirementLibraryIdsCoercerForArray.class)})
    @CheckBlockingMilestone(entityType=Requirement.class)
    public List<Requirement> copyNodesToRequirement(@Id(value="requirementId") long requirementId, @Ids(value="sourceNodesIds") Long[] sourceNodesIds, ClipboardPayload clipboardPayload) {
        PasteStrategy<Requirement, Requirement> pasteStrategy = this.getPasteToRequirementStrategy();
        this.makeCopierStrategy(pasteStrategy);
        return pasteStrategy.pasteNodes(requirementId, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="requirementId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="nodeIds", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="nodeIds", coercer=RequirementLibraryIdsCoercerForArray.class)})
    @CheckBlockingMilestone(entityType=Requirement.class)
    public void moveNodesToRequirement(@Id(value="requirementId") long requirementId, @Ids(value="nodeIds") Long[] nodeIds, ClipboardPayload clipboardPayload) {
        if (nodeIds.length == 0) {
            return;
        }
        try {
            PasteStrategy<Requirement, Requirement> pasteStrategy = this.getPasteToRequirementStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteNodes(requirementId, clipboardPayload);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="requirementId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="nodeIds", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="nodeIds", coercer=RequirementLibraryIdsCoercerForArray.class)})
    @CheckBlockingMilestone(entityType=Requirement.class)
    public void moveNodesToRequirement(@Id(value="requirementId") long requirementId, @Ids(value="nodeIds") Long[] nodeIds) {
        this.moveNodesToRequirement(requirementId, nodeIds, ClipboardPayload.withWhiteListIgnored(Arrays.asList(nodeIds)));
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="requirementId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="nodeIds", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="nodeIds", coercer=RequirementLibraryIdsCoercerForArray.class)})
    @CheckBlockingMilestone(entityType=Requirement.class)
    public void moveNodesToRequirement(@Id(value="requirementId") long requirementId, @Ids(value="nodeIds") Long[] nodeIds, int position, ClipboardPayload clipboardPayload) {
        if (nodeIds.length == 0) {
            return;
        }
        try {
            PasteStrategy<Requirement, Requirement> pasteStrategy = this.getPasteToRequirementStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteNodes(requirementId, clipboardPayload, position);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    public List<ExportRequirementData> findRequirementsToExportFromLibrary(List<Long> libraryIds) {
        List<Long> list = libraryIds;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(list);
        PermissionsUtils.checkPermission(this.permissionService, libraryIds, EXPORT, RequirementLibrary.class.getName());
        return this.requirementDao.findRequirementToExportFromLibrary(libraryIds);
    }

    @Override
    public List<ExportRequirementData> findRequirementsToExportFromNodes(List<Long> nodesIds) {
        List<Long> list = nodesIds;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(list);
        PermissionsUtils.checkPermission(this.permissionService, nodesIds, EXPORT, RequirementLibraryNode.class.getName());
        return this.requirementDao.findRequirementToExportFromNodes(nodesIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'READ') or hasRole('ROLE_ADMIN')")
    public List<Requirement> findChildrenRequirements(long requirementId) {
        return this.requirementDao.findChildrenRequirements(requirementId);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="sourceNodesIds", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="sourceNodesIds", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void copyNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="sourceNodesIds") Long[] sourceNodesIds, ClipboardPayload clipboardPayload) {
        super.copyNodesToFolder(destinationId, sourceNodesIds, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetId", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetId", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void copyNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        super.copyNodesToLibrary(destinationId, targetId, clipboardPayload);
    }

    private void replaceAllInfoListReferences(RequirementFolder folder) {
        new CategoryChainFixer().fix(folder);
    }

    private void replaceAllInfoListReferences(Requirement requirement) {
        new CategoryChainFixer().fix(requirement);
    }

    private void createAllCustomFieldValues(RequirementFolder folder) {
        new CustomFieldValuesFixer().fix(folder);
    }

    @Override
    public File exportRequirementAsExcel(List<Long> libraryIds, List<Long> nodeIds, boolean keepRteFormat, MessageSource messageSource) {
        return this.exportRequirementAsExcel(libraryIds, nodeIds, false, keepRteFormat, messageSource);
    }

    @Override
    public File exportRequirementAsExcel(List<Long> libraryIds, List<Long> nodeIds, boolean addLinkedLowLevelReq, boolean keepRteFormat, MessageSource messageSource) {
        HashSet<Long> reqIds = new HashSet<Long>();
        Collection<Long> allIds = this.findRequirementIdsFromSelection(libraryIds, nodeIds);
        allIds = this.securityFilterIds(allIds, Requirement.class.getName(), EXPORT);
        reqIds.addAll(allIds);
        if (addLinkedLowLevelReq) {
            List<Long> exportableProjectIds = this.findExportableProjectIds();
            reqIds.addAll(this.highLevelRequirementDisplayDao.findStandardRequirementsByRequirementIdsAndProjectIds(new ArrayList<Long>(reqIds), exportableProjectIds));
        }
        List<Long> reqVersionIds = this.requirementDao.findIdsVersionsForAll(new ArrayList<Long>(reqIds));
        RequirementExportModel exportModel = this.requirementExportDao.findAllRequirementModel(reqVersionIds);
        RequirementExcelExporter exporter = (RequirementExcelExporter)this.exporterProvider.get();
        exporter.appendToWorkbook(exportModel, keepRteFormat);
        return exporter.print();
    }

    @Override
    public File searchExportRequirementAsExcel(List<Long> nodeIds, boolean keepRteFormat, boolean addLinkedLowLevelReq, MessageSource messageSource, String type, Boolean simplifiedColumnDisplay) {
        File file;
        Set<Long> reqVersionIds = this.securityFilterIds(nodeIds, RequirementVersion.class.getName(), EXPORT);
        if (addLinkedLowLevelReq) {
            List<Long> exportableProjectIds = this.findExportableProjectIds();
            reqVersionIds.addAll(this.highLevelRequirementDisplayDao.findLinkedLowLevelReqVersionIdsByReqVersionIdsAndProjectIds(new ArrayList<Long>(reqVersionIds), exportableProjectIds));
        }
        if (type.equals(SIMPLE)) {
            RequirementExportModel exportModel = this.requirementExportDao.populateRequirementExportModelFromJooq(new ArrayList<Long>(reqVersionIds));
            exporter = (SearchSimpleRequirementExcelExporter)this.searchSimpleExporterProvider.get();
            ((RequirementSearchExcelExporter)exporter).createHeaders(simplifiedColumnDisplay);
            ((RequirementSearchExcelExporter)exporter).getMessageSource(messageSource);
            ((RequirementSearchExcelExporter)exporter).appendToWorkbook(exportModel, keepRteFormat, simplifiedColumnDisplay);
            file = ((RequirementSearchExcelExporter)exporter).print();
        } else {
            RequirementExportModel exportModel = this.requirementExportDao.findAllRequirementModel(new ArrayList<Long>(reqVersionIds));
            exporter = (SearchRequirementExcelExporter)this.searchExporterProvider.get();
            ((RequirementExcelExporter)exporter).appendToWorkbook(exportModel, keepRteFormat);
            file = ((RequirementExcelExporter)exporter).print();
        }
        return file;
    }

    @Override
    public ImportLog simulateImportExcelRequirement(File xls) {
        this.xlsImportLimitationHandler.checkMaxNumberOfRequirementsInsideXlsFile(xls);
        return this.batchImporter.simulateImport(xls);
    }

    @Override
    public ImportLog importExcelRequirement(File xls) {
        try {
            this.xlsImportLimitationHandler.incrementImportProcessCounter();
            this.xlsImportLimitationHandler.checkMaxNumberOfRequirementsInsideXlsFile(xls);
            this.xlsImportLimitationHandler.checkIfImportSlotIsAvailable();
            ImportLog importLog = this.batchImporter.performImport(xls);
            return importLog;
        }
        finally {
            this.xlsImportLimitationHandler.decrementImportProcessCounter();
        }
    }

    @Override
    public List<Long> findNodeIdsByPath(List<String> paths) {
        return this.requirementLibraryNodeDao.findNodeIdsByPath(paths);
    }

    @Override
    public Long findNodeIdByPath(String path) {
        return StringUtils.isBlank((CharSequence)path) ? null : this.requirementLibraryNodeDao.findNodeIdByPath(path);
    }

    @Override
    public Long findNodeIdByRemoteKey(String remoteKey, String projectName) {
        return this.requirementDao.findNodeIdByRemoteKey(remoteKey, projectName);
    }

    @Override
    public Long findNodeIdByRemoteKeyAndSynchronisationId(String remoteKey, Long remoteSyncId) {
        return this.requirementDao.findNodeIdByRemoteKeyAndRemoteSyncId(remoteKey, remoteSyncId);
    }

    @Override
    public List<Long> findNodeIdsByRemoteKeys(List<String> remoteKeys, String projectName) {
        return this.requirementDao.findNodeIdsByRemoteKeys(remoteKeys, projectName);
    }

    @Override
    public Collection<Long> findRequirementIdsFromSelection(Collection<Long> libraryIds, Collection<Long> nodeIds) {
        return this.findRequirementIdsFromSelection(libraryIds, nodeIds, false);
    }

    @Override
    public Collection<Long> findRequirementIdsFromSelection(Collection<Long> libraryIds, Collection<Long> nodeIds, boolean isExtendedHighLvlReqScope) {
        Set<Long> readLibIds = this.securityFilterIds(libraryIds, RequirementLibrary.class.getName(), "READ");
        Set<Long> readNodeIds = this.securityFilterIds(nodeIds, RequirementLibraryNode.class.getName(), "READ");
        HashSet<Long> reqIds = new HashSet<Long>();
        if (!readLibIds.isEmpty()) {
            reqIds.addAll(this.highLevelRequirementDisplayDao.findRequirementIdsByLibraryIds(readLibIds, isExtendedHighLvlReqScope));
        }
        if (!readNodeIds.isEmpty()) {
            reqIds.addAll(this.highLevelRequirementDisplayDao.findRequirementIdsByNodeIds(readNodeIds, isExtendedHighLvlReqScope));
        }
        return reqIds;
    }

    @Override
    public Long mkdirs(String folderpath) {
        RequirementFolder folderTree;
        List paths = PathUtils.scanPath((String)folderpath);
        String[] splits = PathUtils.splitPath((String)folderpath);
        Project project = this.projectDao.findByName(PathUtils.unescapePathPartSlashes((String)splits[0]));
        if (splits.length < 2) {
            throw new IllegalArgumentException("Folder path for mkdir must contains at least a valid /projectName/folder");
        }
        if (project == null) {
            throw new IllegalArgumentException("Folder path for mkdir must concern an existing project");
        }
        List<Long> ids = this.findNodeIdsByPath(paths);
        int position = ids.indexOf(null);
        switch (position) {
            case -1: {
                return ids.get(ids.size() - 1);
            }
            case 0: {
                folderTree = this.makeFolderTree(project, 1, splits);
                this.addFolderToLibrary((long)project.getRequirementLibrary().getId(), folderTree);
                break;
            }
            default: {
                return this.createReqOrFolderIfSomethingAlreadyExists(splits, project, ids, position);
            }
        }
        RequirementFolder lastfolder = folderTree;
        while (lastfolder.hasContent()) {
            lastfolder = (RequirementFolder)lastfolder.getContent().get(0);
        }
        return lastfolder.getId();
    }

    private Long createReqOrFolderIfSomethingAlreadyExists(String[] splits, Project project, List<Long> ids, int position) {
        Requirement requirement = this.findRequirement(ids.get(position - 1));
        if (requirement == null) {
            return this.createFolderTree(project, position, ids.get(position - 1), splits);
        }
        return this.createRequirementTree(project, position, ids.get(position - 1), splits, requirement.isHighLevel());
    }

    private List<Long> findExportableProjectIds() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.projectFinder.findAllExportableIdsOnGivenLibrary(currentUser, RequirementLibrary.class.getName(), (TableField<ProjectRecord, Long>)Tables.PROJECT.RL_ID);
    }

    private Long createRequirementTree(Project project, int position, Long idBaseRequirement, String[] splits, boolean isHighLevel) {
        Requirement requirementTree = this.makeRequirementTree(project, position + 1, splits);
        List<Long> emptyIds = Collections.emptyList();
        if (isHighLevel) {
            this.addRequirementToHighLevelRequirement((long)idBaseRequirement, requirementTree, emptyIds);
        } else {
            this.addRequirementToRequirement((long)idBaseRequirement, requirementTree, emptyIds);
        }
        Requirement lastRequirement = requirementTree;
        while (lastRequirement.hasContent()) {
            lastRequirement = (Requirement)lastRequirement.getContent().get(0);
        }
        return lastRequirement.getId();
    }

    private Long createFolderTree(Project project, int position, Long idBaseFolder, String[] splits) {
        RequirementFolder folderTree = this.makeFolderTree(project, position + 1, splits);
        this.addFolderToFolder((long)idBaseFolder, folderTree);
        RequirementFolder lastfolder = folderTree;
        while (lastfolder.hasContent()) {
            lastfolder = (RequirementFolder)lastfolder.getContent().get(0);
        }
        return lastfolder.getId();
    }

    private RequirementFolder makeFolderTree(Project project, int startIndex, String[] names) {
        RequirementFolder baseFolder = null;
        RequirementFolder parentFolder = null;
        int i = startIndex;
        while (i < names.length) {
            RequirementFolder childFolder = new RequirementFolder();
            childFolder.setName(PathUtils.unescapePathPartSlashes((String)names[i]));
            childFolder.setDescription("");
            childFolder.notifyAssociatedWithProject(project);
            if (baseFolder == null) {
                baseFolder = childFolder;
            } else {
                parentFolder.addContent((RequirementLibraryNode)childFolder);
            }
            parentFolder = childFolder;
            ++i;
        }
        return baseFolder;
    }

    private Requirement makeRequirementTree(Project project, int startIndex, String[] names) {
        Requirement baseRequirement = null;
        Requirement parentRequirement = null;
        int i = startIndex;
        while (i < names.length) {
            Requirement childRequirement = new Requirement(new RequirementVersion());
            childRequirement.setName(PathUtils.unescapePathPartSlashes((String)names[i]));
            childRequirement.setDescription("");
            childRequirement.setCategory(this.infoListItemService.findDefaultRequirementCategory(project.getId()));
            childRequirement.notifyAssociatedWithProject(project);
            if (baseRequirement == null) {
                baseRequirement = childRequirement;
            } else {
                parentRequirement.addContent(childRequirement);
            }
            parentRequirement = childRequirement;
            ++i;
        }
        return baseRequirement;
    }

    @Override
    public void changeCurrentVersionNumber(Requirement requirement, Integer noVersion) {
        if (requirement.getCurrentVersion().getVersionNumber() == noVersion.intValue()) {
            return;
        }
        if (requirement.findRequirementVersion(noVersion.intValue()) != null) {
            throw new IllegalArgumentException("RequirementVersion with version number " + noVersion + " already exist in this Requirement, id : " + requirement.getId());
        }
        RequirementVersion lastCreatedReqVersion = requirement.getCurrentVersion();
        lastCreatedReqVersion.setVersionNumber(noVersion.intValue());
        requirement.setCurrentVersion(requirement.findLastNonObsoleteVersionAfterImport());
    }

    @Override
    public void initCUFvalues(RequirementVersion reqVersion, Map<Long, RawValue> initialCustomFieldValues) {
        this.customFieldValueService.initCustomFieldValues((BoundEntity)reqVersion, initialCustomFieldValues);
    }

    @Override
    public RequirementLibraryNode findRequirementLibraryNodeById(Long id) {
        return (RequirementLibraryNode)this.requirementLibraryNodeDao.findById(id);
    }

    @Override
    @PreAuthorize(value="hasPermission(#rlnId, 'org.squashtest.tm.domain.requirement.RequirementLibraryNode', 'READ') or hasRole('ROLE_ADMIN')")
    public List<String> findNamesInNodeStartingWith(long rlnId, String nameStart) {
        return this.requirementFolderDao.findNamesInNodeStartingWith(rlnId, nameStart);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.requirement.RequirementLibrary', 'READ') or hasRole('ROLE_ADMIN')")
    public List<String> findNamesInLibraryStartingWith(long libraryId, String nameStart) {
        return this.requirementFolderDao.findNamesInLibraryStartingWith(libraryId, nameStart);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetId", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetId", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void moveNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        super.moveNodesToFolder(destinationId, targetId, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetId", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetId", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void moveNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, int position, ClipboardPayload clipboardPayload) {
        super.moveNodesToFolder(destinationId, targetId, position, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetId", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetId", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void moveNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, ClipboardPayload clipboardPayload) {
        super.moveNodesToLibrary(destinationId, targetId, clipboardPayload);
    }

    @Override
    public void moveNodesToLibrary(long destinationId, Long[] targetId) {
        super.moveNodesToLibrary(destinationId, targetId, ClipboardPayload.withWhiteListIgnored(Arrays.asList(targetId)));
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=RequirementLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetId", coercer=RLNAndParentIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetId", coercer=RequirementLibraryIdsCoercerForArray.class)})
    public void moveNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetId, int position, ClipboardPayload clipboardPayload) {
        super.moveNodesToLibrary(destinationId, targetId, position, clipboardPayload);
    }

    @Override
    public void moveNodesToLibrary(long destinationId, Long[] targetId, int position) {
        super.moveNodesToLibrary(destinationId, targetId, position, ClipboardPayload.withWhiteListIgnored(Arrays.asList(targetId)));
    }

    @Override
    @PreventConcurrents(batchsLocks={@BatchPreventConcurrent(entityType=RequirementLibraryNode.class, paramName="targetIds", coercer=RLNAndParentIdsCoercerForList.class), @BatchPreventConcurrent(entityType=RequirementLibrary.class, paramName="targetIds", coercer=RequirementLibraryIdsCoercerForList.class)})
    @CheckBlockingMilestones(entityType=Requirement.class)
    public OperationReport deleteNodes(@Ids(value="targetIds") List<Long> targetIds) {
        return super.deleteNodes(targetIds);
    }

    @Override
    public RequirementStatisticsBundle getStatisticsForSelection(Collection<Long> libraryIds, Collection<Long> nodeIds) {
        return this.getStatisticsForSelection(libraryIds, nodeIds, false);
    }

    @Override
    public RequirementStatisticsBundle getStatisticsForSelection(Collection<Long> libraryIds, Collection<Long> nodeIds, boolean isExtendedHighLvlReqScope) {
        Collection<Long> reqIds = this.findRequirementIdsFromSelection(libraryIds, nodeIds, isExtendedHighLvlReqScope);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            return this.statisticsService.gatherRequirementStatisticsBundleForActiveMilestone(reqIds, activeMilestone.get());
        }
        return this.statisticsService.gatherRequirementStatisticsBundle(reqIds);
    }

    @Override
    public List<Long> findAllRequirementIdsInMilestone(Milestone activeMilestone) {
        if (activeMilestone != null) {
            ArrayList<Long> milestoneIds = new ArrayList<Long>();
            milestoneIds.add(activeMilestone.getId());
            return this.requirementDao.findAllRequirementIdsFromMilestones(milestoneIds);
        }
        return new ArrayList<Long>();
    }

    @Override
    public Requirement findRequirement(Long nodeId) {
        return (Requirement)this.requirementDao.findById(nodeId);
    }

    @Override
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void validatePathForSync(String projectName, String synchronisationPath) throws RequiredFieldException, PathValidationDomainException, PathAlreadyInUseException {
        if (StringUtils.isBlank((CharSequence)synchronisationPath)) {
            throw new RequiredFieldException("path");
        }
        if (!PathUtils.isPathSyntaxValid((String)synchronisationPath)) {
            throw new PathValidationDomainException(SYNCHRONISATION_PATH);
        }
        this.remoteSynchronisationService.checkPathAvailability(projectName, synchronisationPath);
        String fullSynchronisationPath = PathUtils.appendPathToProjectName((String)projectName, (String)synchronisationPath);
        Long id = this.findNodeIdByPath(fullSynchronisationPath);
        if (id != null) {
            throw new PathAlreadyInUseException(SYNCHRONISATION_PATH);
        }
    }

    private class CategoryChainFixer
    implements RequirementLibraryNodeVisitor {
        private CategoryChainFixer() {
        }

        private void fix(RequirementFolder folder) {
            for (RequirementLibraryNode node : folder.getContent()) {
                node.accept((RequirementLibraryNodeVisitor)this);
            }
        }

        private void fix(Requirement req) {
            req.accept((RequirementLibraryNodeVisitor)this);
        }

        public void visit(Requirement visited) {
            this.replaceInfoListReferences(visited);
            for (Requirement insider : visited.getContent()) {
                this.fix(insider);
            }
        }

        public void visit(RequirementFolder visited) {
            this.fix(visited);
        }

        private void replaceInfoListReferences(Requirement newReq) {
            RequirementVersion.PropertiesSetter ppt = newReq.getResource().getPropertySetter();
            InfoList projectCategories = newReq.getProject().getRequirementCategories();
            InfoListItem category = newReq.getCategory();
            if (category == null) {
                ppt.setCategory(projectCategories.getDefaultItem());
            } else {
                if (!projectCategories.contains(category)) {
                    throw new InconsistentInfoListItemException("category", category.getCode());
                }
                if (category instanceof ListItemReference) {
                    ppt.setCategory(projectCategories.getItem(category));
                }
            }
        }
    }

    private class CustomFieldValuesFixer
    implements RequirementLibraryNodeVisitor {
        private CustomFieldValuesFixer() {
        }

        private void fix(RequirementFolder folder) {
            for (RequirementLibraryNode node : folder.getContent()) {
                node.accept((RequirementLibraryNodeVisitor)this);
            }
        }

        private void fix(Requirement req) {
            req.accept((RequirementLibraryNodeVisitor)this);
        }

        public void visit(Requirement requirement) {
            RequirementLibraryNavigationServiceImpl.this.createCustomFieldValues((BoundEntity)requirement.getCurrentVersion());
            for (Requirement req : requirement.getContent()) {
                this.fix(req);
            }
        }

        public void visit(RequirementFolder folder) {
            this.fix(folder);
        }
    }
}

