/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate.loaders.testcase;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.Subgraph;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.common.FetchPlanBuilder;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.common.HintOption;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;

@Repository
public class JpaTestCaseLoader
implements TestCaseLoader {
    private final EntityManager entityManager;

    public JpaTestCaseLoader(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public EnumSet<TestCaseLoader.Options> defaultOptions() {
        return EnumSet.noneOf(TestCaseLoader.Options.class);
    }

    @Override
    public List<TestCase> load(Collection<Long> ids, EnumSet<TestCaseLoader.Options> options) {
        FetchPlanBuilder<Long, TestCase> fetchPlanBuilder = new FetchPlanBuilder<Long, TestCase>(ids);
        this.assignInitialQuery(fetchPlanBuilder);
        this.addFetchOptions(options, fetchPlanBuilder);
        return fetchPlanBuilder.build().fetch();
    }

    private void addFetchOptions(EnumSet<TestCaseLoader.Options> options, FetchPlanBuilder<Long, TestCase> fetchPlanBuilder) {
        String[] fetchAttributes = (String[])options.stream().filter(opt -> opt.field != null).map(opt -> opt.field).toArray(String[]::new);
        if (fetchAttributes.length == 0) {
            return;
        }
        EntityGraph entityGraph = this.entityManager.createEntityGraph(TestCase.class);
        entityGraph.addAttributeNodes(fetchAttributes);
        if (options.contains((Object)TestCaseLoader.Options.FETCH_ATTACHMENT_LIST)) {
            Subgraph subGraph = entityGraph.addSubgraph(TestCaseLoader.Options.FETCH_ATTACHMENT_LIST.field);
            subGraph.addAttributeNodes(new String[]{"attachments"});
        }
        HintOption option = new HintOption(HintOption.FETCH_GRAPH, entityGraph);
        fetchPlanBuilder.addHint(option);
    }

    private void assignInitialQuery(FetchPlanBuilder<Long, TestCase> fetchPlanBuilder) {
        fetchPlanBuilder.withMainQuery(this::getQuery);
    }

    private TypedQuery<TestCase> getQuery() {
        return this.entityManager.createQuery("select distinct tc from TestCase tc where tc.id in :ids", TestCase.class).setHint("hibernate.query.passDistinctThrough", (Object)false);
    }
}

