/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.io.Serializable;
import java.util.Optional;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.internal.repository.CustomRequirementVersionDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

public class RequirementVersionDaoImpl
implements CustomRequirementVersionDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;

    private Session currentSession() {
        return (Session)this.em.unwrap(Session.class);
    }

    @Override
    public Requirement findRequirementById(long requirementId) {
        return (Requirement)this.currentSession().load(Requirement.class, (Serializable)Long.valueOf(requirementId));
    }

    @Override
    public RequirementVersion findByRequirementIdAndMilestone(long requirementId) {
        Optional<Milestone> active = this.activeMilestoneHolder.getActiveMilestone();
        if (active.isPresent()) {
            Query q = this.currentSession().getNamedQuery("requirementVersion.findVersionByRequirementAndMilestone");
            q.setParameter("requirementId", (Object)requirementId);
            q.setParameter("milestoneId", (Object)active.get().getId());
            return (RequirementVersion)q.uniqueResult();
        }
        Query q = this.currentSession().getNamedQuery("requirementVersion.findLatestRequirementVersion");
        q.setParameter("requirementId", (Object)requirementId);
        return (RequirementVersion)q.uniqueResult();
    }

    @Override
    public RequirementVersion loadForCoverageAddition(Long versionId) {
        return (RequirementVersion)this.em.createQuery("select rv from RequirementVersion rv\njoin fetch rv.requirement\nleft join fetch rv.requirementVersionCoverages\nwhere rv.id = :versionId", RequirementVersion.class).setParameter("versionId", (Object)versionId).getSingleResult();
    }
}

