/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.service.internal.repository.CustomInfoListDao;
import org.squashtest.tm.service.internal.repository.InfoListDao;

@Repository
public class InfoListDaoImpl
implements CustomInfoListDao {
    @Inject
    @Lazy
    private InfoListDao infoListDao;
    @PersistenceContext
    private EntityManager em;

    @Override
    public boolean isUsedByOneOrMoreProject(long infoListId) {
        Query query = this.em.createNamedQuery("infoList.findProjectUsingInfoList");
        query.setParameter("id", (Object)infoListId);
        return !query.getResultList().isEmpty();
    }

    @Override
    public void unbindFromProject(long infoListId) {
        InfoList defaultReqCatList = this.infoListDao.findByCode(SystemInfoListCode.REQUIREMENT_CATEGORY.getCode());
        this.execUpdateQuery(infoListId, "infoList.project.setReqCatListToDefault", defaultReqCatList);
        InfoList defaultTcNatList = this.infoListDao.findByCode(SystemInfoListCode.TEST_CASE_NATURE.getCode());
        this.execUpdateQuery(infoListId, "infoList.project.setTcNatListToDefault", defaultTcNatList);
        InfoList defaultTcTypeList = this.infoListDao.findByCode(SystemInfoListCode.TEST_CASE_TYPE.getCode());
        this.execUpdateQuery(infoListId, "infoList.project.setTcTypeListToDefault", defaultTcTypeList);
    }

    private void execUpdateQuery(long infoListId, String queryName, Object defaultParam) {
        Query query = this.em.createNamedQuery(queryName);
        query.setParameter("default", defaultParam);
        query.setParameter("id", (Object)infoListId);
        query.executeUpdate();
    }
}

