/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityGraph;
import org.hibernate.jpa.QueryHints;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.hibernate.ContainerIdNameStartParameterCallback;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetNodeContentParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

@Repository
public class HibernateRequirementFolderDao
extends HibernateEntityDao<RequirementFolder>
implements RequirementFolderDao {
    @Override
    public RequirementFolder findByContent(RequirementLibraryNode node) {
        SetNodeContentParameter callback = new SetNodeContentParameter((LibraryNode)node);
        return (RequirementFolder)this.executeEntityNamedQuery("requirementFolder.findByContent", callback);
    }

    @Override
    public List<String> findNamesInLibraryStartingWith(long libraryId, String nameStart) {
        ContainerIdNameStartParameterCallback newCallBack1 = new ContainerIdNameStartParameterCallback(libraryId, nameStart);
        return this.executeListNamedQuery("requirementFolder.findNamesInLibraryStartingWith", newCallBack1);
    }

    @Override
    public List<String> findNamesInNodeStartingWith(long nodeId, String nameStart) {
        ContainerIdNameStartParameterCallback newCallBack1 = new ContainerIdNameStartParameterCallback(nodeId, nameStart);
        return this.executeListNamedQuery("requirementLibraryNode.findNamesInNodeStartingWith", newCallBack1);
    }

    @Override
    public RequirementFolder findByIdWithContent(Long id) {
        EntityGraph graph = this.entityManager.createEntityGraph(RequirementFolder.class);
        graph.addSubgraph("content", RequirementLibraryNode.class);
        return (RequirementFolder)this.entityManager.createQuery("SELECT rf FROM RequirementFolder rf  WHERE rf.id = :id", RequirementFolder.class).setHint("javax.persistence.fetchgraph", (Object)graph).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public RequirementFolder loadContainerForPaste(long id) {
        EntityGraph graph = this.entityManager.createEntityGraph(RequirementFolder.class);
        graph.addSubgraph("content", Requirement.class).addAttributeNodes(new String[]{"syncExtender", "versions"});
        return (RequirementFolder)this.entityManager.createQuery("SELECT rf FROM RequirementFolder rf  WHERE rf.id = :id", RequirementFolder.class).setHint(QueryHints.HINT_FETCHGRAPH, (Object)graph).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<Long[]> findPairedContentForList(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        NativeQuery query = this.currentSession().createNativeQuery("select * from RLN_RELATIONSHIP where ancestor_id in (:folderIds)");
        query.setParameterList("folderIds", ids, (Type)LongType.INSTANCE);
        query.addScalar("ancestor_id", (Type)LongType.INSTANCE);
        query.addScalar("descendant_id", (Type)LongType.INSTANCE);
        List result = query.list();
        return this.toArrayOfLong(result);
    }

    @Override
    public List<Long> findContentForList(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        NativeQuery query = this.currentSession().createNativeQuery("select * from RLN_RELATIONSHIP where ancestor_id in (:folderIds)");
        query.setParameterList("folderIds", ids, (Type)LongType.INSTANCE);
        query.addScalar("descendant_id", (Type)LongType.INSTANCE);
        return query.list();
    }

    private List<Long[]> toArrayOfLong(List<Object[]> input) {
        ArrayList<Long[]> result = new ArrayList<Long[]>();
        for (Object[] pair : input) {
            Long[] newPair = new Long[]{(Long)pair[0], (Long)pair[1]};
            result.add(newPair);
        }
        return result;
    }

    @Override
    public RequirementFolder findParentOf(Long id) {
        ContentIdParametterCallback newCallBack = new ContentIdParametterCallback(id);
        return (RequirementFolder)this.executeEntityNamedQuery("requirementFolder.findParentOf", newCallBack);
    }

    private static final class ContentIdParametterCallback
    implements SetQueryParametersCallback {
        private long contentId;

        private ContentIdParametterCallback(long contentId) {
            this.contentId = contentId;
        }

        @Override
        public void setQueryParameters(Query query) {
            query.setParameter("contentId", (Object)this.contentId, (Type)LongType.INSTANCE);
        }
    }
}

