/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.RequirementDeletionDao;
import org.squashtest.tm.service.internal.repository.hibernate.AbstractHibernateDeletionDao;

@Repository
public class HibernateRequirementDeletionDao
extends AbstractHibernateDeletionDao
implements RequirementDeletionDao {
    private static final String REQUIREMENT_IDS = "requirementIds";
    private static final String VERSION_IDS = "versionIds";
    private static final String FOLDER_IDS = "folderIds";
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateRequirementDeletionDao.class);
    private final DSLContext dslContext;
    @Qualifier(value="squashtest.tm.repository.RequirementLibraryNodeDao")
    private final LibraryNodeDao<RequirementLibraryNode> requirementLibraryNodeDao;

    public HibernateRequirementDeletionDao(DSLContext dslContext, LibraryNodeDao<RequirementLibraryNode> requirementLibraryNodeDao) {
        this.dslContext = dslContext;
        this.requirementLibraryNodeDao = requirementLibraryNodeDao;
    }

    @Override
    public void deleteVersions(List<Long> versionIds) {
        this.executeDeleteNamedQuery("requirementDeletionDao.deleteVersions", VERSION_IDS, versionIds);
    }

    @Override
    public void removeEntities(List<Long> entityIds) {
        if (!entityIds.isEmpty()) {
            Set<Long> rootNodeParentIds = this.findParentRequirementLibraryIds(entityIds);
            Set<Long> childrenNodeParentIds = this.findParentRequirementLibraryNodeIds(entityIds);
            this.deleteContentAndRelationships(entityIds);
            this.deleteNodes(entityIds);
            this.reorderAfterDelete(rootNodeParentIds, childrenNodeParentIds);
        }
    }

    private void reorderAfterDelete(Set<Long> rootNodeParentIds, Set<Long> childrenNodeParentIds) {
        this.reorderRootNodes(rootNodeParentIds);
        this.reorderRelationships(childrenNodeParentIds);
    }

    private void deleteContentAndRelationships(List<Long> entityIds) {
        this.executeWithinHibernateSession((Query)this.dslContext.delete((Table)Tables.REQUIREMENT_LIBRARY_CONTENT).where(Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID.in(entityIds)));
        this.executeWithinHibernateSession((Query)this.dslContext.delete((Table)Tables.RLN_RELATIONSHIP).where(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.in(entityIds)));
    }

    private void deleteNodes(List<Long> entityIds) {
        List nodes = this.requirementLibraryNodeDao.findAllByIds(entityIds);
        for (RequirementLibraryNode node : nodes) {
            if (node == null) continue;
            this.entityManager().remove((Object)node);
            this.entityManager().flush();
        }
        this.deleteRemainingRequirements(entityIds);
    }

    private void deleteRemainingRequirements(List<Long> entityIds) {
        this.executeWithinHibernateSession((Query)this.dslContext.delete((Table)Tables.REQUIREMENT).where(Tables.REQUIREMENT.RLN_ID.in(entityIds)));
        this.executeWithinHibernateSession((Query)this.dslContext.delete((Table)Tables.REQUIREMENT_LIBRARY_NODE).where(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.in(entityIds)));
    }

    private void reorderRootNodes(Set<Long> parentIds) {
        if (!parentIds.isEmpty()) {
            Map groups = this.dslContext.selectFrom((TableLike)Tables.REQUIREMENT_LIBRARY_CONTENT).where(Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID.in(parentIds)).orderBy((OrderField)Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ORDER).fetchGroups((Field)Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID);
            this.dslContext.delete((Table)Tables.REQUIREMENT_LIBRARY_CONTENT).where(Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID.in(parentIds)).execute();
            this.doBatchReorder(groups, (Table)Tables.REQUIREMENT_LIBRARY_CONTENT, (Field<Long>)Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID, (Field<Long>)Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID, (Field<Integer>)Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ORDER);
        }
    }

    private <R extends Record3<Long, Long, Integer>> void doBatchReorder(Map<Long, Result<R>> groups, Table<R> table, Field<Long> parentColumn, Field<Long> childrenColumn, Field<Integer> orderColumn) {
        int numberOfItems = groups.values().stream().mapToInt(List::size).sum();
        if (numberOfItems > 0) {
            BatchBindStep batch = this.dslContext.batch((Query)this.dslContext.insertInto(table, parentColumn, childrenColumn, orderColumn).values(null, null, null));
            groups.forEach((parentId, children) -> IntStream.range(0, children.size()).forEach(position -> {
                Record3 record = (Record3)children.get(position);
                batch.bind(new Object[]{record.getValue(parentColumn), record.getValue(childrenColumn), position});
            }));
            batch.execute();
        }
    }

    private Set<Long> findParentRequirementLibraryIds(List<Long> rootRlnIds) {
        return this.dslContext.selectDistinct((SelectField)Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID).from((TableLike)Tables.REQUIREMENT_LIBRARY_CONTENT).where(Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID.in(rootRlnIds)).fetchSet((Field)Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID);
    }

    private void reorderRelationships(Set<Long> parentIds) {
        if (!parentIds.isEmpty()) {
            Map groups = this.dslContext.selectFrom((TableLike)Tables.RLN_RELATIONSHIP).where(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.in(parentIds)).orderBy((OrderField)Tables.RLN_RELATIONSHIP.CONTENT_ORDER).fetchGroups((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID);
            this.dslContext.delete((Table)Tables.RLN_RELATIONSHIP).where(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.in(parentIds)).execute();
            this.doBatchReorder(groups, (Table)Tables.RLN_RELATIONSHIP, (Field<Long>)Tables.RLN_RELATIONSHIP.ANCESTOR_ID, (Field<Long>)Tables.RLN_RELATIONSHIP.DESCENDANT_ID, (Field<Integer>)Tables.RLN_RELATIONSHIP.CONTENT_ORDER);
        }
    }

    private Set<Long> findParentRequirementLibraryNodeIds(List<Long> rlnIds) {
        return this.dslContext.select((SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID).from((TableLike)Tables.RLN_RELATIONSHIP).where(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.in(rlnIds)).and(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.notIn(rlnIds)).fetchSet((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID);
    }

    private void executeWithinHibernateSession(Query jooqQuery) {
        NativeQuery nativeQuery = this.getSession().createNativeQuery(jooqQuery.getSQL());
        List bindValues = jooqQuery.getBindValues();
        int i = 0;
        while (i < bindValues.size()) {
            nativeQuery.setParameter(i + 1, bindValues.get(i));
            ++i;
        }
        nativeQuery.executeUpdate();
    }

    @Override
    public List<Long>[] separateFolderFromRequirementIds(List<Long> originalIds) {
        ArrayList<Long> folderIds = new ArrayList<Long>(0);
        ArrayList<Long> requirementIds = new ArrayList<Long>(0);
        List filtredFolderIds = this.executeSelectSQLQuery("select folder.rln_id from REQUIREMENT_FOLDER folder where folder.rln_id in (:requirementIds)", REQUIREMENT_IDS, originalIds);
        for (Long oId : originalIds) {
            if (filtredFolderIds.contains(BigInteger.valueOf(oId))) {
                folderIds.add(oId);
                continue;
            }
            requirementIds.add(oId);
        }
        return new List[]{folderIds, requirementIds};
    }

    @Override
    public List<Long> findRequirementAttachmentListIds(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            org.hibernate.query.Query query = this.getSession().getNamedQuery("requirement.findAllAttachmentLists");
            query.setParameterList(REQUIREMENT_IDS, requirementIds);
            return query.list();
        }
        return new ArrayList<Long>(0);
    }

    @Override
    public List<Long> findRequirementVersionAttachmentListIds(List<Long> versionIds) {
        if (!versionIds.isEmpty()) {
            org.hibernate.query.Query query = this.getSession().getNamedQuery("requirementVersion.findAllAttachmentLists");
            query.setParameterList(VERSION_IDS, versionIds);
            return query.list();
        }
        return new ArrayList<Long>(0);
    }

    @Override
    public List<Long> findRequirementFolderAttachmentListIds(List<Long> folderIds) {
        if (!folderIds.isEmpty()) {
            org.hibernate.query.Query query = this.getSession().getNamedQuery("requirementFolder.findAllAttachmentLists");
            query.setParameterList(FOLDER_IDS, folderIds);
            return query.list();
        }
        return Collections.emptyList();
    }

    @Override
    public void removeFromVerifiedVersionsLists(List<Long> versionIds) {
        if (!versionIds.isEmpty()) {
            this.executeDeleteSQLQuery(" delete from REQUIREMENT_VERSION_COVERAGE  where verified_req_version_id in (:versionIds)", VERSION_IDS, versionIds);
        }
    }

    @Override
    public void removeFromLinkedVersionsLists(List<Long> versionIds) {
        if (!versionIds.isEmpty()) {
            this.executeDeleteSQLQuery("delete from REQUIREMENT_VERSION_LINK where requirement_version_id in (:versionIds) or related_requirement_version_id in (:versionIds)", VERSION_IDS, versionIds);
        }
    }

    @Override
    public void removeFromVerifiedRequirementLists(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            this.executeDeleteSQLQuery(" delete from REQUIREMENT_VERSION_COVERAGE  where verified_req_version_id in (  select req_v.res_id from REQUIREMENT_VERSION req_v where req_v.requirement_id in (:requirementIds) )", REQUIREMENT_IDS, requirementIds);
        }
    }

    @Override
    public void removeTestStepsCoverageByRequirementVersionIds(List<Long> requirementVersionIds) {
        if (!requirementVersionIds.isEmpty()) {
            this.executeDeleteSQLQuery("delete from VERIFYING_STEPS where REQUIREMENT_VERSION_COVERAGE_ID in (select REQUIREMENT_VERSION_COVERAGE_ID from REQUIREMENT_VERSION_COVERAGE where VERIFIED_REQ_VERSION_ID in (:versionIds))", VERSION_IDS, requirementVersionIds);
        }
    }

    @Override
    public void deleteRequirementAuditEvents(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            List events = this.executeSelectNamedQuery("requirementAuditEvent.findAllByRequirementIds", "ids", requirementIds);
            for (RequirementAuditEvent event : events) {
                this.removeEntity(event);
            }
            this.flush();
        }
    }

    @Override
    public void deleteHighLevelRequirementReferenceIfExists(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            org.hibernate.query.Query query = this.getSession().getNamedQuery("Requirement.removeHighLvlReqReferenceOnAllLinkedRequirements");
            query.setParameterList(REQUIREMENT_IDS, requirementIds);
            query.executeUpdate();
        }
    }

    @Override
    public void deleteRequirementVersionAuditEvents(List<Long> versionIds) {
        if (!versionIds.isEmpty()) {
            List events = this.executeSelectNamedQuery("requirementAuditEvent.findAllByRequirementVersionIds", "ids", versionIds);
            for (RequirementAuditEvent event : events) {
                this.removeEntity(event);
            }
            this.flush();
        }
    }

    @Override
    public List<Long> findVersionIds(List<Long> requirementIds) {
        return this.executeSelectNamedQuery("requirementDeletionDao.findVersionIds", "reqIds", requirementIds);
    }

    @Override
    public List<Long> findRemainingRequirementIds(List<Long> originalIds) {
        List rawids = this.executeSelectSQLQuery("select RLN_ID from REQUIREMENT where RLN_ID in (:allRequirementIds)", "allRequirementIds", originalIds);
        ArrayList<Long> cIds = new ArrayList<Long>(rawids.size());
        for (BigInteger rid : rawids) {
            cIds.add(rid.longValue());
        }
        return cIds;
    }

    @Override
    public List<Long> findDeletableVersions(List<Long> requirementIds, Long milestoneId) {
        ArrayList<Long> deletableVersions = new ArrayList<Long>(0);
        List<Long> versionsBelongingToMilestone = this.findVersionIdsForMilestone(requirementIds, milestoneId);
        deletableVersions.addAll(versionsBelongingToMilestone);
        List<Long> hasManyMilestones = this.filterVersionIdsHavingMultipleMilestones(deletableVersions);
        deletableVersions.removeAll(hasManyMilestones);
        List<Long> lockedVersions = this.filterVersionIdsWhichMilestonesForbidsDeletion(deletableVersions);
        deletableVersions.removeAll(lockedVersions);
        return deletableVersions;
    }

    @Override
    public List<Long> findUnbindableVersions(List<Long> requirementIds, Long milestoneId) {
        ArrayList<Long> unbindableVersions = new ArrayList<Long>(0);
        List<Long> versionsBelongingToMilestone = this.findVersionIdsForMilestone(requirementIds, milestoneId);
        unbindableVersions.addAll(versionsBelongingToMilestone);
        versionsBelongingToMilestone = this.filterVersionIdsHavingMultipleMilestones(unbindableVersions);
        List<Long> lockedVersions = this.filterVersionIdsWhichMilestonesForbidsDeletion(unbindableVersions);
        versionsBelongingToMilestone.removeAll(lockedVersions);
        return versionsBelongingToMilestone;
    }

    @Override
    public List<Long> filterRequirementsHavingDeletableVersions(List<Long> requirementIds, Long milestoneId) {
        List<Long> deletableVersions = this.findDeletableVersions(requirementIds, milestoneId);
        return this.findByRequirementVersion(deletableVersions);
    }

    @Override
    public List<Long> filterRequirementsHavingUnbindableVersions(List<Long> requirementIds, Long milestoneId) {
        List<Long> deletableVersions = this.findUnbindableVersions(requirementIds, milestoneId);
        return this.findByRequirementVersion(deletableVersions);
    }

    @Override
    public List<Long> filterRequirementsIdsWhichMilestonesForbidsDeletion(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            Object[] blockingStatuses = new MilestoneStatus[MilestoneStatus.MILESTONE_BLOCKING_STATUSES.size()];
            MilestoneStatus.MILESTONE_BLOCKING_STATUSES.toArray(blockingStatuses);
            org.hibernate.query.Query query = this.getSession().getNamedQuery("requirementDeletionDao.findRequirementsWhichMilestonesForbidsDeletion");
            query.setParameterList(REQUIREMENT_IDS, requirementIds, (Type)LongType.INSTANCE);
            query.setParameterList("lockedStatuses", blockingStatuses);
            return query.list();
        }
        return new ArrayList<Long>(0);
    }

    @Override
    public List<Long> filterVersionIdsWhichMilestonesForbidsDeletion(List<Long> versionIds) {
        if (!versionIds.isEmpty()) {
            Object[] blockingStatuses = new MilestoneStatus[MilestoneStatus.MILESTONE_BLOCKING_STATUSES.size()];
            MilestoneStatus.MILESTONE_BLOCKING_STATUSES.toArray(blockingStatuses);
            org.hibernate.query.Query query = this.getSession().getNamedQuery("requirementDeletionDao.findVersionsWhichMilestonesForbidsDeletion");
            query.setParameterList(VERSION_IDS, versionIds, (Type)LongType.INSTANCE);
            query.setParameterList("lockedStatuses", blockingStatuses);
            return query.list();
        }
        return new ArrayList<Long>(0);
    }

    @Override
    public List<Long> filterVersionIdsHavingMultipleMilestones(List<Long> versionIds) {
        if (!versionIds.isEmpty()) {
            org.hibernate.query.Query q = this.getSession().getNamedQuery("requirementDeletionDao.findVersionIdsHavingMultipleMilestones");
            q.setParameterList(VERSION_IDS, versionIds, (Type)LongType.INSTANCE);
            return q.list();
        }
        return new ArrayList<Long>(0);
    }

    @Override
    public List<Long> findVersionIdsForMilestone(List<Long> requirementIds, Long milestoneId) {
        if (!requirementIds.isEmpty()) {
            org.hibernate.query.Query query = this.getSession().getNamedQuery("requirementDeletionDao.findAllVersionForMilestone");
            query.setParameterList("nodeIds", requirementIds, (Type)LongType.INSTANCE);
            query.setParameter("milestoneId", (Object)milestoneId);
            return query.list();
        }
        return new ArrayList<Long>(0);
    }

    @Override
    public void unbindFromMilestone(List<Long> requirementIds, Long milestoneId) {
        if (!requirementIds.isEmpty()) {
            NativeQuery query = this.getSession().createNativeQuery("delete from MILESTONE_REQ_VERSION where MILESTONE_ID = :milestoneId and REQ_VERSION_ID in (select v.RES_ID from REQUIREMENT_VERSION v where v.REQUIREMENT_ID in (:requirementIds) )");
            query.setParameterList(REQUIREMENT_IDS, requirementIds, (Type)LongType.INSTANCE);
            query.setParameter("milestoneId", (Object)milestoneId);
            query.executeUpdate();
        }
    }

    @Override
    public void unsetRequirementCurrentVersion(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            org.hibernate.query.Query q = this.getSession().getNamedQuery("requirement.findAllById");
            q.setParameterList(REQUIREMENT_IDS, requirementIds);
            List requirements = q.list();
            for (Requirement r : requirements) {
                r.setCurrentVersion(null);
            }
        }
    }

    @Override
    public void resetRequirementCurrentVersion(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            org.hibernate.query.Query q = this.getSession().getNamedQuery("requirement.findAllRequirementsWithLatestVersionByIds");
            q.setParameterList(REQUIREMENT_IDS, requirementIds);
            List tuples = q.list();
            for (Object[] tuple : tuples) {
                RequirementVersion latest = (RequirementVersion)tuple[1];
                ((Requirement)tuple[0]).setCurrentVersion(latest);
            }
        }
    }

    @Override
    public void reorderRequirementVersions(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            org.hibernate.query.Query q = this.getSession().getNamedQuery("requirement.findRequirementWithVersions");
            q.setParameterList(REQUIREMENT_IDS, requirementIds);
            List requirements = q.list();
            requirements.forEach(requirement -> {
                List<RequirementVersion> versions = requirement.getRequirementVersions().stream().sorted(Comparator.comparingInt(RequirementVersion::getVersionNumber)).toList();
                this.doReorderRequirementVersions(versions);
            });
        }
    }

    private void doReorderRequirementVersions(List<RequirementVersion> versions) {
        IntStream.range(0, versions.size()).forEach(index -> {
            RequirementVersion version = (RequirementVersion)versions.get(index);
            int newVersionNumber = index + 1;
            if (version.getVersionNumber() != newVersionNumber) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Reorder incorrect RequirementVersion Version number. Requirement Id {} - RequirementVersion Id {}. Update old version number {} to new version number {}", new Object[]{version.getRequirement().getId(), version.getId(), version.getVersionNumber(), newVersionNumber});
                }
                version.setVersionNumber(newVersionNumber);
                this.entityManager().flush();
            }
        });
    }

    private List<Long> findByRequirementVersion(List<Long> versionIds) {
        if (!versionIds.isEmpty()) {
            org.hibernate.query.Query q = this.getSession().getNamedQuery("requirement.findByRequirementVersion");
            q.setParameterList(VERSION_IDS, versionIds, (Type)LongType.INSTANCE);
            return q.list();
        }
        return new ArrayList<Long>(0);
    }
}

