/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.service.internal.repository.AutomatedTestDao;
import org.squashtest.tm.service.internal.repository.hibernate.NonUniqueEntityException;

@Repository
public class HibernateAutomatedTestDao
implements AutomatedTestDao {
    @PersistenceContext
    private EntityManager em;

    @Override
    public AutomatedTest persistOrAttach(AutomatedTest newTest) {
        if (newTest.getId() != null && this.findById(newTest.getId()) != null) {
            return newTest;
        }
        AutomatedTest persisted = this.findByExample(newTest);
        if (persisted != null) {
            return persisted;
        }
        this.em.persist((Object)newTest);
        return newTest;
    }

    @Override
    public List<AutomatedTest> findAll() {
        Query query = this.em.createNamedQuery("AutomatedTest.findAll");
        return query.getResultList();
    }

    @Override
    public void removeIfUnused(AutomatedTest test) {
        if (test == null) {
            return;
        }
        AutomatedTest persisted = test.getId() != null ? test : this.findByExample(test);
        if (this.countReferences(persisted.getId()) == 0L) {
            ((Session)this.em.unwrap(Session.class)).delete((Object)persisted);
        }
    }

    @Override
    public void pruneOrphans() {
        List orphans = this.em.createNamedQuery("automatedTest.findOrphans").getResultList();
        if (orphans.isEmpty()) {
            return;
        }
        Query q = this.em.createNamedQuery("automatedTest.bulkDelete");
        q.setParameter("tests", (Object)orphans);
        q.executeUpdate();
    }

    @Override
    public long countReferences(long testId) {
        Query qCountTC = this.em.createNamedQuery("automatedTest.countReferencesByTestCases");
        qCountTC.setParameter("autoTestId", (Object)testId);
        long countTC = (Long)qCountTC.getSingleResult();
        Query qCountExt = this.em.createNamedQuery("automatedTest.countReferencesByExecutions");
        qCountExt.setParameter("autoTestId", (Object)testId);
        long countExt = (Long)qCountExt.getSingleResult();
        return countTC + countExt;
    }

    @Override
    public AutomatedTest findById(Long testId) {
        Session session = (Session)this.em.unwrap(Session.class);
        return (AutomatedTest)session.load(AutomatedTest.class, (Serializable)testId);
    }

    @Override
    public List<AutomatedTest> findByTestCases(Collection<Long> testCaseIds) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        Query query = this.em.createNamedQuery("automatedTest.findByTestCase");
        query.setParameter("testCaseIds", testCaseIds);
        return query.getResultList();
    }

    private AutomatedTest findByExample(AutomatedTest example) {
        List results = this.em.createQuery("from AutomatedTest where name = :name and project = :project").setParameter("name", (Object)example.getName()).setParameter("project", (Object)example.getProject()).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new NonUniqueEntityException();
        }
        return (AutomatedTest)results.get(0);
    }

    @Override
    public List<AutomatedTest> findAllByExtenderIds(List<Long> extenderIds) {
        if (extenderIds.isEmpty()) {
            return Collections.emptyList();
        }
        Query query = this.em.createNamedQuery("automatedTest.findAllByExtenderIds");
        query.setParameter("extenderIds", extenderIds);
        return query.getResultList();
    }

    @Override
    public List<AutomatedTest> findAllByExtender(Collection<AutomatedExecutionExtender> extenders) {
        if (extenders.isEmpty()) {
            return Collections.emptyList();
        }
        Query query = this.em.createNamedQuery("automatedTest.findAllByExtenders");
        query.setParameter("extenders", extenders);
        return query.getResultList();
    }
}

