/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record2;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.ActionTestStep;
import org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode;
import org.squashtest.tm.jooq.domain.tables.TestCaseSteps;
import org.squashtest.tm.service.internal.repository.AttachmentListDao;
import org.squashtest.tm.service.internal.repository.hibernate.attachmentlist.querybuilder.AttachmentListQueryBuilder;

@Repository
public class HibernateAttachmentListDao
implements AttachmentListDao {
    private static final Map<String, Class<?>> ENTITY_CLASS_MAP = Map.of(EntityType.PROJECT.toString(), GenericProject.class, EntityType.REQUIREMENT_VERSION.toString(), RequirementVersion.class, EntityType.TEST_CASE.toString(), TestCase.class, EntityType.CAMPAIGN.toString(), Campaign.class, EntityType.ITERATION.toString(), Iteration.class, EntityType.TEST_SUITE.toString(), TestSuite.class, EntityType.EXECUTION.toString(), Execution.class, EntityType.SESSION_NOTE.toString(), SessionNote.class, EntityType.EXECUTION_STEP.toString(), ExecutionStep.class);
    private static final Map<String, Class<?>> EXTENDED_ENTITY_CLASS_MAP = new HashMap(ENTITY_CLASS_MAP);
    private static final String ENTITY_TYPE = "entity_type";
    private static final String ENTITY_ID = "entity_id";
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dsl;

    static {
        EXTENDED_ENTITY_CLASS_MAP.put(EntityType.REQUIREMENT_LIBRARY.toString(), RequirementLibrary.class);
        EXTENDED_ENTITY_CLASS_MAP.put(EntityType.REQUIREMENT_FOLDER.toString(), RequirementFolder.class);
        EXTENDED_ENTITY_CLASS_MAP.put(EntityType.CAMPAIGN_LIBRARY.toString(), CampaignLibrary.class);
        EXTENDED_ENTITY_CLASS_MAP.put(EntityType.CAMPAIGN_FOLDER.toString(), CampaignFolder.class);
        EXTENDED_ENTITY_CLASS_MAP.put(EntityType.TEST_CASE_LIBRARY.toString(), TestCaseLibrary.class);
        EXTENDED_ENTITY_CLASS_MAP.put(EntityType.TEST_CASE_FOLDER.toString(), TestCaseFolder.class);
        EXTENDED_ENTITY_CLASS_MAP.put(EntityType.ACTION_WORD_LIBRARY.toString(), ActionWordLibrary.class);
        EXTENDED_ENTITY_CLASS_MAP.put(EntityType.SPRINT.toString(), Sprint.class);
        EXTENDED_ENTITY_CLASS_MAP.put(EntityType.EXPLORATORY_SESSION_OVERVIEW.toString(), ExploratorySessionOverview.class);
        EXTENDED_ENTITY_CLASS_MAP.put(EntityType.SPRINT_GROUP.toString(), SprintGroup.class);
    }

    @Override
    public AttachmentList getOne(Long id) {
        return (AttachmentList)this.entityManager.getReference(AttachmentList.class, (Object)id);
    }

    @Override
    public TestCase findAssociatedTestCaseIfExists(Long attachmentListId) {
        QTestCase testCase = QTestCase.testCase;
        return (TestCase)((JPAQuery)new JPAQueryFactory(this.entityManager).selectFrom((EntityPath)testCase).where((Predicate)testCase.attachmentList.id.eq((Object)attachmentListId))).fetchOne();
    }

    @Override
    public RequirementVersion findAssociatedRequirementVersionIfExists(Long attachmentListId) {
        QRequirementVersion req = QRequirementVersion.requirementVersion;
        return (RequirementVersion)((JPAQuery)new JPAQueryFactory(this.entityManager).selectFrom((EntityPath)req).where((Predicate)req.attachmentList.id.eq((Object)attachmentListId))).fetchOne();
    }

    @Override
    public Long findAttachmentListIdByAttachmentId(Long attachmentId) {
        return (Long)this.dsl.select((SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID).from((TableLike)Tables.ATTACHMENT).where(Tables.ATTACHMENT.ATTACHMENT_ID.eq((Object)attachmentId)).fetchOne((Field)Tables.ATTACHMENT.ATTACHMENT_LIST_ID);
    }

    @Override
    public AuditableMixin findAuditableAssociatedEntityIfExists(Long attachmentListId, EntityType holderType) {
        Class holderClass = holderType.getEntityClass();
        if (!AuditableMixin.class.isAssignableFrom(holderClass)) {
            return null;
        }
        String query = new AttachmentListQueryBuilder().getHolderEntityQuery(holderType);
        return (AuditableMixin)this.entityManager.createQuery(query, AuditableMixin.class).setParameter("attachmentListId", (Object)attachmentListId).getSingleResult();
    }

    @Override
    public AttachmentHolder findAttachmentHolder(Long attachmentListId) {
        Record2<String, Long> jooqRecord = this.getAssociatedEntityTypeAndId(attachmentListId);
        if (jooqRecord != null) {
            String entityType = (String)jooqRecord.get(ENTITY_TYPE, String.class);
            long entityId = (Long)jooqRecord.get(ENTITY_ID, Long.class);
            Class<?> entityClass = EXTENDED_ENTITY_CLASS_MAP.get(entityType);
            if (entityClass != null) {
                return (AttachmentHolder)this.entityManager.find(entityClass, (Object)entityId);
            }
        } else {
            String automatedSuiteId = this.getAssociatedAutomatedSuite(attachmentListId);
            if (automatedSuiteId != null) {
                return (AttachmentHolder)this.entityManager.find(AutomatedSuite.class, (Object)automatedSuiteId);
            }
        }
        throw new IllegalArgumentException("No entity class holder found for attachment list id : " + attachmentListId);
    }

    @Override
    public AttachmentHolder findAttachmentHolder(Long attachmentListId, EntityType entityType) {
        Class holderClass = entityType.getEntityClass();
        if (!AttachmentHolder.class.isAssignableFrom(holderClass)) {
            throw new IllegalArgumentException("Entity type " + entityType + " is not an attachment holder");
        }
        String query = new AttachmentListQueryBuilder().getHolderEntityQuery(entityType);
        return (AttachmentHolder)this.entityManager.createQuery(query, AttachmentHolder.class).setParameter("attachmentListId", (Object)attachmentListId).getSingleResult();
    }

    private Record2<String, Long> getAssociatedEntityTypeAndId(Long attachmentListId) {
        return (Record2)this.dsl.select((SelectField)DSL.field((SelectField)DSL.when((Condition)Tables.TEST_CASE_FOLDER.TCLN_ID.isNull(), (Field)DSL.inline((String)EntityType.TEST_CASE.toString())).otherwise((Field)DSL.inline((String)EntityType.TEST_CASE_FOLDER.toString()))).as(ENTITY_TYPE), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as(ENTITY_ID)).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID.eq((Object)attachmentListId)).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.TEST_CASE.toString()).as(ENTITY_TYPE), (SelectField)TestCaseLibraryNode.TEST_CASE_LIBRARY_NODE.TCLN_ID.as(ENTITY_ID)).from((TableLike)TestCaseLibraryNode.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)TestCaseSteps.TEST_CASE_STEPS).on(TestCaseSteps.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)TestCaseLibraryNode.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)ActionTestStep.ACTION_TEST_STEP).on(ActionTestStep.ACTION_TEST_STEP.TEST_STEP_ID.eq((Field)TestCaseSteps.TEST_CASE_STEPS.STEP_ID)).where(ActionTestStep.ACTION_TEST_STEP.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.field((SelectField)DSL.when((Condition)Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull(), (Field)DSL.inline((String)EntityType.CAMPAIGN_FOLDER.toString())).when(Tables.SPRINT.CLN_ID.isNotNull(), (Field)DSL.inline((String)EntityType.SPRINT.toString())).when(Tables.SPRINT_GROUP.CLN_ID.isNotNull(), (Field)DSL.inline((String)EntityType.SPRINT_GROUP.toString())).otherwise((Field)DSL.inline((String)EntityType.CAMPAIGN.toString()))).as(ENTITY_TYPE), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as(ENTITY_ID)).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_FOLDER.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT_GROUP.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.field((SelectField)DSL.when((Condition)Tables.REQUIREMENT_FOLDER.RLN_ID.isNull(), (Field)DSL.inline((String)EntityType.REQUIREMENT_VERSION.toString())).otherwise((Field)DSL.inline((String)EntityType.REQUIREMENT_FOLDER.toString()))).as(ENTITY_TYPE), (SelectField)DSL.field((SelectField)DSL.when((Condition)Tables.REQUIREMENT_FOLDER.RLN_ID.isNull(), (Field)Tables.RESOURCE.RES_ID).otherwise((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).as(ENTITY_ID)).from((TableLike)Tables.RESOURCE).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_FOLDER.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).where(Tables.RESOURCE.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.ITERATION.toString()).as(ENTITY_TYPE), (SelectField)Tables.ITERATION.ITERATION_ID.as(ENTITY_ID)).from((TableLike)Tables.ITERATION).where(Tables.ITERATION.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.TEST_SUITE.toString()).as(ENTITY_TYPE), (SelectField)Tables.TEST_SUITE.ID.as(ENTITY_ID)).from((TableLike)Tables.TEST_SUITE).where(Tables.TEST_SUITE.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.PROJECT.toString()).as(ENTITY_TYPE), (SelectField)Tables.PROJECT.PROJECT_ID.as(ENTITY_ID)).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.EXECUTION_STEP.toString()).as(ENTITY_TYPE), (SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID.as(ENTITY_ID)).from((TableLike)Tables.EXECUTION_STEP).where(Tables.EXECUTION_STEP.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.REQUIREMENT_LIBRARY.toString()).as(ENTITY_TYPE), (SelectField)Tables.REQUIREMENT_LIBRARY.RL_ID.as(ENTITY_ID)).from((TableLike)Tables.REQUIREMENT_LIBRARY).where(Tables.REQUIREMENT_LIBRARY.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.TEST_CASE_LIBRARY.toString()).as(ENTITY_TYPE), (SelectField)Tables.TEST_CASE_LIBRARY.TCL_ID.as(ENTITY_ID)).from((TableLike)Tables.TEST_CASE_LIBRARY).where(Tables.TEST_CASE_LIBRARY.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.CAMPAIGN_LIBRARY.toString()).as(ENTITY_TYPE), (SelectField)Tables.CAMPAIGN_LIBRARY.CL_ID.as(ENTITY_ID)).from((TableLike)Tables.CAMPAIGN_LIBRARY).where(Tables.CAMPAIGN_LIBRARY.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.EXPLORATORY_SESSION_OVERVIEW.toString()).as(ENTITY_TYPE), (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.as(ENTITY_ID)).from((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).where(Tables.EXPLORATORY_SESSION_OVERVIEW.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.SESSION_NOTE.toString()).as(ENTITY_TYPE), (SelectField)Tables.SESSION_NOTE.NOTE_ID.as(ENTITY_ID)).from((TableLike)Tables.SESSION_NOTE).where(Tables.SESSION_NOTE.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.EXECUTION.toString()).as(ENTITY_TYPE), (SelectField)Tables.EXECUTION.EXECUTION_ID.as(ENTITY_ID)).from((TableLike)Tables.EXECUTION).leftJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.AUTOMATED_SUITE).on(Tables.AUTOMATED_SUITE.SUITE_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).where(Tables.EXECUTION.ATTACHMENT_LIST_ID.eq((Object)attachmentListId).or(Tables.AUTOMATED_SUITE.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).limit((Number)1)).union((Select)this.dsl.select((SelectField)DSL.inline((String)EntityType.ACTION_WORD_LIBRARY.toString()).as(ENTITY_TYPE), (SelectField)Tables.ACTION_WORD_LIBRARY.AWL_ID.as(ENTITY_ID)).from((TableLike)Tables.ACTION_WORD_LIBRARY).where(Tables.ACTION_WORD_LIBRARY.ATTACHMENT_LIST_ID.eq((Object)attachmentListId))).fetchOne();
    }

    private String getAssociatedAutomatedSuite(Long attachmentListId) {
        return (String)this.dsl.select((SelectField)Tables.AUTOMATED_SUITE.SUITE_ID).from((TableLike)Tables.AUTOMATED_SUITE).where(Tables.AUTOMATED_SUITE.ATTACHMENT_LIST_ID.eq((Object)attachmentListId)).fetchOneInto(String.class);
    }
}

