/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntityVisitor;
import org.squashtest.tm.domain.customreport.GetCustomReportTreeDefinitionVisitor;
import org.squashtest.tm.service.internal.repository.CustomCustomReportLibraryNodeDao;

public class CustomReportLibraryNodeDaoImpl
implements CustomCustomReportLibraryNodeDao {
    private static final String UNCHECKED = "unchecked";
    @PersistenceContext
    EntityManager em;

    @Override
    public List<Long> findAllDescendantIds(List<Long> nodesIds) {
        Query query = this.em.createNamedQuery("CustomReportLibraryNodePathEdge.findAllDescendantIds");
        query.setParameter("ids", nodesIds);
        return query.getResultList();
    }

    @Override
    public List<Long> findAllFirstLevelDescendantIds(List<Long> nodesIds) {
        Query query = this.em.createNamedQuery("CustomReportLibraryNodePathEdge.findAllFirstLevelDescendantIds");
        query.setParameter("ids", nodesIds);
        return query.getResultList();
    }

    @Override
    public List<Long> findAncestorIds(Long nodeId) {
        Query query = this.em.createNamedQuery("CustomReportLibraryNodePathEdge.findAllAncestorIds");
        query.setParameter("id", (Object)nodeId);
        return query.getResultList();
    }

    @Override
    public List<Object[]> findAncestor(Long nodeId) {
        Query query = this.em.createNativeQuery("SELECT CRLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, CUSTOM_REPORT_LIBRARY_NODE.ENTITY_TYPE FROM CRLN_RELATIONSHIP_CLOSURE LEFT JOIN CUSTOM_REPORT_LIBRARY_NODE ON CRLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID = CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID WHERE CRLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID = :id");
        query.setParameter("id", (Object)nodeId);
        return query.getResultList();
    }

    @Override
    public List<Long> findAllFirstLevelDescendantIds(Long nodeId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(nodeId);
        return this.findAllFirstLevelDescendantIds(ids);
    }

    @Override
    public CustomReportLibraryNode findNodeFromEntity(CustomReportTreeEntity treeEntity) {
        GetCustomReportTreeDefinitionVisitor visitor = new GetCustomReportTreeDefinitionVisitor();
        treeEntity.accept((CustomReportTreeEntityVisitor)visitor);
        Query query = this.em.createNamedQuery("CustomReportLibraryNode.findNodeFromEntity");
        query.setParameter("entityType", (Object)visitor.getCustomReportTreeDefinition());
        query.setParameter("entityId", (Object)treeEntity.getId());
        return (CustomReportLibraryNode)query.getSingleResult();
    }

    @Override
    public Long countNodeFromEntity(CustomReportTreeEntity treeEntity) {
        GetCustomReportTreeDefinitionVisitor visitor = new GetCustomReportTreeDefinitionVisitor();
        treeEntity.accept((CustomReportTreeEntityVisitor)visitor);
        Query query = this.em.createNamedQuery("CustomReportLibraryNode.countNodeFromEntity");
        query.setParameter("entityType", (Object)visitor.getCustomReportTreeDefinition());
        query.setParameter("entityId", (Object)treeEntity.getId());
        return (Long)query.getSingleResult();
    }

    @Override
    public List<Long> findAllNodeIdsForLibraryEntity(Long projectId) {
        Query query = this.em.createNamedQuery("CustomReportLibraryNode.findAllNodeByProjectId");
        query.setParameter("projectId", (Object)projectId);
        return query.getResultList();
    }
}

