/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.CustomAutomatedExecExtenderDao;

@Repository
public class CustomAutomatedExecExtenderDaoImpl
implements CustomAutomatedExecExtenderDao {
    private final DSLContext dslContext;

    public CustomAutomatedExecExtenderDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public String findExecutionStatusByExtenderId(long extenderId) {
        return (String)this.dslContext.select((SelectField)Tables.EXECUTION.EXECUTION_STATUS).from((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).join((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq((Object)extenderId)).fetchOneInto(String.class);
    }

    @Override
    public boolean areAllFailureDetailLinkedToIssueByExtenderId(long extenderId) {
        Integer unmatchedCount = (Integer)this.dslContext.selectCount().from((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).join((TableLike)Tables.FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID.eq((Field)Tables.FAILURE_DETAIL.FAILURE_DETAIL_ID)).leftJoin((TableLike)Tables.ISSUE).on(Tables.FAILURE_DETAIL.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID)).where(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.eq((Object)extenderId)).and(Tables.ISSUE.ISSUE_ID.isNull()).fetchOneInto(Integer.class);
        return (unmatchedCount = Objects.requireNonNullElse(unmatchedCount, 0)) == 0;
    }

    @Override
    public boolean isAnyFailureDetailLinkedToIssueByExtenderId(long extenderId) {
        Integer linkedCount = (Integer)this.dslContext.selectCount().from((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).join((TableLike)Tables.FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID.eq((Field)Tables.FAILURE_DETAIL.FAILURE_DETAIL_ID)).join((TableLike)Tables.ISSUE).on(Tables.FAILURE_DETAIL.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID)).where(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.eq((Object)extenderId)).fetchOneInto(Integer.class);
        return (linkedCount = Objects.requireNonNullElse(linkedCount, 0)) > 0;
    }

    @Override
    public List<Long> findRecentExtenderIdsByExtenderId(long extenderId, int recentCount) {
        Long itemTestPlanId = (Long)this.dslContext.select((SelectField)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID).from((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).join((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID)).where(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq((Object)extenderId)).fetchOneInto(Long.class);
        return this.dslContext.select((SelectField)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID).from((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).join((TableLike)Tables.EXECUTION).on(Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID)).where(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Object)itemTestPlanId)).orderBy((OrderField)Tables.EXECUTION.LAST_EXECUTED_ON.desc()).limit((Number)recentCount).fetchInto(Long.class);
    }

    @Override
    public Map<Long, ExecutionStatus> findExecutionStatusesByExtenderIds(List<Long> extenderIds) {
        return this.dslContext.select((SelectField)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID, (SelectField)Tables.EXECUTION.EXECUTION_STATUS).from((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).join((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.in(extenderIds)).fetchMap(record -> (Long)record.get((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID), record -> ExecutionStatus.valueOf((String)((String)record.get((Field)Tables.EXECUTION.EXECUTION_STATUS))));
    }

    @Override
    public Map<Long, List<Long>> findFailureDetailIdsByExtenderIds(List<Long> extenderIds) {
        return this.dslContext.select((SelectField)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID, (SelectField)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID).from((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).where(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.in(extenderIds)).orderBy((OrderField)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID.asc()).fetchGroups(record -> (Long)record.get((Field)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID), record -> (Long)record.get((Field)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID));
    }

    @Override
    public Long findLastExtenderIdByExtenderId(long extenderId) {
        List<Long> recentExtenderIds = this.findRecentExtenderIdsByExtenderId(extenderId, 2);
        return recentExtenderIds.size() >= 2 ? recentExtenderIds.get(1) : null;
    }

    @Override
    public List<Long> findExtenderIdsByIssueId(long issueId) {
        return this.dslContext.select((SelectField)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID).from((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).join((TableLike)Tables.FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID.eq((Field)Tables.FAILURE_DETAIL.FAILURE_DETAIL_ID)).join((TableLike)Tables.ISSUE).on(Tables.FAILURE_DETAIL.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID)).where(Tables.ISSUE.ISSUE_ID.eq((Object)issueId)).fetchInto(Long.class);
    }

    @Override
    public Map<Long, Boolean> getAnyFailureDetailHasIssueByExtenderIds(List<Long> extenderIds) {
        Map matchedCounts = this.dslContext.select((SelectField)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID, (SelectField)DSL.count().as("matchedCount")).from((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).join((TableLike)Tables.FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID.eq((Field)Tables.FAILURE_DETAIL.FAILURE_DETAIL_ID)).join((TableLike)Tables.ISSUE).on(Tables.FAILURE_DETAIL.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID)).where(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.in(extenderIds)).groupBy(new GroupField[]{Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID}).fetchMap(record -> (Long)record.get((Field)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID), record -> (Integer)record.get("matchedCount", Integer.class));
        return extenderIds.stream().collect(Collectors.toMap(extenderId -> extenderId, extenderId -> matchedCounts.getOrDefault(extenderId, 0) > 0));
    }

    @Override
    public Map<Long, Boolean> getSomeFailureDetailDoesNotHaveIssueByExtenderId(List<Long> extenderIds) {
        Map unmatchedCounts = this.dslContext.select((SelectField)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID, (SelectField)DSL.count().as("unmatchedCount")).from((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).join((TableLike)Tables.FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID.eq((Field)Tables.FAILURE_DETAIL.FAILURE_DETAIL_ID)).leftJoin((TableLike)Tables.ISSUE).on(Tables.FAILURE_DETAIL.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID)).where(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.in(extenderIds)).and(Tables.ISSUE.ISSUE_ID.isNull()).groupBy(new GroupField[]{Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID}).fetchMap(record -> (Long)record.get((Field)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID), record -> (Integer)record.get("unmatchedCount", Integer.class));
        return extenderIds.stream().collect(Collectors.toMap(extenderId -> extenderId, extenderId -> unmatchedCounts.getOrDefault(extenderId, 0) != 0));
    }
}

