/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class CampaignCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    public CampaignCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> campaigns = this.collectCampaigns(ids);
        this.appendMilestonesInCampaigns(campaigns);
        return campaigns;
    }

    private Map<Long, DataRow> collectCampaigns(List<Long> ids) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("NAME"), (SelectField)Tables.CAMPAIGN.REFERENCE, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("projectId"), (SelectField)DSL.count((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID).as("CHILD_COUNT")).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.in(ids)).groupBy(new GroupField[]{Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CAMPAIGN_LIBRARY_NODE.NAME, Tables.CAMPAIGN.CLN_ID}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.CAMPAIGN, (Long)tuple.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setState((Integer)tuple.get("CHILD_COUNT", Integer.class) > 0 ? DataRow.State.closed : DataRow.State.leaf);
            dataRow.setData(tuple.intoMap());
            if (!Strings.isNullOrEmpty((String)((String)tuple.get((Field)Tables.CAMPAIGN.REFERENCE, String.class)))) {
                dataRow.getData().replace("NAME", String.valueOf((String)tuple.get((Field)Tables.CAMPAIGN.REFERENCE)) + " - " + (String)tuple.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME));
            }
            return dataRow;
        }));
    }

    private void appendMilestonesInCampaigns(Map<Long, DataRow> campaigns) {
        Multimap<Long, MilestoneDto> milestoneByCampaignId = this.milestoneDisplayDao.findMilestonesByCampaignId(campaigns.keySet());
        campaigns.forEach((campaignId, dataRow) -> dataRow.addData("MILESTONES", milestoneByCampaignId.get(campaignId).stream().map(MilestoneDto::getId).toList()));
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.CAMPAIGN;
    }
}

