/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.UserAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.UserAdminViewTeamDto;
import org.squashtest.tm.service.internal.repository.display.UserDisplayDao;

@Repository
public class UserDisplayDaoImpl
implements UserDisplayDao {
    @Inject
    private DSLContext dsl;

    @Override
    public UserAdminViewDto getUserById(Long userId) {
        return (UserAdminViewDto)this.getBaseRequest().where(Tables.CORE_USER.PARTY_ID.eq((Object)userId)).fetchOne().into(UserAdminViewDto.class);
    }

    @Override
    public List<UserAdminViewTeamDto> getTeamsByUser(Long userId) {
        return this.dsl.select((SelectField)Tables.CORE_TEAM.PARTY_ID, (SelectField)Tables.CORE_TEAM.NAME).from((TableLike)Tables.CORE_TEAM).leftJoin((TableLike)Tables.CORE_TEAM_MEMBER).on(Tables.CORE_TEAM.PARTY_ID.eq((Field)Tables.CORE_TEAM_MEMBER.TEAM_ID)).where(Tables.CORE_TEAM_MEMBER.USER_ID.eq((Object)userId)).fetchInto(UserAdminViewTeamDto.class);
    }

    @Override
    public List<Long> findPartyIdsCanAccessProject(List<Long> projectIds) {
        return this.dsl.select((SelectField)Tables.CORE_PARTY.PARTY_ID).from((TableLike)Tables.CORE_PARTY).join((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Field)Tables.CORE_PARTY.PARTY_ID)).join((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_OBJECT_IDENTITY.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID)).join((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).join((TableLike)Tables.ACL_CLASS).on(Tables.ACL_GROUP_PERMISSION.CLASS_ID.eq((Field)Tables.ACL_CLASS.ID).and(Tables.ACL_CLASS.CLASSNAME.eq((Object)"org.squashtest.tm.domain.project.Project"))).where(Tables.ACL_OBJECT_IDENTITY.IDENTITY.in(projectIds)).groupBy(new GroupField[]{Tables.CORE_PARTY.PARTY_ID}).fetch((Field)Tables.CORE_PARTY.PARTY_ID, Long.class);
    }

    @Override
    public List<NamedReference> findUserLoginsByPartyIds(List<Long> partyIds) {
        List usersSolo = this.dsl.select((SelectField)Tables.CORE_USER.PARTY_ID.as("ID"), (SelectField)Tables.CORE_USER.LOGIN.as("NAME")).from((TableLike)Tables.CORE_USER).join((TableLike)Tables.CORE_PARTY).on(Tables.CORE_PARTY.PARTY_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).where(Tables.CORE_PARTY.PARTY_ID.in(partyIds)).groupBy(new GroupField[]{Tables.CORE_USER.PARTY_ID}).fetchInto(NamedReference.class);
        List usersInTeam = this.dsl.select((SelectField)Tables.CORE_USER.PARTY_ID.as("ID"), (SelectField)Tables.CORE_USER.LOGIN.as("NAME")).from((TableLike)Tables.CORE_USER).join((TableLike)Tables.CORE_TEAM_MEMBER).on(Tables.CORE_TEAM_MEMBER.USER_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).join((TableLike)Tables.CORE_PARTY).on(Tables.CORE_TEAM_MEMBER.TEAM_ID.eq((Field)Tables.CORE_PARTY.PARTY_ID)).where(Tables.CORE_PARTY.PARTY_ID.in(partyIds)).groupBy(new GroupField[]{Tables.CORE_USER.PARTY_ID}).fetchInto(NamedReference.class);
        return Stream.concat(usersSolo.stream(), usersInTeam.stream()).distinct().toList();
    }

    private SelectJoinStep<?> getBaseRequest() {
        return this.dsl.select((SelectField)Tables.CORE_USER.PARTY_ID.as("ID"), (SelectField)Tables.CORE_USER.LOGIN, (SelectField)Tables.CORE_USER.FIRST_NAME, (SelectField)Tables.CORE_USER.LAST_NAME, (SelectField)Tables.CORE_USER.EMAIL, (SelectField)Tables.CORE_USER.ACTIVE, (SelectField)Tables.CORE_USER.CREATED_BY, (SelectField)Tables.CORE_USER.CREATED_ON, (SelectField)Tables.CORE_USER.LAST_MODIFIED_BY, (SelectField)Tables.CORE_USER.LAST_MODIFIED_ON, (SelectField)Tables.CORE_USER.LAST_CONNECTED_ON, (SelectField)Tables.CORE_GROUP_MEMBER.GROUP_ID.as("USERS_GROUP_BINDING"), (SelectField)Tables.CORE_USER.CAN_DELETE_FROM_FRONT).from((TableLike)Tables.CORE_USER).leftJoin((TableLike)Tables.CORE_GROUP_MEMBER).on(Tables.CORE_GROUP_MEMBER.PARTY_ID.eq((Field)Tables.CORE_USER.PARTY_ID));
    }
}

