/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.inject.Inject;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.CoverageStepInfoDto;
import org.squashtest.tm.service.internal.display.dto.RequirementVersionCoverageDto;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionCoverageDisplayDao;

@Repository
public class RequirementVersionCoverageDisplayDaoImpl
implements RequirementVersionCoverageDisplayDao {
    private static final String MILESTONE_LABELS = "MILESTONE_LABELS";
    private static final String MILESTONE_MAX_DATE = "MILESTONE_MAX_DATE";
    private static final String MILESTONE_MIN_DATE = "MILESTONE_MIN_DATE";
    private static final String RES_ID = "RES_ID";
    @Inject
    private DSLContext dsl;

    @Override
    public List<RequirementVersionCoverageDto> findDirectCoverageByTestCaseId(Long testCaseId) {
        return this.findByTestCaseIds(testCaseId, Collections.emptySet());
    }

    @Override
    public List<RequirementVersionCoverageDto> findByTestCaseIds(Long testCaseId, Set<Long> calledTestCaseIds) {
        HashSet<Long> allIds = new HashSet<Long>(calledTestCaseIds);
        allIds.add(testCaseId);
        SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> milestoneDates = this.getMilestoneDates();
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS, (SelectField)Tables.VERIFYING_STEPS.TEST_STEP_ID, (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER, (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID, (SelectField)DSL.field((String)MILESTONE_LABELS), (SelectField)DSL.field((String)MILESTONE_MIN_DATE), (SelectField)DSL.field((String)MILESTONE_MAX_DATE)).from((TableLike)Tables.RESOURCE).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.VERIFYING_STEPS).on(Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID)).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.VERIFYING_STEPS.TEST_STEP_ID)).leftJoin(milestoneDates).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(milestoneDates.field(RES_ID, Long.class))).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.in(allIds)).orderBy((OrderField)Tables.REQUIREMENT_VERSION.RES_ID).fetch().stream().collect(new CoverageCollector(testCaseId));
    }

    private SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> getMilestoneDates() {
        return DSL.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID.as(RES_ID), (SelectField)DSL.min((Field)Tables.MILESTONE.END_DATE).as(MILESTONE_MIN_DATE), (SelectField)DSL.max((Field)Tables.MILESTONE.END_DATE).as(MILESTONE_MAX_DATE), (SelectField)DSL.listAgg((Field)Tables.MILESTONE.LABEL, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.MILESTONE.END_DATE.asc()}).as(MILESTONE_LABELS)).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID, Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID});
    }

    private static class CoverageCollector
    implements Collector<Record, Map<Long, RequirementVersionCoverageDto>, List<RequirementVersionCoverageDto>> {
        private Long rootTcId;

        CoverageCollector(Long rootTcId) {
            this.rootTcId = rootTcId;
        }

        @Override
        public Supplier<Map<Long, RequirementVersionCoverageDto>> supplier() {
            return LinkedHashMap::new;
        }

        @Override
        public BiConsumer<Map<Long, RequirementVersionCoverageDto>, Record> accumulator() {
            return (coverageMap, record) -> {
                Long reqVersionId = (Long)record.get((Field)Tables.REQUIREMENT_VERSION.RES_ID);
                if (coverageMap.containsKey(reqVersionId)) {
                    RequirementVersionCoverageDto coverageDto = (RequirementVersionCoverageDto)coverageMap.get(reqVersionId);
                    this.updateCoverage((Record)record, coverageDto);
                } else {
                    RequirementVersionCoverageDto coverageDto = this.createCoverage((Record)record);
                    coverageMap.put(coverageDto.getRequirementVersionId(), coverageDto);
                }
            };
        }

        @Override
        public BinaryOperator<Map<Long, RequirementVersionCoverageDto>> combiner() {
            return (map1, map2) -> {
                throw new UnsupportedOperationException();
            };
        }

        @Override
        public Function<Map<Long, RequirementVersionCoverageDto>, List<RequirementVersionCoverageDto>> finisher() {
            return coverageMap -> new ArrayList(coverageMap.values());
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }

        private void updateCoverage(Record record, RequirementVersionCoverageDto coverageDto) {
            Long verifyingStepId = (Long)record.get((Field)Tables.VERIFYING_STEPS.TEST_STEP_ID);
            Long verifyingTestCaseId = (Long)record.get((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID);
            Integer stepIndex = (Integer)record.get((Field)Tables.TEST_CASE_STEPS.STEP_ORDER);
            if (this.rootTcId.equals(verifyingTestCaseId)) {
                if (Objects.isNull(coverageDto.getVerifyingTestCaseId())) {
                    coverageDto.setVerifyingTestCaseId(verifyingTestCaseId);
                }
                if (Objects.nonNull(verifyingStepId)) {
                    CoverageStepInfoDto coverageStepInfoDto = new CoverageStepInfoDto();
                    coverageStepInfoDto.setId(verifyingStepId);
                    coverageStepInfoDto.setIndex(stepIndex);
                    coverageDto.addCoverageStepInfo(coverageStepInfoDto);
                }
            } else {
                coverageDto.addCalledVerifyingTestCase(verifyingTestCaseId);
            }
        }

        private RequirementVersionCoverageDto createCoverage(Record record) {
            Long verifyingStepId = (Long)record.get((Field)Tables.VERIFYING_STEPS.TEST_STEP_ID);
            Integer stepIndex = (Integer)record.get((Field)Tables.TEST_CASE_STEPS.STEP_ORDER);
            Long verifyingTestCaseId = (Long)record.get((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID);
            RequirementVersionCoverageDto coverageDto = new RequirementVersionCoverageDto();
            coverageDto.setRequirementVersionId((Long)record.get((Field)Tables.REQUIREMENT_VERSION.RES_ID));
            coverageDto.setRequirementId((Long)record.get((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID));
            coverageDto.setProjectId((Long)record.get((Field)Tables.PROJECT.PROJECT_ID));
            coverageDto.setProjectName((String)record.get((Field)Tables.PROJECT.NAME));
            coverageDto.setReference((String)record.get((Field)Tables.REQUIREMENT_VERSION.REFERENCE));
            coverageDto.setName((String)record.get((Field)Tables.RESOURCE.NAME));
            coverageDto.setCriticality((String)record.get((Field)Tables.REQUIREMENT_VERSION.CRITICALITY));
            coverageDto.setStatus((String)record.get((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS));
            coverageDto.setMilestoneLabels((String)record.get(RequirementVersionCoverageDisplayDaoImpl.MILESTONE_LABELS));
            coverageDto.setMilestoneMaxDate((Date)record.get(RequirementVersionCoverageDisplayDaoImpl.MILESTONE_MAX_DATE));
            coverageDto.setMilestoneMinDate((Date)record.get(RequirementVersionCoverageDisplayDaoImpl.MILESTONE_MIN_DATE));
            if (this.rootTcId.equals(verifyingTestCaseId)) {
                coverageDto.setVerifyingTestCaseId(verifyingTestCaseId);
                if (Objects.nonNull(verifyingStepId)) {
                    CoverageStepInfoDto coverageStepInfoDto = new CoverageStepInfoDto();
                    coverageStepInfoDto.setId(verifyingStepId);
                    coverageStepInfoDto.setIndex(stepIndex);
                    coverageDto.addCoverageStepInfo(coverageStepInfoDto);
                }
            } else {
                coverageDto.addCalledVerifyingTestCase(verifyingTestCaseId);
            }
            return coverageDto;
        }
    }
}

