/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record19;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CampaignIteration;
import org.squashtest.tm.jooq.domain.tables.CampaignLibraryNode;
import org.squashtest.tm.jooq.domain.tables.ItemTestPlanList;
import org.squashtest.tm.jooq.domain.tables.Iteration;
import org.squashtest.tm.jooq.domain.tables.IterationTestPlanItem;
import org.squashtest.tm.service.internal.display.dto.campaign.IterationDto;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;

@Repository
public class IterationDisplayDaoImpl
implements IterationDisplayDao {
    private DSLContext dsl;

    public IterationDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public IterationDto findById(long iterationId) {
        return (IterationDto)((Record19)this.dsl.select((SelectField)Iteration.ITERATION.ITERATION_ID.as("ID"), (SelectField)Iteration.ITERATION.NAME, (SelectField)Iteration.ITERATION.REFERENCE, (SelectField)Iteration.ITERATION.DESCRIPTION, (SelectField)Iteration.ITERATION.UUID, (SelectField)Iteration.ITERATION.ITERATION_STATUS, (SelectField)Iteration.ITERATION.CREATED_BY, (SelectField)Iteration.ITERATION.CREATED_ON, (SelectField)Iteration.ITERATION.LAST_MODIFIED_BY, (SelectField)Iteration.ITERATION.LAST_MODIFIED_ON, (SelectField)Iteration.ITERATION.ACTUAL_END_AUTO, (SelectField)Iteration.ITERATION.ACTUAL_END_DATE, (SelectField)Iteration.ITERATION.ACTUAL_START_AUTO, (SelectField)Iteration.ITERATION.ACTUAL_START_DATE, (SelectField)Iteration.ITERATION.SCHEDULED_END_DATE, (SelectField)Iteration.ITERATION.SCHEDULED_START_DATE, (SelectField)Iteration.ITERATION.ATTACHMENT_LIST_ID, (SelectField)DSL.field((Condition)DSL.count((Field)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.DATASET_ID).gt((Object)0)).as("HAS_DATASETS"), (SelectField)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID).from((TableLike)Iteration.ITERATION).innerJoin((TableLike)CampaignIteration.CAMPAIGN_ITERATION).on(Iteration.ITERATION.ITERATION_ID.eq((Field)CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE).on(CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)ItemTestPlanList.ITEM_TEST_PLAN_LIST).on(ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Iteration.ITERATION.ITERATION_ID)).leftJoin((TableLike)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM).on(ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.eq((Field)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).where(Iteration.ITERATION.ITERATION_ID.eq((Object)iterationId)).groupBy(new GroupField[]{Iteration.ITERATION.ITERATION_ID, CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID}).fetchOne()).into(IterationDto.class);
    }

    @Override
    public HashMap<Long, String> getExecutionStatusMap(Long iterationId) {
        return (HashMap)this.dsl.select((SelectField)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, (SelectField)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS).from((TableLike)Iteration.ITERATION).innerJoin((TableLike)ItemTestPlanList.ITEM_TEST_PLAN_LIST).on(ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Iteration.ITERATION.ITERATION_ID)).innerJoin((TableLike)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM).on(IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).where(Iteration.ITERATION.ITERATION_ID.eq((Object)iterationId)).fetch().intoMap((Field)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, (Field)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS);
    }

    @Override
    public int getNbTestPlanItem(Long iterationId, String login) {
        Integer count;
        SelectConditionStep allTestPlanItemsFromIteration = this.dsl.selectCount().from((TableLike)Iteration.ITERATION).innerJoin((TableLike)ItemTestPlanList.ITEM_TEST_PLAN_LIST).on(ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Iteration.ITERATION.ITERATION_ID)).innerJoin((TableLike)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM).on(ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.eq((Field)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.PARTY_ID.eq((Field)IterationTestPlanItem.ITERATION_TEST_PLAN_ITEM.USER_ID)).where(Iteration.ITERATION.ITERATION_ID.eq((Object)iterationId));
        if (login != null) {
            allTestPlanItemsFromIteration = allTestPlanItemsFromIteration.and(Tables.CORE_USER.LOGIN.eq((Object)login));
        }
        return (count = (Integer)allTestPlanItemsFromIteration.groupBy(new GroupField[]{Iteration.ITERATION.ITERATION_ID}).fetchOneInto(Integer.TYPE)) != null ? count : 0;
    }

    @Override
    public List<String> retrieveFullNameByIterationIds(List<Long> iterationIds, List<Long> projectIds) {
        Field fullName = DSL.when((Condition)Iteration.ITERATION.REFERENCE.isNull().or(Iteration.ITERATION.REFERENCE.eq((Object)"")), (Field)Iteration.ITERATION.NAME).otherwise(DSL.concat((Field[])new Field[]{Iteration.ITERATION.REFERENCE, DSL.val((String)" - "), Iteration.ITERATION.NAME}));
        return this.dsl.select((SelectField)fullName).from((TableLike)Iteration.ITERATION).join((TableLike)CampaignIteration.CAMPAIGN_ITERATION).on(Iteration.ITERATION.ITERATION_ID.eq((Field)CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE).on(CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Iteration.ITERATION.ITERATION_ID.in(iterationIds)).and(CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)fullName).fetch(fullName);
    }

    @Override
    public List<Long> findDistinctProjectIdsByIterationIds(Set<Long> iterationIds) {
        return this.dsl.selectDistinct((SelectField)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID).from((TableLike)CampaignIteration.CAMPAIGN_ITERATION).leftJoin((TableLike)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE).on(CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID.in(iterationIds)).fetchInto(Long.class);
    }

    @Override
    public Set<Long> findCampaignIdsByIterationIds(Set<Long> iterationIds) {
        return this.dsl.selectDistinct((SelectField)CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID).from((TableLike)CampaignIteration.CAMPAIGN_ITERATION).where(CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID.in(iterationIds)).fetchSet((Field)CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID);
    }

    @Override
    public List<NamedReference> findNamedReferences(List<Long> targetIds) {
        return this.dsl.select((SelectField)Iteration.ITERATION.ITERATION_ID, (SelectField)Iteration.ITERATION.NAME).from((TableLike)Iteration.ITERATION).where(Iteration.ITERATION.ITERATION_ID.in(targetIds)).fetch().into(NamedReference.class);
    }

    @Override
    public Map<Long, List<Long>> findExecutionIdsByIterationIds(List<Long> targetIds) {
        return this.dsl.select((SelectField)ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITERATION_ID, (SelectField)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID).from((TableLike)ItemTestPlanList.ITEM_TEST_PLAN_LIST).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID)).where(ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITERATION_ID.in(targetIds)).fetchGroups((Field)ItemTestPlanList.ITEM_TEST_PLAN_LIST.ITERATION_ID, (Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID);
    }
}

